/*
 * Decompiled with CFR 0.152.
 */
package org.glite.lb;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;
import org.glite.jobid.Jobid;
import org.glite.lb.Escape;
import org.glite.lb.Event;
import org.glite.lb.LBException;
import org.glite.lb.SeqCode;
import org.glite.lb.Sources;

public abstract class Context {
    private Sources source;
    private int flag;
    private String host;
    private String user;
    private String prog;
    private String srcInstance;
    private Jobid jobid;
    private SeqCode seqCode;

    public Context() {
    }

    public Context(Sources sources, int n, String string, String string2, String string3, String string4, Jobid jobid) {
        if (sources == null) {
            throw new IllegalArgumentException("Context source");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Context flag");
        }
        if (string == null || string.equals("")) {
            try {
                string = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                System.err.println(unknownHostException);
            }
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Context user");
        }
        if (string3 == null) {
            string3 = new String("edg-wms");
        }
        if (string4 == null) {
            string4 = new String("");
        }
        if (jobid == null) {
            throw new IllegalArgumentException("Context jobid");
        }
        this.source = sources;
        this.flag = n;
        this.host = string;
        this.user = string2;
        this.prog = string3;
        this.srcInstance = string4;
        this.jobid = jobid;
    }

    public abstract void log(Event var1) throws LBException;

    protected String createMessage(Event event) {
        if (event == null) {
            throw new IllegalArgumentException("Context event");
        }
        if (this.jobid == null) {
            throw new IllegalArgumentException("Context jobid");
        }
        if (this.jobid.getBkserver() == null) {
            throw new IllegalArgumentException("Context Jobid bkserver");
        }
        if (this.jobid.getPort() <= 0 || this.jobid.getPort() >= 65536) {
            throw new IllegalArgumentException("Context Jobid port");
        }
        if (this.jobid.getUnique() == null) {
            throw new IllegalArgumentException("Context Jobid unique");
        }
        if (event == null) {
            throw new IllegalArgumentException("Context event");
        }
        if (this.seqCode == null) {
            throw new IllegalArgumentException("Context seqCode");
        }
        if (this.flag < 0) {
            throw new IllegalArgumentException("Context flag");
        }
        if (this.host == null || this.host.equals("")) {
            try {
                this.host = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                System.err.println(unknownHostException);
            }
        }
        if (this.prog == null) {
            this.prog = new String("edg-wms");
        }
        if (this.user == null) {
            throw new IllegalArgumentException("Context user");
        }
        if (this.srcInstance == null) {
            this.srcInstance = new String("");
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "UTC"));
        String string = simpleDateFormat.format(new Date()) + "000";
        if (this.seqCode != null) {
            this.seqCode.incrementSeqCode(this.source);
        }
        String string2 = " DG.USER=\"" + Escape.ulm(this.user) + "\"" + " DATE=" + string + " HOST=\"" + Escape.ulm(this.host) + "\"" + " PROG=" + Escape.ulm(this.prog) + " LVL=SYSTEM" + " DG.PRIORITY=0" + " DG.SOURCE=\"" + this.source + "\"" + " DG.SRC_INSTANCE=\"" + Escape.ulm(this.srcInstance) + "\"" + " DG.EVNT=\"" + event.getEventType() + "\"" + " DG.JOBID=\"" + this.jobid + "\"" + " DG.SEQCODE=\"" + Escape.ulm(this.seqCode.toString()) + "\"" + event.ulm();
        return string2;
    }

    public int getFlag() {
        return this.flag;
    }

    public void setFlag(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Context flag");
        }
        this.flag = n;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Context host");
        }
        this.host = string;
    }

    public Jobid getJobid() {
        return this.jobid;
    }

    public void setJobid(Jobid jobid) {
        if (jobid == null) {
            throw new IllegalArgumentException("Context jobid");
        }
        this.jobid = jobid;
    }

    public String getProg() {
        return this.prog;
    }

    public void setProg(String string) {
        if (string == null) {
            string = new String("edg-wms");
        }
        this.prog = string;
    }

    public SeqCode getSeqCode() {
        return this.seqCode;
    }

    public void setSeqCode(SeqCode seqCode) {
        if (seqCode == null) {
            throw new IllegalArgumentException("Context seqCode");
        }
        this.seqCode = seqCode;
    }

    public Sources getSource() {
        return this.source;
    }

    public void setSource(Sources sources) {
        this.source = sources;
    }

    public String getSrcInstance() {
        return this.srcInstance;
    }

    public void setSrcInstance(String string) {
        if (string == null) {
            string = new String("");
        }
        this.srcInstance = string;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Context user");
        }
        this.user = string;
    }
}

