#ifndef GLITE_LB_PRODUCER_H
#define GLITE_LB_PRODUCER_H

/**
 * \file producer.h
 * \brief client API for storing data into L&B service
 */

#ident "$Header: /cvs/glite/org.glite.lb.client/interface/producer.h.T,v 1.16 2012/10/11 10:12:40 mvocu Exp $"
/*
Copyright (c) Members of the EGEE Collaboration. 2004-2010.
See http://www.eu-egee.org/partners for details on the copyright holders.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

/*

  !! Automatically generated file
  !! Do not edit, your changes will be discarded upon build
  !! Change the corresponding template file ./interface/producer.h.T

*/

#ifdef __cplusplus
extern "C" {
#endif

#include "glite/lb/context.h"
#include "glite/lb/events.h"

/* Event sources: */

#if 0 /* obsolete */
#define EDG_WLL_SOURCE_UI           "UserInterface"
#define EDG_WLL_SOURCE_RB           "ResourceBroker"
#define EDG_WLL_SOURCE_JSS          "JobSubmissionService"  /* aka Condor-G */
#define EDG_WLL_SOURCE_JOBMGR       "GlobusJobmanager"
#define EDG_WLL_SOURCE_LRMS         "LocalResourceManager"
#define EDG_WLL_SOURCE_APP          "Application"

#define EDG_WLL_SOURCE_NS	"NetworkServer"
#define EDG_WLL_SOURCE_WM	"WorkloadManager"
#define EDG_WLL_SOURCE_BH	"BigHelper"
#define EDG_WLL_SOURCE_LM	"LogMonitor"

#endif

/* edg_wll_LogEvent shortcuts */

/**
 * \brief edg_wll_LogTransfer
 *
 * edg_wll_LogTransfer - simple wrapper around edg_wll_LogEvent for event Transfer
 *
 * \param[in,out] context	context to work with, 
 * \param[in] destination	Destination where the job is being transfered to.
 * \param[in] dest_host	Hostname of server that takes over control of the job.
 * \param[in] dest_instance	Service (instance) that takes over control of the job.
 * \param[in] job	Job description in receiver's language.
 * \param[in] result	Result code of the transfer attempt (START, OK, REFUSED or FAIL).
 * \param[in] reason	Detailed description of the transfer, especially reason of failure.
 * \param[in] dest_jobid	Job id as assigned by the receiving software component.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogTransfer(edg_wll_Context context, const edg_wll_Source destination, const char * dest_host, const char * dest_instance, const char * job, const char * result, const char * reason, const char * dest_jobid);

/**
 * \brief edg_wll_LogTransferProxy
 *
 * edg_wll_LogTransferProxy - simple wrapper around edg_wll_LogEventProxy for event Transfer
 *
 * \param[in,out] context	context to work with, 
 * \param[in] destination	Destination where the job is being transfered to.
 * \param[in] dest_host	Hostname of server that takes over control of the job.
 * \param[in] dest_instance	Service (instance) that takes over control of the job.
 * \param[in] job	Job description in receiver's language.
 * \param[in] result	Result code of the transfer attempt (START, OK, REFUSED or FAIL).
 * \param[in] reason	Detailed description of the transfer, especially reason of failure.
 * \param[in] dest_jobid	Job id as assigned by the receiving software component.
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogTransferProxy(edg_wll_Context context, const edg_wll_Source destination, const char * dest_host, const char * dest_instance, const char * job, const char * result, const char * reason, const char * dest_jobid);

/**
 * \brief edg_wll_LogTransferFile
 *
 * edg_wll_LogTransferFile - simple wrapper around edg_wll_LogEventFile for event Transfer
 *
 * \param[in,out] context	context to work with, 
 * \param[in] destination	Destination where the job is being transfered to.
 * \param[in] dest_host	Hostname of server that takes over control of the job.
 * \param[in] dest_instance	Service (instance) that takes over control of the job.
 * \param[in] job	Job description in receiver's language.
 * \param[in] result	Result code of the transfer attempt (START, OK, REFUSED or FAIL).
 * \param[in] reason	Detailed description of the transfer, especially reason of failure.
 * \param[in] dest_jobid	Job id as assigned by the receiving software component.
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogTransferFile(edg_wll_Context context, const edg_wll_Source destination, const char * dest_host, const char * dest_instance, const char * job, const char * result, const char * reason, const char * dest_jobid);

/**
 * \brief edg_wll_LogTransferSTART
 *
 * edg_wll_LogTransferSTART - simple wrapper around edg_wll_LogEvent for event Transfer, result START
 *
 * \param[in,out] context	context to work with, 
 * \param[in] destination	Destination where the job is being transfered to.
 * \param[in] dest_host	Hostname of server that takes over control of the job.
 * \param[in] dest_instance	Service (instance) that takes over control of the job.
 * \param[in] job	Job description in receiver's language.
 * \param[in] reason	Detailed description of the transfer, especially reason of failure.
 * \param[in] dest_jobid	Job id as assigned by the receiving software component.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogTransferSTART(edg_wll_Context context, const edg_wll_Source destination, const char * dest_host, const char * dest_instance, const char * job, const char * reason, const char * dest_jobid);

/**
 * \brief edg_wll_LogTransferSTARTProxy
 *
 * edg_wll_LogTransferSTARTProxy - simple wrapper around edg_wll_LogEventProxy for event Transfer, result START
 *
 * \param[in,out] context	context to work with, 
 * \param[in] destination	Destination where the job is being transfered to.
 * \param[in] dest_host	Hostname of server that takes over control of the job.
 * \param[in] dest_instance	Service (instance) that takes over control of the job.
 * \param[in] job	Job description in receiver's language.
 * \param[in] reason	Detailed description of the transfer, especially reason of failure.
 * \param[in] dest_jobid	Job id as assigned by the receiving software component.
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogTransferSTARTProxy(edg_wll_Context context, const edg_wll_Source destination, const char * dest_host, const char * dest_instance, const char * job, const char * reason, const char * dest_jobid);

/**
 * \brief edg_wll_LogTransferSTARTFile
 *
 * edg_wll_LogTransferSTARTFile - simple wrapper around edg_wll_LogEventFile for event Transfer, result START
 *
 * \param[in,out] context	context to work with, 
 * \param[in] destination	Destination where the job is being transfered to.
 * \param[in] dest_host	Hostname of server that takes over control of the job.
 * \param[in] dest_instance	Service (instance) that takes over control of the job.
 * \param[in] job	Job description in receiver's language.
 * \param[in] reason	Detailed description of the transfer, especially reason of failure.
 * \param[in] dest_jobid	Job id as assigned by the receiving software component.
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogTransferSTARTFile(edg_wll_Context context, const edg_wll_Source destination, const char * dest_host, const char * dest_instance, const char * job, const char * reason, const char * dest_jobid);

/**
 * \brief edg_wll_LogTransferOK
 *
 * edg_wll_LogTransferOK - simple wrapper around edg_wll_LogEvent for event Transfer, result OK
 *
 * \param[in,out] context	context to work with, 
 * \param[in] destination	Destination where the job is being transfered to.
 * \param[in] dest_host	Hostname of server that takes over control of the job.
 * \param[in] dest_instance	Service (instance) that takes over control of the job.
 * \param[in] job	Job description in receiver's language.
 * \param[in] reason	Detailed description of the transfer, especially reason of failure.
 * \param[in] dest_jobid	Job id as assigned by the receiving software component.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogTransferOK(edg_wll_Context context, const edg_wll_Source destination, const char * dest_host, const char * dest_instance, const char * job, const char * reason, const char * dest_jobid);

/**
 * \brief edg_wll_LogTransferOKProxy
 *
 * edg_wll_LogTransferOKProxy - simple wrapper around edg_wll_LogEventProxy for event Transfer, result OK
 *
 * \param[in,out] context	context to work with, 
 * \param[in] destination	Destination where the job is being transfered to.
 * \param[in] dest_host	Hostname of server that takes over control of the job.
 * \param[in] dest_instance	Service (instance) that takes over control of the job.
 * \param[in] job	Job description in receiver's language.
 * \param[in] reason	Detailed description of the transfer, especially reason of failure.
 * \param[in] dest_jobid	Job id as assigned by the receiving software component.
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogTransferOKProxy(edg_wll_Context context, const edg_wll_Source destination, const char * dest_host, const char * dest_instance, const char * job, const char * reason, const char * dest_jobid);

/**
 * \brief edg_wll_LogTransferOKFile
 *
 * edg_wll_LogTransferOKFile - simple wrapper around edg_wll_LogEventFile for event Transfer, result OK
 *
 * \param[in,out] context	context to work with, 
 * \param[in] destination	Destination where the job is being transfered to.
 * \param[in] dest_host	Hostname of server that takes over control of the job.
 * \param[in] dest_instance	Service (instance) that takes over control of the job.
 * \param[in] job	Job description in receiver's language.
 * \param[in] reason	Detailed description of the transfer, especially reason of failure.
 * \param[in] dest_jobid	Job id as assigned by the receiving software component.
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogTransferOKFile(edg_wll_Context context, const edg_wll_Source destination, const char * dest_host, const char * dest_instance, const char * job, const char * reason, const char * dest_jobid);

/**
 * \brief edg_wll_LogTransferREFUSED
 *
 * edg_wll_LogTransferREFUSED - simple wrapper around edg_wll_LogEvent for event Transfer, result REFUSED
 *
 * \param[in,out] context	context to work with, 
 * \param[in] destination	Destination where the job is being transfered to.
 * \param[in] dest_host	Hostname of server that takes over control of the job.
 * \param[in] dest_instance	Service (instance) that takes over control of the job.
 * \param[in] job	Job description in receiver's language.
 * \param[in] reason	Detailed description of the transfer, especially reason of failure.
 * \param[in] dest_jobid	Job id as assigned by the receiving software component.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogTransferREFUSED(edg_wll_Context context, const edg_wll_Source destination, const char * dest_host, const char * dest_instance, const char * job, const char * reason, const char * dest_jobid);

/**
 * \brief edg_wll_LogTransferREFUSEDProxy
 *
 * edg_wll_LogTransferREFUSEDProxy - simple wrapper around edg_wll_LogEventProxy for event Transfer, result REFUSED
 *
 * \param[in,out] context	context to work with, 
 * \param[in] destination	Destination where the job is being transfered to.
 * \param[in] dest_host	Hostname of server that takes over control of the job.
 * \param[in] dest_instance	Service (instance) that takes over control of the job.
 * \param[in] job	Job description in receiver's language.
 * \param[in] reason	Detailed description of the transfer, especially reason of failure.
 * \param[in] dest_jobid	Job id as assigned by the receiving software component.
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogTransferREFUSEDProxy(edg_wll_Context context, const edg_wll_Source destination, const char * dest_host, const char * dest_instance, const char * job, const char * reason, const char * dest_jobid);

/**
 * \brief edg_wll_LogTransferREFUSEDFile
 *
 * edg_wll_LogTransferREFUSEDFile - simple wrapper around edg_wll_LogEventFile for event Transfer, result REFUSED
 *
 * \param[in,out] context	context to work with, 
 * \param[in] destination	Destination where the job is being transfered to.
 * \param[in] dest_host	Hostname of server that takes over control of the job.
 * \param[in] dest_instance	Service (instance) that takes over control of the job.
 * \param[in] job	Job description in receiver's language.
 * \param[in] reason	Detailed description of the transfer, especially reason of failure.
 * \param[in] dest_jobid	Job id as assigned by the receiving software component.
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogTransferREFUSEDFile(edg_wll_Context context, const edg_wll_Source destination, const char * dest_host, const char * dest_instance, const char * job, const char * reason, const char * dest_jobid);

/**
 * \brief edg_wll_LogTransferFAIL
 *
 * edg_wll_LogTransferFAIL - simple wrapper around edg_wll_LogEvent for event Transfer, result FAIL
 *
 * \param[in,out] context	context to work with, 
 * \param[in] destination	Destination where the job is being transfered to.
 * \param[in] dest_host	Hostname of server that takes over control of the job.
 * \param[in] dest_instance	Service (instance) that takes over control of the job.
 * \param[in] job	Job description in receiver's language.
 * \param[in] reason	Detailed description of the transfer, especially reason of failure.
 * \param[in] dest_jobid	Job id as assigned by the receiving software component.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogTransferFAIL(edg_wll_Context context, const edg_wll_Source destination, const char * dest_host, const char * dest_instance, const char * job, const char * reason, const char * dest_jobid);

/**
 * \brief edg_wll_LogTransferFAILProxy
 *
 * edg_wll_LogTransferFAILProxy - simple wrapper around edg_wll_LogEventProxy for event Transfer, result FAIL
 *
 * \param[in,out] context	context to work with, 
 * \param[in] destination	Destination where the job is being transfered to.
 * \param[in] dest_host	Hostname of server that takes over control of the job.
 * \param[in] dest_instance	Service (instance) that takes over control of the job.
 * \param[in] job	Job description in receiver's language.
 * \param[in] reason	Detailed description of the transfer, especially reason of failure.
 * \param[in] dest_jobid	Job id as assigned by the receiving software component.
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogTransferFAILProxy(edg_wll_Context context, const edg_wll_Source destination, const char * dest_host, const char * dest_instance, const char * job, const char * reason, const char * dest_jobid);

/**
 * \brief edg_wll_LogTransferFAILFile
 *
 * edg_wll_LogTransferFAILFile - simple wrapper around edg_wll_LogEventFile for event Transfer, result FAIL
 *
 * \param[in,out] context	context to work with, 
 * \param[in] destination	Destination where the job is being transfered to.
 * \param[in] dest_host	Hostname of server that takes over control of the job.
 * \param[in] dest_instance	Service (instance) that takes over control of the job.
 * \param[in] job	Job description in receiver's language.
 * \param[in] reason	Detailed description of the transfer, especially reason of failure.
 * \param[in] dest_jobid	Job id as assigned by the receiving software component.
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogTransferFAILFile(edg_wll_Context context, const edg_wll_Source destination, const char * dest_host, const char * dest_instance, const char * job, const char * reason, const char * dest_jobid);

/**
 * \brief edg_wll_LogAccepted
 *
 * edg_wll_LogAccepted - simple wrapper around edg_wll_LogEvent for event Accepted
 *
 * \param[in,out] context	context to work with, 
 * \param[in] from	The software component  the job was received from.
 * \param[in] from_host	Hostname of the component the job was received from.
 * \param[in] from_instance	Instance of the component the job was received from.
 * \param[in] local_jobid	New job id as assigned by the receiving component.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogAccepted(edg_wll_Context context, const edg_wll_Source from, const char * from_host, const char * from_instance, const char * local_jobid);

/**
 * \brief edg_wll_LogAcceptedProxy
 *
 * edg_wll_LogAcceptedProxy - simple wrapper around edg_wll_LogEventProxy for event Accepted
 *
 * \param[in,out] context	context to work with, 
 * \param[in] from	The software component  the job was received from.
 * \param[in] from_host	Hostname of the component the job was received from.
 * \param[in] from_instance	Instance of the component the job was received from.
 * \param[in] local_jobid	New job id as assigned by the receiving component.
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogAcceptedProxy(edg_wll_Context context, const edg_wll_Source from, const char * from_host, const char * from_instance, const char * local_jobid);

/**
 * \brief edg_wll_LogAcceptedFile
 *
 * edg_wll_LogAcceptedFile - simple wrapper around edg_wll_LogEventFile for event Accepted
 *
 * \param[in,out] context	context to work with, 
 * \param[in] from	The software component  the job was received from.
 * \param[in] from_host	Hostname of the component the job was received from.
 * \param[in] from_instance	Instance of the component the job was received from.
 * \param[in] local_jobid	New job id as assigned by the receiving component.
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogAcceptedFile(edg_wll_Context context, const edg_wll_Source from, const char * from_host, const char * from_instance, const char * local_jobid);

/**
 * \brief edg_wll_LogRefused
 *
 * edg_wll_LogRefused - simple wrapper around edg_wll_LogEvent for event Refused
 *
 * \param[in,out] context	context to work with, 
 * \param[in] from	The software component that tried to send the job.
 * \param[in] from_host	Hostname of the component that tried to send the job.
 * \param[in] from_instance	Instance of the component that tried to send the job.
 * \param[in] reason	Description of the reason why the job was refused.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogRefused(edg_wll_Context context, const edg_wll_Source from, const char * from_host, const char * from_instance, const char * reason);

/**
 * \brief edg_wll_LogRefusedProxy
 *
 * edg_wll_LogRefusedProxy - simple wrapper around edg_wll_LogEventProxy for event Refused
 *
 * \param[in,out] context	context to work with, 
 * \param[in] from	The software component that tried to send the job.
 * \param[in] from_host	Hostname of the component that tried to send the job.
 * \param[in] from_instance	Instance of the component that tried to send the job.
 * \param[in] reason	Description of the reason why the job was refused.
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogRefusedProxy(edg_wll_Context context, const edg_wll_Source from, const char * from_host, const char * from_instance, const char * reason);

/**
 * \brief edg_wll_LogRefusedFile
 *
 * edg_wll_LogRefusedFile - simple wrapper around edg_wll_LogEventFile for event Refused
 *
 * \param[in,out] context	context to work with, 
 * \param[in] from	The software component that tried to send the job.
 * \param[in] from_host	Hostname of the component that tried to send the job.
 * \param[in] from_instance	Instance of the component that tried to send the job.
 * \param[in] reason	Description of the reason why the job was refused.
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogRefusedFile(edg_wll_Context context, const edg_wll_Source from, const char * from_host, const char * from_instance, const char * reason);

/**
 * \brief edg_wll_LogEnQueued
 *
 * edg_wll_LogEnQueued - simple wrapper around edg_wll_LogEvent for event EnQueued
 *
 * \param[in,out] context	context to work with, 
 * \param[in] queue	Queue into which the job has been stored for retrieval by another component.
 * \param[in] job	Job description in the receiver's language.
 * \param[in] result	Result code of the attempt to put job into the queue (START, OK, REFUSED or FAIL).
 * \param[in] reason	Detailed description of the attempt to enqueue the job, especially the reason of failure.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogEnQueued(edg_wll_Context context, const char * queue, const char * job, const char * result, const char * reason);

/**
 * \brief edg_wll_LogEnQueuedProxy
 *
 * edg_wll_LogEnQueuedProxy - simple wrapper around edg_wll_LogEventProxy for event EnQueued
 *
 * \param[in,out] context	context to work with, 
 * \param[in] queue	Queue into which the job has been stored for retrieval by another component.
 * \param[in] job	Job description in the receiver's language.
 * \param[in] result	Result code of the attempt to put job into the queue (START, OK, REFUSED or FAIL).
 * \param[in] reason	Detailed description of the attempt to enqueue the job, especially the reason of failure.
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogEnQueuedProxy(edg_wll_Context context, const char * queue, const char * job, const char * result, const char * reason);

/**
 * \brief edg_wll_LogEnQueuedFile
 *
 * edg_wll_LogEnQueuedFile - simple wrapper around edg_wll_LogEventFile for event EnQueued
 *
 * \param[in,out] context	context to work with, 
 * \param[in] queue	Queue into which the job has been stored for retrieval by another component.
 * \param[in] job	Job description in the receiver's language.
 * \param[in] result	Result code of the attempt to put job into the queue (START, OK, REFUSED or FAIL).
 * \param[in] reason	Detailed description of the attempt to enqueue the job, especially the reason of failure.
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogEnQueuedFile(edg_wll_Context context, const char * queue, const char * job, const char * result, const char * reason);

/**
 * \brief edg_wll_LogEnQueuedSTART
 *
 * edg_wll_LogEnQueuedSTART - simple wrapper around edg_wll_LogEvent for event EnQueued, result START
 *
 * \param[in,out] context	context to work with, 
 * \param[in] queue	Queue into which the job has been stored for retrieval by another component.
 * \param[in] job	Job description in the receiver's language.
 * \param[in] reason	Detailed description of the attempt to enqueue the job, especially the reason of failure.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogEnQueuedSTART(edg_wll_Context context, const char * queue, const char * job, const char * reason);

/**
 * \brief edg_wll_LogEnQueuedSTARTProxy
 *
 * edg_wll_LogEnQueuedSTARTProxy - simple wrapper around edg_wll_LogEventProxy for event EnQueued, result START
 *
 * \param[in,out] context	context to work with, 
 * \param[in] queue	Queue into which the job has been stored for retrieval by another component.
 * \param[in] job	Job description in the receiver's language.
 * \param[in] reason	Detailed description of the attempt to enqueue the job, especially the reason of failure.
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogEnQueuedSTARTProxy(edg_wll_Context context, const char * queue, const char * job, const char * reason);

/**
 * \brief edg_wll_LogEnQueuedSTARTFile
 *
 * edg_wll_LogEnQueuedSTARTFile - simple wrapper around edg_wll_LogEventFile for event EnQueued, result START
 *
 * \param[in,out] context	context to work with, 
 * \param[in] queue	Queue into which the job has been stored for retrieval by another component.
 * \param[in] job	Job description in the receiver's language.
 * \param[in] reason	Detailed description of the attempt to enqueue the job, especially the reason of failure.
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogEnQueuedSTARTFile(edg_wll_Context context, const char * queue, const char * job, const char * reason);

/**
 * \brief edg_wll_LogEnQueuedOK
 *
 * edg_wll_LogEnQueuedOK - simple wrapper around edg_wll_LogEvent for event EnQueued, result OK
 *
 * \param[in,out] context	context to work with, 
 * \param[in] queue	Queue into which the job has been stored for retrieval by another component.
 * \param[in] job	Job description in the receiver's language.
 * \param[in] reason	Detailed description of the attempt to enqueue the job, especially the reason of failure.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogEnQueuedOK(edg_wll_Context context, const char * queue, const char * job, const char * reason);

/**
 * \brief edg_wll_LogEnQueuedOKProxy
 *
 * edg_wll_LogEnQueuedOKProxy - simple wrapper around edg_wll_LogEventProxy for event EnQueued, result OK
 *
 * \param[in,out] context	context to work with, 
 * \param[in] queue	Queue into which the job has been stored for retrieval by another component.
 * \param[in] job	Job description in the receiver's language.
 * \param[in] reason	Detailed description of the attempt to enqueue the job, especially the reason of failure.
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogEnQueuedOKProxy(edg_wll_Context context, const char * queue, const char * job, const char * reason);

/**
 * \brief edg_wll_LogEnQueuedOKFile
 *
 * edg_wll_LogEnQueuedOKFile - simple wrapper around edg_wll_LogEventFile for event EnQueued, result OK
 *
 * \param[in,out] context	context to work with, 
 * \param[in] queue	Queue into which the job has been stored for retrieval by another component.
 * \param[in] job	Job description in the receiver's language.
 * \param[in] reason	Detailed description of the attempt to enqueue the job, especially the reason of failure.
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogEnQueuedOKFile(edg_wll_Context context, const char * queue, const char * job, const char * reason);

/**
 * \brief edg_wll_LogEnQueuedREFUSED
 *
 * edg_wll_LogEnQueuedREFUSED - simple wrapper around edg_wll_LogEvent for event EnQueued, result REFUSED
 *
 * \param[in,out] context	context to work with, 
 * \param[in] queue	Queue into which the job has been stored for retrieval by another component.
 * \param[in] job	Job description in the receiver's language.
 * \param[in] reason	Detailed description of the attempt to enqueue the job, especially the reason of failure.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogEnQueuedREFUSED(edg_wll_Context context, const char * queue, const char * job, const char * reason);

/**
 * \brief edg_wll_LogEnQueuedREFUSEDProxy
 *
 * edg_wll_LogEnQueuedREFUSEDProxy - simple wrapper around edg_wll_LogEventProxy for event EnQueued, result REFUSED
 *
 * \param[in,out] context	context to work with, 
 * \param[in] queue	Queue into which the job has been stored for retrieval by another component.
 * \param[in] job	Job description in the receiver's language.
 * \param[in] reason	Detailed description of the attempt to enqueue the job, especially the reason of failure.
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogEnQueuedREFUSEDProxy(edg_wll_Context context, const char * queue, const char * job, const char * reason);

/**
 * \brief edg_wll_LogEnQueuedREFUSEDFile
 *
 * edg_wll_LogEnQueuedREFUSEDFile - simple wrapper around edg_wll_LogEventFile for event EnQueued, result REFUSED
 *
 * \param[in,out] context	context to work with, 
 * \param[in] queue	Queue into which the job has been stored for retrieval by another component.
 * \param[in] job	Job description in the receiver's language.
 * \param[in] reason	Detailed description of the attempt to enqueue the job, especially the reason of failure.
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogEnQueuedREFUSEDFile(edg_wll_Context context, const char * queue, const char * job, const char * reason);

/**
 * \brief edg_wll_LogEnQueuedFAIL
 *
 * edg_wll_LogEnQueuedFAIL - simple wrapper around edg_wll_LogEvent for event EnQueued, result FAIL
 *
 * \param[in,out] context	context to work with, 
 * \param[in] queue	Queue into which the job has been stored for retrieval by another component.
 * \param[in] job	Job description in the receiver's language.
 * \param[in] reason	Detailed description of the attempt to enqueue the job, especially the reason of failure.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogEnQueuedFAIL(edg_wll_Context context, const char * queue, const char * job, const char * reason);

/**
 * \brief edg_wll_LogEnQueuedFAILProxy
 *
 * edg_wll_LogEnQueuedFAILProxy - simple wrapper around edg_wll_LogEventProxy for event EnQueued, result FAIL
 *
 * \param[in,out] context	context to work with, 
 * \param[in] queue	Queue into which the job has been stored for retrieval by another component.
 * \param[in] job	Job description in the receiver's language.
 * \param[in] reason	Detailed description of the attempt to enqueue the job, especially the reason of failure.
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogEnQueuedFAILProxy(edg_wll_Context context, const char * queue, const char * job, const char * reason);

/**
 * \brief edg_wll_LogEnQueuedFAILFile
 *
 * edg_wll_LogEnQueuedFAILFile - simple wrapper around edg_wll_LogEventFile for event EnQueued, result FAIL
 *
 * \param[in,out] context	context to work with, 
 * \param[in] queue	Queue into which the job has been stored for retrieval by another component.
 * \param[in] job	Job description in the receiver's language.
 * \param[in] reason	Detailed description of the attempt to enqueue the job, especially the reason of failure.
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogEnQueuedFAILFile(edg_wll_Context context, const char * queue, const char * job, const char * reason);

/**
 * \brief edg_wll_LogDeQueued
 *
 * edg_wll_LogDeQueued - simple wrapper around edg_wll_LogEvent for event DeQueued
 *
 * \param[in,out] context	context to work with, 
 * \param[in] queue	Name of the queue the job was obtained from.
 * \param[in] local_jobid	New job id as assigned by the retreiving component.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogDeQueued(edg_wll_Context context, const char * queue, const char * local_jobid);

/**
 * \brief edg_wll_LogDeQueuedProxy
 *
 * edg_wll_LogDeQueuedProxy - simple wrapper around edg_wll_LogEventProxy for event DeQueued
 *
 * \param[in,out] context	context to work with, 
 * \param[in] queue	Name of the queue the job was obtained from.
 * \param[in] local_jobid	New job id as assigned by the retreiving component.
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogDeQueuedProxy(edg_wll_Context context, const char * queue, const char * local_jobid);

/**
 * \brief edg_wll_LogDeQueuedFile
 *
 * edg_wll_LogDeQueuedFile - simple wrapper around edg_wll_LogEventFile for event DeQueued
 *
 * \param[in,out] context	context to work with, 
 * \param[in] queue	Name of the queue the job was obtained from.
 * \param[in] local_jobid	New job id as assigned by the retreiving component.
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogDeQueuedFile(edg_wll_Context context, const char * queue, const char * local_jobid);

/**
 * \brief edg_wll_LogHelperCall
 *
 * edg_wll_LogHelperCall - simple wrapper around edg_wll_LogEvent for event HelperCall
 *
 * \param[in,out] context	context to work with, 
 * \param[in] helper_name	Name of the called helper component.
 * \param[in] helper_params	Parameters of the call to the helper component.
 * \param[in] src_role	The role the event sender is playing in the helper call (CALLING or CALLEE).
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogHelperCall(edg_wll_Context context, const char * helper_name, const char * helper_params, const char * src_role);

/**
 * \brief edg_wll_LogHelperCallProxy
 *
 * edg_wll_LogHelperCallProxy - simple wrapper around edg_wll_LogEventProxy for event HelperCall
 *
 * \param[in,out] context	context to work with, 
 * \param[in] helper_name	Name of the called helper component.
 * \param[in] helper_params	Parameters of the call to the helper component.
 * \param[in] src_role	The role the event sender is playing in the helper call (CALLING or CALLEE).
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogHelperCallProxy(edg_wll_Context context, const char * helper_name, const char * helper_params, const char * src_role);

/**
 * \brief edg_wll_LogHelperCallFile
 *
 * edg_wll_LogHelperCallFile - simple wrapper around edg_wll_LogEventFile for event HelperCall
 *
 * \param[in,out] context	context to work with, 
 * \param[in] helper_name	Name of the called helper component.
 * \param[in] helper_params	Parameters of the call to the helper component.
 * \param[in] src_role	The role the event sender is playing in the helper call (CALLING or CALLEE).
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogHelperCallFile(edg_wll_Context context, const char * helper_name, const char * helper_params, const char * src_role);

/**
 * \brief edg_wll_LogHelperCallCALLING
 *
 * edg_wll_LogHelperCallCALLING - simple wrapper around edg_wll_LogEvent for event HelperCall, src_role CALLING
 *
 * \param[in,out] context	context to work with, 
 * \param[in] helper_name	Name of the called helper component.
 * \param[in] helper_params	Parameters of the call to the helper component.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogHelperCallCALLING(edg_wll_Context context, const char * helper_name, const char * helper_params);

/**
 * \brief edg_wll_LogHelperCallCALLINGProxy
 *
 * edg_wll_LogHelperCallCALLINGProxy - simple wrapper around edg_wll_LogEventProxy for event HelperCall, src_role CALLING
 *
 * \param[in,out] context	context to work with, 
 * \param[in] helper_name	Name of the called helper component.
 * \param[in] helper_params	Parameters of the call to the helper component.
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogHelperCallCALLINGProxy(edg_wll_Context context, const char * helper_name, const char * helper_params);

/**
 * \brief edg_wll_LogHelperCallCALLINGFile
 *
 * edg_wll_LogHelperCallCALLINGFile - simple wrapper around edg_wll_LogEventFile for event HelperCall, src_role CALLING
 *
 * \param[in,out] context	context to work with, 
 * \param[in] helper_name	Name of the called helper component.
 * \param[in] helper_params	Parameters of the call to the helper component.
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogHelperCallCALLINGFile(edg_wll_Context context, const char * helper_name, const char * helper_params);

/**
 * \brief edg_wll_LogHelperCallCALLED
 *
 * edg_wll_LogHelperCallCALLED - simple wrapper around edg_wll_LogEvent for event HelperCall, src_role CALLED
 *
 * \param[in,out] context	context to work with, 
 * \param[in] helper_name	Name of the called helper component.
 * \param[in] helper_params	Parameters of the call to the helper component.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogHelperCallCALLED(edg_wll_Context context, const char * helper_name, const char * helper_params);

/**
 * \brief edg_wll_LogHelperCallCALLEDProxy
 *
 * edg_wll_LogHelperCallCALLEDProxy - simple wrapper around edg_wll_LogEventProxy for event HelperCall, src_role CALLED
 *
 * \param[in,out] context	context to work with, 
 * \param[in] helper_name	Name of the called helper component.
 * \param[in] helper_params	Parameters of the call to the helper component.
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogHelperCallCALLEDProxy(edg_wll_Context context, const char * helper_name, const char * helper_params);

/**
 * \brief edg_wll_LogHelperCallCALLEDFile
 *
 * edg_wll_LogHelperCallCALLEDFile - simple wrapper around edg_wll_LogEventFile for event HelperCall, src_role CALLED
 *
 * \param[in,out] context	context to work with, 
 * \param[in] helper_name	Name of the called helper component.
 * \param[in] helper_params	Parameters of the call to the helper component.
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogHelperCallCALLEDFile(edg_wll_Context context, const char * helper_name, const char * helper_params);

/**
 * \brief edg_wll_LogHelperReturn
 *
 * edg_wll_LogHelperReturn - simple wrapper around edg_wll_LogEvent for event HelperReturn
 *
 * \param[in,out] context	context to work with, 
 * \param[in] helper_name	Name of the called helper component.
 * \param[in] retval	Data returned by the call to the helper component.
 * \param[in] src_role	The role the event sender is playing in the helper call (CALLING or CALLEE).
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogHelperReturn(edg_wll_Context context, const char * helper_name, const char * retval, const char * src_role);

/**
 * \brief edg_wll_LogHelperReturnProxy
 *
 * edg_wll_LogHelperReturnProxy - simple wrapper around edg_wll_LogEventProxy for event HelperReturn
 *
 * \param[in,out] context	context to work with, 
 * \param[in] helper_name	Name of the called helper component.
 * \param[in] retval	Data returned by the call to the helper component.
 * \param[in] src_role	The role the event sender is playing in the helper call (CALLING or CALLEE).
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogHelperReturnProxy(edg_wll_Context context, const char * helper_name, const char * retval, const char * src_role);

/**
 * \brief edg_wll_LogHelperReturnFile
 *
 * edg_wll_LogHelperReturnFile - simple wrapper around edg_wll_LogEventFile for event HelperReturn
 *
 * \param[in,out] context	context to work with, 
 * \param[in] helper_name	Name of the called helper component.
 * \param[in] retval	Data returned by the call to the helper component.
 * \param[in] src_role	The role the event sender is playing in the helper call (CALLING or CALLEE).
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogHelperReturnFile(edg_wll_Context context, const char * helper_name, const char * retval, const char * src_role);

/**
 * \brief edg_wll_LogHelperReturnCALLING
 *
 * edg_wll_LogHelperReturnCALLING - simple wrapper around edg_wll_LogEvent for event HelperReturn, src_role CALLING
 *
 * \param[in,out] context	context to work with, 
 * \param[in] helper_name	Name of the called helper component.
 * \param[in] retval	Data returned by the call to the helper component.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogHelperReturnCALLING(edg_wll_Context context, const char * helper_name, const char * retval);

/**
 * \brief edg_wll_LogHelperReturnCALLINGProxy
 *
 * edg_wll_LogHelperReturnCALLINGProxy - simple wrapper around edg_wll_LogEventProxy for event HelperReturn, src_role CALLING
 *
 * \param[in,out] context	context to work with, 
 * \param[in] helper_name	Name of the called helper component.
 * \param[in] retval	Data returned by the call to the helper component.
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogHelperReturnCALLINGProxy(edg_wll_Context context, const char * helper_name, const char * retval);

/**
 * \brief edg_wll_LogHelperReturnCALLINGFile
 *
 * edg_wll_LogHelperReturnCALLINGFile - simple wrapper around edg_wll_LogEventFile for event HelperReturn, src_role CALLING
 *
 * \param[in,out] context	context to work with, 
 * \param[in] helper_name	Name of the called helper component.
 * \param[in] retval	Data returned by the call to the helper component.
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogHelperReturnCALLINGFile(edg_wll_Context context, const char * helper_name, const char * retval);

/**
 * \brief edg_wll_LogHelperReturnCALLED
 *
 * edg_wll_LogHelperReturnCALLED - simple wrapper around edg_wll_LogEvent for event HelperReturn, src_role CALLED
 *
 * \param[in,out] context	context to work with, 
 * \param[in] helper_name	Name of the called helper component.
 * \param[in] retval	Data returned by the call to the helper component.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogHelperReturnCALLED(edg_wll_Context context, const char * helper_name, const char * retval);

/**
 * \brief edg_wll_LogHelperReturnCALLEDProxy
 *
 * edg_wll_LogHelperReturnCALLEDProxy - simple wrapper around edg_wll_LogEventProxy for event HelperReturn, src_role CALLED
 *
 * \param[in,out] context	context to work with, 
 * \param[in] helper_name	Name of the called helper component.
 * \param[in] retval	Data returned by the call to the helper component.
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogHelperReturnCALLEDProxy(edg_wll_Context context, const char * helper_name, const char * retval);

/**
 * \brief edg_wll_LogHelperReturnCALLEDFile
 *
 * edg_wll_LogHelperReturnCALLEDFile - simple wrapper around edg_wll_LogEventFile for event HelperReturn, src_role CALLED
 *
 * \param[in,out] context	context to work with, 
 * \param[in] helper_name	Name of the called helper component.
 * \param[in] retval	Data returned by the call to the helper component.
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogHelperReturnCALLEDFile(edg_wll_Context context, const char * helper_name, const char * retval);

/**
 * \brief edg_wll_LogRunning
 *
 * edg_wll_LogRunning - simple wrapper around edg_wll_LogEvent for event Running
 *
 * \param[in,out] context	context to work with, 
 * \param[in] node	Worker node on which the job executable is being run.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogRunning(edg_wll_Context context, const char * node);

/**
 * \brief edg_wll_LogRunningProxy
 *
 * edg_wll_LogRunningProxy - simple wrapper around edg_wll_LogEventProxy for event Running
 *
 * \param[in,out] context	context to work with, 
 * \param[in] node	Worker node on which the job executable is being run.
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogRunningProxy(edg_wll_Context context, const char * node);

/**
 * \brief edg_wll_LogRunningFile
 *
 * edg_wll_LogRunningFile - simple wrapper around edg_wll_LogEventFile for event Running
 *
 * \param[in,out] context	context to work with, 
 * \param[in] node	Worker node on which the job executable is being run.
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogRunningFile(edg_wll_Context context, const char * node);

/**
 * \brief edg_wll_LogResubmission
 *
 * edg_wll_LogResubmission - simple wrapper around edg_wll_LogEvent for event Resubmission
 *
 * \param[in,out] context	context to work with, 
 * \param[in] result	Result code of the resubmission decision (WILLRESUB or WONTRESUB or SHALLOW).
 * \param[in] reason	Reason why the job will or will not be resubmitted.
 * \param[in] tag	Value of the attribute on which the decision to resubmit the job was based.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogResubmission(edg_wll_Context context, const char * result, const char * reason, const char * tag);

/**
 * \brief edg_wll_LogResubmissionProxy
 *
 * edg_wll_LogResubmissionProxy - simple wrapper around edg_wll_LogEventProxy for event Resubmission
 *
 * \param[in,out] context	context to work with, 
 * \param[in] result	Result code of the resubmission decision (WILLRESUB or WONTRESUB or SHALLOW).
 * \param[in] reason	Reason why the job will or will not be resubmitted.
 * \param[in] tag	Value of the attribute on which the decision to resubmit the job was based.
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogResubmissionProxy(edg_wll_Context context, const char * result, const char * reason, const char * tag);

/**
 * \brief edg_wll_LogResubmissionFile
 *
 * edg_wll_LogResubmissionFile - simple wrapper around edg_wll_LogEventFile for event Resubmission
 *
 * \param[in,out] context	context to work with, 
 * \param[in] result	Result code of the resubmission decision (WILLRESUB or WONTRESUB or SHALLOW).
 * \param[in] reason	Reason why the job will or will not be resubmitted.
 * \param[in] tag	Value of the attribute on which the decision to resubmit the job was based.
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogResubmissionFile(edg_wll_Context context, const char * result, const char * reason, const char * tag);

/**
 * \brief edg_wll_LogResubmissionWILLRESUB
 *
 * edg_wll_LogResubmissionWILLRESUB - simple wrapper around edg_wll_LogEvent for event Resubmission, result WILLRESUB
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason why the job will or will not be resubmitted.
 * \param[in] tag	Value of the attribute on which the decision to resubmit the job was based.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogResubmissionWILLRESUB(edg_wll_Context context, const char * reason, const char * tag);

/**
 * \brief edg_wll_LogResubmissionWILLRESUBProxy
 *
 * edg_wll_LogResubmissionWILLRESUBProxy - simple wrapper around edg_wll_LogEventProxy for event Resubmission, result WILLRESUB
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason why the job will or will not be resubmitted.
 * \param[in] tag	Value of the attribute on which the decision to resubmit the job was based.
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogResubmissionWILLRESUBProxy(edg_wll_Context context, const char * reason, const char * tag);

/**
 * \brief edg_wll_LogResubmissionWILLRESUBFile
 *
 * edg_wll_LogResubmissionWILLRESUBFile - simple wrapper around edg_wll_LogEventFile for event Resubmission, result WILLRESUB
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason why the job will or will not be resubmitted.
 * \param[in] tag	Value of the attribute on which the decision to resubmit the job was based.
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogResubmissionWILLRESUBFile(edg_wll_Context context, const char * reason, const char * tag);

/**
 * \brief edg_wll_LogResubmissionWONTRESUB
 *
 * edg_wll_LogResubmissionWONTRESUB - simple wrapper around edg_wll_LogEvent for event Resubmission, result WONTRESUB
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason why the job will or will not be resubmitted.
 * \param[in] tag	Value of the attribute on which the decision to resubmit the job was based.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogResubmissionWONTRESUB(edg_wll_Context context, const char * reason, const char * tag);

/**
 * \brief edg_wll_LogResubmissionWONTRESUBProxy
 *
 * edg_wll_LogResubmissionWONTRESUBProxy - simple wrapper around edg_wll_LogEventProxy for event Resubmission, result WONTRESUB
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason why the job will or will not be resubmitted.
 * \param[in] tag	Value of the attribute on which the decision to resubmit the job was based.
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogResubmissionWONTRESUBProxy(edg_wll_Context context, const char * reason, const char * tag);

/**
 * \brief edg_wll_LogResubmissionWONTRESUBFile
 *
 * edg_wll_LogResubmissionWONTRESUBFile - simple wrapper around edg_wll_LogEventFile for event Resubmission, result WONTRESUB
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason why the job will or will not be resubmitted.
 * \param[in] tag	Value of the attribute on which the decision to resubmit the job was based.
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogResubmissionWONTRESUBFile(edg_wll_Context context, const char * reason, const char * tag);

/**
 * \brief edg_wll_LogResubmissionSHALLOW
 *
 * edg_wll_LogResubmissionSHALLOW - simple wrapper around edg_wll_LogEvent for event Resubmission, result SHALLOW
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason why the job will or will not be resubmitted.
 * \param[in] tag	Value of the attribute on which the decision to resubmit the job was based.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogResubmissionSHALLOW(edg_wll_Context context, const char * reason, const char * tag);

/**
 * \brief edg_wll_LogResubmissionSHALLOWProxy
 *
 * edg_wll_LogResubmissionSHALLOWProxy - simple wrapper around edg_wll_LogEventProxy for event Resubmission, result SHALLOW
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason why the job will or will not be resubmitted.
 * \param[in] tag	Value of the attribute on which the decision to resubmit the job was based.
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogResubmissionSHALLOWProxy(edg_wll_Context context, const char * reason, const char * tag);

/**
 * \brief edg_wll_LogResubmissionSHALLOWFile
 *
 * edg_wll_LogResubmissionSHALLOWFile - simple wrapper around edg_wll_LogEventFile for event Resubmission, result SHALLOW
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason why the job will or will not be resubmitted.
 * \param[in] tag	Value of the attribute on which the decision to resubmit the job was based.
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogResubmissionSHALLOWFile(edg_wll_Context context, const char * reason, const char * tag);

/**
 * \brief edg_wll_LogDone
 *
 * edg_wll_LogDone - simple wrapper around edg_wll_LogEvent for event Done
 *
 * \param[in,out] context	context to work with, 
 * \param[in] status_code	Reason code for the termination of the job (OK, FAILED or CANCELLED).
 * \param[in] reason	Detailed description why the job was terminated.
 * \param[in] exit_code	Exit code of the job's process.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogDone(edg_wll_Context context, const char * status_code, const char * reason, const int exit_code);

/**
 * \brief edg_wll_LogDoneProxy
 *
 * edg_wll_LogDoneProxy - simple wrapper around edg_wll_LogEventProxy for event Done
 *
 * \param[in,out] context	context to work with, 
 * \param[in] status_code	Reason code for the termination of the job (OK, FAILED or CANCELLED).
 * \param[in] reason	Detailed description why the job was terminated.
 * \param[in] exit_code	Exit code of the job's process.
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogDoneProxy(edg_wll_Context context, const char * status_code, const char * reason, const int exit_code);

/**
 * \brief edg_wll_LogDoneFile
 *
 * edg_wll_LogDoneFile - simple wrapper around edg_wll_LogEventFile for event Done
 *
 * \param[in,out] context	context to work with, 
 * \param[in] status_code	Reason code for the termination of the job (OK, FAILED or CANCELLED).
 * \param[in] reason	Detailed description why the job was terminated.
 * \param[in] exit_code	Exit code of the job's process.
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogDoneFile(edg_wll_Context context, const char * status_code, const char * reason, const int exit_code);

/**
 * \brief edg_wll_LogDoneOK
 *
 * edg_wll_LogDoneOK - simple wrapper around edg_wll_LogEvent for event Done, status_code OK
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Detailed description why the job was terminated.
 * \param[in] exit_code	Exit code of the job's process.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogDoneOK(edg_wll_Context context, const char * reason, const int exit_code);

/**
 * \brief edg_wll_LogDoneOKProxy
 *
 * edg_wll_LogDoneOKProxy - simple wrapper around edg_wll_LogEventProxy for event Done, status_code OK
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Detailed description why the job was terminated.
 * \param[in] exit_code	Exit code of the job's process.
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogDoneOKProxy(edg_wll_Context context, const char * reason, const int exit_code);

/**
 * \brief edg_wll_LogDoneOKFile
 *
 * edg_wll_LogDoneOKFile - simple wrapper around edg_wll_LogEventFile for event Done, status_code OK
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Detailed description why the job was terminated.
 * \param[in] exit_code	Exit code of the job's process.
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogDoneOKFile(edg_wll_Context context, const char * reason, const int exit_code);

/**
 * \brief edg_wll_LogDoneFAILED
 *
 * edg_wll_LogDoneFAILED - simple wrapper around edg_wll_LogEvent for event Done, status_code FAILED
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Detailed description why the job was terminated.
 * \param[in] exit_code	Exit code of the job's process.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogDoneFAILED(edg_wll_Context context, const char * reason, const int exit_code);

/**
 * \brief edg_wll_LogDoneFAILEDProxy
 *
 * edg_wll_LogDoneFAILEDProxy - simple wrapper around edg_wll_LogEventProxy for event Done, status_code FAILED
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Detailed description why the job was terminated.
 * \param[in] exit_code	Exit code of the job's process.
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogDoneFAILEDProxy(edg_wll_Context context, const char * reason, const int exit_code);

/**
 * \brief edg_wll_LogDoneFAILEDFile
 *
 * edg_wll_LogDoneFAILEDFile - simple wrapper around edg_wll_LogEventFile for event Done, status_code FAILED
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Detailed description why the job was terminated.
 * \param[in] exit_code	Exit code of the job's process.
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogDoneFAILEDFile(edg_wll_Context context, const char * reason, const int exit_code);

/**
 * \brief edg_wll_LogDoneCANCELLED
 *
 * edg_wll_LogDoneCANCELLED - simple wrapper around edg_wll_LogEvent for event Done, status_code CANCELLED
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Detailed description why the job was terminated.
 * \param[in] exit_code	Exit code of the job's process.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogDoneCANCELLED(edg_wll_Context context, const char * reason, const int exit_code);

/**
 * \brief edg_wll_LogDoneCANCELLEDProxy
 *
 * edg_wll_LogDoneCANCELLEDProxy - simple wrapper around edg_wll_LogEventProxy for event Done, status_code CANCELLED
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Detailed description why the job was terminated.
 * \param[in] exit_code	Exit code of the job's process.
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogDoneCANCELLEDProxy(edg_wll_Context context, const char * reason, const int exit_code);

/**
 * \brief edg_wll_LogDoneCANCELLEDFile
 *
 * edg_wll_LogDoneCANCELLEDFile - simple wrapper around edg_wll_LogEventFile for event Done, status_code CANCELLED
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Detailed description why the job was terminated.
 * \param[in] exit_code	Exit code of the job's process.
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogDoneCANCELLEDFile(edg_wll_Context context, const char * reason, const int exit_code);

/**
 * \brief edg_wll_LogDoneKILLED
 *
 * edg_wll_LogDoneKILLED - simple wrapper around edg_wll_LogEvent for event Done, status_code KILLED
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Detailed description why the job was terminated.
 * \param[in] exit_code	Exit code of the job's process.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogDoneKILLED(edg_wll_Context context, const char * reason, const int exit_code);

/**
 * \brief edg_wll_LogDoneKILLEDProxy
 *
 * edg_wll_LogDoneKILLEDProxy - simple wrapper around edg_wll_LogEventProxy for event Done, status_code KILLED
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Detailed description why the job was terminated.
 * \param[in] exit_code	Exit code of the job's process.
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogDoneKILLEDProxy(edg_wll_Context context, const char * reason, const int exit_code);

/**
 * \brief edg_wll_LogDoneKILLEDFile
 *
 * edg_wll_LogDoneKILLEDFile - simple wrapper around edg_wll_LogEventFile for event Done, status_code KILLED
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Detailed description why the job was terminated.
 * \param[in] exit_code	Exit code of the job's process.
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogDoneKILLEDFile(edg_wll_Context context, const char * reason, const int exit_code);

/**
 * \brief edg_wll_LogCancel
 *
 * edg_wll_LogCancel - simple wrapper around edg_wll_LogEvent for event Cancel
 *
 * \param[in,out] context	context to work with, 
 * \param[in] status_code	Classification of the attempt to cancel the job (REQ, REFUSE, DONE or ABORT).
 * \param[in] reason	Detailed description of the attempt to cancel the job, especially the reason of failure.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogCancel(edg_wll_Context context, const char * status_code, const char * reason);

/**
 * \brief edg_wll_LogCancelProxy
 *
 * edg_wll_LogCancelProxy - simple wrapper around edg_wll_LogEventProxy for event Cancel
 *
 * \param[in,out] context	context to work with, 
 * \param[in] status_code	Classification of the attempt to cancel the job (REQ, REFUSE, DONE or ABORT).
 * \param[in] reason	Detailed description of the attempt to cancel the job, especially the reason of failure.
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogCancelProxy(edg_wll_Context context, const char * status_code, const char * reason);

/**
 * \brief edg_wll_LogCancelFile
 *
 * edg_wll_LogCancelFile - simple wrapper around edg_wll_LogEventFile for event Cancel
 *
 * \param[in,out] context	context to work with, 
 * \param[in] status_code	Classification of the attempt to cancel the job (REQ, REFUSE, DONE or ABORT).
 * \param[in] reason	Detailed description of the attempt to cancel the job, especially the reason of failure.
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogCancelFile(edg_wll_Context context, const char * status_code, const char * reason);

/**
 * \brief edg_wll_LogCancelREQ
 *
 * edg_wll_LogCancelREQ - simple wrapper around edg_wll_LogEvent for event Cancel, status_code REQ
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Detailed description of the attempt to cancel the job, especially the reason of failure.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogCancelREQ(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogCancelREQProxy
 *
 * edg_wll_LogCancelREQProxy - simple wrapper around edg_wll_LogEventProxy for event Cancel, status_code REQ
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Detailed description of the attempt to cancel the job, especially the reason of failure.
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogCancelREQProxy(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogCancelREQFile
 *
 * edg_wll_LogCancelREQFile - simple wrapper around edg_wll_LogEventFile for event Cancel, status_code REQ
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Detailed description of the attempt to cancel the job, especially the reason of failure.
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogCancelREQFile(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogCancelREFUSE
 *
 * edg_wll_LogCancelREFUSE - simple wrapper around edg_wll_LogEvent for event Cancel, status_code REFUSE
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Detailed description of the attempt to cancel the job, especially the reason of failure.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogCancelREFUSE(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogCancelREFUSEProxy
 *
 * edg_wll_LogCancelREFUSEProxy - simple wrapper around edg_wll_LogEventProxy for event Cancel, status_code REFUSE
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Detailed description of the attempt to cancel the job, especially the reason of failure.
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogCancelREFUSEProxy(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogCancelREFUSEFile
 *
 * edg_wll_LogCancelREFUSEFile - simple wrapper around edg_wll_LogEventFile for event Cancel, status_code REFUSE
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Detailed description of the attempt to cancel the job, especially the reason of failure.
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogCancelREFUSEFile(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogCancelDONE
 *
 * edg_wll_LogCancelDONE - simple wrapper around edg_wll_LogEvent for event Cancel, status_code DONE
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Detailed description of the attempt to cancel the job, especially the reason of failure.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogCancelDONE(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogCancelDONEProxy
 *
 * edg_wll_LogCancelDONEProxy - simple wrapper around edg_wll_LogEventProxy for event Cancel, status_code DONE
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Detailed description of the attempt to cancel the job, especially the reason of failure.
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogCancelDONEProxy(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogCancelDONEFile
 *
 * edg_wll_LogCancelDONEFile - simple wrapper around edg_wll_LogEventFile for event Cancel, status_code DONE
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Detailed description of the attempt to cancel the job, especially the reason of failure.
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogCancelDONEFile(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogCancelABORT
 *
 * edg_wll_LogCancelABORT - simple wrapper around edg_wll_LogEvent for event Cancel, status_code ABORT
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Detailed description of the attempt to cancel the job, especially the reason of failure.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogCancelABORT(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogCancelABORTProxy
 *
 * edg_wll_LogCancelABORTProxy - simple wrapper around edg_wll_LogEventProxy for event Cancel, status_code ABORT
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Detailed description of the attempt to cancel the job, especially the reason of failure.
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogCancelABORTProxy(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogCancelABORTFile
 *
 * edg_wll_LogCancelABORTFile - simple wrapper around edg_wll_LogEventFile for event Cancel, status_code ABORT
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Detailed description of the attempt to cancel the job, especially the reason of failure.
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogCancelABORTFile(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogAbort
 *
 * edg_wll_LogAbort - simple wrapper around edg_wll_LogEvent for event Abort
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason why the job was aborted by the system.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogAbort(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogAbortProxy
 *
 * edg_wll_LogAbortProxy - simple wrapper around edg_wll_LogEventProxy for event Abort
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason why the job was aborted by the system.
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogAbortProxy(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogAbortFile
 *
 * edg_wll_LogAbortFile - simple wrapper around edg_wll_LogEventFile for event Abort
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason why the job was aborted by the system.
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogAbortFile(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogClear
 *
 * edg_wll_LogClear - simple wrapper around edg_wll_LogEvent for event Clear
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Description of the reason why the job was cleared and the output sandbox removed (USER, TIMEOUT or NOOUTPUT).
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogClear(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogClearProxy
 *
 * edg_wll_LogClearProxy - simple wrapper around edg_wll_LogEventProxy for event Clear
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Description of the reason why the job was cleared and the output sandbox removed (USER, TIMEOUT or NOOUTPUT).
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogClearProxy(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogClearFile
 *
 * edg_wll_LogClearFile - simple wrapper around edg_wll_LogEventFile for event Clear
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Description of the reason why the job was cleared and the output sandbox removed (USER, TIMEOUT or NOOUTPUT).
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogClearFile(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogClearUSER
 *
 * edg_wll_LogClearUSER - simple wrapper around edg_wll_LogEvent for event Clear, reason USER
 *
 * \param[in,out] context	context to work with, 
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogClearUSER(edg_wll_Context context);

/**
 * \brief edg_wll_LogClearUSERProxy
 *
 * edg_wll_LogClearUSERProxy - simple wrapper around edg_wll_LogEventProxy for event Clear, reason USER
 *
 * \param[in,out] context	context to work with, 
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogClearUSERProxy(edg_wll_Context context);

/**
 * \brief edg_wll_LogClearUSERFile
 *
 * edg_wll_LogClearUSERFile - simple wrapper around edg_wll_LogEventFile for event Clear, reason USER
 *
 * \param[in,out] context	context to work with, 
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogClearUSERFile(edg_wll_Context context);

/**
 * \brief edg_wll_LogClearTIMEOUT
 *
 * edg_wll_LogClearTIMEOUT - simple wrapper around edg_wll_LogEvent for event Clear, reason TIMEOUT
 *
 * \param[in,out] context	context to work with, 
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogClearTIMEOUT(edg_wll_Context context);

/**
 * \brief edg_wll_LogClearTIMEOUTProxy
 *
 * edg_wll_LogClearTIMEOUTProxy - simple wrapper around edg_wll_LogEventProxy for event Clear, reason TIMEOUT
 *
 * \param[in,out] context	context to work with, 
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogClearTIMEOUTProxy(edg_wll_Context context);

/**
 * \brief edg_wll_LogClearTIMEOUTFile
 *
 * edg_wll_LogClearTIMEOUTFile - simple wrapper around edg_wll_LogEventFile for event Clear, reason TIMEOUT
 *
 * \param[in,out] context	context to work with, 
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogClearTIMEOUTFile(edg_wll_Context context);

/**
 * \brief edg_wll_LogClearNOOUTPUT
 *
 * edg_wll_LogClearNOOUTPUT - simple wrapper around edg_wll_LogEvent for event Clear, reason NOOUTPUT
 *
 * \param[in,out] context	context to work with, 
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogClearNOOUTPUT(edg_wll_Context context);

/**
 * \brief edg_wll_LogClearNOOUTPUTProxy
 *
 * edg_wll_LogClearNOOUTPUTProxy - simple wrapper around edg_wll_LogEventProxy for event Clear, reason NOOUTPUT
 *
 * \param[in,out] context	context to work with, 
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogClearNOOUTPUTProxy(edg_wll_Context context);

/**
 * \brief edg_wll_LogClearNOOUTPUTFile
 *
 * edg_wll_LogClearNOOUTPUTFile - simple wrapper around edg_wll_LogEventFile for event Clear, reason NOOUTPUT
 *
 * \param[in,out] context	context to work with, 
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogClearNOOUTPUTFile(edg_wll_Context context);

/**
 * \brief edg_wll_LogPurge
 *
 * edg_wll_LogPurge - simple wrapper around edg_wll_LogEvent for event Purge
 *
 * \param[in,out] context	context to work with, 
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogPurge(edg_wll_Context context);

/**
 * \brief edg_wll_LogPurgeProxy
 *
 * edg_wll_LogPurgeProxy - simple wrapper around edg_wll_LogEventProxy for event Purge
 *
 * \param[in,out] context	context to work with, 
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogPurgeProxy(edg_wll_Context context);

/**
 * \brief edg_wll_LogPurgeFile
 *
 * edg_wll_LogPurgeFile - simple wrapper around edg_wll_LogEventFile for event Purge
 *
 * \param[in,out] context	context to work with, 
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogPurgeFile(edg_wll_Context context);

/**
 * \brief edg_wll_LogMatch
 *
 * edg_wll_LogMatch - simple wrapper around edg_wll_LogEvent for event Match
 *
 * \param[in,out] context	context to work with, 
 * \param[in] dest_id	Identification of the queue on the CE that the job could be send to.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogMatch(edg_wll_Context context, const char * dest_id);

/**
 * \brief edg_wll_LogMatchProxy
 *
 * edg_wll_LogMatchProxy - simple wrapper around edg_wll_LogEventProxy for event Match
 *
 * \param[in,out] context	context to work with, 
 * \param[in] dest_id	Identification of the queue on the CE that the job could be send to.
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogMatchProxy(edg_wll_Context context, const char * dest_id);

/**
 * \brief edg_wll_LogMatchFile
 *
 * edg_wll_LogMatchFile - simple wrapper around edg_wll_LogEventFile for event Match
 *
 * \param[in,out] context	context to work with, 
 * \param[in] dest_id	Identification of the queue on the CE that the job could be send to.
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogMatchFile(edg_wll_Context context, const char * dest_id);

/**
 * \brief edg_wll_LogPending
 *
 * edg_wll_LogPending - simple wrapper around edg_wll_LogEvent for event Pending
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Description why the matching CE for the job was not found (yet).
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogPending(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogPendingProxy
 *
 * edg_wll_LogPendingProxy - simple wrapper around edg_wll_LogEventProxy for event Pending
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Description why the matching CE for the job was not found (yet).
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogPendingProxy(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogPendingFile
 *
 * edg_wll_LogPendingFile - simple wrapper around edg_wll_LogEventFile for event Pending
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Description why the matching CE for the job was not found (yet).
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogPendingFile(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogRegJob
 *
 * edg_wll_LogRegJob - simple wrapper around edg_wll_LogEvent for event RegJob
 *
 * \param[in,out] context	context to work with, 
 * \param[in] jdl	Job description of the job being registered.
 * \param[in] ns	NetworkServer/CE endpoint etc. handling the newly registered job.
 * \param[in] parent	Grid job id of the parent job registering this new one.
 * \param[in] jobtype	Type of the job being registered (SIMPLE, DAG, PARTITIONABLE etc.).
 * \param[in] nsubjobs	Number of subjobs this job plans to spawn.
 * \param[in] seed	Seed for subjob id generation.
 * \param[in] wms_dn	DN of WMS handling the job
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogRegJob(edg_wll_Context context, const char * jdl, const char * ns, const glite_jobid_t parent, const char * jobtype, const int nsubjobs, const char * seed, const char * wms_dn);

/**
 * \brief edg_wll_LogRegJobProxy
 *
 * edg_wll_LogRegJobProxy - simple wrapper around edg_wll_LogEventProxy for event RegJob
 *
 * \param[in,out] context	context to work with, 
 * \param[in] jdl	Job description of the job being registered.
 * \param[in] ns	NetworkServer/CE endpoint etc. handling the newly registered job.
 * \param[in] parent	Grid job id of the parent job registering this new one.
 * \param[in] jobtype	Type of the job being registered (SIMPLE, DAG, PARTITIONABLE etc.).
 * \param[in] nsubjobs	Number of subjobs this job plans to spawn.
 * \param[in] seed	Seed for subjob id generation.
 * \param[in] wms_dn	DN of WMS handling the job
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogRegJobProxy(edg_wll_Context context, const char * jdl, const char * ns, const glite_jobid_t parent, const char * jobtype, const int nsubjobs, const char * seed, const char * wms_dn);

/**
 * \brief edg_wll_LogRegJobFile
 *
 * edg_wll_LogRegJobFile - simple wrapper around edg_wll_LogEventFile for event RegJob
 *
 * \param[in,out] context	context to work with, 
 * \param[in] jdl	Job description of the job being registered.
 * \param[in] ns	NetworkServer/CE endpoint etc. handling the newly registered job.
 * \param[in] parent	Grid job id of the parent job registering this new one.
 * \param[in] jobtype	Type of the job being registered (SIMPLE, DAG, PARTITIONABLE etc.).
 * \param[in] nsubjobs	Number of subjobs this job plans to spawn.
 * \param[in] seed	Seed for subjob id generation.
 * \param[in] wms_dn	DN of WMS handling the job
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogRegJobFile(edg_wll_Context context, const char * jdl, const char * ns, const glite_jobid_t parent, const char * jobtype, const int nsubjobs, const char * seed, const char * wms_dn);

/**
 * \brief edg_wll_LogRegJobSIMPLE
 *
 * edg_wll_LogRegJobSIMPLE - simple wrapper around edg_wll_LogEvent for event RegJob, jobtype SIMPLE
 *
 * \param[in,out] context	context to work with, 
 * \param[in] jdl	Job description of the job being registered.
 * \param[in] ns	NetworkServer/CE endpoint etc. handling the newly registered job.
 * \param[in] parent	Grid job id of the parent job registering this new one.
 * \param[in] nsubjobs	Number of subjobs this job plans to spawn.
 * \param[in] seed	Seed for subjob id generation.
 * \param[in] wms_dn	DN of WMS handling the job
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogRegJobSIMPLE(edg_wll_Context context, const char * jdl, const char * ns, const glite_jobid_t parent, const int nsubjobs, const char * seed, const char * wms_dn);

/**
 * \brief edg_wll_LogRegJobSIMPLEProxy
 *
 * edg_wll_LogRegJobSIMPLEProxy - simple wrapper around edg_wll_LogEventProxy for event RegJob, jobtype SIMPLE
 *
 * \param[in,out] context	context to work with, 
 * \param[in] jdl	Job description of the job being registered.
 * \param[in] ns	NetworkServer/CE endpoint etc. handling the newly registered job.
 * \param[in] parent	Grid job id of the parent job registering this new one.
 * \param[in] nsubjobs	Number of subjobs this job plans to spawn.
 * \param[in] seed	Seed for subjob id generation.
 * \param[in] wms_dn	DN of WMS handling the job
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogRegJobSIMPLEProxy(edg_wll_Context context, const char * jdl, const char * ns, const glite_jobid_t parent, const int nsubjobs, const char * seed, const char * wms_dn);

/**
 * \brief edg_wll_LogRegJobSIMPLEFile
 *
 * edg_wll_LogRegJobSIMPLEFile - simple wrapper around edg_wll_LogEventFile for event RegJob, jobtype SIMPLE
 *
 * \param[in,out] context	context to work with, 
 * \param[in] jdl	Job description of the job being registered.
 * \param[in] ns	NetworkServer/CE endpoint etc. handling the newly registered job.
 * \param[in] parent	Grid job id of the parent job registering this new one.
 * \param[in] nsubjobs	Number of subjobs this job plans to spawn.
 * \param[in] seed	Seed for subjob id generation.
 * \param[in] wms_dn	DN of WMS handling the job
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogRegJobSIMPLEFile(edg_wll_Context context, const char * jdl, const char * ns, const glite_jobid_t parent, const int nsubjobs, const char * seed, const char * wms_dn);

/**
 * \brief edg_wll_LogRegJobDAG
 *
 * edg_wll_LogRegJobDAG - simple wrapper around edg_wll_LogEvent for event RegJob, jobtype DAG
 *
 * \param[in,out] context	context to work with, 
 * \param[in] jdl	Job description of the job being registered.
 * \param[in] ns	NetworkServer/CE endpoint etc. handling the newly registered job.
 * \param[in] parent	Grid job id of the parent job registering this new one.
 * \param[in] nsubjobs	Number of subjobs this job plans to spawn.
 * \param[in] seed	Seed for subjob id generation.
 * \param[in] wms_dn	DN of WMS handling the job
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogRegJobDAG(edg_wll_Context context, const char * jdl, const char * ns, const glite_jobid_t parent, const int nsubjobs, const char * seed, const char * wms_dn);

/**
 * \brief edg_wll_LogRegJobDAGProxy
 *
 * edg_wll_LogRegJobDAGProxy - simple wrapper around edg_wll_LogEventProxy for event RegJob, jobtype DAG
 *
 * \param[in,out] context	context to work with, 
 * \param[in] jdl	Job description of the job being registered.
 * \param[in] ns	NetworkServer/CE endpoint etc. handling the newly registered job.
 * \param[in] parent	Grid job id of the parent job registering this new one.
 * \param[in] nsubjobs	Number of subjobs this job plans to spawn.
 * \param[in] seed	Seed for subjob id generation.
 * \param[in] wms_dn	DN of WMS handling the job
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogRegJobDAGProxy(edg_wll_Context context, const char * jdl, const char * ns, const glite_jobid_t parent, const int nsubjobs, const char * seed, const char * wms_dn);

/**
 * \brief edg_wll_LogRegJobDAGFile
 *
 * edg_wll_LogRegJobDAGFile - simple wrapper around edg_wll_LogEventFile for event RegJob, jobtype DAG
 *
 * \param[in,out] context	context to work with, 
 * \param[in] jdl	Job description of the job being registered.
 * \param[in] ns	NetworkServer/CE endpoint etc. handling the newly registered job.
 * \param[in] parent	Grid job id of the parent job registering this new one.
 * \param[in] nsubjobs	Number of subjobs this job plans to spawn.
 * \param[in] seed	Seed for subjob id generation.
 * \param[in] wms_dn	DN of WMS handling the job
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogRegJobDAGFile(edg_wll_Context context, const char * jdl, const char * ns, const glite_jobid_t parent, const int nsubjobs, const char * seed, const char * wms_dn);

/**
 * \brief edg_wll_LogRegJobPARTITIONABLE
 *
 * edg_wll_LogRegJobPARTITIONABLE - simple wrapper around edg_wll_LogEvent for event RegJob, jobtype PARTITIONABLE
 *
 * \param[in,out] context	context to work with, 
 * \param[in] jdl	Job description of the job being registered.
 * \param[in] ns	NetworkServer/CE endpoint etc. handling the newly registered job.
 * \param[in] parent	Grid job id of the parent job registering this new one.
 * \param[in] nsubjobs	Number of subjobs this job plans to spawn.
 * \param[in] seed	Seed for subjob id generation.
 * \param[in] wms_dn	DN of WMS handling the job
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogRegJobPARTITIONABLE(edg_wll_Context context, const char * jdl, const char * ns, const glite_jobid_t parent, const int nsubjobs, const char * seed, const char * wms_dn);

/**
 * \brief edg_wll_LogRegJobPARTITIONABLEProxy
 *
 * edg_wll_LogRegJobPARTITIONABLEProxy - simple wrapper around edg_wll_LogEventProxy for event RegJob, jobtype PARTITIONABLE
 *
 * \param[in,out] context	context to work with, 
 * \param[in] jdl	Job description of the job being registered.
 * \param[in] ns	NetworkServer/CE endpoint etc. handling the newly registered job.
 * \param[in] parent	Grid job id of the parent job registering this new one.
 * \param[in] nsubjobs	Number of subjobs this job plans to spawn.
 * \param[in] seed	Seed for subjob id generation.
 * \param[in] wms_dn	DN of WMS handling the job
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogRegJobPARTITIONABLEProxy(edg_wll_Context context, const char * jdl, const char * ns, const glite_jobid_t parent, const int nsubjobs, const char * seed, const char * wms_dn);

/**
 * \brief edg_wll_LogRegJobPARTITIONABLEFile
 *
 * edg_wll_LogRegJobPARTITIONABLEFile - simple wrapper around edg_wll_LogEventFile for event RegJob, jobtype PARTITIONABLE
 *
 * \param[in,out] context	context to work with, 
 * \param[in] jdl	Job description of the job being registered.
 * \param[in] ns	NetworkServer/CE endpoint etc. handling the newly registered job.
 * \param[in] parent	Grid job id of the parent job registering this new one.
 * \param[in] nsubjobs	Number of subjobs this job plans to spawn.
 * \param[in] seed	Seed for subjob id generation.
 * \param[in] wms_dn	DN of WMS handling the job
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogRegJobPARTITIONABLEFile(edg_wll_Context context, const char * jdl, const char * ns, const glite_jobid_t parent, const int nsubjobs, const char * seed, const char * wms_dn);

/**
 * \brief edg_wll_LogRegJobPARTITIONED
 *
 * edg_wll_LogRegJobPARTITIONED - simple wrapper around edg_wll_LogEvent for event RegJob, jobtype PARTITIONED
 *
 * \param[in,out] context	context to work with, 
 * \param[in] jdl	Job description of the job being registered.
 * \param[in] ns	NetworkServer/CE endpoint etc. handling the newly registered job.
 * \param[in] parent	Grid job id of the parent job registering this new one.
 * \param[in] nsubjobs	Number of subjobs this job plans to spawn.
 * \param[in] seed	Seed for subjob id generation.
 * \param[in] wms_dn	DN of WMS handling the job
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogRegJobPARTITIONED(edg_wll_Context context, const char * jdl, const char * ns, const glite_jobid_t parent, const int nsubjobs, const char * seed, const char * wms_dn);

/**
 * \brief edg_wll_LogRegJobPARTITIONEDProxy
 *
 * edg_wll_LogRegJobPARTITIONEDProxy - simple wrapper around edg_wll_LogEventProxy for event RegJob, jobtype PARTITIONED
 *
 * \param[in,out] context	context to work with, 
 * \param[in] jdl	Job description of the job being registered.
 * \param[in] ns	NetworkServer/CE endpoint etc. handling the newly registered job.
 * \param[in] parent	Grid job id of the parent job registering this new one.
 * \param[in] nsubjobs	Number of subjobs this job plans to spawn.
 * \param[in] seed	Seed for subjob id generation.
 * \param[in] wms_dn	DN of WMS handling the job
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogRegJobPARTITIONEDProxy(edg_wll_Context context, const char * jdl, const char * ns, const glite_jobid_t parent, const int nsubjobs, const char * seed, const char * wms_dn);

/**
 * \brief edg_wll_LogRegJobPARTITIONEDFile
 *
 * edg_wll_LogRegJobPARTITIONEDFile - simple wrapper around edg_wll_LogEventFile for event RegJob, jobtype PARTITIONED
 *
 * \param[in,out] context	context to work with, 
 * \param[in] jdl	Job description of the job being registered.
 * \param[in] ns	NetworkServer/CE endpoint etc. handling the newly registered job.
 * \param[in] parent	Grid job id of the parent job registering this new one.
 * \param[in] nsubjobs	Number of subjobs this job plans to spawn.
 * \param[in] seed	Seed for subjob id generation.
 * \param[in] wms_dn	DN of WMS handling the job
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogRegJobPARTITIONEDFile(edg_wll_Context context, const char * jdl, const char * ns, const glite_jobid_t parent, const int nsubjobs, const char * seed, const char * wms_dn);

/**
 * \brief edg_wll_LogRegJobCOLLECTION
 *
 * edg_wll_LogRegJobCOLLECTION - simple wrapper around edg_wll_LogEvent for event RegJob, jobtype COLLECTION
 *
 * \param[in,out] context	context to work with, 
 * \param[in] jdl	Job description of the job being registered.
 * \param[in] ns	NetworkServer/CE endpoint etc. handling the newly registered job.
 * \param[in] parent	Grid job id of the parent job registering this new one.
 * \param[in] nsubjobs	Number of subjobs this job plans to spawn.
 * \param[in] seed	Seed for subjob id generation.
 * \param[in] wms_dn	DN of WMS handling the job
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogRegJobCOLLECTION(edg_wll_Context context, const char * jdl, const char * ns, const glite_jobid_t parent, const int nsubjobs, const char * seed, const char * wms_dn);

/**
 * \brief edg_wll_LogRegJobCOLLECTIONProxy
 *
 * edg_wll_LogRegJobCOLLECTIONProxy - simple wrapper around edg_wll_LogEventProxy for event RegJob, jobtype COLLECTION
 *
 * \param[in,out] context	context to work with, 
 * \param[in] jdl	Job description of the job being registered.
 * \param[in] ns	NetworkServer/CE endpoint etc. handling the newly registered job.
 * \param[in] parent	Grid job id of the parent job registering this new one.
 * \param[in] nsubjobs	Number of subjobs this job plans to spawn.
 * \param[in] seed	Seed for subjob id generation.
 * \param[in] wms_dn	DN of WMS handling the job
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogRegJobCOLLECTIONProxy(edg_wll_Context context, const char * jdl, const char * ns, const glite_jobid_t parent, const int nsubjobs, const char * seed, const char * wms_dn);

/**
 * \brief edg_wll_LogRegJobCOLLECTIONFile
 *
 * edg_wll_LogRegJobCOLLECTIONFile - simple wrapper around edg_wll_LogEventFile for event RegJob, jobtype COLLECTION
 *
 * \param[in,out] context	context to work with, 
 * \param[in] jdl	Job description of the job being registered.
 * \param[in] ns	NetworkServer/CE endpoint etc. handling the newly registered job.
 * \param[in] parent	Grid job id of the parent job registering this new one.
 * \param[in] nsubjobs	Number of subjobs this job plans to spawn.
 * \param[in] seed	Seed for subjob id generation.
 * \param[in] wms_dn	DN of WMS handling the job
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogRegJobCOLLECTIONFile(edg_wll_Context context, const char * jdl, const char * ns, const glite_jobid_t parent, const int nsubjobs, const char * seed, const char * wms_dn);

/**
 * \brief edg_wll_LogRegJobPBS
 *
 * edg_wll_LogRegJobPBS - simple wrapper around edg_wll_LogEvent for event RegJob, jobtype PBS
 *
 * \param[in,out] context	context to work with, 
 * \param[in] jdl	Job description of the job being registered.
 * \param[in] ns	NetworkServer/CE endpoint etc. handling the newly registered job.
 * \param[in] parent	Grid job id of the parent job registering this new one.
 * \param[in] nsubjobs	Number of subjobs this job plans to spawn.
 * \param[in] seed	Seed for subjob id generation.
 * \param[in] wms_dn	DN of WMS handling the job
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogRegJobPBS(edg_wll_Context context, const char * jdl, const char * ns, const glite_jobid_t parent, const int nsubjobs, const char * seed, const char * wms_dn);

/**
 * \brief edg_wll_LogRegJobPBSProxy
 *
 * edg_wll_LogRegJobPBSProxy - simple wrapper around edg_wll_LogEventProxy for event RegJob, jobtype PBS
 *
 * \param[in,out] context	context to work with, 
 * \param[in] jdl	Job description of the job being registered.
 * \param[in] ns	NetworkServer/CE endpoint etc. handling the newly registered job.
 * \param[in] parent	Grid job id of the parent job registering this new one.
 * \param[in] nsubjobs	Number of subjobs this job plans to spawn.
 * \param[in] seed	Seed for subjob id generation.
 * \param[in] wms_dn	DN of WMS handling the job
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogRegJobPBSProxy(edg_wll_Context context, const char * jdl, const char * ns, const glite_jobid_t parent, const int nsubjobs, const char * seed, const char * wms_dn);

/**
 * \brief edg_wll_LogRegJobPBSFile
 *
 * edg_wll_LogRegJobPBSFile - simple wrapper around edg_wll_LogEventFile for event RegJob, jobtype PBS
 *
 * \param[in,out] context	context to work with, 
 * \param[in] jdl	Job description of the job being registered.
 * \param[in] ns	NetworkServer/CE endpoint etc. handling the newly registered job.
 * \param[in] parent	Grid job id of the parent job registering this new one.
 * \param[in] nsubjobs	Number of subjobs this job plans to spawn.
 * \param[in] seed	Seed for subjob id generation.
 * \param[in] wms_dn	DN of WMS handling the job
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogRegJobPBSFile(edg_wll_Context context, const char * jdl, const char * ns, const glite_jobid_t parent, const int nsubjobs, const char * seed, const char * wms_dn);

/**
 * \brief edg_wll_LogRegJobCONDOR
 *
 * edg_wll_LogRegJobCONDOR - simple wrapper around edg_wll_LogEvent for event RegJob, jobtype CONDOR
 *
 * \param[in,out] context	context to work with, 
 * \param[in] jdl	Job description of the job being registered.
 * \param[in] ns	NetworkServer/CE endpoint etc. handling the newly registered job.
 * \param[in] parent	Grid job id of the parent job registering this new one.
 * \param[in] nsubjobs	Number of subjobs this job plans to spawn.
 * \param[in] seed	Seed for subjob id generation.
 * \param[in] wms_dn	DN of WMS handling the job
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogRegJobCONDOR(edg_wll_Context context, const char * jdl, const char * ns, const glite_jobid_t parent, const int nsubjobs, const char * seed, const char * wms_dn);

/**
 * \brief edg_wll_LogRegJobCONDORProxy
 *
 * edg_wll_LogRegJobCONDORProxy - simple wrapper around edg_wll_LogEventProxy for event RegJob, jobtype CONDOR
 *
 * \param[in,out] context	context to work with, 
 * \param[in] jdl	Job description of the job being registered.
 * \param[in] ns	NetworkServer/CE endpoint etc. handling the newly registered job.
 * \param[in] parent	Grid job id of the parent job registering this new one.
 * \param[in] nsubjobs	Number of subjobs this job plans to spawn.
 * \param[in] seed	Seed for subjob id generation.
 * \param[in] wms_dn	DN of WMS handling the job
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogRegJobCONDORProxy(edg_wll_Context context, const char * jdl, const char * ns, const glite_jobid_t parent, const int nsubjobs, const char * seed, const char * wms_dn);

/**
 * \brief edg_wll_LogRegJobCONDORFile
 *
 * edg_wll_LogRegJobCONDORFile - simple wrapper around edg_wll_LogEventFile for event RegJob, jobtype CONDOR
 *
 * \param[in,out] context	context to work with, 
 * \param[in] jdl	Job description of the job being registered.
 * \param[in] ns	NetworkServer/CE endpoint etc. handling the newly registered job.
 * \param[in] parent	Grid job id of the parent job registering this new one.
 * \param[in] nsubjobs	Number of subjobs this job plans to spawn.
 * \param[in] seed	Seed for subjob id generation.
 * \param[in] wms_dn	DN of WMS handling the job
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogRegJobCONDORFile(edg_wll_Context context, const char * jdl, const char * ns, const glite_jobid_t parent, const int nsubjobs, const char * seed, const char * wms_dn);

/**
 * \brief edg_wll_LogRegJobCREAM
 *
 * edg_wll_LogRegJobCREAM - simple wrapper around edg_wll_LogEvent for event RegJob, jobtype CREAM
 *
 * \param[in,out] context	context to work with, 
 * \param[in] jdl	Job description of the job being registered.
 * \param[in] ns	NetworkServer/CE endpoint etc. handling the newly registered job.
 * \param[in] parent	Grid job id of the parent job registering this new one.
 * \param[in] nsubjobs	Number of subjobs this job plans to spawn.
 * \param[in] seed	Seed for subjob id generation.
 * \param[in] wms_dn	DN of WMS handling the job
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogRegJobCREAM(edg_wll_Context context, const char * jdl, const char * ns, const glite_jobid_t parent, const int nsubjobs, const char * seed, const char * wms_dn);

/**
 * \brief edg_wll_LogRegJobCREAMProxy
 *
 * edg_wll_LogRegJobCREAMProxy - simple wrapper around edg_wll_LogEventProxy for event RegJob, jobtype CREAM
 *
 * \param[in,out] context	context to work with, 
 * \param[in] jdl	Job description of the job being registered.
 * \param[in] ns	NetworkServer/CE endpoint etc. handling the newly registered job.
 * \param[in] parent	Grid job id of the parent job registering this new one.
 * \param[in] nsubjobs	Number of subjobs this job plans to spawn.
 * \param[in] seed	Seed for subjob id generation.
 * \param[in] wms_dn	DN of WMS handling the job
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogRegJobCREAMProxy(edg_wll_Context context, const char * jdl, const char * ns, const glite_jobid_t parent, const int nsubjobs, const char * seed, const char * wms_dn);

/**
 * \brief edg_wll_LogRegJobCREAMFile
 *
 * edg_wll_LogRegJobCREAMFile - simple wrapper around edg_wll_LogEventFile for event RegJob, jobtype CREAM
 *
 * \param[in,out] context	context to work with, 
 * \param[in] jdl	Job description of the job being registered.
 * \param[in] ns	NetworkServer/CE endpoint etc. handling the newly registered job.
 * \param[in] parent	Grid job id of the parent job registering this new one.
 * \param[in] nsubjobs	Number of subjobs this job plans to spawn.
 * \param[in] seed	Seed for subjob id generation.
 * \param[in] wms_dn	DN of WMS handling the job
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogRegJobCREAMFile(edg_wll_Context context, const char * jdl, const char * ns, const glite_jobid_t parent, const int nsubjobs, const char * seed, const char * wms_dn);

/**
 * \brief edg_wll_LogRegJobFILE_TRANSFER_COLLECTION
 *
 * edg_wll_LogRegJobFILE_TRANSFER_COLLECTION - simple wrapper around edg_wll_LogEvent for event RegJob, jobtype FILE_TRANSFER_COLLECTION
 *
 * \param[in,out] context	context to work with, 
 * \param[in] jdl	Job description of the job being registered.
 * \param[in] ns	NetworkServer/CE endpoint etc. handling the newly registered job.
 * \param[in] parent	Grid job id of the parent job registering this new one.
 * \param[in] nsubjobs	Number of subjobs this job plans to spawn.
 * \param[in] seed	Seed for subjob id generation.
 * \param[in] wms_dn	DN of WMS handling the job
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogRegJobFILE_TRANSFER_COLLECTION(edg_wll_Context context, const char * jdl, const char * ns, const glite_jobid_t parent, const int nsubjobs, const char * seed, const char * wms_dn);

/**
 * \brief edg_wll_LogRegJobFILE_TRANSFER_COLLECTIONProxy
 *
 * edg_wll_LogRegJobFILE_TRANSFER_COLLECTIONProxy - simple wrapper around edg_wll_LogEventProxy for event RegJob, jobtype FILE_TRANSFER_COLLECTION
 *
 * \param[in,out] context	context to work with, 
 * \param[in] jdl	Job description of the job being registered.
 * \param[in] ns	NetworkServer/CE endpoint etc. handling the newly registered job.
 * \param[in] parent	Grid job id of the parent job registering this new one.
 * \param[in] nsubjobs	Number of subjobs this job plans to spawn.
 * \param[in] seed	Seed for subjob id generation.
 * \param[in] wms_dn	DN of WMS handling the job
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogRegJobFILE_TRANSFER_COLLECTIONProxy(edg_wll_Context context, const char * jdl, const char * ns, const glite_jobid_t parent, const int nsubjobs, const char * seed, const char * wms_dn);

/**
 * \brief edg_wll_LogRegJobFILE_TRANSFER_COLLECTIONFile
 *
 * edg_wll_LogRegJobFILE_TRANSFER_COLLECTIONFile - simple wrapper around edg_wll_LogEventFile for event RegJob, jobtype FILE_TRANSFER_COLLECTION
 *
 * \param[in,out] context	context to work with, 
 * \param[in] jdl	Job description of the job being registered.
 * \param[in] ns	NetworkServer/CE endpoint etc. handling the newly registered job.
 * \param[in] parent	Grid job id of the parent job registering this new one.
 * \param[in] nsubjobs	Number of subjobs this job plans to spawn.
 * \param[in] seed	Seed for subjob id generation.
 * \param[in] wms_dn	DN of WMS handling the job
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogRegJobFILE_TRANSFER_COLLECTIONFile(edg_wll_Context context, const char * jdl, const char * ns, const glite_jobid_t parent, const int nsubjobs, const char * seed, const char * wms_dn);

/**
 * \brief edg_wll_LogRegJobFILE_TRANSFER
 *
 * edg_wll_LogRegJobFILE_TRANSFER - simple wrapper around edg_wll_LogEvent for event RegJob, jobtype FILE_TRANSFER
 *
 * \param[in,out] context	context to work with, 
 * \param[in] jdl	Job description of the job being registered.
 * \param[in] ns	NetworkServer/CE endpoint etc. handling the newly registered job.
 * \param[in] parent	Grid job id of the parent job registering this new one.
 * \param[in] nsubjobs	Number of subjobs this job plans to spawn.
 * \param[in] seed	Seed for subjob id generation.
 * \param[in] wms_dn	DN of WMS handling the job
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogRegJobFILE_TRANSFER(edg_wll_Context context, const char * jdl, const char * ns, const glite_jobid_t parent, const int nsubjobs, const char * seed, const char * wms_dn);

/**
 * \brief edg_wll_LogRegJobFILE_TRANSFERProxy
 *
 * edg_wll_LogRegJobFILE_TRANSFERProxy - simple wrapper around edg_wll_LogEventProxy for event RegJob, jobtype FILE_TRANSFER
 *
 * \param[in,out] context	context to work with, 
 * \param[in] jdl	Job description of the job being registered.
 * \param[in] ns	NetworkServer/CE endpoint etc. handling the newly registered job.
 * \param[in] parent	Grid job id of the parent job registering this new one.
 * \param[in] nsubjobs	Number of subjobs this job plans to spawn.
 * \param[in] seed	Seed for subjob id generation.
 * \param[in] wms_dn	DN of WMS handling the job
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogRegJobFILE_TRANSFERProxy(edg_wll_Context context, const char * jdl, const char * ns, const glite_jobid_t parent, const int nsubjobs, const char * seed, const char * wms_dn);

/**
 * \brief edg_wll_LogRegJobFILE_TRANSFERFile
 *
 * edg_wll_LogRegJobFILE_TRANSFERFile - simple wrapper around edg_wll_LogEventFile for event RegJob, jobtype FILE_TRANSFER
 *
 * \param[in,out] context	context to work with, 
 * \param[in] jdl	Job description of the job being registered.
 * \param[in] ns	NetworkServer/CE endpoint etc. handling the newly registered job.
 * \param[in] parent	Grid job id of the parent job registering this new one.
 * \param[in] nsubjobs	Number of subjobs this job plans to spawn.
 * \param[in] seed	Seed for subjob id generation.
 * \param[in] wms_dn	DN of WMS handling the job
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogRegJobFILE_TRANSFERFile(edg_wll_Context context, const char * jdl, const char * ns, const glite_jobid_t parent, const int nsubjobs, const char * seed, const char * wms_dn);

/**
 * \brief edg_wll_LogRegJobVIRTUAL_MACHINE
 *
 * edg_wll_LogRegJobVIRTUAL_MACHINE - simple wrapper around edg_wll_LogEvent for event RegJob, jobtype VIRTUAL_MACHINE
 *
 * \param[in,out] context	context to work with, 
 * \param[in] jdl	Job description of the job being registered.
 * \param[in] ns	NetworkServer/CE endpoint etc. handling the newly registered job.
 * \param[in] parent	Grid job id of the parent job registering this new one.
 * \param[in] nsubjobs	Number of subjobs this job plans to spawn.
 * \param[in] seed	Seed for subjob id generation.
 * \param[in] wms_dn	DN of WMS handling the job
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogRegJobVIRTUAL_MACHINE(edg_wll_Context context, const char * jdl, const char * ns, const glite_jobid_t parent, const int nsubjobs, const char * seed, const char * wms_dn);

/**
 * \brief edg_wll_LogRegJobVIRTUAL_MACHINEProxy
 *
 * edg_wll_LogRegJobVIRTUAL_MACHINEProxy - simple wrapper around edg_wll_LogEventProxy for event RegJob, jobtype VIRTUAL_MACHINE
 *
 * \param[in,out] context	context to work with, 
 * \param[in] jdl	Job description of the job being registered.
 * \param[in] ns	NetworkServer/CE endpoint etc. handling the newly registered job.
 * \param[in] parent	Grid job id of the parent job registering this new one.
 * \param[in] nsubjobs	Number of subjobs this job plans to spawn.
 * \param[in] seed	Seed for subjob id generation.
 * \param[in] wms_dn	DN of WMS handling the job
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogRegJobVIRTUAL_MACHINEProxy(edg_wll_Context context, const char * jdl, const char * ns, const glite_jobid_t parent, const int nsubjobs, const char * seed, const char * wms_dn);

/**
 * \brief edg_wll_LogRegJobVIRTUAL_MACHINEFile
 *
 * edg_wll_LogRegJobVIRTUAL_MACHINEFile - simple wrapper around edg_wll_LogEventFile for event RegJob, jobtype VIRTUAL_MACHINE
 *
 * \param[in,out] context	context to work with, 
 * \param[in] jdl	Job description of the job being registered.
 * \param[in] ns	NetworkServer/CE endpoint etc. handling the newly registered job.
 * \param[in] parent	Grid job id of the parent job registering this new one.
 * \param[in] nsubjobs	Number of subjobs this job plans to spawn.
 * \param[in] seed	Seed for subjob id generation.
 * \param[in] wms_dn	DN of WMS handling the job
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogRegJobVIRTUAL_MACHINEFile(edg_wll_Context context, const char * jdl, const char * ns, const glite_jobid_t parent, const int nsubjobs, const char * seed, const char * wms_dn);

/**
 * \brief edg_wll_LogChkpt
 *
 * edg_wll_LogChkpt - simple wrapper around edg_wll_LogEvent for event Chkpt
 *
 * \param[in,out] context	context to work with, 
 * \param[in] tag	Application specific checkpoint tag.
 * \param[in] classad	Application specific checkpoint value.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogChkpt(edg_wll_Context context, const char * tag, const char * classad);

/**
 * \brief edg_wll_LogChkptProxy
 *
 * edg_wll_LogChkptProxy - simple wrapper around edg_wll_LogEventProxy for event Chkpt
 *
 * \param[in,out] context	context to work with, 
 * \param[in] tag	Application specific checkpoint tag.
 * \param[in] classad	Application specific checkpoint value.
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogChkptProxy(edg_wll_Context context, const char * tag, const char * classad);

/**
 * \brief edg_wll_LogChkptFile
 *
 * edg_wll_LogChkptFile - simple wrapper around edg_wll_LogEventFile for event Chkpt
 *
 * \param[in,out] context	context to work with, 
 * \param[in] tag	Application specific checkpoint tag.
 * \param[in] classad	Application specific checkpoint value.
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogChkptFile(edg_wll_Context context, const char * tag, const char * classad);

/**
 * \brief edg_wll_LogListener
 *
 * edg_wll_LogListener - simple wrapper around edg_wll_LogEvent for event Listener
 *
 * \param[in,out] context	context to work with, 
 * \param[in] svc_name	Name of the port instance for interactive job control.
 * \param[in] svc_host	Hostname of the interactive job controller.
 * \param[in] svc_port	Port number of the interactive job controller.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogListener(edg_wll_Context context, const char * svc_name, const char * svc_host, const uint16_t svc_port);

/**
 * \brief edg_wll_LogListenerProxy
 *
 * edg_wll_LogListenerProxy - simple wrapper around edg_wll_LogEventProxy for event Listener
 *
 * \param[in,out] context	context to work with, 
 * \param[in] svc_name	Name of the port instance for interactive job control.
 * \param[in] svc_host	Hostname of the interactive job controller.
 * \param[in] svc_port	Port number of the interactive job controller.
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogListenerProxy(edg_wll_Context context, const char * svc_name, const char * svc_host, const uint16_t svc_port);

/**
 * \brief edg_wll_LogListenerFile
 *
 * edg_wll_LogListenerFile - simple wrapper around edg_wll_LogEventFile for event Listener
 *
 * \param[in,out] context	context to work with, 
 * \param[in] svc_name	Name of the port instance for interactive job control.
 * \param[in] svc_host	Hostname of the interactive job controller.
 * \param[in] svc_port	Port number of the interactive job controller.
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogListenerFile(edg_wll_Context context, const char * svc_name, const char * svc_host, const uint16_t svc_port);

/**
 * \brief edg_wll_LogCurDescr
 *
 * edg_wll_LogCurDescr - simple wrapper around edg_wll_LogEvent for event CurDescr
 *
 * \param[in,out] context	context to work with, 
 * \param[in] descr	Description of the current job transformation (output of the helper).
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogCurDescr(edg_wll_Context context, const char * descr);

/**
 * \brief edg_wll_LogCurDescrProxy
 *
 * edg_wll_LogCurDescrProxy - simple wrapper around edg_wll_LogEventProxy for event CurDescr
 *
 * \param[in,out] context	context to work with, 
 * \param[in] descr	Description of the current job transformation (output of the helper).
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogCurDescrProxy(edg_wll_Context context, const char * descr);

/**
 * \brief edg_wll_LogCurDescrFile
 *
 * edg_wll_LogCurDescrFile - simple wrapper around edg_wll_LogEventFile for event CurDescr
 *
 * \param[in,out] context	context to work with, 
 * \param[in] descr	Description of the current job transformation (output of the helper).
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogCurDescrFile(edg_wll_Context context, const char * descr);

/**
 * \brief edg_wll_LogUserTag
 *
 * edg_wll_LogUserTag - simple wrapper around edg_wll_LogEvent for event UserTag
 *
 * \param[in,out] context	context to work with, 
 * \param[in] name	Arbitrary user tag name.
 * \param[in] value	Arbitrary user tag value.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogUserTag(edg_wll_Context context, const char * name, const char * value);

/**
 * \brief edg_wll_LogUserTagProxy
 *
 * edg_wll_LogUserTagProxy - simple wrapper around edg_wll_LogEventProxy for event UserTag
 *
 * \param[in,out] context	context to work with, 
 * \param[in] name	Arbitrary user tag name.
 * \param[in] value	Arbitrary user tag value.
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogUserTagProxy(edg_wll_Context context, const char * name, const char * value);

/**
 * \brief edg_wll_LogUserTagFile
 *
 * edg_wll_LogUserTagFile - simple wrapper around edg_wll_LogEventFile for event UserTag
 *
 * \param[in,out] context	context to work with, 
 * \param[in] name	Arbitrary user tag name.
 * \param[in] value	Arbitrary user tag value.
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogUserTagFile(edg_wll_Context context, const char * name, const char * value);

/**
 * \brief edg_wll_LogChangeACL
 *
 * edg_wll_LogChangeACL - simple wrapper around edg_wll_LogEvent for event ChangeACL
 *
 * \param[in,out] context	context to work with, 
 * \param[in] user_id	Certificate or VOMS parameter.
 * \param[in] user_id_type	Type of information given in user_id.
 * \param[in] permission	ACL permission to change.
 * \param[in] permission_type	Type of permission requested.
 * \param[in] operation	Operation requested to perform with ACL.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogChangeACL(edg_wll_Context context, const char * user_id, const char * user_id_type, const char * permission, const char * permission_type, const char * operation);

/**
 * \brief edg_wll_LogChangeACLProxy
 *
 * edg_wll_LogChangeACLProxy - simple wrapper around edg_wll_LogEventProxy for event ChangeACL
 *
 * \param[in,out] context	context to work with, 
 * \param[in] user_id	Certificate or VOMS parameter.
 * \param[in] user_id_type	Type of information given in user_id.
 * \param[in] permission	ACL permission to change.
 * \param[in] permission_type	Type of permission requested.
 * \param[in] operation	Operation requested to perform with ACL.
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogChangeACLProxy(edg_wll_Context context, const char * user_id, const char * user_id_type, const char * permission, const char * permission_type, const char * operation);

/**
 * \brief edg_wll_LogChangeACLFile
 *
 * edg_wll_LogChangeACLFile - simple wrapper around edg_wll_LogEventFile for event ChangeACL
 *
 * \param[in,out] context	context to work with, 
 * \param[in] user_id	Certificate or VOMS parameter.
 * \param[in] user_id_type	Type of information given in user_id.
 * \param[in] permission	ACL permission to change.
 * \param[in] permission_type	Type of permission requested.
 * \param[in] operation	Operation requested to perform with ACL.
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogChangeACLFile(edg_wll_Context context, const char * user_id, const char * user_id_type, const char * permission, const char * permission_type, const char * operation);

/**
 * \brief edg_wll_LogChangeACLDN
 *
 * edg_wll_LogChangeACLDN - simple wrapper around edg_wll_LogEvent for event ChangeACL, user_id_type DN
 *
 * \param[in,out] context	context to work with, 
 * \param[in] user_id	Certificate or VOMS parameter.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogChangeACLDN(edg_wll_Context context, const char * user_id);

/**
 * \brief edg_wll_LogChangeACLDNProxy
 *
 * edg_wll_LogChangeACLDNProxy - simple wrapper around edg_wll_LogEventProxy for event ChangeACL, user_id_type DN
 *
 * \param[in,out] context	context to work with, 
 * \param[in] user_id	Certificate or VOMS parameter.
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogChangeACLDNProxy(edg_wll_Context context, const char * user_id);

/**
 * \brief edg_wll_LogChangeACLDNFile
 *
 * edg_wll_LogChangeACLDNFile - simple wrapper around edg_wll_LogEventFile for event ChangeACL, user_id_type DN
 *
 * \param[in,out] context	context to work with, 
 * \param[in] user_id	Certificate or VOMS parameter.
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogChangeACLDNFile(edg_wll_Context context, const char * user_id);

/**
 * \brief edg_wll_LogChangeACLGROUP
 *
 * edg_wll_LogChangeACLGROUP - simple wrapper around edg_wll_LogEvent for event ChangeACL, user_id_type GROUP
 *
 * \param[in,out] context	context to work with, 
 * \param[in] user_id	Certificate or VOMS parameter.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogChangeACLGROUP(edg_wll_Context context, const char * user_id);

/**
 * \brief edg_wll_LogChangeACLGROUPProxy
 *
 * edg_wll_LogChangeACLGROUPProxy - simple wrapper around edg_wll_LogEventProxy for event ChangeACL, user_id_type GROUP
 *
 * \param[in,out] context	context to work with, 
 * \param[in] user_id	Certificate or VOMS parameter.
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogChangeACLGROUPProxy(edg_wll_Context context, const char * user_id);

/**
 * \brief edg_wll_LogChangeACLGROUPFile
 *
 * edg_wll_LogChangeACLGROUPFile - simple wrapper around edg_wll_LogEventFile for event ChangeACL, user_id_type GROUP
 *
 * \param[in,out] context	context to work with, 
 * \param[in] user_id	Certificate or VOMS parameter.
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogChangeACLGROUPFile(edg_wll_Context context, const char * user_id);

/**
 * \brief edg_wll_LogChangeACLFQAN
 *
 * edg_wll_LogChangeACLFQAN - simple wrapper around edg_wll_LogEvent for event ChangeACL, user_id_type FQAN
 *
 * \param[in,out] context	context to work with, 
 * \param[in] user_id	Certificate or VOMS parameter.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogChangeACLFQAN(edg_wll_Context context, const char * user_id);

/**
 * \brief edg_wll_LogChangeACLFQANProxy
 *
 * edg_wll_LogChangeACLFQANProxy - simple wrapper around edg_wll_LogEventProxy for event ChangeACL, user_id_type FQAN
 *
 * \param[in,out] context	context to work with, 
 * \param[in] user_id	Certificate or VOMS parameter.
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogChangeACLFQANProxy(edg_wll_Context context, const char * user_id);

/**
 * \brief edg_wll_LogChangeACLFQANFile
 *
 * edg_wll_LogChangeACLFQANFile - simple wrapper around edg_wll_LogEventFile for event ChangeACL, user_id_type FQAN
 *
 * \param[in,out] context	context to work with, 
 * \param[in] user_id	Certificate or VOMS parameter.
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogChangeACLFQANFile(edg_wll_Context context, const char * user_id);

/**
 * \brief edg_wll_LogChangeACLREAD
 *
 * edg_wll_LogChangeACLREAD - simple wrapper around edg_wll_LogEvent for event ChangeACL, permission READ
 *
 * \param[in,out] context	context to work with, 
 * \param[in] user_id	Certificate or VOMS parameter.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogChangeACLREAD(edg_wll_Context context, const char * user_id);

/**
 * \brief edg_wll_LogChangeACLREADProxy
 *
 * edg_wll_LogChangeACLREADProxy - simple wrapper around edg_wll_LogEventProxy for event ChangeACL, permission READ
 *
 * \param[in,out] context	context to work with, 
 * \param[in] user_id	Certificate or VOMS parameter.
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogChangeACLREADProxy(edg_wll_Context context, const char * user_id);

/**
 * \brief edg_wll_LogChangeACLREADFile
 *
 * edg_wll_LogChangeACLREADFile - simple wrapper around edg_wll_LogEventFile for event ChangeACL, permission READ
 *
 * \param[in,out] context	context to work with, 
 * \param[in] user_id	Certificate or VOMS parameter.
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogChangeACLREADFile(edg_wll_Context context, const char * user_id);

/**
 * \brief edg_wll_LogChangeACLTAG
 *
 * edg_wll_LogChangeACLTAG - simple wrapper around edg_wll_LogEvent for event ChangeACL, permission TAG
 *
 * \param[in,out] context	context to work with, 
 * \param[in] user_id	Certificate or VOMS parameter.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogChangeACLTAG(edg_wll_Context context, const char * user_id);

/**
 * \brief edg_wll_LogChangeACLTAGProxy
 *
 * edg_wll_LogChangeACLTAGProxy - simple wrapper around edg_wll_LogEventProxy for event ChangeACL, permission TAG
 *
 * \param[in,out] context	context to work with, 
 * \param[in] user_id	Certificate or VOMS parameter.
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogChangeACLTAGProxy(edg_wll_Context context, const char * user_id);

/**
 * \brief edg_wll_LogChangeACLTAGFile
 *
 * edg_wll_LogChangeACLTAGFile - simple wrapper around edg_wll_LogEventFile for event ChangeACL, permission TAG
 *
 * \param[in,out] context	context to work with, 
 * \param[in] user_id	Certificate or VOMS parameter.
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogChangeACLTAGFile(edg_wll_Context context, const char * user_id);

/**
 * \brief edg_wll_LogChangeACLALLOW
 *
 * edg_wll_LogChangeACLALLOW - simple wrapper around edg_wll_LogEvent for event ChangeACL, permission_type ALLOW
 *
 * \param[in,out] context	context to work with, 
 * \param[in] user_id	Certificate or VOMS parameter.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogChangeACLALLOW(edg_wll_Context context, const char * user_id);

/**
 * \brief edg_wll_LogChangeACLALLOWProxy
 *
 * edg_wll_LogChangeACLALLOWProxy - simple wrapper around edg_wll_LogEventProxy for event ChangeACL, permission_type ALLOW
 *
 * \param[in,out] context	context to work with, 
 * \param[in] user_id	Certificate or VOMS parameter.
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogChangeACLALLOWProxy(edg_wll_Context context, const char * user_id);

/**
 * \brief edg_wll_LogChangeACLALLOWFile
 *
 * edg_wll_LogChangeACLALLOWFile - simple wrapper around edg_wll_LogEventFile for event ChangeACL, permission_type ALLOW
 *
 * \param[in,out] context	context to work with, 
 * \param[in] user_id	Certificate or VOMS parameter.
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogChangeACLALLOWFile(edg_wll_Context context, const char * user_id);

/**
 * \brief edg_wll_LogChangeACLDENY
 *
 * edg_wll_LogChangeACLDENY - simple wrapper around edg_wll_LogEvent for event ChangeACL, permission_type DENY
 *
 * \param[in,out] context	context to work with, 
 * \param[in] user_id	Certificate or VOMS parameter.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogChangeACLDENY(edg_wll_Context context, const char * user_id);

/**
 * \brief edg_wll_LogChangeACLDENYProxy
 *
 * edg_wll_LogChangeACLDENYProxy - simple wrapper around edg_wll_LogEventProxy for event ChangeACL, permission_type DENY
 *
 * \param[in,out] context	context to work with, 
 * \param[in] user_id	Certificate or VOMS parameter.
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogChangeACLDENYProxy(edg_wll_Context context, const char * user_id);

/**
 * \brief edg_wll_LogChangeACLDENYFile
 *
 * edg_wll_LogChangeACLDENYFile - simple wrapper around edg_wll_LogEventFile for event ChangeACL, permission_type DENY
 *
 * \param[in,out] context	context to work with, 
 * \param[in] user_id	Certificate or VOMS parameter.
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogChangeACLDENYFile(edg_wll_Context context, const char * user_id);

/**
 * \brief edg_wll_LogChangeACLADD
 *
 * edg_wll_LogChangeACLADD - simple wrapper around edg_wll_LogEvent for event ChangeACL, operation ADD
 *
 * \param[in,out] context	context to work with, 
 * \param[in] user_id	Certificate or VOMS parameter.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogChangeACLADD(edg_wll_Context context, const char * user_id);

/**
 * \brief edg_wll_LogChangeACLADDProxy
 *
 * edg_wll_LogChangeACLADDProxy - simple wrapper around edg_wll_LogEventProxy for event ChangeACL, operation ADD
 *
 * \param[in,out] context	context to work with, 
 * \param[in] user_id	Certificate or VOMS parameter.
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogChangeACLADDProxy(edg_wll_Context context, const char * user_id);

/**
 * \brief edg_wll_LogChangeACLADDFile
 *
 * edg_wll_LogChangeACLADDFile - simple wrapper around edg_wll_LogEventFile for event ChangeACL, operation ADD
 *
 * \param[in,out] context	context to work with, 
 * \param[in] user_id	Certificate or VOMS parameter.
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogChangeACLADDFile(edg_wll_Context context, const char * user_id);

/**
 * \brief edg_wll_LogChangeACLREMOVE
 *
 * edg_wll_LogChangeACLREMOVE - simple wrapper around edg_wll_LogEvent for event ChangeACL, operation REMOVE
 *
 * \param[in,out] context	context to work with, 
 * \param[in] user_id	Certificate or VOMS parameter.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogChangeACLREMOVE(edg_wll_Context context, const char * user_id);

/**
 * \brief edg_wll_LogChangeACLREMOVEProxy
 *
 * edg_wll_LogChangeACLREMOVEProxy - simple wrapper around edg_wll_LogEventProxy for event ChangeACL, operation REMOVE
 *
 * \param[in,out] context	context to work with, 
 * \param[in] user_id	Certificate or VOMS parameter.
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogChangeACLREMOVEProxy(edg_wll_Context context, const char * user_id);

/**
 * \brief edg_wll_LogChangeACLREMOVEFile
 *
 * edg_wll_LogChangeACLREMOVEFile - simple wrapper around edg_wll_LogEventFile for event ChangeACL, operation REMOVE
 *
 * \param[in,out] context	context to work with, 
 * \param[in] user_id	Certificate or VOMS parameter.
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogChangeACLREMOVEFile(edg_wll_Context context, const char * user_id);

/**
 * \brief edg_wll_LogNotification
 *
 * edg_wll_LogNotification - simple wrapper around edg_wll_LogEvent for event Notification
 *
 * \param[in,out] context	context to work with, 
 * \param[in] notifId	Notification id.
 * \param[in] owner	Identification of the job owner (certificate subject).
 * \param[in] dest_host	Hostname the notification is sent to.
 * \param[in] dest_port	Port number the notification is sent to.
 * \param[in] expires	When the notification expires
 * \param[in] jobstat	Status of the job (the notification content).
 * \param[in] dest_url	Destination URL (preferred over host and port).
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogNotification(edg_wll_Context context, const edg_wll_NotifId notifId, const char * owner, const char * dest_host, const uint16_t dest_port, const int expires, const char * jobstat, const char * dest_url);

/**
 * \brief edg_wll_LogNotificationProxy
 *
 * edg_wll_LogNotificationProxy - simple wrapper around edg_wll_LogEventProxy for event Notification
 *
 * \param[in,out] context	context to work with, 
 * \param[in] notifId	Notification id.
 * \param[in] owner	Identification of the job owner (certificate subject).
 * \param[in] dest_host	Hostname the notification is sent to.
 * \param[in] dest_port	Port number the notification is sent to.
 * \param[in] expires	When the notification expires
 * \param[in] jobstat	Status of the job (the notification content).
 * \param[in] dest_url	Destination URL (preferred over host and port).
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogNotificationProxy(edg_wll_Context context, const edg_wll_NotifId notifId, const char * owner, const char * dest_host, const uint16_t dest_port, const int expires, const char * jobstat, const char * dest_url);

/**
 * \brief edg_wll_LogNotificationFile
 *
 * edg_wll_LogNotificationFile - simple wrapper around edg_wll_LogEventFile for event Notification
 *
 * \param[in,out] context	context to work with, 
 * \param[in] notifId	Notification id.
 * \param[in] owner	Identification of the job owner (certificate subject).
 * \param[in] dest_host	Hostname the notification is sent to.
 * \param[in] dest_port	Port number the notification is sent to.
 * \param[in] expires	When the notification expires
 * \param[in] jobstat	Status of the job (the notification content).
 * \param[in] dest_url	Destination URL (preferred over host and port).
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogNotificationFile(edg_wll_Context context, const edg_wll_NotifId notifId, const char * owner, const char * dest_host, const uint16_t dest_port, const int expires, const char * jobstat, const char * dest_url);

/**
 * \brief edg_wll_LogResourceUsage
 *
 * edg_wll_LogResourceUsage - simple wrapper around edg_wll_LogEvent for event ResourceUsage
 *
 * \param[in,out] context	context to work with, 
 * \param[in] resource	Resource's name.
 * \param[in] quantity	Resources's quantity (how much).
 * \param[in] unit	Units (sec, kB, etc.).
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogResourceUsage(edg_wll_Context context, const char * resource, const double quantity, const char * unit);

/**
 * \brief edg_wll_LogResourceUsageProxy
 *
 * edg_wll_LogResourceUsageProxy - simple wrapper around edg_wll_LogEventProxy for event ResourceUsage
 *
 * \param[in,out] context	context to work with, 
 * \param[in] resource	Resource's name.
 * \param[in] quantity	Resources's quantity (how much).
 * \param[in] unit	Units (sec, kB, etc.).
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogResourceUsageProxy(edg_wll_Context context, const char * resource, const double quantity, const char * unit);

/**
 * \brief edg_wll_LogResourceUsageFile
 *
 * edg_wll_LogResourceUsageFile - simple wrapper around edg_wll_LogEventFile for event ResourceUsage
 *
 * \param[in,out] context	context to work with, 
 * \param[in] resource	Resource's name.
 * \param[in] quantity	Resources's quantity (how much).
 * \param[in] unit	Units (sec, kB, etc.).
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogResourceUsageFile(edg_wll_Context context, const char * resource, const double quantity, const char * unit);

/**
 * \brief edg_wll_LogReallyRunning
 *
 * edg_wll_LogReallyRunning - simple wrapper around edg_wll_LogEvent for event ReallyRunning
 *
 * \param[in,out] context	context to work with, 
 * \param[in] wn_seq	Sequence code on the worker node.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogReallyRunning(edg_wll_Context context, const char * wn_seq);

/**
 * \brief edg_wll_LogReallyRunningProxy
 *
 * edg_wll_LogReallyRunningProxy - simple wrapper around edg_wll_LogEventProxy for event ReallyRunning
 *
 * \param[in,out] context	context to work with, 
 * \param[in] wn_seq	Sequence code on the worker node.
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogReallyRunningProxy(edg_wll_Context context, const char * wn_seq);

/**
 * \brief edg_wll_LogReallyRunningFile
 *
 * edg_wll_LogReallyRunningFile - simple wrapper around edg_wll_LogEventFile for event ReallyRunning
 *
 * \param[in,out] context	context to work with, 
 * \param[in] wn_seq	Sequence code on the worker node.
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogReallyRunningFile(edg_wll_Context context, const char * wn_seq);

/**
 * \brief edg_wll_LogSuspend
 *
 * edg_wll_LogSuspend - simple wrapper around edg_wll_LogEvent for event Suspend
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason for the suspend.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogSuspend(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogSuspendProxy
 *
 * edg_wll_LogSuspendProxy - simple wrapper around edg_wll_LogEventProxy for event Suspend
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason for the suspend.
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogSuspendProxy(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogSuspendFile
 *
 * edg_wll_LogSuspendFile - simple wrapper around edg_wll_LogEventFile for event Suspend
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason for the suspend.
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogSuspendFile(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogResume
 *
 * edg_wll_LogResume - simple wrapper around edg_wll_LogEvent for event Resume
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason for the resume.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogResume(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogResumeProxy
 *
 * edg_wll_LogResumeProxy - simple wrapper around edg_wll_LogEventProxy for event Resume
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason for the resume.
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogResumeProxy(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogResumeFile
 *
 * edg_wll_LogResumeFile - simple wrapper around edg_wll_LogEventFile for event Resume
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason for the resume.
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogResumeFile(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogCollectionState
 *
 * edg_wll_LogCollectionState - simple wrapper around edg_wll_LogEvent for event CollectionState
 *
 * \param[in,out] context	context to work with, 
 * \param[in] state	New collection state.
 * \param[in] done_code	In case of (state == Done) contains done code 
 * \param[in] histogram	User readable histogram; useful for debugging.
 * \param[in] child	JobId of subjob, which triggered the state change.	
 * \param[in] child_event	Event which triggered the state change.	
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogCollectionState(edg_wll_Context context, const char * state, const int done_code, const char * histogram, const glite_jobid_t child, const char * child_event);

/**
 * \brief edg_wll_LogCollectionStateProxy
 *
 * edg_wll_LogCollectionStateProxy - simple wrapper around edg_wll_LogEventProxy for event CollectionState
 *
 * \param[in,out] context	context to work with, 
 * \param[in] state	New collection state.
 * \param[in] done_code	In case of (state == Done) contains done code 
 * \param[in] histogram	User readable histogram; useful for debugging.
 * \param[in] child	JobId of subjob, which triggered the state change.	
 * \param[in] child_event	Event which triggered the state change.	
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogCollectionStateProxy(edg_wll_Context context, const char * state, const int done_code, const char * histogram, const glite_jobid_t child, const char * child_event);

/**
 * \brief edg_wll_LogCollectionStateFile
 *
 * edg_wll_LogCollectionStateFile - simple wrapper around edg_wll_LogEventFile for event CollectionState
 *
 * \param[in,out] context	context to work with, 
 * \param[in] state	New collection state.
 * \param[in] done_code	In case of (state == Done) contains done code 
 * \param[in] histogram	User readable histogram; useful for debugging.
 * \param[in] child	JobId of subjob, which triggered the state change.	
 * \param[in] child_event	Event which triggered the state change.	
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogCollectionStateFile(edg_wll_Context context, const char * state, const int done_code, const char * histogram, const glite_jobid_t child, const char * child_event);

/**
 * \brief edg_wll_LogGrantPayloadOwnership
 *
 * edg_wll_LogGrantPayloadOwnership - simple wrapper around edg_wll_LogEvent for event GrantPayloadOwnership
 *
 * \param[in,out] context	context to work with, 
 * \param[in] payload_owner	Identity (certificate subject) of the payload owner.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogGrantPayloadOwnership(edg_wll_Context context, const char * payload_owner);

/**
 * \brief edg_wll_LogGrantPayloadOwnershipProxy
 *
 * edg_wll_LogGrantPayloadOwnershipProxy - simple wrapper around edg_wll_LogEventProxy for event GrantPayloadOwnership
 *
 * \param[in,out] context	context to work with, 
 * \param[in] payload_owner	Identity (certificate subject) of the payload owner.
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogGrantPayloadOwnershipProxy(edg_wll_Context context, const char * payload_owner);

/**
 * \brief edg_wll_LogGrantPayloadOwnershipFile
 *
 * edg_wll_LogGrantPayloadOwnershipFile - simple wrapper around edg_wll_LogEventFile for event GrantPayloadOwnership
 *
 * \param[in,out] context	context to work with, 
 * \param[in] payload_owner	Identity (certificate subject) of the payload owner.
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogGrantPayloadOwnershipFile(edg_wll_Context context, const char * payload_owner);

/**
 * \brief edg_wll_LogTakePayloadOwnership
 *
 * edg_wll_LogTakePayloadOwnership - simple wrapper around edg_wll_LogEvent for event TakePayloadOwnership
 *
 * \param[in,out] context	context to work with, 
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogTakePayloadOwnership(edg_wll_Context context);

/**
 * \brief edg_wll_LogTakePayloadOwnershipProxy
 *
 * edg_wll_LogTakePayloadOwnershipProxy - simple wrapper around edg_wll_LogEventProxy for event TakePayloadOwnership
 *
 * \param[in,out] context	context to work with, 
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogTakePayloadOwnershipProxy(edg_wll_Context context);

/**
 * \brief edg_wll_LogTakePayloadOwnershipFile
 *
 * edg_wll_LogTakePayloadOwnershipFile - simple wrapper around edg_wll_LogEventFile for event TakePayloadOwnership
 *
 * \param[in,out] context	context to work with, 
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogTakePayloadOwnershipFile(edg_wll_Context context);

/**
 * \brief edg_wll_LogConnectJob
 *
 * edg_wll_LogConnectJob - simple wrapper around edg_wll_LogEvent for event ConnectJob
 *
 * \param[in,out] context	context to work with, 
 * \param[in] dest_jobid	ID of connected job
 * \param[in] jobtype	Type of the job being connected (SIMPLE, DAG, PARTITIONABLE etc.).
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogConnectJob(edg_wll_Context context, const char * dest_jobid, const char * jobtype);

/**
 * \brief edg_wll_LogConnectJobProxy
 *
 * edg_wll_LogConnectJobProxy - simple wrapper around edg_wll_LogEventProxy for event ConnectJob
 *
 * \param[in,out] context	context to work with, 
 * \param[in] dest_jobid	ID of connected job
 * \param[in] jobtype	Type of the job being connected (SIMPLE, DAG, PARTITIONABLE etc.).
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogConnectJobProxy(edg_wll_Context context, const char * dest_jobid, const char * jobtype);

/**
 * \brief edg_wll_LogConnectJobFile
 *
 * edg_wll_LogConnectJobFile - simple wrapper around edg_wll_LogEventFile for event ConnectJob
 *
 * \param[in,out] context	context to work with, 
 * \param[in] dest_jobid	ID of connected job
 * \param[in] jobtype	Type of the job being connected (SIMPLE, DAG, PARTITIONABLE etc.).
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogConnectJobFile(edg_wll_Context context, const char * dest_jobid, const char * jobtype);

/**
 * \brief edg_wll_LogConnectJobSIMPLE
 *
 * edg_wll_LogConnectJobSIMPLE - simple wrapper around edg_wll_LogEvent for event ConnectJob, jobtype SIMPLE
 *
 * \param[in,out] context	context to work with, 
 * \param[in] dest_jobid	ID of connected job
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogConnectJobSIMPLE(edg_wll_Context context, const char * dest_jobid);

/**
 * \brief edg_wll_LogConnectJobSIMPLEProxy
 *
 * edg_wll_LogConnectJobSIMPLEProxy - simple wrapper around edg_wll_LogEventProxy for event ConnectJob, jobtype SIMPLE
 *
 * \param[in,out] context	context to work with, 
 * \param[in] dest_jobid	ID of connected job
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogConnectJobSIMPLEProxy(edg_wll_Context context, const char * dest_jobid);

/**
 * \brief edg_wll_LogConnectJobSIMPLEFile
 *
 * edg_wll_LogConnectJobSIMPLEFile - simple wrapper around edg_wll_LogEventFile for event ConnectJob, jobtype SIMPLE
 *
 * \param[in,out] context	context to work with, 
 * \param[in] dest_jobid	ID of connected job
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogConnectJobSIMPLEFile(edg_wll_Context context, const char * dest_jobid);

/**
 * \brief edg_wll_LogConnectJobDAG
 *
 * edg_wll_LogConnectJobDAG - simple wrapper around edg_wll_LogEvent for event ConnectJob, jobtype DAG
 *
 * \param[in,out] context	context to work with, 
 * \param[in] dest_jobid	ID of connected job
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogConnectJobDAG(edg_wll_Context context, const char * dest_jobid);

/**
 * \brief edg_wll_LogConnectJobDAGProxy
 *
 * edg_wll_LogConnectJobDAGProxy - simple wrapper around edg_wll_LogEventProxy for event ConnectJob, jobtype DAG
 *
 * \param[in,out] context	context to work with, 
 * \param[in] dest_jobid	ID of connected job
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogConnectJobDAGProxy(edg_wll_Context context, const char * dest_jobid);

/**
 * \brief edg_wll_LogConnectJobDAGFile
 *
 * edg_wll_LogConnectJobDAGFile - simple wrapper around edg_wll_LogEventFile for event ConnectJob, jobtype DAG
 *
 * \param[in,out] context	context to work with, 
 * \param[in] dest_jobid	ID of connected job
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogConnectJobDAGFile(edg_wll_Context context, const char * dest_jobid);

/**
 * \brief edg_wll_LogConnectJobPARTITIONABLE
 *
 * edg_wll_LogConnectJobPARTITIONABLE - simple wrapper around edg_wll_LogEvent for event ConnectJob, jobtype PARTITIONABLE
 *
 * \param[in,out] context	context to work with, 
 * \param[in] dest_jobid	ID of connected job
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogConnectJobPARTITIONABLE(edg_wll_Context context, const char * dest_jobid);

/**
 * \brief edg_wll_LogConnectJobPARTITIONABLEProxy
 *
 * edg_wll_LogConnectJobPARTITIONABLEProxy - simple wrapper around edg_wll_LogEventProxy for event ConnectJob, jobtype PARTITIONABLE
 *
 * \param[in,out] context	context to work with, 
 * \param[in] dest_jobid	ID of connected job
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogConnectJobPARTITIONABLEProxy(edg_wll_Context context, const char * dest_jobid);

/**
 * \brief edg_wll_LogConnectJobPARTITIONABLEFile
 *
 * edg_wll_LogConnectJobPARTITIONABLEFile - simple wrapper around edg_wll_LogEventFile for event ConnectJob, jobtype PARTITIONABLE
 *
 * \param[in,out] context	context to work with, 
 * \param[in] dest_jobid	ID of connected job
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogConnectJobPARTITIONABLEFile(edg_wll_Context context, const char * dest_jobid);

/**
 * \brief edg_wll_LogConnectJobPARTITIONED
 *
 * edg_wll_LogConnectJobPARTITIONED - simple wrapper around edg_wll_LogEvent for event ConnectJob, jobtype PARTITIONED
 *
 * \param[in,out] context	context to work with, 
 * \param[in] dest_jobid	ID of connected job
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogConnectJobPARTITIONED(edg_wll_Context context, const char * dest_jobid);

/**
 * \brief edg_wll_LogConnectJobPARTITIONEDProxy
 *
 * edg_wll_LogConnectJobPARTITIONEDProxy - simple wrapper around edg_wll_LogEventProxy for event ConnectJob, jobtype PARTITIONED
 *
 * \param[in,out] context	context to work with, 
 * \param[in] dest_jobid	ID of connected job
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogConnectJobPARTITIONEDProxy(edg_wll_Context context, const char * dest_jobid);

/**
 * \brief edg_wll_LogConnectJobPARTITIONEDFile
 *
 * edg_wll_LogConnectJobPARTITIONEDFile - simple wrapper around edg_wll_LogEventFile for event ConnectJob, jobtype PARTITIONED
 *
 * \param[in,out] context	context to work with, 
 * \param[in] dest_jobid	ID of connected job
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogConnectJobPARTITIONEDFile(edg_wll_Context context, const char * dest_jobid);

/**
 * \brief edg_wll_LogConnectJobCOLLECTION
 *
 * edg_wll_LogConnectJobCOLLECTION - simple wrapper around edg_wll_LogEvent for event ConnectJob, jobtype COLLECTION
 *
 * \param[in,out] context	context to work with, 
 * \param[in] dest_jobid	ID of connected job
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogConnectJobCOLLECTION(edg_wll_Context context, const char * dest_jobid);

/**
 * \brief edg_wll_LogConnectJobCOLLECTIONProxy
 *
 * edg_wll_LogConnectJobCOLLECTIONProxy - simple wrapper around edg_wll_LogEventProxy for event ConnectJob, jobtype COLLECTION
 *
 * \param[in,out] context	context to work with, 
 * \param[in] dest_jobid	ID of connected job
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogConnectJobCOLLECTIONProxy(edg_wll_Context context, const char * dest_jobid);

/**
 * \brief edg_wll_LogConnectJobCOLLECTIONFile
 *
 * edg_wll_LogConnectJobCOLLECTIONFile - simple wrapper around edg_wll_LogEventFile for event ConnectJob, jobtype COLLECTION
 *
 * \param[in,out] context	context to work with, 
 * \param[in] dest_jobid	ID of connected job
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogConnectJobCOLLECTIONFile(edg_wll_Context context, const char * dest_jobid);

/**
 * \brief edg_wll_LogConnectJobPBS
 *
 * edg_wll_LogConnectJobPBS - simple wrapper around edg_wll_LogEvent for event ConnectJob, jobtype PBS
 *
 * \param[in,out] context	context to work with, 
 * \param[in] dest_jobid	ID of connected job
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogConnectJobPBS(edg_wll_Context context, const char * dest_jobid);

/**
 * \brief edg_wll_LogConnectJobPBSProxy
 *
 * edg_wll_LogConnectJobPBSProxy - simple wrapper around edg_wll_LogEventProxy for event ConnectJob, jobtype PBS
 *
 * \param[in,out] context	context to work with, 
 * \param[in] dest_jobid	ID of connected job
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogConnectJobPBSProxy(edg_wll_Context context, const char * dest_jobid);

/**
 * \brief edg_wll_LogConnectJobPBSFile
 *
 * edg_wll_LogConnectJobPBSFile - simple wrapper around edg_wll_LogEventFile for event ConnectJob, jobtype PBS
 *
 * \param[in,out] context	context to work with, 
 * \param[in] dest_jobid	ID of connected job
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogConnectJobPBSFile(edg_wll_Context context, const char * dest_jobid);

/**
 * \brief edg_wll_LogConnectJobCONDOR
 *
 * edg_wll_LogConnectJobCONDOR - simple wrapper around edg_wll_LogEvent for event ConnectJob, jobtype CONDOR
 *
 * \param[in,out] context	context to work with, 
 * \param[in] dest_jobid	ID of connected job
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogConnectJobCONDOR(edg_wll_Context context, const char * dest_jobid);

/**
 * \brief edg_wll_LogConnectJobCONDORProxy
 *
 * edg_wll_LogConnectJobCONDORProxy - simple wrapper around edg_wll_LogEventProxy for event ConnectJob, jobtype CONDOR
 *
 * \param[in,out] context	context to work with, 
 * \param[in] dest_jobid	ID of connected job
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogConnectJobCONDORProxy(edg_wll_Context context, const char * dest_jobid);

/**
 * \brief edg_wll_LogConnectJobCONDORFile
 *
 * edg_wll_LogConnectJobCONDORFile - simple wrapper around edg_wll_LogEventFile for event ConnectJob, jobtype CONDOR
 *
 * \param[in,out] context	context to work with, 
 * \param[in] dest_jobid	ID of connected job
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogConnectJobCONDORFile(edg_wll_Context context, const char * dest_jobid);

/**
 * \brief edg_wll_LogConnectJobCREAM
 *
 * edg_wll_LogConnectJobCREAM - simple wrapper around edg_wll_LogEvent for event ConnectJob, jobtype CREAM
 *
 * \param[in,out] context	context to work with, 
 * \param[in] dest_jobid	ID of connected job
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogConnectJobCREAM(edg_wll_Context context, const char * dest_jobid);

/**
 * \brief edg_wll_LogConnectJobCREAMProxy
 *
 * edg_wll_LogConnectJobCREAMProxy - simple wrapper around edg_wll_LogEventProxy for event ConnectJob, jobtype CREAM
 *
 * \param[in,out] context	context to work with, 
 * \param[in] dest_jobid	ID of connected job
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogConnectJobCREAMProxy(edg_wll_Context context, const char * dest_jobid);

/**
 * \brief edg_wll_LogConnectJobCREAMFile
 *
 * edg_wll_LogConnectJobCREAMFile - simple wrapper around edg_wll_LogEventFile for event ConnectJob, jobtype CREAM
 *
 * \param[in,out] context	context to work with, 
 * \param[in] dest_jobid	ID of connected job
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogConnectJobCREAMFile(edg_wll_Context context, const char * dest_jobid);

/**
 * \brief edg_wll_LogConnectJobFILE_TRANSFER_COLLECTION
 *
 * edg_wll_LogConnectJobFILE_TRANSFER_COLLECTION - simple wrapper around edg_wll_LogEvent for event ConnectJob, jobtype FILE_TRANSFER_COLLECTION
 *
 * \param[in,out] context	context to work with, 
 * \param[in] dest_jobid	ID of connected job
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogConnectJobFILE_TRANSFER_COLLECTION(edg_wll_Context context, const char * dest_jobid);

/**
 * \brief edg_wll_LogConnectJobFILE_TRANSFER_COLLECTIONProxy
 *
 * edg_wll_LogConnectJobFILE_TRANSFER_COLLECTIONProxy - simple wrapper around edg_wll_LogEventProxy for event ConnectJob, jobtype FILE_TRANSFER_COLLECTION
 *
 * \param[in,out] context	context to work with, 
 * \param[in] dest_jobid	ID of connected job
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogConnectJobFILE_TRANSFER_COLLECTIONProxy(edg_wll_Context context, const char * dest_jobid);

/**
 * \brief edg_wll_LogConnectJobFILE_TRANSFER_COLLECTIONFile
 *
 * edg_wll_LogConnectJobFILE_TRANSFER_COLLECTIONFile - simple wrapper around edg_wll_LogEventFile for event ConnectJob, jobtype FILE_TRANSFER_COLLECTION
 *
 * \param[in,out] context	context to work with, 
 * \param[in] dest_jobid	ID of connected job
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogConnectJobFILE_TRANSFER_COLLECTIONFile(edg_wll_Context context, const char * dest_jobid);

/**
 * \brief edg_wll_LogConnectJobFILE_TRANSFER
 *
 * edg_wll_LogConnectJobFILE_TRANSFER - simple wrapper around edg_wll_LogEvent for event ConnectJob, jobtype FILE_TRANSFER
 *
 * \param[in,out] context	context to work with, 
 * \param[in] dest_jobid	ID of connected job
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogConnectJobFILE_TRANSFER(edg_wll_Context context, const char * dest_jobid);

/**
 * \brief edg_wll_LogConnectJobFILE_TRANSFERProxy
 *
 * edg_wll_LogConnectJobFILE_TRANSFERProxy - simple wrapper around edg_wll_LogEventProxy for event ConnectJob, jobtype FILE_TRANSFER
 *
 * \param[in,out] context	context to work with, 
 * \param[in] dest_jobid	ID of connected job
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogConnectJobFILE_TRANSFERProxy(edg_wll_Context context, const char * dest_jobid);

/**
 * \brief edg_wll_LogConnectJobFILE_TRANSFERFile
 *
 * edg_wll_LogConnectJobFILE_TRANSFERFile - simple wrapper around edg_wll_LogEventFile for event ConnectJob, jobtype FILE_TRANSFER
 *
 * \param[in,out] context	context to work with, 
 * \param[in] dest_jobid	ID of connected job
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogConnectJobFILE_TRANSFERFile(edg_wll_Context context, const char * dest_jobid);

/**
 * \brief edg_wll_LogConnectJobVIRTUAL_MACHINE
 *
 * edg_wll_LogConnectJobVIRTUAL_MACHINE - simple wrapper around edg_wll_LogEvent for event ConnectJob, jobtype VIRTUAL_MACHINE
 *
 * \param[in,out] context	context to work with, 
 * \param[in] dest_jobid	ID of connected job
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogConnectJobVIRTUAL_MACHINE(edg_wll_Context context, const char * dest_jobid);

/**
 * \brief edg_wll_LogConnectJobVIRTUAL_MACHINEProxy
 *
 * edg_wll_LogConnectJobVIRTUAL_MACHINEProxy - simple wrapper around edg_wll_LogEventProxy for event ConnectJob, jobtype VIRTUAL_MACHINE
 *
 * \param[in,out] context	context to work with, 
 * \param[in] dest_jobid	ID of connected job
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogConnectJobVIRTUAL_MACHINEProxy(edg_wll_Context context, const char * dest_jobid);

/**
 * \brief edg_wll_LogConnectJobVIRTUAL_MACHINEFile
 *
 * edg_wll_LogConnectJobVIRTUAL_MACHINEFile - simple wrapper around edg_wll_LogEventFile for event ConnectJob, jobtype VIRTUAL_MACHINE
 *
 * \param[in,out] context	context to work with, 
 * \param[in] dest_jobid	ID of connected job
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogConnectJobVIRTUAL_MACHINEFile(edg_wll_Context context, const char * dest_jobid);

/**
 * \brief edg_wll_LogDisconnectJob
 *
 * edg_wll_LogDisconnectJob - simple wrapper around edg_wll_LogEvent for event DisconnectJob
 *
 * \param[in,out] context	context to work with, 
 * \param[in] dest_jobid	ID of connected job
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogDisconnectJob(edg_wll_Context context, const char * dest_jobid);

/**
 * \brief edg_wll_LogDisconnectJobProxy
 *
 * edg_wll_LogDisconnectJobProxy - simple wrapper around edg_wll_LogEventProxy for event DisconnectJob
 *
 * \param[in,out] context	context to work with, 
 * \param[in] dest_jobid	ID of connected job
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogDisconnectJobProxy(edg_wll_Context context, const char * dest_jobid);

/**
 * \brief edg_wll_LogDisconnectJobFile
 *
 * edg_wll_LogDisconnectJobFile - simple wrapper around edg_wll_LogEventFile for event DisconnectJob
 *
 * \param[in,out] context	context to work with, 
 * \param[in] dest_jobid	ID of connected job
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogDisconnectJobFile(edg_wll_Context context, const char * dest_jobid);

/**
 * \brief edg_wll_LogPBSInternalStateChange
 *
 * edg_wll_LogPBSInternalStateChange - simple wrapper around edg_wll_LogEvent for event PBSInternalStateChange
 *
 * \param[in,out] context	context to work with, 
 * \param[in] oldstate	
 * \param[in] oldsubstate	
 * \param[in] newstate	
 * \param[in] newsubstate	
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogPBSInternalStateChange(edg_wll_Context context, const int oldstate, const int oldsubstate, const int newstate, const int newsubstate);

/**
 * \brief edg_wll_LogPBSInternalStateChangeProxy
 *
 * edg_wll_LogPBSInternalStateChangeProxy - simple wrapper around edg_wll_LogEventProxy for event PBSInternalStateChange
 *
 * \param[in,out] context	context to work with, 
 * \param[in] oldstate	
 * \param[in] oldsubstate	
 * \param[in] newstate	
 * \param[in] newsubstate	
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogPBSInternalStateChangeProxy(edg_wll_Context context, const int oldstate, const int oldsubstate, const int newstate, const int newsubstate);

/**
 * \brief edg_wll_LogPBSInternalStateChangeFile
 *
 * edg_wll_LogPBSInternalStateChangeFile - simple wrapper around edg_wll_LogEventFile for event PBSInternalStateChange
 *
 * \param[in,out] context	context to work with, 
 * \param[in] oldstate	
 * \param[in] oldsubstate	
 * \param[in] newstate	
 * \param[in] newsubstate	
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogPBSInternalStateChangeFile(edg_wll_Context context, const int oldstate, const int oldsubstate, const int newstate, const int newsubstate);

/**
 * \brief edg_wll_LogPBSTransfer
 *
 * edg_wll_LogPBSTransfer - simple wrapper around edg_wll_LogEvent for event PBSTransfer
 *
 * \param[in,out] context	context to work with, 
 * \param[in] destination	Destination where the job is being transfered to.
 * \param[in] dest_instance	Service (instance) that takes over control of the job.
 * \param[in] result	Result code of the transfer attempt (START, OK, REFUSED or FAIL).
 * \param[in] reason	Detailed description of the transfer, especially reason of failure.
 * \param[in] dest_jobid	Job id as assigned by the receiving software component.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogPBSTransfer(edg_wll_Context context, const edg_wll_Source destination, const char * dest_instance, const char * result, const char * reason, const char * dest_jobid);

/**
 * \brief edg_wll_LogPBSTransferProxy
 *
 * edg_wll_LogPBSTransferProxy - simple wrapper around edg_wll_LogEventProxy for event PBSTransfer
 *
 * \param[in,out] context	context to work with, 
 * \param[in] destination	Destination where the job is being transfered to.
 * \param[in] dest_instance	Service (instance) that takes over control of the job.
 * \param[in] result	Result code of the transfer attempt (START, OK, REFUSED or FAIL).
 * \param[in] reason	Detailed description of the transfer, especially reason of failure.
 * \param[in] dest_jobid	Job id as assigned by the receiving software component.
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogPBSTransferProxy(edg_wll_Context context, const edg_wll_Source destination, const char * dest_instance, const char * result, const char * reason, const char * dest_jobid);

/**
 * \brief edg_wll_LogPBSTransferFile
 *
 * edg_wll_LogPBSTransferFile - simple wrapper around edg_wll_LogEventFile for event PBSTransfer
 *
 * \param[in,out] context	context to work with, 
 * \param[in] destination	Destination where the job is being transfered to.
 * \param[in] dest_instance	Service (instance) that takes over control of the job.
 * \param[in] result	Result code of the transfer attempt (START, OK, REFUSED or FAIL).
 * \param[in] reason	Detailed description of the transfer, especially reason of failure.
 * \param[in] dest_jobid	Job id as assigned by the receiving software component.
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogPBSTransferFile(edg_wll_Context context, const edg_wll_Source destination, const char * dest_instance, const char * result, const char * reason, const char * dest_jobid);

/**
 * \brief edg_wll_LogPBSTransferSTART
 *
 * edg_wll_LogPBSTransferSTART - simple wrapper around edg_wll_LogEvent for event PBSTransfer, result START
 *
 * \param[in,out] context	context to work with, 
 * \param[in] destination	Destination where the job is being transfered to.
 * \param[in] dest_instance	Service (instance) that takes over control of the job.
 * \param[in] reason	Detailed description of the transfer, especially reason of failure.
 * \param[in] dest_jobid	Job id as assigned by the receiving software component.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogPBSTransferSTART(edg_wll_Context context, const edg_wll_Source destination, const char * dest_instance, const char * reason, const char * dest_jobid);

/**
 * \brief edg_wll_LogPBSTransferSTARTProxy
 *
 * edg_wll_LogPBSTransferSTARTProxy - simple wrapper around edg_wll_LogEventProxy for event PBSTransfer, result START
 *
 * \param[in,out] context	context to work with, 
 * \param[in] destination	Destination where the job is being transfered to.
 * \param[in] dest_instance	Service (instance) that takes over control of the job.
 * \param[in] reason	Detailed description of the transfer, especially reason of failure.
 * \param[in] dest_jobid	Job id as assigned by the receiving software component.
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogPBSTransferSTARTProxy(edg_wll_Context context, const edg_wll_Source destination, const char * dest_instance, const char * reason, const char * dest_jobid);

/**
 * \brief edg_wll_LogPBSTransferSTARTFile
 *
 * edg_wll_LogPBSTransferSTARTFile - simple wrapper around edg_wll_LogEventFile for event PBSTransfer, result START
 *
 * \param[in,out] context	context to work with, 
 * \param[in] destination	Destination where the job is being transfered to.
 * \param[in] dest_instance	Service (instance) that takes over control of the job.
 * \param[in] reason	Detailed description of the transfer, especially reason of failure.
 * \param[in] dest_jobid	Job id as assigned by the receiving software component.
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogPBSTransferSTARTFile(edg_wll_Context context, const edg_wll_Source destination, const char * dest_instance, const char * reason, const char * dest_jobid);

/**
 * \brief edg_wll_LogPBSTransferOK
 *
 * edg_wll_LogPBSTransferOK - simple wrapper around edg_wll_LogEvent for event PBSTransfer, result OK
 *
 * \param[in,out] context	context to work with, 
 * \param[in] destination	Destination where the job is being transfered to.
 * \param[in] dest_instance	Service (instance) that takes over control of the job.
 * \param[in] reason	Detailed description of the transfer, especially reason of failure.
 * \param[in] dest_jobid	Job id as assigned by the receiving software component.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogPBSTransferOK(edg_wll_Context context, const edg_wll_Source destination, const char * dest_instance, const char * reason, const char * dest_jobid);

/**
 * \brief edg_wll_LogPBSTransferOKProxy
 *
 * edg_wll_LogPBSTransferOKProxy - simple wrapper around edg_wll_LogEventProxy for event PBSTransfer, result OK
 *
 * \param[in,out] context	context to work with, 
 * \param[in] destination	Destination where the job is being transfered to.
 * \param[in] dest_instance	Service (instance) that takes over control of the job.
 * \param[in] reason	Detailed description of the transfer, especially reason of failure.
 * \param[in] dest_jobid	Job id as assigned by the receiving software component.
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogPBSTransferOKProxy(edg_wll_Context context, const edg_wll_Source destination, const char * dest_instance, const char * reason, const char * dest_jobid);

/**
 * \brief edg_wll_LogPBSTransferOKFile
 *
 * edg_wll_LogPBSTransferOKFile - simple wrapper around edg_wll_LogEventFile for event PBSTransfer, result OK
 *
 * \param[in,out] context	context to work with, 
 * \param[in] destination	Destination where the job is being transfered to.
 * \param[in] dest_instance	Service (instance) that takes over control of the job.
 * \param[in] reason	Detailed description of the transfer, especially reason of failure.
 * \param[in] dest_jobid	Job id as assigned by the receiving software component.
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogPBSTransferOKFile(edg_wll_Context context, const edg_wll_Source destination, const char * dest_instance, const char * reason, const char * dest_jobid);

/**
 * \brief edg_wll_LogPBSTransferREFUSED
 *
 * edg_wll_LogPBSTransferREFUSED - simple wrapper around edg_wll_LogEvent for event PBSTransfer, result REFUSED
 *
 * \param[in,out] context	context to work with, 
 * \param[in] destination	Destination where the job is being transfered to.
 * \param[in] dest_instance	Service (instance) that takes over control of the job.
 * \param[in] reason	Detailed description of the transfer, especially reason of failure.
 * \param[in] dest_jobid	Job id as assigned by the receiving software component.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogPBSTransferREFUSED(edg_wll_Context context, const edg_wll_Source destination, const char * dest_instance, const char * reason, const char * dest_jobid);

/**
 * \brief edg_wll_LogPBSTransferREFUSEDProxy
 *
 * edg_wll_LogPBSTransferREFUSEDProxy - simple wrapper around edg_wll_LogEventProxy for event PBSTransfer, result REFUSED
 *
 * \param[in,out] context	context to work with, 
 * \param[in] destination	Destination where the job is being transfered to.
 * \param[in] dest_instance	Service (instance) that takes over control of the job.
 * \param[in] reason	Detailed description of the transfer, especially reason of failure.
 * \param[in] dest_jobid	Job id as assigned by the receiving software component.
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogPBSTransferREFUSEDProxy(edg_wll_Context context, const edg_wll_Source destination, const char * dest_instance, const char * reason, const char * dest_jobid);

/**
 * \brief edg_wll_LogPBSTransferREFUSEDFile
 *
 * edg_wll_LogPBSTransferREFUSEDFile - simple wrapper around edg_wll_LogEventFile for event PBSTransfer, result REFUSED
 *
 * \param[in,out] context	context to work with, 
 * \param[in] destination	Destination where the job is being transfered to.
 * \param[in] dest_instance	Service (instance) that takes over control of the job.
 * \param[in] reason	Detailed description of the transfer, especially reason of failure.
 * \param[in] dest_jobid	Job id as assigned by the receiving software component.
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogPBSTransferREFUSEDFile(edg_wll_Context context, const edg_wll_Source destination, const char * dest_instance, const char * reason, const char * dest_jobid);

/**
 * \brief edg_wll_LogPBSTransferFAIL
 *
 * edg_wll_LogPBSTransferFAIL - simple wrapper around edg_wll_LogEvent for event PBSTransfer, result FAIL
 *
 * \param[in,out] context	context to work with, 
 * \param[in] destination	Destination where the job is being transfered to.
 * \param[in] dest_instance	Service (instance) that takes over control of the job.
 * \param[in] reason	Detailed description of the transfer, especially reason of failure.
 * \param[in] dest_jobid	Job id as assigned by the receiving software component.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogPBSTransferFAIL(edg_wll_Context context, const edg_wll_Source destination, const char * dest_instance, const char * reason, const char * dest_jobid);

/**
 * \brief edg_wll_LogPBSTransferFAILProxy
 *
 * edg_wll_LogPBSTransferFAILProxy - simple wrapper around edg_wll_LogEventProxy for event PBSTransfer, result FAIL
 *
 * \param[in,out] context	context to work with, 
 * \param[in] destination	Destination where the job is being transfered to.
 * \param[in] dest_instance	Service (instance) that takes over control of the job.
 * \param[in] reason	Detailed description of the transfer, especially reason of failure.
 * \param[in] dest_jobid	Job id as assigned by the receiving software component.
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogPBSTransferFAILProxy(edg_wll_Context context, const edg_wll_Source destination, const char * dest_instance, const char * reason, const char * dest_jobid);

/**
 * \brief edg_wll_LogPBSTransferFAILFile
 *
 * edg_wll_LogPBSTransferFAILFile - simple wrapper around edg_wll_LogEventFile for event PBSTransfer, result FAIL
 *
 * \param[in,out] context	context to work with, 
 * \param[in] destination	Destination where the job is being transfered to.
 * \param[in] dest_instance	Service (instance) that takes over control of the job.
 * \param[in] reason	Detailed description of the transfer, especially reason of failure.
 * \param[in] dest_jobid	Job id as assigned by the receiving software component.
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogPBSTransferFAILFile(edg_wll_Context context, const edg_wll_Source destination, const char * dest_instance, const char * reason, const char * dest_jobid);

/**
 * \brief edg_wll_LogPBSAccepted
 *
 * edg_wll_LogPBSAccepted - simple wrapper around edg_wll_LogEvent for event PBSAccepted
 *
 * \param[in,out] context	context to work with, 
 * \param[in] from	The software component  the job was received from.
 * \param[in] from_instance	Instance of the component the job was received from.
 * \param[in] local_jobid	New job id as assigned by the receiving component.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogPBSAccepted(edg_wll_Context context, const edg_wll_Source from, const char * from_instance, const char * local_jobid);

/**
 * \brief edg_wll_LogPBSAcceptedProxy
 *
 * edg_wll_LogPBSAcceptedProxy - simple wrapper around edg_wll_LogEventProxy for event PBSAccepted
 *
 * \param[in,out] context	context to work with, 
 * \param[in] from	The software component  the job was received from.
 * \param[in] from_instance	Instance of the component the job was received from.
 * \param[in] local_jobid	New job id as assigned by the receiving component.
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogPBSAcceptedProxy(edg_wll_Context context, const edg_wll_Source from, const char * from_instance, const char * local_jobid);

/**
 * \brief edg_wll_LogPBSAcceptedFile
 *
 * edg_wll_LogPBSAcceptedFile - simple wrapper around edg_wll_LogEventFile for event PBSAccepted
 *
 * \param[in,out] context	context to work with, 
 * \param[in] from	The software component  the job was received from.
 * \param[in] from_instance	Instance of the component the job was received from.
 * \param[in] local_jobid	New job id as assigned by the receiving component.
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogPBSAcceptedFile(edg_wll_Context context, const edg_wll_Source from, const char * from_instance, const char * local_jobid);

/**
 * \brief edg_wll_LogPBSRefused
 *
 * edg_wll_LogPBSRefused - simple wrapper around edg_wll_LogEvent for event PBSRefused
 *
 * \param[in,out] context	context to work with, 
 * \param[in] from	The software component that tried to send the job.
 * \param[in] from_instance	Instance of the component that tried to send the job.
 * \param[in] reason	Description of the reason why the job was refused.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogPBSRefused(edg_wll_Context context, const edg_wll_Source from, const char * from_instance, const char * reason);

/**
 * \brief edg_wll_LogPBSRefusedProxy
 *
 * edg_wll_LogPBSRefusedProxy - simple wrapper around edg_wll_LogEventProxy for event PBSRefused
 *
 * \param[in,out] context	context to work with, 
 * \param[in] from	The software component that tried to send the job.
 * \param[in] from_instance	Instance of the component that tried to send the job.
 * \param[in] reason	Description of the reason why the job was refused.
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogPBSRefusedProxy(edg_wll_Context context, const edg_wll_Source from, const char * from_instance, const char * reason);

/**
 * \brief edg_wll_LogPBSRefusedFile
 *
 * edg_wll_LogPBSRefusedFile - simple wrapper around edg_wll_LogEventFile for event PBSRefused
 *
 * \param[in,out] context	context to work with, 
 * \param[in] from	The software component that tried to send the job.
 * \param[in] from_instance	Instance of the component that tried to send the job.
 * \param[in] reason	Description of the reason why the job was refused.
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogPBSRefusedFile(edg_wll_Context context, const edg_wll_Source from, const char * from_instance, const char * reason);

/**
 * \brief edg_wll_LogPBSQueued
 *
 * edg_wll_LogPBSQueued - simple wrapper around edg_wll_LogEvent for event PBSQueued
 *
 * \param[in,out] context	context to work with, 
 * \param[in] queue	Queue name
 * \param[in] name	Job name
 * \param[in] owner	Job owner
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogPBSQueued(edg_wll_Context context, const char * queue, const char * name, const char * owner);

/**
 * \brief edg_wll_LogPBSQueuedProxy
 *
 * edg_wll_LogPBSQueuedProxy - simple wrapper around edg_wll_LogEventProxy for event PBSQueued
 *
 * \param[in,out] context	context to work with, 
 * \param[in] queue	Queue name
 * \param[in] name	Job name
 * \param[in] owner	Job owner
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogPBSQueuedProxy(edg_wll_Context context, const char * queue, const char * name, const char * owner);

/**
 * \brief edg_wll_LogPBSQueuedFile
 *
 * edg_wll_LogPBSQueuedFile - simple wrapper around edg_wll_LogEventFile for event PBSQueued
 *
 * \param[in,out] context	context to work with, 
 * \param[in] queue	Queue name
 * \param[in] name	Job name
 * \param[in] owner	Job owner
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogPBSQueuedFile(edg_wll_Context context, const char * queue, const char * name, const char * owner);

/**
 * \brief edg_wll_LogPBSDequeued
 *
 * edg_wll_LogPBSDequeued - simple wrapper around edg_wll_LogEvent for event PBSDequeued
 *
 * \param[in,out] context	context to work with, 
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogPBSDequeued(edg_wll_Context context);

/**
 * \brief edg_wll_LogPBSDequeuedProxy
 *
 * edg_wll_LogPBSDequeuedProxy - simple wrapper around edg_wll_LogEventProxy for event PBSDequeued
 *
 * \param[in,out] context	context to work with, 
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogPBSDequeuedProxy(edg_wll_Context context);

/**
 * \brief edg_wll_LogPBSDequeuedFile
 *
 * edg_wll_LogPBSDequeuedFile - simple wrapper around edg_wll_LogEventFile for event PBSDequeued
 *
 * \param[in,out] context	context to work with, 
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogPBSDequeuedFile(edg_wll_Context context);

/**
 * \brief edg_wll_LogPBSMatch
 *
 * edg_wll_LogPBSMatch - simple wrapper around edg_wll_LogEvent for event PBSMatch
 *
 * \param[in,out] context	context to work with, 
 * \param[in] dest_host	Aka exec host
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogPBSMatch(edg_wll_Context context, const char * dest_host);

/**
 * \brief edg_wll_LogPBSMatchProxy
 *
 * edg_wll_LogPBSMatchProxy - simple wrapper around edg_wll_LogEventProxy for event PBSMatch
 *
 * \param[in,out] context	context to work with, 
 * \param[in] dest_host	Aka exec host
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogPBSMatchProxy(edg_wll_Context context, const char * dest_host);

/**
 * \brief edg_wll_LogPBSMatchFile
 *
 * edg_wll_LogPBSMatchFile - simple wrapper around edg_wll_LogEventFile for event PBSMatch
 *
 * \param[in,out] context	context to work with, 
 * \param[in] dest_host	Aka exec host
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogPBSMatchFile(edg_wll_Context context, const char * dest_host);

/**
 * \brief edg_wll_LogPBSPending
 *
 * edg_wll_LogPBSPending - simple wrapper around edg_wll_LogEvent for event PBSPending
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reasons of job pendation or errors
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogPBSPending(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogPBSPendingProxy
 *
 * edg_wll_LogPBSPendingProxy - simple wrapper around edg_wll_LogEventProxy for event PBSPending
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reasons of job pendation or errors
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogPBSPendingProxy(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogPBSPendingFile
 *
 * edg_wll_LogPBSPendingFile - simple wrapper around edg_wll_LogEventFile for event PBSPending
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reasons of job pendation or errors
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogPBSPendingFile(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogPBSWaiting
 *
 * edg_wll_LogPBSWaiting - simple wrapper around edg_wll_LogEvent for event PBSWaiting
 *
 * \param[in,out] context	context to work with, 
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogPBSWaiting(edg_wll_Context context);

/**
 * \brief edg_wll_LogPBSWaitingProxy
 *
 * edg_wll_LogPBSWaitingProxy - simple wrapper around edg_wll_LogEventProxy for event PBSWaiting
 *
 * \param[in,out] context	context to work with, 
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogPBSWaitingProxy(edg_wll_Context context);

/**
 * \brief edg_wll_LogPBSWaitingFile
 *
 * edg_wll_LogPBSWaitingFile - simple wrapper around edg_wll_LogEventFile for event PBSWaiting
 *
 * \param[in,out] context	context to work with, 
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogPBSWaitingFile(edg_wll_Context context);

/**
 * \brief edg_wll_LogPBSRun
 *
 * edg_wll_LogPBSRun - simple wrapper around edg_wll_LogEvent for event PBSRun
 *
 * \param[in,out] context	context to work with, 
 * \param[in] scheduler	Scheduler ID
 * \param[in] dest_host	Where to run the job
 * \param[in] pid	Actual process ID
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogPBSRun(edg_wll_Context context, const char * scheduler, const char * dest_host, const int pid);

/**
 * \brief edg_wll_LogPBSRunProxy
 *
 * edg_wll_LogPBSRunProxy - simple wrapper around edg_wll_LogEventProxy for event PBSRun
 *
 * \param[in,out] context	context to work with, 
 * \param[in] scheduler	Scheduler ID
 * \param[in] dest_host	Where to run the job
 * \param[in] pid	Actual process ID
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogPBSRunProxy(edg_wll_Context context, const char * scheduler, const char * dest_host, const int pid);

/**
 * \brief edg_wll_LogPBSRunFile
 *
 * edg_wll_LogPBSRunFile - simple wrapper around edg_wll_LogEventFile for event PBSRun
 *
 * \param[in,out] context	context to work with, 
 * \param[in] scheduler	Scheduler ID
 * \param[in] dest_host	Where to run the job
 * \param[in] pid	Actual process ID
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogPBSRunFile(edg_wll_Context context, const char * scheduler, const char * dest_host, const int pid);

/**
 * \brief edg_wll_LogPBSRerun
 *
 * edg_wll_LogPBSRerun - simple wrapper around edg_wll_LogEvent for event PBSRerun
 *
 * \param[in,out] context	context to work with, 
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogPBSRerun(edg_wll_Context context);

/**
 * \brief edg_wll_LogPBSRerunProxy
 *
 * edg_wll_LogPBSRerunProxy - simple wrapper around edg_wll_LogEventProxy for event PBSRerun
 *
 * \param[in,out] context	context to work with, 
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogPBSRerunProxy(edg_wll_Context context);

/**
 * \brief edg_wll_LogPBSRerunFile
 *
 * edg_wll_LogPBSRerunFile - simple wrapper around edg_wll_LogEventFile for event PBSRerun
 *
 * \param[in,out] context	context to work with, 
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogPBSRerunFile(edg_wll_Context context);

/**
 * \brief edg_wll_LogPBSAbort
 *
 * edg_wll_LogPBSAbort - simple wrapper around edg_wll_LogEvent for event PBSAbort
 *
 * \param[in,out] context	context to work with, 
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogPBSAbort(edg_wll_Context context);

/**
 * \brief edg_wll_LogPBSAbortProxy
 *
 * edg_wll_LogPBSAbortProxy - simple wrapper around edg_wll_LogEventProxy for event PBSAbort
 *
 * \param[in,out] context	context to work with, 
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogPBSAbortProxy(edg_wll_Context context);

/**
 * \brief edg_wll_LogPBSAbortFile
 *
 * edg_wll_LogPBSAbortFile - simple wrapper around edg_wll_LogEventFile for event PBSAbort
 *
 * \param[in,out] context	context to work with, 
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogPBSAbortFile(edg_wll_Context context);

/**
 * \brief edg_wll_LogPBSDone
 *
 * edg_wll_LogPBSDone - simple wrapper around edg_wll_LogEvent for event PBSDone
 *
 * \param[in,out] context	context to work with, 
 * \param[in] exit_status	Exit status
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogPBSDone(edg_wll_Context context, const int exit_status);

/**
 * \brief edg_wll_LogPBSDoneProxy
 *
 * edg_wll_LogPBSDoneProxy - simple wrapper around edg_wll_LogEventProxy for event PBSDone
 *
 * \param[in,out] context	context to work with, 
 * \param[in] exit_status	Exit status
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogPBSDoneProxy(edg_wll_Context context, const int exit_status);

/**
 * \brief edg_wll_LogPBSDoneFile
 *
 * edg_wll_LogPBSDoneFile - simple wrapper around edg_wll_LogEventFile for event PBSDone
 *
 * \param[in,out] context	context to work with, 
 * \param[in] exit_status	Exit status
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogPBSDoneFile(edg_wll_Context context, const int exit_status);

/**
 * \brief edg_wll_LogPBSResourceUsage
 *
 * edg_wll_LogPBSResourceUsage - simple wrapper around edg_wll_LogEvent for event PBSResourceUsage
 *
 * \param[in,out] context	context to work with, 
 * \param[in] usage	Type of record
 * \param[in] resources	List of resources
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogPBSResourceUsage(edg_wll_Context context, const char * usage, const edg_wll_TagValue * resources);

/**
 * \brief edg_wll_LogPBSResourceUsageProxy
 *
 * edg_wll_LogPBSResourceUsageProxy - simple wrapper around edg_wll_LogEventProxy for event PBSResourceUsage
 *
 * \param[in,out] context	context to work with, 
 * \param[in] usage	Type of record
 * \param[in] resources	List of resources
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogPBSResourceUsageProxy(edg_wll_Context context, const char * usage, const edg_wll_TagValue * resources);

/**
 * \brief edg_wll_LogPBSResourceUsageFile
 *
 * edg_wll_LogPBSResourceUsageFile - simple wrapper around edg_wll_LogEventFile for event PBSResourceUsage
 *
 * \param[in,out] context	context to work with, 
 * \param[in] usage	Type of record
 * \param[in] resources	List of resources
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogPBSResourceUsageFile(edg_wll_Context context, const char * usage, const edg_wll_TagValue * resources);

/**
 * \brief edg_wll_LogPBSResourceUsageREQUESTED
 *
 * edg_wll_LogPBSResourceUsageREQUESTED - simple wrapper around edg_wll_LogEvent for event PBSResourceUsage, usage REQUESTED
 *
 * \param[in,out] context	context to work with, 
 * \param[in] resources	List of resources
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogPBSResourceUsageREQUESTED(edg_wll_Context context, const edg_wll_TagValue * resources);

/**
 * \brief edg_wll_LogPBSResourceUsageREQUESTEDProxy
 *
 * edg_wll_LogPBSResourceUsageREQUESTEDProxy - simple wrapper around edg_wll_LogEventProxy for event PBSResourceUsage, usage REQUESTED
 *
 * \param[in,out] context	context to work with, 
 * \param[in] resources	List of resources
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogPBSResourceUsageREQUESTEDProxy(edg_wll_Context context, const edg_wll_TagValue * resources);

/**
 * \brief edg_wll_LogPBSResourceUsageREQUESTEDFile
 *
 * edg_wll_LogPBSResourceUsageREQUESTEDFile - simple wrapper around edg_wll_LogEventFile for event PBSResourceUsage, usage REQUESTED
 *
 * \param[in,out] context	context to work with, 
 * \param[in] resources	List of resources
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogPBSResourceUsageREQUESTEDFile(edg_wll_Context context, const edg_wll_TagValue * resources);

/**
 * \brief edg_wll_LogPBSResourceUsageUSED
 *
 * edg_wll_LogPBSResourceUsageUSED - simple wrapper around edg_wll_LogEvent for event PBSResourceUsage, usage USED
 *
 * \param[in,out] context	context to work with, 
 * \param[in] resources	List of resources
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogPBSResourceUsageUSED(edg_wll_Context context, const edg_wll_TagValue * resources);

/**
 * \brief edg_wll_LogPBSResourceUsageUSEDProxy
 *
 * edg_wll_LogPBSResourceUsageUSEDProxy - simple wrapper around edg_wll_LogEventProxy for event PBSResourceUsage, usage USED
 *
 * \param[in,out] context	context to work with, 
 * \param[in] resources	List of resources
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogPBSResourceUsageUSEDProxy(edg_wll_Context context, const edg_wll_TagValue * resources);

/**
 * \brief edg_wll_LogPBSResourceUsageUSEDFile
 *
 * edg_wll_LogPBSResourceUsageUSEDFile - simple wrapper around edg_wll_LogEventFile for event PBSResourceUsage, usage USED
 *
 * \param[in,out] context	context to work with, 
 * \param[in] resources	List of resources
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogPBSResourceUsageUSEDFile(edg_wll_Context context, const edg_wll_TagValue * resources);

/**
 * \brief edg_wll_LogPBSError
 *
 * edg_wll_LogPBSError - simple wrapper around edg_wll_LogEvent for event PBSError
 *
 * \param[in,out] context	context to work with, 
 * \param[in] error_desc	Error reason
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogPBSError(edg_wll_Context context, const char * error_desc);

/**
 * \brief edg_wll_LogPBSErrorProxy
 *
 * edg_wll_LogPBSErrorProxy - simple wrapper around edg_wll_LogEventProxy for event PBSError
 *
 * \param[in,out] context	context to work with, 
 * \param[in] error_desc	Error reason
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogPBSErrorProxy(edg_wll_Context context, const char * error_desc);

/**
 * \brief edg_wll_LogPBSErrorFile
 *
 * edg_wll_LogPBSErrorFile - simple wrapper around edg_wll_LogEventFile for event PBSError
 *
 * \param[in,out] context	context to work with, 
 * \param[in] error_desc	Error reason
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogPBSErrorFile(edg_wll_Context context, const char * error_desc);

/**
 * \brief edg_wll_LogCondorMatch
 *
 * edg_wll_LogCondorMatch - simple wrapper around edg_wll_LogEvent for event CondorMatch
 *
 * \param[in,out] context	context to work with, 
 * \param[in] owner	Owner
 * \param[in] dest_host	Matched host
 * \param[in] preempting	Preempting
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogCondorMatch(edg_wll_Context context, const char * owner, const char * dest_host, const char * preempting);

/**
 * \brief edg_wll_LogCondorMatchProxy
 *
 * edg_wll_LogCondorMatchProxy - simple wrapper around edg_wll_LogEventProxy for event CondorMatch
 *
 * \param[in,out] context	context to work with, 
 * \param[in] owner	Owner
 * \param[in] dest_host	Matched host
 * \param[in] preempting	Preempting
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogCondorMatchProxy(edg_wll_Context context, const char * owner, const char * dest_host, const char * preempting);

/**
 * \brief edg_wll_LogCondorMatchFile
 *
 * edg_wll_LogCondorMatchFile - simple wrapper around edg_wll_LogEventFile for event CondorMatch
 *
 * \param[in,out] context	context to work with, 
 * \param[in] owner	Owner
 * \param[in] dest_host	Matched host
 * \param[in] preempting	Preempting
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogCondorMatchFile(edg_wll_Context context, const char * owner, const char * dest_host, const char * preempting);

/**
 * \brief edg_wll_LogCondorReject
 *
 * edg_wll_LogCondorReject - simple wrapper around edg_wll_LogEvent for event CondorReject
 *
 * \param[in,out] context	context to work with, 
 * \param[in] owner	Owner
 * \param[in] status_code	Reason code for the rejection of the job
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogCondorReject(edg_wll_Context context, const char * owner, const char * status_code);

/**
 * \brief edg_wll_LogCondorRejectProxy
 *
 * edg_wll_LogCondorRejectProxy - simple wrapper around edg_wll_LogEventProxy for event CondorReject
 *
 * \param[in,out] context	context to work with, 
 * \param[in] owner	Owner
 * \param[in] status_code	Reason code for the rejection of the job
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogCondorRejectProxy(edg_wll_Context context, const char * owner, const char * status_code);

/**
 * \brief edg_wll_LogCondorRejectFile
 *
 * edg_wll_LogCondorRejectFile - simple wrapper around edg_wll_LogEventFile for event CondorReject
 *
 * \param[in,out] context	context to work with, 
 * \param[in] owner	Owner
 * \param[in] status_code	Reason code for the rejection of the job
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogCondorRejectFile(edg_wll_Context context, const char * owner, const char * status_code);

/**
 * \brief edg_wll_LogCondorRejectNOMATCH
 *
 * edg_wll_LogCondorRejectNOMATCH - simple wrapper around edg_wll_LogEvent for event CondorReject, status_code NOMATCH
 *
 * \param[in,out] context	context to work with, 
 * \param[in] owner	Owner
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogCondorRejectNOMATCH(edg_wll_Context context, const char * owner);

/**
 * \brief edg_wll_LogCondorRejectNOMATCHProxy
 *
 * edg_wll_LogCondorRejectNOMATCHProxy - simple wrapper around edg_wll_LogEventProxy for event CondorReject, status_code NOMATCH
 *
 * \param[in,out] context	context to work with, 
 * \param[in] owner	Owner
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogCondorRejectNOMATCHProxy(edg_wll_Context context, const char * owner);

/**
 * \brief edg_wll_LogCondorRejectNOMATCHFile
 *
 * edg_wll_LogCondorRejectNOMATCHFile - simple wrapper around edg_wll_LogEventFile for event CondorReject, status_code NOMATCH
 *
 * \param[in,out] context	context to work with, 
 * \param[in] owner	Owner
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogCondorRejectNOMATCHFile(edg_wll_Context context, const char * owner);

/**
 * \brief edg_wll_LogCondorRejectOTHER
 *
 * edg_wll_LogCondorRejectOTHER - simple wrapper around edg_wll_LogEvent for event CondorReject, status_code OTHER
 *
 * \param[in,out] context	context to work with, 
 * \param[in] owner	Owner
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogCondorRejectOTHER(edg_wll_Context context, const char * owner);

/**
 * \brief edg_wll_LogCondorRejectOTHERProxy
 *
 * edg_wll_LogCondorRejectOTHERProxy - simple wrapper around edg_wll_LogEventProxy for event CondorReject, status_code OTHER
 *
 * \param[in,out] context	context to work with, 
 * \param[in] owner	Owner
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogCondorRejectOTHERProxy(edg_wll_Context context, const char * owner);

/**
 * \brief edg_wll_LogCondorRejectOTHERFile
 *
 * edg_wll_LogCondorRejectOTHERFile - simple wrapper around edg_wll_LogEventFile for event CondorReject, status_code OTHER
 *
 * \param[in,out] context	context to work with, 
 * \param[in] owner	Owner
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogCondorRejectOTHERFile(edg_wll_Context context, const char * owner);

/**
 * \brief edg_wll_LogCondorShadowStarted
 *
 * edg_wll_LogCondorShadowStarted - simple wrapper around edg_wll_LogEvent for event CondorShadowStarted
 *
 * \param[in,out] context	context to work with, 
 * \param[in] shadow_host	Shadow host
 * \param[in] shadow_port	Shadow port
 * \param[in] shadow_pid	PID of shadow process
 * \param[in] shadow_status	Shadow status
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogCondorShadowStarted(edg_wll_Context context, const char * shadow_host, const uint16_t shadow_port, const int shadow_pid, const char * shadow_status);

/**
 * \brief edg_wll_LogCondorShadowStartedProxy
 *
 * edg_wll_LogCondorShadowStartedProxy - simple wrapper around edg_wll_LogEventProxy for event CondorShadowStarted
 *
 * \param[in,out] context	context to work with, 
 * \param[in] shadow_host	Shadow host
 * \param[in] shadow_port	Shadow port
 * \param[in] shadow_pid	PID of shadow process
 * \param[in] shadow_status	Shadow status
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogCondorShadowStartedProxy(edg_wll_Context context, const char * shadow_host, const uint16_t shadow_port, const int shadow_pid, const char * shadow_status);

/**
 * \brief edg_wll_LogCondorShadowStartedFile
 *
 * edg_wll_LogCondorShadowStartedFile - simple wrapper around edg_wll_LogEventFile for event CondorShadowStarted
 *
 * \param[in,out] context	context to work with, 
 * \param[in] shadow_host	Shadow host
 * \param[in] shadow_port	Shadow port
 * \param[in] shadow_pid	PID of shadow process
 * \param[in] shadow_status	Shadow status
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogCondorShadowStartedFile(edg_wll_Context context, const char * shadow_host, const uint16_t shadow_port, const int shadow_pid, const char * shadow_status);

/**
 * \brief edg_wll_LogCondorShadowExited
 *
 * edg_wll_LogCondorShadowExited - simple wrapper around edg_wll_LogEvent for event CondorShadowExited
 *
 * \param[in,out] context	context to work with, 
 * \param[in] shadow_pid	PID of shadow process
 * \param[in] shadow_exit_status	Exit status of shadow process
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogCondorShadowExited(edg_wll_Context context, const int shadow_pid, const int shadow_exit_status);

/**
 * \brief edg_wll_LogCondorShadowExitedProxy
 *
 * edg_wll_LogCondorShadowExitedProxy - simple wrapper around edg_wll_LogEventProxy for event CondorShadowExited
 *
 * \param[in,out] context	context to work with, 
 * \param[in] shadow_pid	PID of shadow process
 * \param[in] shadow_exit_status	Exit status of shadow process
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogCondorShadowExitedProxy(edg_wll_Context context, const int shadow_pid, const int shadow_exit_status);

/**
 * \brief edg_wll_LogCondorShadowExitedFile
 *
 * edg_wll_LogCondorShadowExitedFile - simple wrapper around edg_wll_LogEventFile for event CondorShadowExited
 *
 * \param[in,out] context	context to work with, 
 * \param[in] shadow_pid	PID of shadow process
 * \param[in] shadow_exit_status	Exit status of shadow process
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogCondorShadowExitedFile(edg_wll_Context context, const int shadow_pid, const int shadow_exit_status);

/**
 * \brief edg_wll_LogCondorStarterStarted
 *
 * edg_wll_LogCondorStarterStarted - simple wrapper around edg_wll_LogEvent for event CondorStarterStarted
 *
 * \param[in,out] context	context to work with, 
 * \param[in] starter_pid	PID of starter process
 * \param[in] universe	Condor Universe
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogCondorStarterStarted(edg_wll_Context context, const int starter_pid, const char * universe);

/**
 * \brief edg_wll_LogCondorStarterStartedProxy
 *
 * edg_wll_LogCondorStarterStartedProxy - simple wrapper around edg_wll_LogEventProxy for event CondorStarterStarted
 *
 * \param[in,out] context	context to work with, 
 * \param[in] starter_pid	PID of starter process
 * \param[in] universe	Condor Universe
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogCondorStarterStartedProxy(edg_wll_Context context, const int starter_pid, const char * universe);

/**
 * \brief edg_wll_LogCondorStarterStartedFile
 *
 * edg_wll_LogCondorStarterStartedFile - simple wrapper around edg_wll_LogEventFile for event CondorStarterStarted
 *
 * \param[in,out] context	context to work with, 
 * \param[in] starter_pid	PID of starter process
 * \param[in] universe	Condor Universe
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogCondorStarterStartedFile(edg_wll_Context context, const int starter_pid, const char * universe);

/**
 * \brief edg_wll_LogCondorStarterExited
 *
 * edg_wll_LogCondorStarterExited - simple wrapper around edg_wll_LogEvent for event CondorStarterExited
 *
 * \param[in,out] context	context to work with, 
 * \param[in] starter_pid	PID of starter process
 * \param[in] starter_exit_status	Exit status of starter process
 * \param[in] job_pid	PID of running job
 * \param[in] job_exit_status	Job exit status
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogCondorStarterExited(edg_wll_Context context, const int starter_pid, const int starter_exit_status, const int job_pid, const int job_exit_status);

/**
 * \brief edg_wll_LogCondorStarterExitedProxy
 *
 * edg_wll_LogCondorStarterExitedProxy - simple wrapper around edg_wll_LogEventProxy for event CondorStarterExited
 *
 * \param[in,out] context	context to work with, 
 * \param[in] starter_pid	PID of starter process
 * \param[in] starter_exit_status	Exit status of starter process
 * \param[in] job_pid	PID of running job
 * \param[in] job_exit_status	Job exit status
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogCondorStarterExitedProxy(edg_wll_Context context, const int starter_pid, const int starter_exit_status, const int job_pid, const int job_exit_status);

/**
 * \brief edg_wll_LogCondorStarterExitedFile
 *
 * edg_wll_LogCondorStarterExitedFile - simple wrapper around edg_wll_LogEventFile for event CondorStarterExited
 *
 * \param[in,out] context	context to work with, 
 * \param[in] starter_pid	PID of starter process
 * \param[in] starter_exit_status	Exit status of starter process
 * \param[in] job_pid	PID of running job
 * \param[in] job_exit_status	Job exit status
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogCondorStarterExitedFile(edg_wll_Context context, const int starter_pid, const int starter_exit_status, const int job_pid, const int job_exit_status);

/**
 * \brief edg_wll_LogCondorResourceUsage
 *
 * edg_wll_LogCondorResourceUsage - simple wrapper around edg_wll_LogEvent for event CondorResourceUsage
 *
 * \param[in,out] context	context to work with, 
 * \param[in] usage	Type of record
 * \param[in] name	Name of resource
 * \param[in] quantity	The quantity
 * \param[in] unit	Units (sec, kB, etc.)
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogCondorResourceUsage(edg_wll_Context context, const char * usage, const char * name, const double quantity, const char * unit);

/**
 * \brief edg_wll_LogCondorResourceUsageProxy
 *
 * edg_wll_LogCondorResourceUsageProxy - simple wrapper around edg_wll_LogEventProxy for event CondorResourceUsage
 *
 * \param[in,out] context	context to work with, 
 * \param[in] usage	Type of record
 * \param[in] name	Name of resource
 * \param[in] quantity	The quantity
 * \param[in] unit	Units (sec, kB, etc.)
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogCondorResourceUsageProxy(edg_wll_Context context, const char * usage, const char * name, const double quantity, const char * unit);

/**
 * \brief edg_wll_LogCondorResourceUsageFile
 *
 * edg_wll_LogCondorResourceUsageFile - simple wrapper around edg_wll_LogEventFile for event CondorResourceUsage
 *
 * \param[in,out] context	context to work with, 
 * \param[in] usage	Type of record
 * \param[in] name	Name of resource
 * \param[in] quantity	The quantity
 * \param[in] unit	Units (sec, kB, etc.)
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogCondorResourceUsageFile(edg_wll_Context context, const char * usage, const char * name, const double quantity, const char * unit);

/**
 * \brief edg_wll_LogCondorResourceUsageREQUESTED
 *
 * edg_wll_LogCondorResourceUsageREQUESTED - simple wrapper around edg_wll_LogEvent for event CondorResourceUsage, usage REQUESTED
 *
 * \param[in,out] context	context to work with, 
 * \param[in] name	Name of resource
 * \param[in] quantity	The quantity
 * \param[in] unit	Units (sec, kB, etc.)
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogCondorResourceUsageREQUESTED(edg_wll_Context context, const char * name, const double quantity, const char * unit);

/**
 * \brief edg_wll_LogCondorResourceUsageREQUESTEDProxy
 *
 * edg_wll_LogCondorResourceUsageREQUESTEDProxy - simple wrapper around edg_wll_LogEventProxy for event CondorResourceUsage, usage REQUESTED
 *
 * \param[in,out] context	context to work with, 
 * \param[in] name	Name of resource
 * \param[in] quantity	The quantity
 * \param[in] unit	Units (sec, kB, etc.)
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogCondorResourceUsageREQUESTEDProxy(edg_wll_Context context, const char * name, const double quantity, const char * unit);

/**
 * \brief edg_wll_LogCondorResourceUsageREQUESTEDFile
 *
 * edg_wll_LogCondorResourceUsageREQUESTEDFile - simple wrapper around edg_wll_LogEventFile for event CondorResourceUsage, usage REQUESTED
 *
 * \param[in,out] context	context to work with, 
 * \param[in] name	Name of resource
 * \param[in] quantity	The quantity
 * \param[in] unit	Units (sec, kB, etc.)
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogCondorResourceUsageREQUESTEDFile(edg_wll_Context context, const char * name, const double quantity, const char * unit);

/**
 * \brief edg_wll_LogCondorResourceUsageUSED
 *
 * edg_wll_LogCondorResourceUsageUSED - simple wrapper around edg_wll_LogEvent for event CondorResourceUsage, usage USED
 *
 * \param[in,out] context	context to work with, 
 * \param[in] name	Name of resource
 * \param[in] quantity	The quantity
 * \param[in] unit	Units (sec, kB, etc.)
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogCondorResourceUsageUSED(edg_wll_Context context, const char * name, const double quantity, const char * unit);

/**
 * \brief edg_wll_LogCondorResourceUsageUSEDProxy
 *
 * edg_wll_LogCondorResourceUsageUSEDProxy - simple wrapper around edg_wll_LogEventProxy for event CondorResourceUsage, usage USED
 *
 * \param[in,out] context	context to work with, 
 * \param[in] name	Name of resource
 * \param[in] quantity	The quantity
 * \param[in] unit	Units (sec, kB, etc.)
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogCondorResourceUsageUSEDProxy(edg_wll_Context context, const char * name, const double quantity, const char * unit);

/**
 * \brief edg_wll_LogCondorResourceUsageUSEDFile
 *
 * edg_wll_LogCondorResourceUsageUSEDFile - simple wrapper around edg_wll_LogEventFile for event CondorResourceUsage, usage USED
 *
 * \param[in,out] context	context to work with, 
 * \param[in] name	Name of resource
 * \param[in] quantity	The quantity
 * \param[in] unit	Units (sec, kB, etc.)
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogCondorResourceUsageUSEDFile(edg_wll_Context context, const char * name, const double quantity, const char * unit);

/**
 * \brief edg_wll_LogCondorError
 *
 * edg_wll_LogCondorError - simple wrapper around edg_wll_LogEvent for event CondorError
 *
 * \param[in,out] context	context to work with, 
 * \param[in] error_desc	Error reason
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogCondorError(edg_wll_Context context, const char * error_desc);

/**
 * \brief edg_wll_LogCondorErrorProxy
 *
 * edg_wll_LogCondorErrorProxy - simple wrapper around edg_wll_LogEventProxy for event CondorError
 *
 * \param[in,out] context	context to work with, 
 * \param[in] error_desc	Error reason
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogCondorErrorProxy(edg_wll_Context context, const char * error_desc);

/**
 * \brief edg_wll_LogCondorErrorFile
 *
 * edg_wll_LogCondorErrorFile - simple wrapper around edg_wll_LogEventFile for event CondorError
 *
 * \param[in,out] context	context to work with, 
 * \param[in] error_desc	Error reason
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogCondorErrorFile(edg_wll_Context context, const char * error_desc);

/**
 * \brief edg_wll_LogCREAMStart
 *
 * edg_wll_LogCREAMStart - simple wrapper around edg_wll_LogEvent for event CREAMStart
 *
 * \param[in,out] context	context to work with, 
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogCREAMStart(edg_wll_Context context);

/**
 * \brief edg_wll_LogCREAMStartProxy
 *
 * edg_wll_LogCREAMStartProxy - simple wrapper around edg_wll_LogEventProxy for event CREAMStart
 *
 * \param[in,out] context	context to work with, 
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogCREAMStartProxy(edg_wll_Context context);

/**
 * \brief edg_wll_LogCREAMStartFile
 *
 * edg_wll_LogCREAMStartFile - simple wrapper around edg_wll_LogEventFile for event CREAMStart
 *
 * \param[in,out] context	context to work with, 
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogCREAMStartFile(edg_wll_Context context);

/**
 * \brief edg_wll_LogCREAMPurge
 *
 * edg_wll_LogCREAMPurge - simple wrapper around edg_wll_LogEvent for event CREAMPurge
 *
 * \param[in,out] context	context to work with, 
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogCREAMPurge(edg_wll_Context context);

/**
 * \brief edg_wll_LogCREAMPurgeProxy
 *
 * edg_wll_LogCREAMPurgeProxy - simple wrapper around edg_wll_LogEventProxy for event CREAMPurge
 *
 * \param[in,out] context	context to work with, 
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogCREAMPurgeProxy(edg_wll_Context context);

/**
 * \brief edg_wll_LogCREAMPurgeFile
 *
 * edg_wll_LogCREAMPurgeFile - simple wrapper around edg_wll_LogEventFile for event CREAMPurge
 *
 * \param[in,out] context	context to work with, 
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogCREAMPurgeFile(edg_wll_Context context);

/**
 * \brief edg_wll_LogCREAMAccepted
 *
 * edg_wll_LogCREAMAccepted - simple wrapper around edg_wll_LogEvent for event CREAMAccepted
 *
 * \param[in,out] context	context to work with, 
 * \param[in] local_jobid	New job id as assigned by the receiving component.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogCREAMAccepted(edg_wll_Context context, const char * local_jobid);

/**
 * \brief edg_wll_LogCREAMAcceptedProxy
 *
 * edg_wll_LogCREAMAcceptedProxy - simple wrapper around edg_wll_LogEventProxy for event CREAMAccepted
 *
 * \param[in,out] context	context to work with, 
 * \param[in] local_jobid	New job id as assigned by the receiving component.
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogCREAMAcceptedProxy(edg_wll_Context context, const char * local_jobid);

/**
 * \brief edg_wll_LogCREAMAcceptedFile
 *
 * edg_wll_LogCREAMAcceptedFile - simple wrapper around edg_wll_LogEventFile for event CREAMAccepted
 *
 * \param[in,out] context	context to work with, 
 * \param[in] local_jobid	New job id as assigned by the receiving component.
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogCREAMAcceptedFile(edg_wll_Context context, const char * local_jobid);

/**
 * \brief edg_wll_LogCREAMStore
 *
 * edg_wll_LogCREAMStore - simple wrapper around edg_wll_LogEvent for event CREAMStore
 *
 * \param[in,out] context	context to work with, 
 * \param[in] command	Command to store
 * \param[in] cmdid	Id of the command in store
 * \param[in] result	store phase/result
 * \param[in] reason	failure_reason
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogCREAMStore(edg_wll_Context context, const char * command, const char * cmdid, const char * result, const char * reason);

/**
 * \brief edg_wll_LogCREAMStoreProxy
 *
 * edg_wll_LogCREAMStoreProxy - simple wrapper around edg_wll_LogEventProxy for event CREAMStore
 *
 * \param[in,out] context	context to work with, 
 * \param[in] command	Command to store
 * \param[in] cmdid	Id of the command in store
 * \param[in] result	store phase/result
 * \param[in] reason	failure_reason
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogCREAMStoreProxy(edg_wll_Context context, const char * command, const char * cmdid, const char * result, const char * reason);

/**
 * \brief edg_wll_LogCREAMStoreFile
 *
 * edg_wll_LogCREAMStoreFile - simple wrapper around edg_wll_LogEventFile for event CREAMStore
 *
 * \param[in,out] context	context to work with, 
 * \param[in] command	Command to store
 * \param[in] cmdid	Id of the command in store
 * \param[in] result	store phase/result
 * \param[in] reason	failure_reason
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogCREAMStoreFile(edg_wll_Context context, const char * command, const char * cmdid, const char * result, const char * reason);

/**
 * \brief edg_wll_LogCREAMStoreCMDSTART
 *
 * edg_wll_LogCREAMStoreCMDSTART - simple wrapper around edg_wll_LogEvent for event CREAMStore, command CMDSTART
 *
 * \param[in,out] context	context to work with, 
 * \param[in] cmdid	Id of the command in store
 * \param[in] reason	failure_reason
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogCREAMStoreCMDSTART(edg_wll_Context context, const char * cmdid, const char * reason);

/**
 * \brief edg_wll_LogCREAMStoreCMDSTARTProxy
 *
 * edg_wll_LogCREAMStoreCMDSTARTProxy - simple wrapper around edg_wll_LogEventProxy for event CREAMStore, command CMDSTART
 *
 * \param[in,out] context	context to work with, 
 * \param[in] cmdid	Id of the command in store
 * \param[in] reason	failure_reason
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogCREAMStoreCMDSTARTProxy(edg_wll_Context context, const char * cmdid, const char * reason);

/**
 * \brief edg_wll_LogCREAMStoreCMDSTARTFile
 *
 * edg_wll_LogCREAMStoreCMDSTARTFile - simple wrapper around edg_wll_LogEventFile for event CREAMStore, command CMDSTART
 *
 * \param[in,out] context	context to work with, 
 * \param[in] cmdid	Id of the command in store
 * \param[in] reason	failure_reason
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogCREAMStoreCMDSTARTFile(edg_wll_Context context, const char * cmdid, const char * reason);

/**
 * \brief edg_wll_LogCREAMStoreCMDCANCEL
 *
 * edg_wll_LogCREAMStoreCMDCANCEL - simple wrapper around edg_wll_LogEvent for event CREAMStore, command CMDCANCEL
 *
 * \param[in,out] context	context to work with, 
 * \param[in] cmdid	Id of the command in store
 * \param[in] reason	failure_reason
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogCREAMStoreCMDCANCEL(edg_wll_Context context, const char * cmdid, const char * reason);

/**
 * \brief edg_wll_LogCREAMStoreCMDCANCELProxy
 *
 * edg_wll_LogCREAMStoreCMDCANCELProxy - simple wrapper around edg_wll_LogEventProxy for event CREAMStore, command CMDCANCEL
 *
 * \param[in,out] context	context to work with, 
 * \param[in] cmdid	Id of the command in store
 * \param[in] reason	failure_reason
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogCREAMStoreCMDCANCELProxy(edg_wll_Context context, const char * cmdid, const char * reason);

/**
 * \brief edg_wll_LogCREAMStoreCMDCANCELFile
 *
 * edg_wll_LogCREAMStoreCMDCANCELFile - simple wrapper around edg_wll_LogEventFile for event CREAMStore, command CMDCANCEL
 *
 * \param[in,out] context	context to work with, 
 * \param[in] cmdid	Id of the command in store
 * \param[in] reason	failure_reason
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogCREAMStoreCMDCANCELFile(edg_wll_Context context, const char * cmdid, const char * reason);

/**
 * \brief edg_wll_LogCREAMStoreCMDPURGE
 *
 * edg_wll_LogCREAMStoreCMDPURGE - simple wrapper around edg_wll_LogEvent for event CREAMStore, command CMDPURGE
 *
 * \param[in,out] context	context to work with, 
 * \param[in] cmdid	Id of the command in store
 * \param[in] reason	failure_reason
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogCREAMStoreCMDPURGE(edg_wll_Context context, const char * cmdid, const char * reason);

/**
 * \brief edg_wll_LogCREAMStoreCMDPURGEProxy
 *
 * edg_wll_LogCREAMStoreCMDPURGEProxy - simple wrapper around edg_wll_LogEventProxy for event CREAMStore, command CMDPURGE
 *
 * \param[in,out] context	context to work with, 
 * \param[in] cmdid	Id of the command in store
 * \param[in] reason	failure_reason
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogCREAMStoreCMDPURGEProxy(edg_wll_Context context, const char * cmdid, const char * reason);

/**
 * \brief edg_wll_LogCREAMStoreCMDPURGEFile
 *
 * edg_wll_LogCREAMStoreCMDPURGEFile - simple wrapper around edg_wll_LogEventFile for event CREAMStore, command CMDPURGE
 *
 * \param[in,out] context	context to work with, 
 * \param[in] cmdid	Id of the command in store
 * \param[in] reason	failure_reason
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogCREAMStoreCMDPURGEFile(edg_wll_Context context, const char * cmdid, const char * reason);

/**
 * \brief edg_wll_LogCREAMStoreCMDSUSPEND
 *
 * edg_wll_LogCREAMStoreCMDSUSPEND - simple wrapper around edg_wll_LogEvent for event CREAMStore, command CMDSUSPEND
 *
 * \param[in,out] context	context to work with, 
 * \param[in] cmdid	Id of the command in store
 * \param[in] reason	failure_reason
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogCREAMStoreCMDSUSPEND(edg_wll_Context context, const char * cmdid, const char * reason);

/**
 * \brief edg_wll_LogCREAMStoreCMDSUSPENDProxy
 *
 * edg_wll_LogCREAMStoreCMDSUSPENDProxy - simple wrapper around edg_wll_LogEventProxy for event CREAMStore, command CMDSUSPEND
 *
 * \param[in,out] context	context to work with, 
 * \param[in] cmdid	Id of the command in store
 * \param[in] reason	failure_reason
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogCREAMStoreCMDSUSPENDProxy(edg_wll_Context context, const char * cmdid, const char * reason);

/**
 * \brief edg_wll_LogCREAMStoreCMDSUSPENDFile
 *
 * edg_wll_LogCREAMStoreCMDSUSPENDFile - simple wrapper around edg_wll_LogEventFile for event CREAMStore, command CMDSUSPEND
 *
 * \param[in,out] context	context to work with, 
 * \param[in] cmdid	Id of the command in store
 * \param[in] reason	failure_reason
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogCREAMStoreCMDSUSPENDFile(edg_wll_Context context, const char * cmdid, const char * reason);

/**
 * \brief edg_wll_LogCREAMStoreCMDRESUME
 *
 * edg_wll_LogCREAMStoreCMDRESUME - simple wrapper around edg_wll_LogEvent for event CREAMStore, command CMDRESUME
 *
 * \param[in,out] context	context to work with, 
 * \param[in] cmdid	Id of the command in store
 * \param[in] reason	failure_reason
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogCREAMStoreCMDRESUME(edg_wll_Context context, const char * cmdid, const char * reason);

/**
 * \brief edg_wll_LogCREAMStoreCMDRESUMEProxy
 *
 * edg_wll_LogCREAMStoreCMDRESUMEProxy - simple wrapper around edg_wll_LogEventProxy for event CREAMStore, command CMDRESUME
 *
 * \param[in,out] context	context to work with, 
 * \param[in] cmdid	Id of the command in store
 * \param[in] reason	failure_reason
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogCREAMStoreCMDRESUMEProxy(edg_wll_Context context, const char * cmdid, const char * reason);

/**
 * \brief edg_wll_LogCREAMStoreCMDRESUMEFile
 *
 * edg_wll_LogCREAMStoreCMDRESUMEFile - simple wrapper around edg_wll_LogEventFile for event CREAMStore, command CMDRESUME
 *
 * \param[in,out] context	context to work with, 
 * \param[in] cmdid	Id of the command in store
 * \param[in] reason	failure_reason
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogCREAMStoreCMDRESUMEFile(edg_wll_Context context, const char * cmdid, const char * reason);

/**
 * \brief edg_wll_LogCREAMStoreSTART
 *
 * edg_wll_LogCREAMStoreSTART - simple wrapper around edg_wll_LogEvent for event CREAMStore, result START
 *
 * \param[in,out] context	context to work with, 
 * \param[in] cmdid	Id of the command in store
 * \param[in] reason	failure_reason
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogCREAMStoreSTART(edg_wll_Context context, const char * cmdid, const char * reason);

/**
 * \brief edg_wll_LogCREAMStoreSTARTProxy
 *
 * edg_wll_LogCREAMStoreSTARTProxy - simple wrapper around edg_wll_LogEventProxy for event CREAMStore, result START
 *
 * \param[in,out] context	context to work with, 
 * \param[in] cmdid	Id of the command in store
 * \param[in] reason	failure_reason
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogCREAMStoreSTARTProxy(edg_wll_Context context, const char * cmdid, const char * reason);

/**
 * \brief edg_wll_LogCREAMStoreSTARTFile
 *
 * edg_wll_LogCREAMStoreSTARTFile - simple wrapper around edg_wll_LogEventFile for event CREAMStore, result START
 *
 * \param[in,out] context	context to work with, 
 * \param[in] cmdid	Id of the command in store
 * \param[in] reason	failure_reason
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogCREAMStoreSTARTFile(edg_wll_Context context, const char * cmdid, const char * reason);

/**
 * \brief edg_wll_LogCREAMStoreOK
 *
 * edg_wll_LogCREAMStoreOK - simple wrapper around edg_wll_LogEvent for event CREAMStore, result OK
 *
 * \param[in,out] context	context to work with, 
 * \param[in] cmdid	Id of the command in store
 * \param[in] reason	failure_reason
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogCREAMStoreOK(edg_wll_Context context, const char * cmdid, const char * reason);

/**
 * \brief edg_wll_LogCREAMStoreOKProxy
 *
 * edg_wll_LogCREAMStoreOKProxy - simple wrapper around edg_wll_LogEventProxy for event CREAMStore, result OK
 *
 * \param[in,out] context	context to work with, 
 * \param[in] cmdid	Id of the command in store
 * \param[in] reason	failure_reason
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogCREAMStoreOKProxy(edg_wll_Context context, const char * cmdid, const char * reason);

/**
 * \brief edg_wll_LogCREAMStoreOKFile
 *
 * edg_wll_LogCREAMStoreOKFile - simple wrapper around edg_wll_LogEventFile for event CREAMStore, result OK
 *
 * \param[in,out] context	context to work with, 
 * \param[in] cmdid	Id of the command in store
 * \param[in] reason	failure_reason
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogCREAMStoreOKFile(edg_wll_Context context, const char * cmdid, const char * reason);

/**
 * \brief edg_wll_LogCREAMStoreFAILED
 *
 * edg_wll_LogCREAMStoreFAILED - simple wrapper around edg_wll_LogEvent for event CREAMStore, result FAILED
 *
 * \param[in,out] context	context to work with, 
 * \param[in] cmdid	Id of the command in store
 * \param[in] reason	failure_reason
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogCREAMStoreFAILED(edg_wll_Context context, const char * cmdid, const char * reason);

/**
 * \brief edg_wll_LogCREAMStoreFAILEDProxy
 *
 * edg_wll_LogCREAMStoreFAILEDProxy - simple wrapper around edg_wll_LogEventProxy for event CREAMStore, result FAILED
 *
 * \param[in,out] context	context to work with, 
 * \param[in] cmdid	Id of the command in store
 * \param[in] reason	failure_reason
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogCREAMStoreFAILEDProxy(edg_wll_Context context, const char * cmdid, const char * reason);

/**
 * \brief edg_wll_LogCREAMStoreFAILEDFile
 *
 * edg_wll_LogCREAMStoreFAILEDFile - simple wrapper around edg_wll_LogEventFile for event CREAMStore, result FAILED
 *
 * \param[in,out] context	context to work with, 
 * \param[in] cmdid	Id of the command in store
 * \param[in] reason	failure_reason
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogCREAMStoreFAILEDFile(edg_wll_Context context, const char * cmdid, const char * reason);

/**
 * \brief edg_wll_LogCREAMCall
 *
 * edg_wll_LogCREAMCall - simple wrapper around edg_wll_LogEvent for event CREAMCall
 *
 * \param[in,out] context	context to work with, 
 * \param[in] command	Command to store
 * \param[in] callee	Called component
 * \param[in] cmdid	Id of the command, as stored previously
 * \param[in] destid	Destination ID
 * \param[in] result	Result code of the CREAM call (START, OK, REFUSED or FAIL)
 * \param[in] reason	Reason for the possible CREAM call failure
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogCREAMCall(edg_wll_Context context, const char * command, const edg_wll_Source callee, const char * cmdid, const char * destid, const char * result, const char * reason);

/**
 * \brief edg_wll_LogCREAMCallProxy
 *
 * edg_wll_LogCREAMCallProxy - simple wrapper around edg_wll_LogEventProxy for event CREAMCall
 *
 * \param[in,out] context	context to work with, 
 * \param[in] command	Command to store
 * \param[in] callee	Called component
 * \param[in] cmdid	Id of the command, as stored previously
 * \param[in] destid	Destination ID
 * \param[in] result	Result code of the CREAM call (START, OK, REFUSED or FAIL)
 * \param[in] reason	Reason for the possible CREAM call failure
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogCREAMCallProxy(edg_wll_Context context, const char * command, const edg_wll_Source callee, const char * cmdid, const char * destid, const char * result, const char * reason);

/**
 * \brief edg_wll_LogCREAMCallFile
 *
 * edg_wll_LogCREAMCallFile - simple wrapper around edg_wll_LogEventFile for event CREAMCall
 *
 * \param[in,out] context	context to work with, 
 * \param[in] command	Command to store
 * \param[in] callee	Called component
 * \param[in] cmdid	Id of the command, as stored previously
 * \param[in] destid	Destination ID
 * \param[in] result	Result code of the CREAM call (START, OK, REFUSED or FAIL)
 * \param[in] reason	Reason for the possible CREAM call failure
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogCREAMCallFile(edg_wll_Context context, const char * command, const edg_wll_Source callee, const char * cmdid, const char * destid, const char * result, const char * reason);

/**
 * \brief edg_wll_LogCREAMCallCMDSTART
 *
 * edg_wll_LogCREAMCallCMDSTART - simple wrapper around edg_wll_LogEvent for event CREAMCall, command CMDSTART
 *
 * \param[in,out] context	context to work with, 
 * \param[in] callee	Called component
 * \param[in] cmdid	Id of the command, as stored previously
 * \param[in] destid	Destination ID
 * \param[in] reason	Reason for the possible CREAM call failure
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogCREAMCallCMDSTART(edg_wll_Context context, const edg_wll_Source callee, const char * cmdid, const char * destid, const char * reason);

/**
 * \brief edg_wll_LogCREAMCallCMDSTARTProxy
 *
 * edg_wll_LogCREAMCallCMDSTARTProxy - simple wrapper around edg_wll_LogEventProxy for event CREAMCall, command CMDSTART
 *
 * \param[in,out] context	context to work with, 
 * \param[in] callee	Called component
 * \param[in] cmdid	Id of the command, as stored previously
 * \param[in] destid	Destination ID
 * \param[in] reason	Reason for the possible CREAM call failure
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogCREAMCallCMDSTARTProxy(edg_wll_Context context, const edg_wll_Source callee, const char * cmdid, const char * destid, const char * reason);

/**
 * \brief edg_wll_LogCREAMCallCMDSTARTFile
 *
 * edg_wll_LogCREAMCallCMDSTARTFile - simple wrapper around edg_wll_LogEventFile for event CREAMCall, command CMDSTART
 *
 * \param[in,out] context	context to work with, 
 * \param[in] callee	Called component
 * \param[in] cmdid	Id of the command, as stored previously
 * \param[in] destid	Destination ID
 * \param[in] reason	Reason for the possible CREAM call failure
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogCREAMCallCMDSTARTFile(edg_wll_Context context, const edg_wll_Source callee, const char * cmdid, const char * destid, const char * reason);

/**
 * \brief edg_wll_LogCREAMCallCMDCANCEL
 *
 * edg_wll_LogCREAMCallCMDCANCEL - simple wrapper around edg_wll_LogEvent for event CREAMCall, command CMDCANCEL
 *
 * \param[in,out] context	context to work with, 
 * \param[in] callee	Called component
 * \param[in] cmdid	Id of the command, as stored previously
 * \param[in] destid	Destination ID
 * \param[in] reason	Reason for the possible CREAM call failure
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogCREAMCallCMDCANCEL(edg_wll_Context context, const edg_wll_Source callee, const char * cmdid, const char * destid, const char * reason);

/**
 * \brief edg_wll_LogCREAMCallCMDCANCELProxy
 *
 * edg_wll_LogCREAMCallCMDCANCELProxy - simple wrapper around edg_wll_LogEventProxy for event CREAMCall, command CMDCANCEL
 *
 * \param[in,out] context	context to work with, 
 * \param[in] callee	Called component
 * \param[in] cmdid	Id of the command, as stored previously
 * \param[in] destid	Destination ID
 * \param[in] reason	Reason for the possible CREAM call failure
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogCREAMCallCMDCANCELProxy(edg_wll_Context context, const edg_wll_Source callee, const char * cmdid, const char * destid, const char * reason);

/**
 * \brief edg_wll_LogCREAMCallCMDCANCELFile
 *
 * edg_wll_LogCREAMCallCMDCANCELFile - simple wrapper around edg_wll_LogEventFile for event CREAMCall, command CMDCANCEL
 *
 * \param[in,out] context	context to work with, 
 * \param[in] callee	Called component
 * \param[in] cmdid	Id of the command, as stored previously
 * \param[in] destid	Destination ID
 * \param[in] reason	Reason for the possible CREAM call failure
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogCREAMCallCMDCANCELFile(edg_wll_Context context, const edg_wll_Source callee, const char * cmdid, const char * destid, const char * reason);

/**
 * \brief edg_wll_LogCREAMCallCMDPURGE
 *
 * edg_wll_LogCREAMCallCMDPURGE - simple wrapper around edg_wll_LogEvent for event CREAMCall, command CMDPURGE
 *
 * \param[in,out] context	context to work with, 
 * \param[in] callee	Called component
 * \param[in] cmdid	Id of the command, as stored previously
 * \param[in] destid	Destination ID
 * \param[in] reason	Reason for the possible CREAM call failure
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogCREAMCallCMDPURGE(edg_wll_Context context, const edg_wll_Source callee, const char * cmdid, const char * destid, const char * reason);

/**
 * \brief edg_wll_LogCREAMCallCMDPURGEProxy
 *
 * edg_wll_LogCREAMCallCMDPURGEProxy - simple wrapper around edg_wll_LogEventProxy for event CREAMCall, command CMDPURGE
 *
 * \param[in,out] context	context to work with, 
 * \param[in] callee	Called component
 * \param[in] cmdid	Id of the command, as stored previously
 * \param[in] destid	Destination ID
 * \param[in] reason	Reason for the possible CREAM call failure
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogCREAMCallCMDPURGEProxy(edg_wll_Context context, const edg_wll_Source callee, const char * cmdid, const char * destid, const char * reason);

/**
 * \brief edg_wll_LogCREAMCallCMDPURGEFile
 *
 * edg_wll_LogCREAMCallCMDPURGEFile - simple wrapper around edg_wll_LogEventFile for event CREAMCall, command CMDPURGE
 *
 * \param[in,out] context	context to work with, 
 * \param[in] callee	Called component
 * \param[in] cmdid	Id of the command, as stored previously
 * \param[in] destid	Destination ID
 * \param[in] reason	Reason for the possible CREAM call failure
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogCREAMCallCMDPURGEFile(edg_wll_Context context, const edg_wll_Source callee, const char * cmdid, const char * destid, const char * reason);

/**
 * \brief edg_wll_LogCREAMCallCMDSUSPEND
 *
 * edg_wll_LogCREAMCallCMDSUSPEND - simple wrapper around edg_wll_LogEvent for event CREAMCall, command CMDSUSPEND
 *
 * \param[in,out] context	context to work with, 
 * \param[in] callee	Called component
 * \param[in] cmdid	Id of the command, as stored previously
 * \param[in] destid	Destination ID
 * \param[in] reason	Reason for the possible CREAM call failure
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogCREAMCallCMDSUSPEND(edg_wll_Context context, const edg_wll_Source callee, const char * cmdid, const char * destid, const char * reason);

/**
 * \brief edg_wll_LogCREAMCallCMDSUSPENDProxy
 *
 * edg_wll_LogCREAMCallCMDSUSPENDProxy - simple wrapper around edg_wll_LogEventProxy for event CREAMCall, command CMDSUSPEND
 *
 * \param[in,out] context	context to work with, 
 * \param[in] callee	Called component
 * \param[in] cmdid	Id of the command, as stored previously
 * \param[in] destid	Destination ID
 * \param[in] reason	Reason for the possible CREAM call failure
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogCREAMCallCMDSUSPENDProxy(edg_wll_Context context, const edg_wll_Source callee, const char * cmdid, const char * destid, const char * reason);

/**
 * \brief edg_wll_LogCREAMCallCMDSUSPENDFile
 *
 * edg_wll_LogCREAMCallCMDSUSPENDFile - simple wrapper around edg_wll_LogEventFile for event CREAMCall, command CMDSUSPEND
 *
 * \param[in,out] context	context to work with, 
 * \param[in] callee	Called component
 * \param[in] cmdid	Id of the command, as stored previously
 * \param[in] destid	Destination ID
 * \param[in] reason	Reason for the possible CREAM call failure
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogCREAMCallCMDSUSPENDFile(edg_wll_Context context, const edg_wll_Source callee, const char * cmdid, const char * destid, const char * reason);

/**
 * \brief edg_wll_LogCREAMCallCMDRESUME
 *
 * edg_wll_LogCREAMCallCMDRESUME - simple wrapper around edg_wll_LogEvent for event CREAMCall, command CMDRESUME
 *
 * \param[in,out] context	context to work with, 
 * \param[in] callee	Called component
 * \param[in] cmdid	Id of the command, as stored previously
 * \param[in] destid	Destination ID
 * \param[in] reason	Reason for the possible CREAM call failure
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogCREAMCallCMDRESUME(edg_wll_Context context, const edg_wll_Source callee, const char * cmdid, const char * destid, const char * reason);

/**
 * \brief edg_wll_LogCREAMCallCMDRESUMEProxy
 *
 * edg_wll_LogCREAMCallCMDRESUMEProxy - simple wrapper around edg_wll_LogEventProxy for event CREAMCall, command CMDRESUME
 *
 * \param[in,out] context	context to work with, 
 * \param[in] callee	Called component
 * \param[in] cmdid	Id of the command, as stored previously
 * \param[in] destid	Destination ID
 * \param[in] reason	Reason for the possible CREAM call failure
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogCREAMCallCMDRESUMEProxy(edg_wll_Context context, const edg_wll_Source callee, const char * cmdid, const char * destid, const char * reason);

/**
 * \brief edg_wll_LogCREAMCallCMDRESUMEFile
 *
 * edg_wll_LogCREAMCallCMDRESUMEFile - simple wrapper around edg_wll_LogEventFile for event CREAMCall, command CMDRESUME
 *
 * \param[in,out] context	context to work with, 
 * \param[in] callee	Called component
 * \param[in] cmdid	Id of the command, as stored previously
 * \param[in] destid	Destination ID
 * \param[in] reason	Reason for the possible CREAM call failure
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogCREAMCallCMDRESUMEFile(edg_wll_Context context, const edg_wll_Source callee, const char * cmdid, const char * destid, const char * reason);

/**
 * \brief edg_wll_LogCREAMCallSTART
 *
 * edg_wll_LogCREAMCallSTART - simple wrapper around edg_wll_LogEvent for event CREAMCall, result START
 *
 * \param[in,out] context	context to work with, 
 * \param[in] callee	Called component
 * \param[in] cmdid	Id of the command, as stored previously
 * \param[in] destid	Destination ID
 * \param[in] reason	Reason for the possible CREAM call failure
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogCREAMCallSTART(edg_wll_Context context, const edg_wll_Source callee, const char * cmdid, const char * destid, const char * reason);

/**
 * \brief edg_wll_LogCREAMCallSTARTProxy
 *
 * edg_wll_LogCREAMCallSTARTProxy - simple wrapper around edg_wll_LogEventProxy for event CREAMCall, result START
 *
 * \param[in,out] context	context to work with, 
 * \param[in] callee	Called component
 * \param[in] cmdid	Id of the command, as stored previously
 * \param[in] destid	Destination ID
 * \param[in] reason	Reason for the possible CREAM call failure
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogCREAMCallSTARTProxy(edg_wll_Context context, const edg_wll_Source callee, const char * cmdid, const char * destid, const char * reason);

/**
 * \brief edg_wll_LogCREAMCallSTARTFile
 *
 * edg_wll_LogCREAMCallSTARTFile - simple wrapper around edg_wll_LogEventFile for event CREAMCall, result START
 *
 * \param[in,out] context	context to work with, 
 * \param[in] callee	Called component
 * \param[in] cmdid	Id of the command, as stored previously
 * \param[in] destid	Destination ID
 * \param[in] reason	Reason for the possible CREAM call failure
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogCREAMCallSTARTFile(edg_wll_Context context, const edg_wll_Source callee, const char * cmdid, const char * destid, const char * reason);

/**
 * \brief edg_wll_LogCREAMCallOK
 *
 * edg_wll_LogCREAMCallOK - simple wrapper around edg_wll_LogEvent for event CREAMCall, result OK
 *
 * \param[in,out] context	context to work with, 
 * \param[in] callee	Called component
 * \param[in] cmdid	Id of the command, as stored previously
 * \param[in] destid	Destination ID
 * \param[in] reason	Reason for the possible CREAM call failure
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogCREAMCallOK(edg_wll_Context context, const edg_wll_Source callee, const char * cmdid, const char * destid, const char * reason);

/**
 * \brief edg_wll_LogCREAMCallOKProxy
 *
 * edg_wll_LogCREAMCallOKProxy - simple wrapper around edg_wll_LogEventProxy for event CREAMCall, result OK
 *
 * \param[in,out] context	context to work with, 
 * \param[in] callee	Called component
 * \param[in] cmdid	Id of the command, as stored previously
 * \param[in] destid	Destination ID
 * \param[in] reason	Reason for the possible CREAM call failure
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogCREAMCallOKProxy(edg_wll_Context context, const edg_wll_Source callee, const char * cmdid, const char * destid, const char * reason);

/**
 * \brief edg_wll_LogCREAMCallOKFile
 *
 * edg_wll_LogCREAMCallOKFile - simple wrapper around edg_wll_LogEventFile for event CREAMCall, result OK
 *
 * \param[in,out] context	context to work with, 
 * \param[in] callee	Called component
 * \param[in] cmdid	Id of the command, as stored previously
 * \param[in] destid	Destination ID
 * \param[in] reason	Reason for the possible CREAM call failure
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogCREAMCallOKFile(edg_wll_Context context, const edg_wll_Source callee, const char * cmdid, const char * destid, const char * reason);

/**
 * \brief edg_wll_LogCREAMCallFAILED
 *
 * edg_wll_LogCREAMCallFAILED - simple wrapper around edg_wll_LogEvent for event CREAMCall, result FAILED
 *
 * \param[in,out] context	context to work with, 
 * \param[in] callee	Called component
 * \param[in] cmdid	Id of the command, as stored previously
 * \param[in] destid	Destination ID
 * \param[in] reason	Reason for the possible CREAM call failure
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogCREAMCallFAILED(edg_wll_Context context, const edg_wll_Source callee, const char * cmdid, const char * destid, const char * reason);

/**
 * \brief edg_wll_LogCREAMCallFAILEDProxy
 *
 * edg_wll_LogCREAMCallFAILEDProxy - simple wrapper around edg_wll_LogEventProxy for event CREAMCall, result FAILED
 *
 * \param[in,out] context	context to work with, 
 * \param[in] callee	Called component
 * \param[in] cmdid	Id of the command, as stored previously
 * \param[in] destid	Destination ID
 * \param[in] reason	Reason for the possible CREAM call failure
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogCREAMCallFAILEDProxy(edg_wll_Context context, const edg_wll_Source callee, const char * cmdid, const char * destid, const char * reason);

/**
 * \brief edg_wll_LogCREAMCallFAILEDFile
 *
 * edg_wll_LogCREAMCallFAILEDFile - simple wrapper around edg_wll_LogEventFile for event CREAMCall, result FAILED
 *
 * \param[in,out] context	context to work with, 
 * \param[in] callee	Called component
 * \param[in] cmdid	Id of the command, as stored previously
 * \param[in] destid	Destination ID
 * \param[in] reason	Reason for the possible CREAM call failure
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogCREAMCallFAILEDFile(edg_wll_Context context, const edg_wll_Source callee, const char * cmdid, const char * destid, const char * reason);

/**
 * \brief edg_wll_LogCREAMRunning
 *
 * edg_wll_LogCREAMRunning - simple wrapper around edg_wll_LogEvent for event CREAMRunning
 *
 * \param[in,out] context	context to work with, 
 * \param[in] node	Node where CREAM job is running
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogCREAMRunning(edg_wll_Context context, const char * node);

/**
 * \brief edg_wll_LogCREAMRunningProxy
 *
 * edg_wll_LogCREAMRunningProxy - simple wrapper around edg_wll_LogEventProxy for event CREAMRunning
 *
 * \param[in,out] context	context to work with, 
 * \param[in] node	Node where CREAM job is running
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogCREAMRunningProxy(edg_wll_Context context, const char * node);

/**
 * \brief edg_wll_LogCREAMRunningFile
 *
 * edg_wll_LogCREAMRunningFile - simple wrapper around edg_wll_LogEventFile for event CREAMRunning
 *
 * \param[in,out] context	context to work with, 
 * \param[in] node	Node where CREAM job is running
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogCREAMRunningFile(edg_wll_Context context, const char * node);

/**
 * \brief edg_wll_LogCREAMReallyRunning
 *
 * edg_wll_LogCREAMReallyRunning - simple wrapper around edg_wll_LogEvent for event CREAMReallyRunning
 *
 * \param[in,out] context	context to work with, 
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogCREAMReallyRunning(edg_wll_Context context);

/**
 * \brief edg_wll_LogCREAMReallyRunningProxy
 *
 * edg_wll_LogCREAMReallyRunningProxy - simple wrapper around edg_wll_LogEventProxy for event CREAMReallyRunning
 *
 * \param[in,out] context	context to work with, 
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogCREAMReallyRunningProxy(edg_wll_Context context);

/**
 * \brief edg_wll_LogCREAMReallyRunningFile
 *
 * edg_wll_LogCREAMReallyRunningFile - simple wrapper around edg_wll_LogEventFile for event CREAMReallyRunning
 *
 * \param[in,out] context	context to work with, 
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogCREAMReallyRunningFile(edg_wll_Context context);

/**
 * \brief edg_wll_LogCREAMDone
 *
 * edg_wll_LogCREAMDone - simple wrapper around edg_wll_LogEvent for event CREAMDone
 *
 * \param[in,out] context	context to work with, 
 * \param[in] status_code	Status code of the CREAM Done
 * \param[in] reason	Reason for the status
 * \param[in] exit_code	Exit code
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogCREAMDone(edg_wll_Context context, const char * status_code, const char * reason, const char * exit_code);

/**
 * \brief edg_wll_LogCREAMDoneProxy
 *
 * edg_wll_LogCREAMDoneProxy - simple wrapper around edg_wll_LogEventProxy for event CREAMDone
 *
 * \param[in,out] context	context to work with, 
 * \param[in] status_code	Status code of the CREAM Done
 * \param[in] reason	Reason for the status
 * \param[in] exit_code	Exit code
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogCREAMDoneProxy(edg_wll_Context context, const char * status_code, const char * reason, const char * exit_code);

/**
 * \brief edg_wll_LogCREAMDoneFile
 *
 * edg_wll_LogCREAMDoneFile - simple wrapper around edg_wll_LogEventFile for event CREAMDone
 *
 * \param[in,out] context	context to work with, 
 * \param[in] status_code	Status code of the CREAM Done
 * \param[in] reason	Reason for the status
 * \param[in] exit_code	Exit code
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogCREAMDoneFile(edg_wll_Context context, const char * status_code, const char * reason, const char * exit_code);

/**
 * \brief edg_wll_LogCREAMDoneOK
 *
 * edg_wll_LogCREAMDoneOK - simple wrapper around edg_wll_LogEvent for event CREAMDone, status_code OK
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason for the status
 * \param[in] exit_code	Exit code
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogCREAMDoneOK(edg_wll_Context context, const char * reason, const char * exit_code);

/**
 * \brief edg_wll_LogCREAMDoneOKProxy
 *
 * edg_wll_LogCREAMDoneOKProxy - simple wrapper around edg_wll_LogEventProxy for event CREAMDone, status_code OK
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason for the status
 * \param[in] exit_code	Exit code
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogCREAMDoneOKProxy(edg_wll_Context context, const char * reason, const char * exit_code);

/**
 * \brief edg_wll_LogCREAMDoneOKFile
 *
 * edg_wll_LogCREAMDoneOKFile - simple wrapper around edg_wll_LogEventFile for event CREAMDone, status_code OK
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason for the status
 * \param[in] exit_code	Exit code
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogCREAMDoneOKFile(edg_wll_Context context, const char * reason, const char * exit_code);

/**
 * \brief edg_wll_LogCREAMDoneFAILED
 *
 * edg_wll_LogCREAMDoneFAILED - simple wrapper around edg_wll_LogEvent for event CREAMDone, status_code FAILED
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason for the status
 * \param[in] exit_code	Exit code
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogCREAMDoneFAILED(edg_wll_Context context, const char * reason, const char * exit_code);

/**
 * \brief edg_wll_LogCREAMDoneFAILEDProxy
 *
 * edg_wll_LogCREAMDoneFAILEDProxy - simple wrapper around edg_wll_LogEventProxy for event CREAMDone, status_code FAILED
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason for the status
 * \param[in] exit_code	Exit code
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogCREAMDoneFAILEDProxy(edg_wll_Context context, const char * reason, const char * exit_code);

/**
 * \brief edg_wll_LogCREAMDoneFAILEDFile
 *
 * edg_wll_LogCREAMDoneFAILEDFile - simple wrapper around edg_wll_LogEventFile for event CREAMDone, status_code FAILED
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason for the status
 * \param[in] exit_code	Exit code
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogCREAMDoneFAILEDFile(edg_wll_Context context, const char * reason, const char * exit_code);

/**
 * \brief edg_wll_LogCREAMDoneCANCELLED
 *
 * edg_wll_LogCREAMDoneCANCELLED - simple wrapper around edg_wll_LogEvent for event CREAMDone, status_code CANCELLED
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason for the status
 * \param[in] exit_code	Exit code
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogCREAMDoneCANCELLED(edg_wll_Context context, const char * reason, const char * exit_code);

/**
 * \brief edg_wll_LogCREAMDoneCANCELLEDProxy
 *
 * edg_wll_LogCREAMDoneCANCELLEDProxy - simple wrapper around edg_wll_LogEventProxy for event CREAMDone, status_code CANCELLED
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason for the status
 * \param[in] exit_code	Exit code
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogCREAMDoneCANCELLEDProxy(edg_wll_Context context, const char * reason, const char * exit_code);

/**
 * \brief edg_wll_LogCREAMDoneCANCELLEDFile
 *
 * edg_wll_LogCREAMDoneCANCELLEDFile - simple wrapper around edg_wll_LogEventFile for event CREAMDone, status_code CANCELLED
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason for the status
 * \param[in] exit_code	Exit code
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogCREAMDoneCANCELLEDFile(edg_wll_Context context, const char * reason, const char * exit_code);

/**
 * \brief edg_wll_LogCREAMDoneKILLED
 *
 * edg_wll_LogCREAMDoneKILLED - simple wrapper around edg_wll_LogEvent for event CREAMDone, status_code KILLED
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason for the status
 * \param[in] exit_code	Exit code
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogCREAMDoneKILLED(edg_wll_Context context, const char * reason, const char * exit_code);

/**
 * \brief edg_wll_LogCREAMDoneKILLEDProxy
 *
 * edg_wll_LogCREAMDoneKILLEDProxy - simple wrapper around edg_wll_LogEventProxy for event CREAMDone, status_code KILLED
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason for the status
 * \param[in] exit_code	Exit code
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogCREAMDoneKILLEDProxy(edg_wll_Context context, const char * reason, const char * exit_code);

/**
 * \brief edg_wll_LogCREAMDoneKILLEDFile
 *
 * edg_wll_LogCREAMDoneKILLEDFile - simple wrapper around edg_wll_LogEventFile for event CREAMDone, status_code KILLED
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason for the status
 * \param[in] exit_code	Exit code
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogCREAMDoneKILLEDFile(edg_wll_Context context, const char * reason, const char * exit_code);

/**
 * \brief edg_wll_LogCREAMCancel
 *
 * edg_wll_LogCREAMCancel - simple wrapper around edg_wll_LogEvent for event CREAMCancel
 *
 * \param[in,out] context	context to work with, 
 * \param[in] status_code	Status code of CREAM Cancel
 * \param[in] reason	Reason for cancelling the job
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogCREAMCancel(edg_wll_Context context, const char * status_code, const char * reason);

/**
 * \brief edg_wll_LogCREAMCancelProxy
 *
 * edg_wll_LogCREAMCancelProxy - simple wrapper around edg_wll_LogEventProxy for event CREAMCancel
 *
 * \param[in,out] context	context to work with, 
 * \param[in] status_code	Status code of CREAM Cancel
 * \param[in] reason	Reason for cancelling the job
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogCREAMCancelProxy(edg_wll_Context context, const char * status_code, const char * reason);

/**
 * \brief edg_wll_LogCREAMCancelFile
 *
 * edg_wll_LogCREAMCancelFile - simple wrapper around edg_wll_LogEventFile for event CREAMCancel
 *
 * \param[in,out] context	context to work with, 
 * \param[in] status_code	Status code of CREAM Cancel
 * \param[in] reason	Reason for cancelling the job
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogCREAMCancelFile(edg_wll_Context context, const char * status_code, const char * reason);

/**
 * \brief edg_wll_LogCREAMCancelREQ
 *
 * edg_wll_LogCREAMCancelREQ - simple wrapper around edg_wll_LogEvent for event CREAMCancel, status_code REQ
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason for cancelling the job
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogCREAMCancelREQ(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogCREAMCancelREQProxy
 *
 * edg_wll_LogCREAMCancelREQProxy - simple wrapper around edg_wll_LogEventProxy for event CREAMCancel, status_code REQ
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason for cancelling the job
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogCREAMCancelREQProxy(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogCREAMCancelREQFile
 *
 * edg_wll_LogCREAMCancelREQFile - simple wrapper around edg_wll_LogEventFile for event CREAMCancel, status_code REQ
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason for cancelling the job
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogCREAMCancelREQFile(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogCREAMCancelREFUSE
 *
 * edg_wll_LogCREAMCancelREFUSE - simple wrapper around edg_wll_LogEvent for event CREAMCancel, status_code REFUSE
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason for cancelling the job
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogCREAMCancelREFUSE(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogCREAMCancelREFUSEProxy
 *
 * edg_wll_LogCREAMCancelREFUSEProxy - simple wrapper around edg_wll_LogEventProxy for event CREAMCancel, status_code REFUSE
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason for cancelling the job
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogCREAMCancelREFUSEProxy(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogCREAMCancelREFUSEFile
 *
 * edg_wll_LogCREAMCancelREFUSEFile - simple wrapper around edg_wll_LogEventFile for event CREAMCancel, status_code REFUSE
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason for cancelling the job
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogCREAMCancelREFUSEFile(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogCREAMCancelDONE
 *
 * edg_wll_LogCREAMCancelDONE - simple wrapper around edg_wll_LogEvent for event CREAMCancel, status_code DONE
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason for cancelling the job
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogCREAMCancelDONE(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogCREAMCancelDONEProxy
 *
 * edg_wll_LogCREAMCancelDONEProxy - simple wrapper around edg_wll_LogEventProxy for event CREAMCancel, status_code DONE
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason for cancelling the job
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogCREAMCancelDONEProxy(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogCREAMCancelDONEFile
 *
 * edg_wll_LogCREAMCancelDONEFile - simple wrapper around edg_wll_LogEventFile for event CREAMCancel, status_code DONE
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason for cancelling the job
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogCREAMCancelDONEFile(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogCREAMCancelABORT
 *
 * edg_wll_LogCREAMCancelABORT - simple wrapper around edg_wll_LogEvent for event CREAMCancel, status_code ABORT
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason for cancelling the job
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogCREAMCancelABORT(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogCREAMCancelABORTProxy
 *
 * edg_wll_LogCREAMCancelABORTProxy - simple wrapper around edg_wll_LogEventProxy for event CREAMCancel, status_code ABORT
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason for cancelling the job
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogCREAMCancelABORTProxy(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogCREAMCancelABORTFile
 *
 * edg_wll_LogCREAMCancelABORTFile - simple wrapper around edg_wll_LogEventFile for event CREAMCancel, status_code ABORT
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason for cancelling the job
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogCREAMCancelABORTFile(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogCREAMAbort
 *
 * edg_wll_LogCREAMAbort - simple wrapper around edg_wll_LogEvent for event CREAMAbort
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason for aborting the job
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogCREAMAbort(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogCREAMAbortProxy
 *
 * edg_wll_LogCREAMAbortProxy - simple wrapper around edg_wll_LogEventProxy for event CREAMAbort
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason for aborting the job
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogCREAMAbortProxy(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogCREAMAbortFile
 *
 * edg_wll_LogCREAMAbortFile - simple wrapper around edg_wll_LogEventFile for event CREAMAbort
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason for aborting the job
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogCREAMAbortFile(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogCREAMStatus
 *
 * edg_wll_LogCREAMStatus - simple wrapper around edg_wll_LogEvent for event CREAMStatus
 *
 * \param[in,out] context	context to work with, 
 * \param[in] old_state	Old status
 * \param[in] new_state	New status
 * \param[in] orig_timestamp	Original timestamp of the job state change
 * \param[in] result	Result of the job state change
 * \param[in] descr	More detailed description
 * \param[in] exit_code	Exit code
 * \param[in] failure_reason	Reason for the failure
 * \param[in] worker_node	Worker node
 * \param[in] LRMS_jobid	jobId from the LRMS
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogCREAMStatus(edg_wll_Context context, const char * old_state, const char * new_state, const struct timeval orig_timestamp, const char * result, const char * descr, const char * exit_code, const char * failure_reason, const char * worker_node, const char * LRMS_jobid);

/**
 * \brief edg_wll_LogCREAMStatusProxy
 *
 * edg_wll_LogCREAMStatusProxy - simple wrapper around edg_wll_LogEventProxy for event CREAMStatus
 *
 * \param[in,out] context	context to work with, 
 * \param[in] old_state	Old status
 * \param[in] new_state	New status
 * \param[in] orig_timestamp	Original timestamp of the job state change
 * \param[in] result	Result of the job state change
 * \param[in] descr	More detailed description
 * \param[in] exit_code	Exit code
 * \param[in] failure_reason	Reason for the failure
 * \param[in] worker_node	Worker node
 * \param[in] LRMS_jobid	jobId from the LRMS
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogCREAMStatusProxy(edg_wll_Context context, const char * old_state, const char * new_state, const struct timeval orig_timestamp, const char * result, const char * descr, const char * exit_code, const char * failure_reason, const char * worker_node, const char * LRMS_jobid);

/**
 * \brief edg_wll_LogCREAMStatusFile
 *
 * edg_wll_LogCREAMStatusFile - simple wrapper around edg_wll_LogEventFile for event CREAMStatus
 *
 * \param[in,out] context	context to work with, 
 * \param[in] old_state	Old status
 * \param[in] new_state	New status
 * \param[in] orig_timestamp	Original timestamp of the job state change
 * \param[in] result	Result of the job state change
 * \param[in] descr	More detailed description
 * \param[in] exit_code	Exit code
 * \param[in] failure_reason	Reason for the failure
 * \param[in] worker_node	Worker node
 * \param[in] LRMS_jobid	jobId from the LRMS
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogCREAMStatusFile(edg_wll_Context context, const char * old_state, const char * new_state, const struct timeval orig_timestamp, const char * result, const char * descr, const char * exit_code, const char * failure_reason, const char * worker_node, const char * LRMS_jobid);

/**
 * \brief edg_wll_LogCREAMStatusARRIVED
 *
 * edg_wll_LogCREAMStatusARRIVED - simple wrapper around edg_wll_LogEvent for event CREAMStatus, result ARRIVED
 *
 * \param[in,out] context	context to work with, 
 * \param[in] old_state	Old status
 * \param[in] new_state	New status
 * \param[in] orig_timestamp	Original timestamp of the job state change
 * \param[in] descr	More detailed description
 * \param[in] exit_code	Exit code
 * \param[in] failure_reason	Reason for the failure
 * \param[in] worker_node	Worker node
 * \param[in] LRMS_jobid	jobId from the LRMS
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogCREAMStatusARRIVED(edg_wll_Context context, const char * old_state, const char * new_state, const struct timeval orig_timestamp, const char * descr, const char * exit_code, const char * failure_reason, const char * worker_node, const char * LRMS_jobid);

/**
 * \brief edg_wll_LogCREAMStatusARRIVEDProxy
 *
 * edg_wll_LogCREAMStatusARRIVEDProxy - simple wrapper around edg_wll_LogEventProxy for event CREAMStatus, result ARRIVED
 *
 * \param[in,out] context	context to work with, 
 * \param[in] old_state	Old status
 * \param[in] new_state	New status
 * \param[in] orig_timestamp	Original timestamp of the job state change
 * \param[in] descr	More detailed description
 * \param[in] exit_code	Exit code
 * \param[in] failure_reason	Reason for the failure
 * \param[in] worker_node	Worker node
 * \param[in] LRMS_jobid	jobId from the LRMS
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogCREAMStatusARRIVEDProxy(edg_wll_Context context, const char * old_state, const char * new_state, const struct timeval orig_timestamp, const char * descr, const char * exit_code, const char * failure_reason, const char * worker_node, const char * LRMS_jobid);

/**
 * \brief edg_wll_LogCREAMStatusARRIVEDFile
 *
 * edg_wll_LogCREAMStatusARRIVEDFile - simple wrapper around edg_wll_LogEventFile for event CREAMStatus, result ARRIVED
 *
 * \param[in,out] context	context to work with, 
 * \param[in] old_state	Old status
 * \param[in] new_state	New status
 * \param[in] orig_timestamp	Original timestamp of the job state change
 * \param[in] descr	More detailed description
 * \param[in] exit_code	Exit code
 * \param[in] failure_reason	Reason for the failure
 * \param[in] worker_node	Worker node
 * \param[in] LRMS_jobid	jobId from the LRMS
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogCREAMStatusARRIVEDFile(edg_wll_Context context, const char * old_state, const char * new_state, const struct timeval orig_timestamp, const char * descr, const char * exit_code, const char * failure_reason, const char * worker_node, const char * LRMS_jobid);

/**
 * \brief edg_wll_LogCREAMStatusDONE
 *
 * edg_wll_LogCREAMStatusDONE - simple wrapper around edg_wll_LogEvent for event CREAMStatus, result DONE
 *
 * \param[in,out] context	context to work with, 
 * \param[in] old_state	Old status
 * \param[in] new_state	New status
 * \param[in] orig_timestamp	Original timestamp of the job state change
 * \param[in] descr	More detailed description
 * \param[in] exit_code	Exit code
 * \param[in] failure_reason	Reason for the failure
 * \param[in] worker_node	Worker node
 * \param[in] LRMS_jobid	jobId from the LRMS
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogCREAMStatusDONE(edg_wll_Context context, const char * old_state, const char * new_state, const struct timeval orig_timestamp, const char * descr, const char * exit_code, const char * failure_reason, const char * worker_node, const char * LRMS_jobid);

/**
 * \brief edg_wll_LogCREAMStatusDONEProxy
 *
 * edg_wll_LogCREAMStatusDONEProxy - simple wrapper around edg_wll_LogEventProxy for event CREAMStatus, result DONE
 *
 * \param[in,out] context	context to work with, 
 * \param[in] old_state	Old status
 * \param[in] new_state	New status
 * \param[in] orig_timestamp	Original timestamp of the job state change
 * \param[in] descr	More detailed description
 * \param[in] exit_code	Exit code
 * \param[in] failure_reason	Reason for the failure
 * \param[in] worker_node	Worker node
 * \param[in] LRMS_jobid	jobId from the LRMS
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogCREAMStatusDONEProxy(edg_wll_Context context, const char * old_state, const char * new_state, const struct timeval orig_timestamp, const char * descr, const char * exit_code, const char * failure_reason, const char * worker_node, const char * LRMS_jobid);

/**
 * \brief edg_wll_LogCREAMStatusDONEFile
 *
 * edg_wll_LogCREAMStatusDONEFile - simple wrapper around edg_wll_LogEventFile for event CREAMStatus, result DONE
 *
 * \param[in,out] context	context to work with, 
 * \param[in] old_state	Old status
 * \param[in] new_state	New status
 * \param[in] orig_timestamp	Original timestamp of the job state change
 * \param[in] descr	More detailed description
 * \param[in] exit_code	Exit code
 * \param[in] failure_reason	Reason for the failure
 * \param[in] worker_node	Worker node
 * \param[in] LRMS_jobid	jobId from the LRMS
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogCREAMStatusDONEFile(edg_wll_Context context, const char * old_state, const char * new_state, const struct timeval orig_timestamp, const char * descr, const char * exit_code, const char * failure_reason, const char * worker_node, const char * LRMS_jobid);

/**
 * \brief edg_wll_LogCREAMSuspend
 *
 * edg_wll_LogCREAMSuspend - simple wrapper around edg_wll_LogEvent for event CREAMSuspend
 *
 * \param[in,out] context	context to work with, 
 * \param[in] status_code	Classification of the attempt to suspend the job (REQ, REFUSE, DONE or ABORT).
 * \param[in] reason	Reason for the suspend.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogCREAMSuspend(edg_wll_Context context, const char * status_code, const char * reason);

/**
 * \brief edg_wll_LogCREAMSuspendProxy
 *
 * edg_wll_LogCREAMSuspendProxy - simple wrapper around edg_wll_LogEventProxy for event CREAMSuspend
 *
 * \param[in,out] context	context to work with, 
 * \param[in] status_code	Classification of the attempt to suspend the job (REQ, REFUSE, DONE or ABORT).
 * \param[in] reason	Reason for the suspend.
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogCREAMSuspendProxy(edg_wll_Context context, const char * status_code, const char * reason);

/**
 * \brief edg_wll_LogCREAMSuspendFile
 *
 * edg_wll_LogCREAMSuspendFile - simple wrapper around edg_wll_LogEventFile for event CREAMSuspend
 *
 * \param[in,out] context	context to work with, 
 * \param[in] status_code	Classification of the attempt to suspend the job (REQ, REFUSE, DONE or ABORT).
 * \param[in] reason	Reason for the suspend.
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogCREAMSuspendFile(edg_wll_Context context, const char * status_code, const char * reason);

/**
 * \brief edg_wll_LogCREAMSuspendREQ
 *
 * edg_wll_LogCREAMSuspendREQ - simple wrapper around edg_wll_LogEvent for event CREAMSuspend, status_code REQ
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason for the suspend.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogCREAMSuspendREQ(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogCREAMSuspendREQProxy
 *
 * edg_wll_LogCREAMSuspendREQProxy - simple wrapper around edg_wll_LogEventProxy for event CREAMSuspend, status_code REQ
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason for the suspend.
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogCREAMSuspendREQProxy(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogCREAMSuspendREQFile
 *
 * edg_wll_LogCREAMSuspendREQFile - simple wrapper around edg_wll_LogEventFile for event CREAMSuspend, status_code REQ
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason for the suspend.
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogCREAMSuspendREQFile(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogCREAMSuspendREFUSE
 *
 * edg_wll_LogCREAMSuspendREFUSE - simple wrapper around edg_wll_LogEvent for event CREAMSuspend, status_code REFUSE
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason for the suspend.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogCREAMSuspendREFUSE(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogCREAMSuspendREFUSEProxy
 *
 * edg_wll_LogCREAMSuspendREFUSEProxy - simple wrapper around edg_wll_LogEventProxy for event CREAMSuspend, status_code REFUSE
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason for the suspend.
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogCREAMSuspendREFUSEProxy(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogCREAMSuspendREFUSEFile
 *
 * edg_wll_LogCREAMSuspendREFUSEFile - simple wrapper around edg_wll_LogEventFile for event CREAMSuspend, status_code REFUSE
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason for the suspend.
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogCREAMSuspendREFUSEFile(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogCREAMSuspendDONE
 *
 * edg_wll_LogCREAMSuspendDONE - simple wrapper around edg_wll_LogEvent for event CREAMSuspend, status_code DONE
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason for the suspend.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogCREAMSuspendDONE(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogCREAMSuspendDONEProxy
 *
 * edg_wll_LogCREAMSuspendDONEProxy - simple wrapper around edg_wll_LogEventProxy for event CREAMSuspend, status_code DONE
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason for the suspend.
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogCREAMSuspendDONEProxy(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogCREAMSuspendDONEFile
 *
 * edg_wll_LogCREAMSuspendDONEFile - simple wrapper around edg_wll_LogEventFile for event CREAMSuspend, status_code DONE
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason for the suspend.
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogCREAMSuspendDONEFile(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogCREAMSuspendABORT
 *
 * edg_wll_LogCREAMSuspendABORT - simple wrapper around edg_wll_LogEvent for event CREAMSuspend, status_code ABORT
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason for the suspend.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogCREAMSuspendABORT(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogCREAMSuspendABORTProxy
 *
 * edg_wll_LogCREAMSuspendABORTProxy - simple wrapper around edg_wll_LogEventProxy for event CREAMSuspend, status_code ABORT
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason for the suspend.
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogCREAMSuspendABORTProxy(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogCREAMSuspendABORTFile
 *
 * edg_wll_LogCREAMSuspendABORTFile - simple wrapper around edg_wll_LogEventFile for event CREAMSuspend, status_code ABORT
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason for the suspend.
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogCREAMSuspendABORTFile(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogCREAMResume
 *
 * edg_wll_LogCREAMResume - simple wrapper around edg_wll_LogEvent for event CREAMResume
 *
 * \param[in,out] context	context to work with, 
 * \param[in] status_code	Classification of the attempt to resume the job (REQ, REFUSE, DONE or ABORT).
 * \param[in] reason	Reason for the resume.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogCREAMResume(edg_wll_Context context, const char * status_code, const char * reason);

/**
 * \brief edg_wll_LogCREAMResumeProxy
 *
 * edg_wll_LogCREAMResumeProxy - simple wrapper around edg_wll_LogEventProxy for event CREAMResume
 *
 * \param[in,out] context	context to work with, 
 * \param[in] status_code	Classification of the attempt to resume the job (REQ, REFUSE, DONE or ABORT).
 * \param[in] reason	Reason for the resume.
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogCREAMResumeProxy(edg_wll_Context context, const char * status_code, const char * reason);

/**
 * \brief edg_wll_LogCREAMResumeFile
 *
 * edg_wll_LogCREAMResumeFile - simple wrapper around edg_wll_LogEventFile for event CREAMResume
 *
 * \param[in,out] context	context to work with, 
 * \param[in] status_code	Classification of the attempt to resume the job (REQ, REFUSE, DONE or ABORT).
 * \param[in] reason	Reason for the resume.
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogCREAMResumeFile(edg_wll_Context context, const char * status_code, const char * reason);

/**
 * \brief edg_wll_LogCREAMResumeREQ
 *
 * edg_wll_LogCREAMResumeREQ - simple wrapper around edg_wll_LogEvent for event CREAMResume, status_code REQ
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason for the resume.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogCREAMResumeREQ(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogCREAMResumeREQProxy
 *
 * edg_wll_LogCREAMResumeREQProxy - simple wrapper around edg_wll_LogEventProxy for event CREAMResume, status_code REQ
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason for the resume.
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogCREAMResumeREQProxy(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogCREAMResumeREQFile
 *
 * edg_wll_LogCREAMResumeREQFile - simple wrapper around edg_wll_LogEventFile for event CREAMResume, status_code REQ
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason for the resume.
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogCREAMResumeREQFile(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogCREAMResumeREFUSE
 *
 * edg_wll_LogCREAMResumeREFUSE - simple wrapper around edg_wll_LogEvent for event CREAMResume, status_code REFUSE
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason for the resume.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogCREAMResumeREFUSE(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogCREAMResumeREFUSEProxy
 *
 * edg_wll_LogCREAMResumeREFUSEProxy - simple wrapper around edg_wll_LogEventProxy for event CREAMResume, status_code REFUSE
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason for the resume.
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogCREAMResumeREFUSEProxy(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogCREAMResumeREFUSEFile
 *
 * edg_wll_LogCREAMResumeREFUSEFile - simple wrapper around edg_wll_LogEventFile for event CREAMResume, status_code REFUSE
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason for the resume.
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogCREAMResumeREFUSEFile(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogCREAMResumeDONE
 *
 * edg_wll_LogCREAMResumeDONE - simple wrapper around edg_wll_LogEvent for event CREAMResume, status_code DONE
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason for the resume.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogCREAMResumeDONE(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogCREAMResumeDONEProxy
 *
 * edg_wll_LogCREAMResumeDONEProxy - simple wrapper around edg_wll_LogEventProxy for event CREAMResume, status_code DONE
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason for the resume.
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogCREAMResumeDONEProxy(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogCREAMResumeDONEFile
 *
 * edg_wll_LogCREAMResumeDONEFile - simple wrapper around edg_wll_LogEventFile for event CREAMResume, status_code DONE
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason for the resume.
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogCREAMResumeDONEFile(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogCREAMResumeABORT
 *
 * edg_wll_LogCREAMResumeABORT - simple wrapper around edg_wll_LogEvent for event CREAMResume, status_code ABORT
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason for the resume.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogCREAMResumeABORT(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogCREAMResumeABORTProxy
 *
 * edg_wll_LogCREAMResumeABORTProxy - simple wrapper around edg_wll_LogEventProxy for event CREAMResume, status_code ABORT
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason for the resume.
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogCREAMResumeABORTProxy(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogCREAMResumeABORTFile
 *
 * edg_wll_LogCREAMResumeABORTFile - simple wrapper around edg_wll_LogEventFile for event CREAMResume, status_code ABORT
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	Reason for the resume.
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogCREAMResumeABORTFile(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogFileTransferRegister
 *
 * edg_wll_LogFileTransferRegister - simple wrapper around edg_wll_LogEvent for event FileTransferRegister
 *
 * \param[in,out] context	context to work with, 
 * \param[in] src	Source of file transfer.
 * \param[in] dest	Destination of file transfer.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogFileTransferRegister(edg_wll_Context context, const char * src, const char * dest);

/**
 * \brief edg_wll_LogFileTransferRegisterProxy
 *
 * edg_wll_LogFileTransferRegisterProxy - simple wrapper around edg_wll_LogEventProxy for event FileTransferRegister
 *
 * \param[in,out] context	context to work with, 
 * \param[in] src	Source of file transfer.
 * \param[in] dest	Destination of file transfer.
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogFileTransferRegisterProxy(edg_wll_Context context, const char * src, const char * dest);

/**
 * \brief edg_wll_LogFileTransferRegisterFile
 *
 * edg_wll_LogFileTransferRegisterFile - simple wrapper around edg_wll_LogEventFile for event FileTransferRegister
 *
 * \param[in,out] context	context to work with, 
 * \param[in] src	Source of file transfer.
 * \param[in] dest	Destination of file transfer.
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogFileTransferRegisterFile(edg_wll_Context context, const char * src, const char * dest);

/**
 * \brief edg_wll_LogFileTransfer
 *
 * edg_wll_LogFileTransfer - simple wrapper around edg_wll_LogEvent for event FileTransfer
 *
 * \param[in,out] context	context to work with, 
 * \param[in] result	Result code of the file transfer attemp.
 * \param[in] reason	The reason of file transfer failure.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogFileTransfer(edg_wll_Context context, const char * result, const char * reason);

/**
 * \brief edg_wll_LogFileTransferProxy
 *
 * edg_wll_LogFileTransferProxy - simple wrapper around edg_wll_LogEventProxy for event FileTransfer
 *
 * \param[in,out] context	context to work with, 
 * \param[in] result	Result code of the file transfer attemp.
 * \param[in] reason	The reason of file transfer failure.
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogFileTransferProxy(edg_wll_Context context, const char * result, const char * reason);

/**
 * \brief edg_wll_LogFileTransferFile
 *
 * edg_wll_LogFileTransferFile - simple wrapper around edg_wll_LogEventFile for event FileTransfer
 *
 * \param[in,out] context	context to work with, 
 * \param[in] result	Result code of the file transfer attemp.
 * \param[in] reason	The reason of file transfer failure.
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogFileTransferFile(edg_wll_Context context, const char * result, const char * reason);

/**
 * \brief edg_wll_LogFileTransferSTART
 *
 * edg_wll_LogFileTransferSTART - simple wrapper around edg_wll_LogEvent for event FileTransfer, result START
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	The reason of file transfer failure.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogFileTransferSTART(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogFileTransferSTARTProxy
 *
 * edg_wll_LogFileTransferSTARTProxy - simple wrapper around edg_wll_LogEventProxy for event FileTransfer, result START
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	The reason of file transfer failure.
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogFileTransferSTARTProxy(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogFileTransferSTARTFile
 *
 * edg_wll_LogFileTransferSTARTFile - simple wrapper around edg_wll_LogEventFile for event FileTransfer, result START
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	The reason of file transfer failure.
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogFileTransferSTARTFile(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogFileTransferOK
 *
 * edg_wll_LogFileTransferOK - simple wrapper around edg_wll_LogEvent for event FileTransfer, result OK
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	The reason of file transfer failure.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogFileTransferOK(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogFileTransferOKProxy
 *
 * edg_wll_LogFileTransferOKProxy - simple wrapper around edg_wll_LogEventProxy for event FileTransfer, result OK
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	The reason of file transfer failure.
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogFileTransferOKProxy(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogFileTransferOKFile
 *
 * edg_wll_LogFileTransferOKFile - simple wrapper around edg_wll_LogEventFile for event FileTransfer, result OK
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	The reason of file transfer failure.
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogFileTransferOKFile(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogFileTransferFAIL
 *
 * edg_wll_LogFileTransferFAIL - simple wrapper around edg_wll_LogEvent for event FileTransfer, result FAIL
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	The reason of file transfer failure.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogFileTransferFAIL(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogFileTransferFAILProxy
 *
 * edg_wll_LogFileTransferFAILProxy - simple wrapper around edg_wll_LogEventProxy for event FileTransfer, result FAIL
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	The reason of file transfer failure.
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogFileTransferFAILProxy(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogFileTransferFAILFile
 *
 * edg_wll_LogFileTransferFAILFile - simple wrapper around edg_wll_LogEventFile for event FileTransfer, result FAIL
 *
 * \param[in,out] context	context to work with, 
 * \param[in] reason	The reason of file transfer failure.
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogFileTransferFAILFile(edg_wll_Context context, const char * reason);

/**
 * \brief edg_wll_LogSandbox
 *
 * edg_wll_LogSandbox - simple wrapper around edg_wll_LogEvent for event Sandbox
 *
 * \param[in,out] context	context to work with, 
 * \param[in] sandbox_type	Type of sandbox.
 * \param[in] transfer_job	Jobid of transfer job (collection) containing set of file transfers (subjobs).
 * \param[in] compute_job	Jobid of (compute) job the sandbox belongs. Exclusive with transfer_job.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogSandbox(edg_wll_Context context, const char * sandbox_type, const char * transfer_job, const char * compute_job);

/**
 * \brief edg_wll_LogSandboxProxy
 *
 * edg_wll_LogSandboxProxy - simple wrapper around edg_wll_LogEventProxy for event Sandbox
 *
 * \param[in,out] context	context to work with, 
 * \param[in] sandbox_type	Type of sandbox.
 * \param[in] transfer_job	Jobid of transfer job (collection) containing set of file transfers (subjobs).
 * \param[in] compute_job	Jobid of (compute) job the sandbox belongs. Exclusive with transfer_job.
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogSandboxProxy(edg_wll_Context context, const char * sandbox_type, const char * transfer_job, const char * compute_job);

/**
 * \brief edg_wll_LogSandboxFile
 *
 * edg_wll_LogSandboxFile - simple wrapper around edg_wll_LogEventFile for event Sandbox
 *
 * \param[in,out] context	context to work with, 
 * \param[in] sandbox_type	Type of sandbox.
 * \param[in] transfer_job	Jobid of transfer job (collection) containing set of file transfers (subjobs).
 * \param[in] compute_job	Jobid of (compute) job the sandbox belongs. Exclusive with transfer_job.
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogSandboxFile(edg_wll_Context context, const char * sandbox_type, const char * transfer_job, const char * compute_job);

/**
 * \brief edg_wll_LogSandboxINPUT
 *
 * edg_wll_LogSandboxINPUT - simple wrapper around edg_wll_LogEvent for event Sandbox, sandbox_type INPUT
 *
 * \param[in,out] context	context to work with, 
 * \param[in] transfer_job	Jobid of transfer job (collection) containing set of file transfers (subjobs).
 * \param[in] compute_job	Jobid of (compute) job the sandbox belongs. Exclusive with transfer_job.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogSandboxINPUT(edg_wll_Context context, const char * transfer_job, const char * compute_job);

/**
 * \brief edg_wll_LogSandboxINPUTProxy
 *
 * edg_wll_LogSandboxINPUTProxy - simple wrapper around edg_wll_LogEventProxy for event Sandbox, sandbox_type INPUT
 *
 * \param[in,out] context	context to work with, 
 * \param[in] transfer_job	Jobid of transfer job (collection) containing set of file transfers (subjobs).
 * \param[in] compute_job	Jobid of (compute) job the sandbox belongs. Exclusive with transfer_job.
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogSandboxINPUTProxy(edg_wll_Context context, const char * transfer_job, const char * compute_job);

/**
 * \brief edg_wll_LogSandboxINPUTFile
 *
 * edg_wll_LogSandboxINPUTFile - simple wrapper around edg_wll_LogEventFile for event Sandbox, sandbox_type INPUT
 *
 * \param[in,out] context	context to work with, 
 * \param[in] transfer_job	Jobid of transfer job (collection) containing set of file transfers (subjobs).
 * \param[in] compute_job	Jobid of (compute) job the sandbox belongs. Exclusive with transfer_job.
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogSandboxINPUTFile(edg_wll_Context context, const char * transfer_job, const char * compute_job);

/**
 * \brief edg_wll_LogSandboxOUTPUT
 *
 * edg_wll_LogSandboxOUTPUT - simple wrapper around edg_wll_LogEvent for event Sandbox, sandbox_type OUTPUT
 *
 * \param[in,out] context	context to work with, 
 * \param[in] transfer_job	Jobid of transfer job (collection) containing set of file transfers (subjobs).
 * \param[in] compute_job	Jobid of (compute) job the sandbox belongs. Exclusive with transfer_job.
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogSandboxOUTPUT(edg_wll_Context context, const char * transfer_job, const char * compute_job);

/**
 * \brief edg_wll_LogSandboxOUTPUTProxy
 *
 * edg_wll_LogSandboxOUTPUTProxy - simple wrapper around edg_wll_LogEventProxy for event Sandbox, sandbox_type OUTPUT
 *
 * \param[in,out] context	context to work with, 
 * \param[in] transfer_job	Jobid of transfer job (collection) containing set of file transfers (subjobs).
 * \param[in] compute_job	Jobid of (compute) job the sandbox belongs. Exclusive with transfer_job.
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogSandboxOUTPUTProxy(edg_wll_Context context, const char * transfer_job, const char * compute_job);

/**
 * \brief edg_wll_LogSandboxOUTPUTFile
 *
 * edg_wll_LogSandboxOUTPUTFile - simple wrapper around edg_wll_LogEventFile for event Sandbox, sandbox_type OUTPUT
 *
 * \param[in,out] context	context to work with, 
 * \param[in] transfer_job	Jobid of transfer job (collection) containing set of file transfers (subjobs).
 * \param[in] compute_job	Jobid of (compute) job the sandbox belongs. Exclusive with transfer_job.
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogSandboxOUTPUTFile(edg_wll_Context context, const char * transfer_job, const char * compute_job);

/**
 * \brief edg_wll_LogVMCreate
 *
 * edg_wll_LogVMCreate - simple wrapper around edg_wll_LogEvent for event VMCreate
 *
 * \param[in,out] context	context to work with, 
 * \param[in] require	machine requirements
 * \param[in] id	machine id
 * \param[in] name	machine name
 * \param[in] owner	machine owner
 * \param[in] hostname	hostname of VM
 * \param[in] manager	VM manager
 * \param[in] image	machine image
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogVMCreate(edg_wll_Context context, const char * require, const char * id, const char * name, const char * owner, const char * hostname, const char * manager, const char * image);

/**
 * \brief edg_wll_LogVMCreateProxy
 *
 * edg_wll_LogVMCreateProxy - simple wrapper around edg_wll_LogEventProxy for event VMCreate
 *
 * \param[in,out] context	context to work with, 
 * \param[in] require	machine requirements
 * \param[in] id	machine id
 * \param[in] name	machine name
 * \param[in] owner	machine owner
 * \param[in] hostname	hostname of VM
 * \param[in] manager	VM manager
 * \param[in] image	machine image
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogVMCreateProxy(edg_wll_Context context, const char * require, const char * id, const char * name, const char * owner, const char * hostname, const char * manager, const char * image);

/**
 * \brief edg_wll_LogVMCreateFile
 *
 * edg_wll_LogVMCreateFile - simple wrapper around edg_wll_LogEventFile for event VMCreate
 *
 * \param[in,out] context	context to work with, 
 * \param[in] require	machine requirements
 * \param[in] id	machine id
 * \param[in] name	machine name
 * \param[in] owner	machine owner
 * \param[in] hostname	hostname of VM
 * \param[in] manager	VM manager
 * \param[in] image	machine image
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogVMCreateFile(edg_wll_Context context, const char * require, const char * id, const char * name, const char * owner, const char * hostname, const char * manager, const char * image);

/**
 * \brief edg_wll_LogVMHost
 *
 * edg_wll_LogVMHost - simple wrapper around edg_wll_LogEvent for event VMHost
 *
 * \param[in,out] context	context to work with, 
 * \param[in] hostname	hostname of physical machine of VM
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogVMHost(edg_wll_Context context, const char * hostname);

/**
 * \brief edg_wll_LogVMHostProxy
 *
 * edg_wll_LogVMHostProxy - simple wrapper around edg_wll_LogEventProxy for event VMHost
 *
 * \param[in,out] context	context to work with, 
 * \param[in] hostname	hostname of physical machine of VM
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogVMHostProxy(edg_wll_Context context, const char * hostname);

/**
 * \brief edg_wll_LogVMHostFile
 *
 * edg_wll_LogVMHostFile - simple wrapper around edg_wll_LogEventFile for event VMHost
 *
 * \param[in,out] context	context to work with, 
 * \param[in] hostname	hostname of physical machine of VM
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogVMHostFile(edg_wll_Context context, const char * hostname);

/**
 * \brief edg_wll_LogVMImage
 *
 * edg_wll_LogVMImage - simple wrapper around edg_wll_LogEvent for event VMImage
 *
 * \param[in,out] context	context to work with, 
 * \param[in] image	machine image
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogVMImage(edg_wll_Context context, const char * image);

/**
 * \brief edg_wll_LogVMImageProxy
 *
 * edg_wll_LogVMImageProxy - simple wrapper around edg_wll_LogEventProxy for event VMImage
 *
 * \param[in,out] context	context to work with, 
 * \param[in] image	machine image
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogVMImageProxy(edg_wll_Context context, const char * image);

/**
 * \brief edg_wll_LogVMImageFile
 *
 * edg_wll_LogVMImageFile - simple wrapper around edg_wll_LogEventFile for event VMImage
 *
 * \param[in,out] context	context to work with, 
 * \param[in] image	machine image
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogVMImageFile(edg_wll_Context context, const char * image);

/**
 * \brief edg_wll_LogVMRunning
 *
 * edg_wll_LogVMRunning - simple wrapper around edg_wll_LogEvent for event VMRunning
 *
 * \param[in,out] context	context to work with, 
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogVMRunning(edg_wll_Context context);

/**
 * \brief edg_wll_LogVMRunningProxy
 *
 * edg_wll_LogVMRunningProxy - simple wrapper around edg_wll_LogEventProxy for event VMRunning
 *
 * \param[in,out] context	context to work with, 
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogVMRunningProxy(edg_wll_Context context);

/**
 * \brief edg_wll_LogVMRunningFile
 *
 * edg_wll_LogVMRunningFile - simple wrapper around edg_wll_LogEventFile for event VMRunning
 *
 * \param[in,out] context	context to work with, 
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogVMRunningFile(edg_wll_Context context);

/**
 * \brief edg_wll_LogVMShutdown
 *
 * edg_wll_LogVMShutdown - simple wrapper around edg_wll_LogEvent for event VMShutdown
 *
 * \param[in,out] context	context to work with, 
 * \param[in] usage	
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogVMShutdown(edg_wll_Context context, const char * usage);

/**
 * \brief edg_wll_LogVMShutdownProxy
 *
 * edg_wll_LogVMShutdownProxy - simple wrapper around edg_wll_LogEventProxy for event VMShutdown
 *
 * \param[in,out] context	context to work with, 
 * \param[in] usage	
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogVMShutdownProxy(edg_wll_Context context, const char * usage);

/**
 * \brief edg_wll_LogVMShutdownFile
 *
 * edg_wll_LogVMShutdownFile - simple wrapper around edg_wll_LogEventFile for event VMShutdown
 *
 * \param[in,out] context	context to work with, 
 * \param[in] usage	
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogVMShutdownFile(edg_wll_Context context, const char * usage);

/**
 * \brief edg_wll_LogVMStop
 *
 * edg_wll_LogVMStop - simple wrapper around edg_wll_LogEvent for event VMStop
 *
 * \param[in,out] context	context to work with, 
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogVMStop(edg_wll_Context context);

/**
 * \brief edg_wll_LogVMStopProxy
 *
 * edg_wll_LogVMStopProxy - simple wrapper around edg_wll_LogEventProxy for event VMStop
 *
 * \param[in,out] context	context to work with, 
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogVMStopProxy(edg_wll_Context context);

/**
 * \brief edg_wll_LogVMStopFile
 *
 * edg_wll_LogVMStopFile - simple wrapper around edg_wll_LogEventFile for event VMStop
 *
 * \param[in,out] context	context to work with, 
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogVMStopFile(edg_wll_Context context);

/**
 * \brief edg_wll_LogVMResume
 *
 * edg_wll_LogVMResume - simple wrapper around edg_wll_LogEvent for event VMResume
 *
 * \param[in,out] context	context to work with, 
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogVMResume(edg_wll_Context context);

/**
 * \brief edg_wll_LogVMResumeProxy
 *
 * edg_wll_LogVMResumeProxy - simple wrapper around edg_wll_LogEventProxy for event VMResume
 *
 * \param[in,out] context	context to work with, 
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogVMResumeProxy(edg_wll_Context context);

/**
 * \brief edg_wll_LogVMResumeFile
 *
 * edg_wll_LogVMResumeFile - simple wrapper around edg_wll_LogEventFile for event VMResume
 *
 * \param[in,out] context	context to work with, 
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogVMResumeFile(edg_wll_Context context);

/**
 * \brief edg_wll_LogVMDone
 *
 * edg_wll_LogVMDone - simple wrapper around edg_wll_LogEvent for event VMDone
 *
 * \param[in,out] context	context to work with, 
 * \param[in] status_code	
 * \param[in] usage	
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogVMDone(edg_wll_Context context, const char * status_code, const char * usage);

/**
 * \brief edg_wll_LogVMDoneProxy
 *
 * edg_wll_LogVMDoneProxy - simple wrapper around edg_wll_LogEventProxy for event VMDone
 *
 * \param[in,out] context	context to work with, 
 * \param[in] status_code	
 * \param[in] usage	
* \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogVMDoneProxy(edg_wll_Context context, const char * status_code, const char * usage);

/**
 * \brief edg_wll_LogVMDoneFile
 *
 * edg_wll_LogVMDoneFile - simple wrapper around edg_wll_LogEventFile for event VMDone
 *
 * \param[in,out] context	context to work with, 
 * \param[in] status_code	
 * \param[in] usage	
 *  \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogVMDoneFile(edg_wll_Context context, const char * status_code, const char * usage);

/**
 * \brief edg_wll_LogVMDoneOK
 *
 * edg_wll_LogVMDoneOK - simple wrapper around edg_wll_LogEvent for event VMDone, status_code OK
 *
 * \param[in,out] context	context to work with, 
 * \param[in] usage	
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogVMDoneOK(edg_wll_Context context, const char * usage);

/**
 * \brief edg_wll_LogVMDoneOKProxy
 *
 * edg_wll_LogVMDoneOKProxy - simple wrapper around edg_wll_LogEventProxy for event VMDone, status_code OK
 *
 * \param[in,out] context	context to work with, 
 * \param[in] usage	
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogVMDoneOKProxy(edg_wll_Context context, const char * usage);

/**
 * \brief edg_wll_LogVMDoneOKFile
 *
 * edg_wll_LogVMDoneOKFile - simple wrapper around edg_wll_LogEventFile for event VMDone, status_code OK
 *
 * \param[in,out] context	context to work with, 
 * \param[in] usage	
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogVMDoneOKFile(edg_wll_Context context, const char * usage);

/**
 * \brief edg_wll_LogVMDoneDELETE
 *
 * edg_wll_LogVMDoneDELETE - simple wrapper around edg_wll_LogEvent for event VMDone, status_code DELETE
 *
 * \param[in,out] context	context to work with, 
 * \param[in] usage	
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogVMDoneDELETE(edg_wll_Context context, const char * usage);

/**
 * \brief edg_wll_LogVMDoneDELETEProxy
 *
 * edg_wll_LogVMDoneDELETEProxy - simple wrapper around edg_wll_LogEventProxy for event VMDone, status_code DELETE
 *
 * \param[in,out] context	context to work with, 
 * \param[in] usage	
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogVMDoneDELETEProxy(edg_wll_Context context, const char * usage);

/**
 * \brief edg_wll_LogVMDoneDELETEFile
 *
 * edg_wll_LogVMDoneDELETEFile - simple wrapper around edg_wll_LogEventFile for event VMDone, status_code DELETE
 *
 * \param[in,out] context	context to work with, 
 * \param[in] usage	
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogVMDoneDELETEFile(edg_wll_Context context, const char * usage);

/**
 * \brief edg_wll_LogVMDoneFAILURE
 *
 * edg_wll_LogVMDoneFAILURE - simple wrapper around edg_wll_LogEvent for event VMDone, status_code FAILURE
 *
 * \param[in,out] context	context to work with, 
 * \param[in] usage	
 * \see edg_wll_LogEvent()
 */

extern int edg_wll_LogVMDoneFAILURE(edg_wll_Context context, const char * usage);

/**
 * \brief edg_wll_LogVMDoneFAILUREProxy
 *
 * edg_wll_LogVMDoneFAILUREProxy - simple wrapper around edg_wll_LogEventProxy for event VMDone, status_code FAILURE
 *
 * \param[in,out] context	context to work with, 
 * \param[in] usage	
 * \see edg_wll_LogEventProxy()
 */

extern int edg_wll_LogVMDoneFAILUREProxy(edg_wll_Context context, const char * usage);

/**
 * \brief edg_wll_LogVMDoneFAILUREFile
 *
 * edg_wll_LogVMDoneFAILUREFile - simple wrapper around edg_wll_LogEventFile for event VMDone, status_code FAILURE
 *
 * \param[in,out] context	context to work with, 
 * \param[in] usage	
 * \see edg_wll_LogEventFile()
 */

extern int edg_wll_LogVMDoneFAILUREFile(edg_wll_Context context, const char * usage);


/**
 * Formats a logging message and sends it asynchronously to local-logger
 * (the connection is through GSS)
 * \brief generic asynchronous logging function
 * \param[in,out] context	context to work with,
 * \param[in] event		type of the event,
 * \param[in] fmt		printf()-like format string,
 * \param[in] ...		event specific values/data according to fmt,
 * \retval 0		successful completition,
 * \retval EINVAL	bad jobId, unknown event code, or the format string together with the remaining arguments does not form a valid event,
 * \retval ENOSPC	L&B infrastructure failed to accept the event due to lack of disk space etc.,
 * \retval ENOMEM	failed to allocate memory,
 * \retval ECONNREFUSED	cannot connect to the specified local logger,
 * \retval EAGAIN	non blocking return from the call, the event may or may not get logged,
 * \retval EDG_WLL_ERROR_NOJOBID logging call attempted without assigning jobId to the context.
 */
extern int edg_wll_LogEvent(
	edg_wll_Context context,
	edg_wll_EventCode event,
	char *fmt, ...);

/**
 * Formats a logging message and sends it synchronously to local-logger
 * (the connection is through GSS)
 * \brief generic synchronous logging function
 * \param[in,out] context	context to work with,
 * \param[in] event		type of the event,
 * \param[in] fmt		printf()-like format string,
 * \param[in] ...		event specific values/data according to fmt,
 * \retval 0		successful completition,
 * \retval EINVAL	bad jobId, unknown event code, or the format string together with the remaining arguments does not form a valid event,
 * \retval ENOSPC	L&B infrastructure failed to accept the event due to lack of disk space etc.,
 * \retval ENOMEM	failed to allocate memory,
 * \retval ECONNREFUSED	cannot connect to the specified local logger,
 * \retval EAGAIN	non blocking return from the call, the event may or may not get logged,
 * \retval EDG_WLL_ERROR_NOJOBID logging call attempted without assigning jobId to the context,
 * \retval EPERM	the user is not authorized to add events to this job,
 * \retval EDG_WLL_ERROR_DB_DUP_KEY exactly the same event has been already stored.
 */
extern int edg_wll_LogEventSync(
	edg_wll_Context context,
	edg_wll_EventCode event,
	char *fmt, ...);

/**
 * Formats a logging message and sends it synchronously to L&B Proxy
 * (the connection is through UNIX socket)
 * \brief generic synchronous logging function
 * \param[in,out] context	context to work with,
 * \param[in] event		type of the event,
 * \param[in] fmt		printf()-like format string,
 * \param[in] ...		event specific values/data according to fmt,
 * \retval 0            successful completition,
 * \retval EINVAL       bad jobId, unknown event code, or the format string together with the remaining arguments does not form a valid event,             
 * \retval ENOSPC       L&B infrastructure failed to accept the event due to lack of disk space etc.,
 * \retval ENOMEM       failed to allocate memory,
 * \retval ECONNREFUSED cannot connect to the specified L&B Proxy
 * \retval EAGAIN       non blocking return from the call, the event may or may not get logged,
 * \retval EDG_WLL_ERROR_NOJOBID logging call attempted without assigning jobId to the context.
 */             
extern int edg_wll_LogEventProxy(
        edg_wll_Context context, 
        edg_wll_EventCode event,
        char *fmt, ...);        

/**
 * Formats a logging message and stores it to local file to be delivered by IL
 * (which is also notified through UNIX socket)
 * \brief generic synchronous logging function
 * \param[in,out] context	context to work with,
 * \param[in] event		type of the event,
 * \param[in] fmt		printf()-like format string,
 * \param[in] ...		event specific values/data according to fmt,
 * \retval 0            successful completition,
 * \retval EINVAL       bad jobId, unknown event code, or the format string together with the remaining arguments does not form a valid event,             
 * \retval ENOSPC       L&B infrastructure failed to accept the event due to lack of disk space etc.,
 * \retval ENOMEM       failed to allocate memory,
 * \retval ECONNREFUSED cannot connect to the specified L&B Proxy
 * \retval EAGAIN       non blocking return from the call, the event may or may not get logged,
 * \retval EDG_WLL_ERROR_NOJOBID logging call attempted without assigning jobId to the context.
 */             
extern int edg_wll_LogEventFile(
        edg_wll_Context context, 
        edg_wll_EventCode event,
        char *fmt, ...);        

/**
 * Instructs interlogger to to deliver all pending events related to current job
 * \brief flush events from interlogger
 * \note sort of status query more than a command
 * \param[in,out] context	context to work with,
 * \param[in,out] timeout	wait at most this much time for completition, remaining time on return,
 * \retval 0		successful completition,
 * \retval EDG_WLL_ERROR_INTERLOG_TIMEOUT the inter-logger did not respond within the timeout,
 * \retval EDG_WLL_ERROR_INTERLOG_CONLOST inter-logger lost connection to one or more servers,
 * \retval EDG_WLL_ERROR_INTERLOG_AGAIN   not all pending events were delivered within the timeout.
 */
extern int edg_wll_LogFlush(
	edg_wll_Context context,
	struct timeval *timeout);


/**
 * Instructs interlogger to to deliver all pending events
 * \brief flush all events from interlogger
 * \note same as edg_wll_LogFlush() for all jobs known to interlogger
 * \see edg_wll_LogFlush()
 */
extern int edg_wll_LogFlushAll(
	edg_wll_Context context,
	struct timeval *timeout);

/**
 * Set a current job for given context.
 * \note Should be called before any logging call.
 * \param[in,out] context 	context to work with
 * \param[in] job 		further logging calls are related to this job
 * \param[in] code 		sequence code as obtained from previous component
 * \param[in] flags 		flags on code handling (\see API documentation)
 */
extern int edg_wll_SetLoggingJob(
	edg_wll_Context	context,
	glite_jobid_const_t	job,
	const char *		code,
	int			flags
);

/**
 * Set a current job for given context.
 * \note Should be called before any call logging to lbproxy.
 * \param[in,out] context 	context to work with
 * \param[in] job 		further logging calls are related to this job
 * \param[in] code 		sequence code as obtained from previous component
 * \param[in] user 		user credentials
 * \param[in] flags 		flags on code handling (\see API documentation)
 */
extern int edg_wll_SetLoggingJobProxy(
	edg_wll_Context	context,
	glite_jobid_const_t	job,
	const char *		code,
	const char *		user,
	int			flags
);

/**
 * Set a current job for given context.
 * \note Should be called before any call logging locally to file to be consumed by IL.
 * \param[in,out] context 	context to work with
 * \param[in] job 		further logging calls are related to this job
 * \param[in] code 		sequence code as obtained from previous component
 * \param[in] user 		user credentials
 * \param[in] flags 		flags on code handling (\see API documentation)
 */
extern int edg_wll_SetLoggingJobFile(
	edg_wll_Context	context,
	glite_jobid_const_t	job,
	const char *		code,
	const char *		user,
	int			flags
);

/**
 * Register job with L&B service.
 * Done via logging REGJOB event directly to LB server (the connection is asynchronous through GSS)
 * - may generate subjob id's and create the parent-children associations,
 * - set the job as current for the context and initialize sequence code,
 * - partitionable jobs should set num_subjobs=0 initially, 
 *   and re-register when the number of subjobs becomes known.
 *
 * \brief asynchronous job registration
 * \param[in,out] context 	context to work with
 * \param[in] job 		jobId
 * \param[in] type 		EDG_WLL_JOB_SIMPLE,  EDG_WLL_JOB_DAG, or EDG_WLL_JOB_PARTITIONABLE
 * \param[in] jdl 		user-specified JDL
 * \param[in] ns 		network server contact
 * \param[in] num_subjobs 	number of subjobs to create
 * \param[in] seed 		seed used for subjob id's generator.
 * 	Use non-NULL value to be able to regenerate the set of jobid's
 * \param[out] subjobs 		returned subjob id's
 */

/* backward compatibility */
#define EDG_WLL_JOB_SIMPLE	EDG_WLL_REGJOB_SIMPLE
#define edg_wll_RegisterJobAsync	edg_wll_RegisterJob 

extern int edg_wll_RegisterJob(
	edg_wll_Context		context,
	glite_jobid_const_t	job,
	enum edg_wll_RegJobJobtype	type,
	const char *		jdl,
	const char *		ns,
	int			num_subjobs,
	const char *		seed,
	glite_jobid_t **	subjobs
);

#if 0
DEPRECATED?
/** 
 * Synchronous variant of edg_wll_RegisterJob
 */

extern int edg_wll_RegisterJobSync(
	edg_wll_Context		context,
	glite_jobid_const_t	job,
	enum edg_wll_RegJobJobtype	type,
	const char *		jdl,
	const char *		ns,
	int			num_subjobs,
	const char *		seed,
	glite_jobid_t **	subjobs
);
#endif
#define edg_wll_RegisterJobSync edg_wll_RegisterJob

/**
 * Register job with L&B Proxy service.
 * Done via logging REGJOB event in parallel both 
 * to LB proxy (through UNIX socket) and 
 * to LB server (through GSS)
 * - may generate subjob id's and create the parent-children associations,
 * - set the job as current for the context and initialize sequence code,
 * - partitionable jobs should set num_subjobs=0 initially,
 *   and re-register when number of subjobs becomes known.
 *
 * \param[in,out] context	context to work with
 * \param[in] job		jobId
 * \param[in] type 		EDG_WLL_JOB_SIMPLE, EDG_WLL_JOB_DAG, or EDG_WLL_JOB_PARTITIONABLE
 * \param[in] jdl 		user-specified JDL
 * \param[in] ns 		network server contact
 * \param[in] num_subjobs 	number of subjobs to create
 * \param[in] seed 		seed used for subjob id's generator.
 *      Use non-NULL value to be able to regenerate the set of jobid's
 * \param[out] subjobs 		returned subjob id's
 */

extern int edg_wll_RegisterJobProxy(
	edg_wll_Context		context,
	glite_jobid_const_t	job,
	enum edg_wll_RegJobJobtype	type,
	const char *		jdl,
	const char *		ns,
	int			num_subjobs,
	const char *		seed,
	glite_jobid_t **	subjobs
);

/** 
 * Job registration with an extra ACL specifying WMS to acces the job
 * (the connection to LB server is asynchronous through GSS)
 * \param[in] wms_dn 		DN of WMS handling the job
 */

extern int edg_wll_RegisterJobExt(
	edg_wll_Context		context,
	glite_jobid_const_t	job,
	enum edg_wll_RegJobJobtype	type,
	const char *		jdl,
	const char *		ns,
	int			num_subjobs,
	const char *		seed,
	glite_jobid_t **	subjobs,
	char **			wms_dn,
	int			flags
);

extern int edg_wll_RegisterJobProxyExt(
	edg_wll_Context		context,
	glite_jobid_const_t	job,
	enum edg_wll_RegJobJobtype	type,
	const char *		jdl,
	const char *		ns,
	int			num_subjobs,
	const char *		seed,
	glite_jobid_t **	subjobs,
	char **			wms_dn,
	int			flags
);

#ifdef LB_PERF
/* register only to LBProxy 		*/
/* useful for performance measurements	*/

extern int edg_wll_RegisterJobProxyOnly(
	edg_wll_Context		context,
	glite_jobid_const_t	job,
	enum edg_wll_RegJobJobtype	type,
	const char *		jdl,
	const char *		ns,
	int			num_subjobs,
	const char *		seed,
	glite_jobid_t **	subjobs
);
#endif



/**
 * Register subjobs in a batch.
 * Mainly used to provide JDL's of individual subjobs in a more efficient
 * way than logging them one by one.
 * \param[in,out] context	context to work with
 * \param[in] parent		parent's jobId
 * \param[in] jdls		array of JDL's
 * \param[in] ns 		network server contact
 * \param[in] subjobs 		array of jobid's in the same order
 */

extern int edg_wll_RegisterSubjobs(
	edg_wll_Context		context,
	glite_jobid_const_t	parent,
	char const * const *	jdls,
	const char *		ns,
	glite_jobid_t const *	subjobs
);


/**
 * Register subjobs to LB Proxyin a batch.
 * Mainly used to provide JDL's of individual subjobs in a more efficient
 * way than logging them one by one.
 * \param[in,out] context	context to work with
 * \param[in] parent		parent's jobId
 * \param[in] jdls		array of JDL's
 * \param[in] ns 		network server contact
 * \param[in] subjobs 		array of jobid's in the same order
 */

extern int edg_wll_RegisterSubjobsProxy(
	edg_wll_Context		context,
	glite_jobid_const_t	parent,
	char const * const *	jdls,
	const char *		ns,
	glite_jobid_t const *	subjobs
);

/**
 * Register file transfer subjobs in a batch.
 * \param[in,out] context       context to work with
 * \param[in] parent            parent's jobId
 * \param[in] ns                network server contact
 * \param[in] nsubjobs		number of subjobs
 * \param[in] subjobs           array of jobid's in the same order
 */

extern int edg_wll_RegisterFTSubjobs(
        edg_wll_Context         ctx,
        glite_jobid_const_t     parent,
        const char *            ns,
        int                     nsubjobs,
        edg_wlc_JobId const *   subjobs
);

/**
 * Change ACL for given job.
 * \param[in,out] context 	context to work with
 * \param[in] job 		jobId
 * \param[in] user_id 		specification of user's credential
 * \param[in] user_id_type 	type of user_id,
 *    for EDG_WLL_USER_SUBJECT the user_id parameter is expected to be user's subject name
 *    for EDG_WLL_USER_VOMS_GROUP the user_id is expected to be of the form VO:group specifying required group membersip as managed by VOMS
 * \param[in] permission 	ACL permission to change
 * \param[in] permission_type 	type of given permission (allow or deny operation) 
 * \param[in] operation 	operation to perform with ACL (add or remove record)
 */
 
extern int edg_wll_ChangeACL(
	edg_wll_Context		context,
	glite_jobid_const_t	job,
	const char *		user_id,
	enum edg_wll_ChangeACLUser_id_type	user_id_type,
	enum edg_wll_ChangeACLPermission	permission,
	enum edg_wll_ChangeACLPermission_type	permission_type,
	enum edg_wll_ChangeACLOperation		operation
);


#ifdef __cplusplus
}
#endif

#endif /* GLITE_LB_PRODUCER_H */
