/*
 * Decompiled with CFR 0.152.
 */
package org.glite.jdl;

import condor.classad.Constant;
import condor.classad.Expr;
import condor.classad.ListExpr;
import condor.classad.RecordExpr;
import java.text.ParseException;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.naming.directory.InvalidAttributeValueException;
import org.glite.jdl.EnumerableAd;
import org.glite.jdl.JobAd;
import org.glite.jdl.JobAdException;

public class ParametricAd
extends JobAd
implements Cloneable,
EnumerableAd {
    private long status = 0L;

    public ParametricAd() {
    }

    public ParametricAd(String ad) throws ParseException, JobAdException {
        super(ad);
    }

    public ParametricAd(RecordExpr ad) throws JobAdException {
        super(ad);
    }

    synchronized void insertAttribute(String attrName, Expr attrValue) throws InvalidAttributeValueException {
        super.insertAttribute(attrName, attrValue);
        this.status = this.status == Long.MAX_VALUE ? 0L : ++this.status;
    }

    public Object clone() {
        try {
            return new ParametricAd(this.jobAd);
        }
        catch (JobAdException jobAdException) {
            throw new RuntimeException("Cannot clone parametric ad");
        }
    }

    private synchronized JobAd cloneWithParameter(String cString, long st) {
        if (this.status != st) {
            throw new ConcurrentModificationException();
        }
        RecordExpr result = new RecordExpr();
        boolean missingEnviron = true;
        Iterator it = this.jobAd.attributes();
        while (it.hasNext()) {
            String attrName = it.next().toString();
            if (attrName.equalsIgnoreCase("ParameterStart") || attrName.equalsIgnoreCase("Parameters") || attrName.equalsIgnoreCase("ParameterStep")) continue;
            if (attrName.equalsIgnoreCase("JobType")) {
                result.insertAttribute(attrName, (Expr)Constant.getInstance((String)"normal"));
                continue;
            }
            Expr source = this.jobAd.lookup(attrName);
            Object target = null;
            if (source.type == -2) {
                ListExpr slist = (ListExpr)source;
                ListExpr tlist = new ListExpr();
                for (int k = 0; k < slist.size(); ++k) {
                    Expr tmpe = slist.sub(k);
                    if (tmpe.type == 5) {
                        String tmps = tmpe.stringValue();
                        if (tmps.indexOf("_PARAM_") >= 0) {
                            tlist.add((Expr)Constant.getInstance((String)tmps.replaceAll("_PARAM_", cString)));
                            continue;
                        }
                        tlist.add((Expr)Constant.getInstance((String)tmps));
                        continue;
                    }
                    tlist.add(tmpe);
                }
                if (attrName.equalsIgnoreCase("Environment")) {
                    missingEnviron = false;
                    tlist.add((Expr)Constant.getInstance((String)("ParameterValue=\"" + cString + "\"")));
                }
                target = tlist;
            } else {
                String tmps;
                target = source.type == 5 ? ((tmps = source.stringValue()).indexOf("_PARAM_") >= 0 ? Constant.getInstance((String)tmps.replaceAll("_PARAM_", cString)) : Constant.getInstance((String)tmps)) : source;
            }
            result.insertAttribute(attrName, target);
        }
        if (missingEnviron) {
            ListExpr tmpe = new ListExpr();
            tmpe.add((Expr)Constant.getInstance((String)("ParameterValue=\"" + cString + "\"")));
            result.insertAttribute("Environment", (Expr)tmpe);
        }
        JobAd resAd = new JobAd();
        resAd.jobAd = result;
        return resAd;
    }

    private synchronized void checkLock(long st) {
        if (this.status != st) {
            throw new ConcurrentModificationException();
        }
    }

    public synchronized Enumeration getJobEnumeration() throws JobAdException {
        Expr tmpe = this.jobAd.lookup("JobType");
        if (tmpe == null || tmpe.type != 5 || !tmpe.stringValue().equalsIgnoreCase("parametric")) {
            throw new JobAdException("JDL does not contain a parametric job");
        }
        try {
            tmpe = this.jobAd.lookup("Parameters");
            if (tmpe == null) {
                throw new JobAdException("Missing attribute \"Parameters\"");
            }
            if (tmpe.type == 3) {
                int begin = 0;
                int end = tmpe.intValue();
                int step = 1;
                tmpe = this.jobAd.lookup("ParameterStart");
                if (tmpe != null && tmpe.type == 3) {
                    begin = tmpe.intValue();
                }
                if ((tmpe = this.jobAd.lookup("ParameterStep")) != null && tmpe.type == 3) {
                    step = tmpe.intValue();
                }
                if (begin < end && step <= 0 || begin > end && step >= 0) {
                    throw new JobAdException("Wrong parameter range");
                }
                return new ParametricAdEnumeration(begin, end, step, this.status);
            }
            if (tmpe.type != -2) {
                throw new JobAdException("Wrong type for attribute \"Parameters\"");
            }
            ListExpr list = (ListExpr)tmpe;
            String[] pArray = new String[list.size()];
            for (int k = 0; k < list.size(); ++k) {
                pArray[k] = list.sub(k).toString();
            }
            return new ParametricAdEnumeration(pArray, this.status);
        }
        catch (ArithmeticException ex) {
            throw new JobAdException("Wrong parameter range");
        }
    }

    public class ParametricAdEnumeration
    implements Enumeration {
        private int counter;
        private int end;
        private int step;
        private String[] patterns;
        private long lock;

        ParametricAdEnumeration(int begin, int end, int incr, long status) {
            this.counter = begin;
            this.end = end;
            this.step = incr;
            this.lock = status;
            this.patterns = null;
        }

        ParametricAdEnumeration(String[] list, long status) {
            this.patterns = list;
            this.counter = 0;
            this.end = list.length;
            this.step = 1;
            this.lock = status;
        }

        public boolean hasMoreElements() {
            ParametricAd.this.checkLock(this.lock);
            return this.counter < this.end;
        }

        public Object nextElement() {
            if (this.counter >= this.end) {
                throw new NoSuchElementException();
            }
            String tmps = this.patterns == null ? Integer.toString(this.counter) : this.patterns[this.counter];
            JobAd result = ParametricAd.this.cloneWithParameter(tmps, this.lock);
            this.counter += this.step;
            return result;
        }
    }
}

