/*
 * Decompiled with CFR 0.152.
 */
package org.glite.jdl;

import condor.classad.Constant;
import condor.classad.Expr;
import java.text.ParseException;
import java.util.Iterator;
import javax.naming.directory.InvalidAttributeValueException;
import org.glite.jdl.Ad;
import org.glite.jdl.JobAdException;

public class JobState
extends Ad {
    public static String JOBID = "StateId";
    public static String CURRENT = "CurrentStep";
    public static String JOBSTEPS = "JobSteps";
    public static String USERDATA = "UserData";

    public JobState(String state) throws ParseException, JobAdException {
        super(state);
    }

    public JobState() {
    }

    public void setId(String jobId) {
        this.jobAd.insertAttribute(JOBID, (Expr)Constant.getInstance((String)jobId));
    }

    public void check() throws JobAdException {
        String finalException = "";
        Iterator it = this.attributes();
        while (it.hasNext()) {
            try {
                String attrName = (String)it.next();
                this.checkAttribute(attrName, this.lookup(attrName));
            }
            catch (Exception exc) {
                finalException = finalException + exc.getMessage() + "\n";
            }
        }
        if (!finalException.equals("")) {
            throw new JobAdException(finalException.trim());
        }
    }

    public void setAttribute(String attrName, Expr attrValue) throws InvalidAttributeValueException, IllegalArgumentException {
        System.out.println("JobState setAttribute Checking 1 " + attrName);
        this.checkAttribute(attrName, attrValue);
        this.jobAd.insertAttribute(attrName, attrValue);
    }

    public void checkAttribute(String attrName, Expr attrValue) throws InvalidAttributeValueException {
        if (attrName.toLowerCase().equals(JOBID.toLowerCase())) {
            System.out.println("JobState Checking jobid " + attrName);
        } else if (attrName.toLowerCase().equals(CURRENT.toLowerCase())) {
            System.out.println("JobState Checking current " + attrName);
        } else if (attrName.toLowerCase().equals(JOBSTEPS.toLowerCase())) {
            System.out.println("JobState Checking jobsteps " + attrName);
        } else if (attrName.toLowerCase().equals(USERDATA.toLowerCase())) {
            System.out.println("JobState Checking userData " + attrName);
        }
    }
}

