/*
 * Decompiled with CFR 0.152.
 */
package org.glite.jdl;

import condor.classad.AttrName;
import condor.classad.ClassAdParser;
import condor.classad.Constant;
import condor.classad.Expr;
import condor.classad.ListExpr;
import condor.classad.RecordExpr;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.text.ParseException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.naming.directory.InvalidAttributeValueException;
import org.glite.jdl.Ad;
import org.glite.jdl.ExtractFiles;
import org.glite.jdl.Jdl;
import org.glite.jdl.JobAdException;
import org.glite.jdl.JobAdSchema;

public class JobAd
extends Ad {
    static final String sepStr = "$STR$";
    static final String sepInt = "$INT$";
    private static String OpSysSeparator = System.getProperty("file.separator");
    private RecordExpr user;
    private boolean checking = false;
    private boolean throwing = false;
    private String finalExceptionMessage;
    private boolean localAccess = true;
    private JobAdSchema schema;
    private Expr defaultRank;
    private Expr defaultReq;

    public JobAd() {
        if (this.user == null) {
            this.user = new RecordExpr();
        }
    }

    public JobAd(String ad) throws ParseException, JobAdException {
        super(ad);
        if (this.user == null) {
            this.user = new RecordExpr();
        }
    }

    public JobAd(RecordExpr ad) throws JobAdException {
        super(ad);
        if (this.user == null) {
            this.user = new RecordExpr();
        }
    }

    public JobAd copy(RecordExpr source) throws JobAdException {
        JobAd result = new JobAd();
        JobAd.copy(source, result);
        return result;
    }

    public Object clone() {
        JobAd target = new JobAd();
        try {
            JobAd.copy(this.jobAd, target);
        }
        catch (JobAdException jobAdException) {
            // empty catch block
        }
        if (this.schema != null) {
            target.schema = (JobAdSchema)this.schema.clone();
        }
        return target;
    }

    public RecordExpr copyAd() {
        Iterator attrs = this.attributes();
        RecordExpr re = new RecordExpr();
        while (attrs.hasNext()) {
            String attrName = attrs.next().toString();
            re.insertAttribute(attrName, this.jobAd.lookup(attrName));
        }
        return re;
    }

    public boolean hasAttribute(String attrName, String attrValue) {
        return this.hasAttribute(attrName, attrValue, true);
    }

    public boolean hasAttribute(String attrName, String attrValue, boolean unsensitive) {
        try {
            Vector vect = this.getStringValue(attrName);
            for (int i = 0; i < vect.size(); ++i) {
                String tmpValue = (String)vect.get(i);
                if (!(unsensitive ? tmpValue.toLowerCase().equals(attrValue.toLowerCase()) : tmpValue.equals(attrValue))) continue;
                return true;
            }
        }
        catch (Exception exc) {
            return false;
        }
        return false;
    }

    public String toLines() {
        return this.toString(true, true);
    }

    public String toString(boolean multiLines, boolean multiLists) {
        return super.toString(multiLines, multiLists);
    }

    public String toSubmissionString() throws JobAdException {
        String[] attributes = new String[]{};
        this.check(attributes);
        String result = super.toString(false, false);
        this.restore();
        return result;
    }

    public String toString() {
        return super.toString(false, false);
    }

    public void toFile(String filePath) throws Exception {
        Iterator it = this.user.attributes();
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(filePath)));
        out.writeBytes(this.toLines());
        out.close();
    }

    public void setLocalAccess(boolean lookInto) {
        this.localAccess = lookInto;
    }

    void insertAttribute(String attrName, Expr attrValue) throws InvalidAttributeValueException {
        super.setAttribute(attrName, attrValue);
        if (this.user == null) {
            this.user = new RecordExpr();
        }
        if (Jdl.findAttribute(attrName, Jdl.changeAttributes) && !this.checking) {
            this.user.insertAttribute(attrName, attrValue);
        }
    }

    public void setAttribute(String attrName, Expr attrValue) throws InvalidAttributeValueException, IllegalArgumentException {
        if (this.lookup(attrName) != null) {
            throw new IllegalArgumentException(attrName + ": already set attribute");
        }
        if (Jdl.find(attrName)) {
            if (attrValue.type == -2) {
                if (!Jdl.findAttribute(attrName, Jdl.listAttributes)) {
                    throw new IllegalArgumentException(attrName + ": List not allowed");
                }
                ListExpr list = (ListExpr)attrValue;
                for (int j = 0; j < list.size(); ++j) {
                    JobAd.checkSyntax(attrName, list.sub(j));
                }
            } else {
                JobAd.checkSyntax(attrName, attrValue);
            }
        }
        this.insertAttribute(attrName, attrValue);
    }

    public void setAttributeExpr(String attrName, String attrValue) throws IllegalArgumentException, InvalidAttributeValueException {
        JobAd.checkAttributeExpr(attrName, attrValue);
        Expr previous = this.lookup(attrName);
        if (previous != null) {
            throw new IllegalArgumentException(attrName + ": already set attribute");
        }
        attrValue = JobAd.parseStringValue(attrValue);
        ClassAdParser cp = new ClassAdParser(attrValue);
        Expr val = cp.parse();
        this.insertAttribute(attrName, val);
    }

    public void setAttribute(String attrName, int attrValue) throws IllegalArgumentException, InvalidAttributeValueException {
        JobAd.checkAttribute(attrName, attrValue);
        Expr previous = this.lookup(attrName);
        if (previous != null) {
            throw new IllegalArgumentException(attrName + ": already set attribute");
        }
        Constant val = Constant.getInstance((int)attrValue);
        this.insertAttribute(attrName, (Expr)val);
    }

    public void setAttribute(String attrName, String attrValue) throws IllegalArgumentException, InvalidAttributeValueException {
        JobAd.checkAttribute(attrName, attrValue);
        Expr previous = this.lookup(attrName);
        if (previous != null) {
            throw new IllegalArgumentException(attrName + ": already set attribute");
        }
        if (attrName.equals("JobType") || attrName.equals("Type") || attrName.equals("VirtualOrganisation")) {
            attrValue = attrValue.toLowerCase();
        }
        Constant val = Constant.getInstance((String)attrValue);
        this.insertAttribute(attrName, (Expr)val);
    }

    public void setAttribute(String attrName, double attrValue) throws IllegalArgumentException, InvalidAttributeValueException {
        JobAd.checkAttribute(attrName, attrValue);
        Expr previous = this.lookup(attrName);
        if (previous != null) {
            throw new IllegalArgumentException(attrName + ": already set attribute");
        }
        Constant val = Constant.getInstance((double)attrValue);
        this.insertAttribute(attrName, (Expr)val);
    }

    public void setAttribute(String attrName, boolean attrValue) throws IllegalArgumentException, InvalidAttributeValueException {
        JobAd.checkAttribute(attrName, attrValue);
        Expr previous = this.lookup(attrName);
        if (previous != null) {
            throw new IllegalArgumentException(attrName + ": already set");
        }
        if (attrValue) {
            this.insertAttribute(attrName, (Expr)Constant.TRUE);
        } else {
            this.insertAttribute(attrName, (Expr)Constant.FALSE);
        }
    }

    public void addAttribute(String attrName, Ad attrValue) throws IllegalArgumentException, InvalidAttributeValueException {
        JobAd.checkAttribute(attrName, attrValue);
        this.addAttribute(attrName, (Expr)attrValue.jobAd);
    }

    public void addAttribute(String attrName, int attrValue) throws IllegalArgumentException, InvalidAttributeValueException {
        JobAd.checkAttribute(attrName, attrValue);
        Constant val = Constant.getInstance((int)attrValue);
        this.addAttribute(attrName, (Expr)val);
    }

    public void addAttribute(String attrName, double attrValue) throws IllegalArgumentException, InvalidAttributeValueException {
        JobAd.checkAttribute(attrName, attrValue);
        Constant val = Constant.getInstance((double)attrValue);
        this.addAttribute(attrName, (Expr)val);
    }

    public void addAttribute(String attrName, boolean attrValue) throws IllegalArgumentException, InvalidAttributeValueException {
        JobAd.checkAttribute(attrName, attrValue);
        if (attrValue) {
            this.addAttribute(attrName, (Expr)Constant.TRUE);
        } else {
            this.addAttribute(attrName, (Expr)Constant.FALSE);
        }
    }

    public void addAttribute(String attrName, String attrValue) throws IllegalArgumentException, InvalidAttributeValueException {
        JobAd.checkAttribute(attrName, attrValue);
        if (attrName.equals("JobType") || attrName.equals("Type") || attrName.equals("VirtualOrganisation")) {
            attrValue = attrValue.toLowerCase();
        }
        Constant val = Constant.getInstance((String)attrValue);
        this.addAttribute(attrName, (Expr)val);
    }

    private void addAttribute(String attrName, Expr attrValue) throws InvalidAttributeValueException, IllegalArgumentException {
        Expr previous = this.lookup(attrName);
        if (previous == null) {
            this.insertAttribute(attrName, attrValue);
        } else if (previous.type == -2) {
            if (!Jdl.findAttribute(attrName, Jdl.listAttributes) && Jdl.find(attrName)) {
                throw new InvalidAttributeValueException(attrName + ": List not allowed");
            }
            ListExpr valueToAppend = this.appendValue(attrValue, (ListExpr)previous);
            this.insertAttribute(attrName, (Expr)valueToAppend);
        } else if (previous.type == 2 || previous.type == 4 || previous.type == 3 || previous.type == -1 || previous.type == 5) {
            if (!Jdl.findAttribute(attrName, Jdl.listAttributes) && Jdl.find(attrName)) {
                throw new InvalidAttributeValueException(attrName + ": List not allowed");
            }
            Vector<Expr> vect = new Vector<Expr>();
            vect.add(previous);
            vect.add(attrValue);
            this.insertAttribute(attrName, (Expr)new ListExpr(vect));
        } else {
            throw new IllegalArgumentException(attrName + ": unexpected type");
        }
    }

    public String getAttributeExpr(String attrName) throws Exception {
        Expr result = this.lookup(attrName);
        if (Jdl.find(attrName) && !Jdl.findExpr(attrName)) {
            throw new InvalidAttributeValueException(attrName + ": expression value not allowed");
        }
        if (result == null) {
            throw new NoSuchFieldException(attrName + ": attribute has not been set");
        }
        return result.toString();
    }

    public JobAd getJobAdValue(String attrName) throws NoSuchFieldException, IllegalArgumentException, JobAdException {
        Expr value = this.lookup(attrName);
        if (value == null) {
            throw new NoSuchFieldException(attrName + ": attribute has not beenset");
        }
        if (value.type == -1) {
            JobAd result = new JobAd();
            JobAd.copy((RecordExpr)value, result);
            return result;
        }
        throw new IllegalArgumentException(attrName + ": attribute type is not a JobAd instance");
    }

    public String getString(String attrName) throws NoSuchFieldException, IllegalArgumentException, InvalidAttributeValueException {
        if (Jdl.findAttribute(attrName, Jdl.listAttributes)) {
            throw new InvalidAttributeValueException(attrName + ": List not allowed, please use getStringValue method");
        }
        return (String)this.getStringValue(attrName).get(0);
    }

    public int getInt(String attrName) throws NoSuchFieldException, IllegalArgumentException, InvalidAttributeValueException {
        if (Jdl.findAttribute(attrName, Jdl.listAttributes)) {
            throw new InvalidAttributeValueException(attrName + ": List not allowed, please use getIntValue method");
        }
        return (Integer)this.getIntValue(attrName).get(0);
    }

    public boolean getBoolean(String attrName) throws NoSuchFieldException, IllegalArgumentException, InvalidAttributeValueException {
        if (Jdl.findAttribute(attrName, Jdl.listAttributes)) {
            throw new InvalidAttributeValueException(attrName + ": List not allowed, please use getBooleanValue method");
        }
        return (Boolean)this.getIntValue(attrName).get(0);
    }

    public double getDouble(String attrName) throws NoSuchFieldException, IllegalArgumentException, InvalidAttributeValueException {
        if (Jdl.findAttribute(attrName, Jdl.listAttributes)) {
            throw new InvalidAttributeValueException(attrName + ": List not allowed, please use getDoubleValue method");
        }
        return (Double)this.getIntValue(attrName).get(0);
    }

    public void delAttribute(String attrName) throws NoSuchFieldException {
        if (this.hasAttribute(attrName)) {
            Iterator attributes = this.jobAd.attributes();
            while (attributes.hasNext()) {
                String attr = attributes.next().toString();
                if (!attrName.toLowerCase().equals(attr.toLowerCase())) continue;
                attrName = new String(attr);
                break;
            }
            this.jobAd.removeAttribute(AttrName.fromString((String)attrName));
            if (this.user.lookup(attrName) != null && !this.checking) {
                this.user.removeAttribute(AttrName.fromString((String)attrName));
            }
        } else {
            throw new NoSuchFieldException(attrName + ": attribute not set, unable to remove");
        }
    }

    public void clear() {
        this.jobAd = new RecordExpr();
        this.user = new RecordExpr();
    }

    private void restore() {
        Iterator it = this.user.attributes();
        while (it.hasNext()) {
            String attrName = it.next().toString();
            try {
                this.jobAd.removeAttribute(AttrName.fromText((String)attrName));
            }
            catch (Exception exc) {
                // empty catch block
            }
            this.jobAd.insertAttribute(attrName, this.user.lookup(attrName));
        }
        String[] specials = new String[]{"DefaultRank", "Environment", "Type", "JobType"};
        for (int i = 0; i < specials.length; ++i) {
            if (this.user.lookup(specials[i]) != null) continue;
            try {
                this.jobAd.removeAttribute(AttrName.fromText((String)specials[i]));
                continue;
            }
            catch (Exception exc) {
                // empty catch block
            }
        }
    }

    public void checkAll() throws JobAdException {
        String[] attributes = new String[]{};
        this.checkAll(attributes);
    }

    public void checkAll(String[] attributes) throws JobAdException {
        this.check(attributes);
        this.restore();
    }

    private void check(String[] attributes) throws JobAdException {
        this.checking = true;
        if (this.schema == null) {
            this.schema = JobAdSchema.glueSchema();
        }
        this.finalExceptionMessage = new String();
        try {
            this.checkSemantic(attributes);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        this.checking = false;
        if (!this.finalExceptionMessage.equals("")) {
            throw new JobAdException(this.finalExceptionMessage.trim());
        }
    }

    private void checkRank() throws Exception {
        String DAC = this.schema.get(0).toLowerCase();
        String rank = this.getAttributeExpr("rank");
        if (rank.toLowerCase().indexOf(DAC) != -1) {
            if (!this.hasAttribute("DataAccessProtocol") || !this.hasAttribute("InputData")) {
                this.throwCheck(new JobAdException("DataAccessProtocol,InputData: Both attributes must be specified when Rank = other.DataAccessCost"));
            } else if (rank.indexOf("+") != -1 || rank.indexOf("-") != -1 || rank.indexOf("*") != -1 || rank.indexOf("/") != -1) {
                this.throwCheck(new JobAdException("rank: other.DataAccessCost is a stand alone value, no other values are allowed"));
            }
        }
    }

    private void checkJobType(Vector vectType) throws Exception {
        boolean jobType = true;
        boolean req = this.hasAttribute("requirements");
        String requirements = "";
        String rank = "";
        if (this.hasAttribute("ListenerPort") && !this.hasAttribute("JobType", "interactive")) {
            throw new JobAdException("ListenerPort: attribute cannot be specified with non INTERACTIVE jobs");
        }
        if (this.hasAttribute("JobSteps") && !this.hasAttribute("JobType", "checkpointable") && !this.hasAttribute("JobType", "partitionable")) {
            throw new JobAdException("JobSteps: attribute can be specified either for PARTITIONABLE or CHECKPOINTABLE jobs");
        }
        if (this.hasAttribute("CurrentStep") && !this.hasAttribute("JobType", "checkpointable") && !this.hasAttribute("JobType", "partitionable")) {
            throw new JobAdException("CurrentStep: attribute cannot be specified with non CHECKPOINTABLE jobs");
        }
        if (this.hasAttribute("JobType", "mpich")) {
            Expr cn = this.lookup("CpuNumber");
            boolean isCpuNumb = true;
            if (cn == null) {
                isCpuNumb = false;
                Expr nn = this.lookup("NodeNumber");
                if (nn == null) {
                    throw new JobAdException("JobType:  CpuNumberattribute must be specified with MPICH jobs");
                }
            }
            if (req) {
                requirements = "(" + this.getAttributeExpr("requirements") + ")" + "  && Member( \"MPICH\", " + this.schema.get(1) + ")" + " && " + this.schema.get(2) + " >= " + (isCpuNumb ? "CpuNumber" : "NodeNumber");
                this.delAttribute("requirements");
                this.setAttributeExpr("requirements", requirements);
            }
            if (!this.hasAttribute("rank")) {
                this.setAttributeExpr("rank", this.schema.get(3));
            }
        } else if (this.hasAttribute("JobType", "interactive")) {
            if (this.hasAttribute("StdInput") || this.hasAttribute("StdOutput") || this.hasAttribute("StdError")) {
                throw new JobAdException("StdInput/Output/Error: attributes cannot be specified for interactive jobs");
            }
            if (req) {
                requirements = "(" + this.getAttributeExpr("requirements") + ")  && " + this.schema.get(4);
                this.delAttribute("requirements");
                this.setAttributeExpr("requirements", requirements);
            }
        } else if (this.hasAttribute("JobType", "checkpointable")) {
            if (this.hasAttribute("JobSteps")) {
                if (this.hasAttribute("CurrentStep")) {
                    int current = this.getInt("CurrentStep");
                    if (this.getType("JobSteps") == 3) {
                        if (current < 0) {
                            throw new JobAdException("CurrentStepThe value cannot be less than 0");
                        }
                        Vector steps = this.getIntValue("JobSteps");
                        if (current > (Integer)this.getIntValue("JobSteps").get(0)) {
                            throw new JobAdException("CurrentStep: The value cannot be greater than the value specified in JobSteps");
                        }
                    } else if (this.getType("JobSteps") == 5) {
                        if (current < 1) {
                            throw new JobAdException("CurrentStep: The value cannot be less than 1");
                        }
                        Vector steps = this.getStringValue("JobSteps");
                        if (current > steps.size()) {
                            throw new JobAdException("CurrentStep: The value cannot be greater then or equal to the number of steps specified in JobSteps");
                        }
                    }
                } else {
                    this.setAttribute("CurrentStep", 1);
                }
            } else if (this.hasAttribute("CurrentStep")) {
                throw new JobAdException("CurrentStep: attribute must not be specified without JobSteps");
            }
        }
    }

    static void checkAttribute(String attrName, int attrValue) throws InvalidAttributeValueException {
        if (Jdl.find(attrName)) {
            if (!Jdl.findInt(attrName) && !Jdl.findDouble(attrName)) {
                throw new InvalidAttributeValueException(attrName + ": mismatch value, cannot be an integer");
            }
            if (attrValue < 0) {
                throw new InvalidAttributeValueException(attrName + ": must be greater or equal to zero (" + attrValue + ")");
            }
            if ((attrName.equals("NodeNumber") || attrName.equals("CpuNumber")) && attrValue < 2) {
                throw new InvalidAttributeValueException(attrName + ": value must be greater than 1 (" + attrValue + ")");
            }
        }
    }

    static void checkAttribute(String attrName, double attrValue) throws InvalidAttributeValueException {
        if (Jdl.find(attrName) && !Jdl.findDouble(attrName)) {
            throw new InvalidAttributeValueException(attrName + ": mismatch value, cannot be a double");
        }
    }

    static void checkAttribute(String attrName, boolean attrValue) throws InvalidAttributeValueException {
        if (Jdl.find(attrName) && !Jdl.findBool(attrName)) {
            throw new InvalidAttributeValueException(attrName + ": mismatch value, cannot be a boolean");
        }
    }

    static void checkAttribute(String attrName, Ad attrValue) throws InvalidAttributeValueException {
        block14: {
            if (Jdl.find(attrName)) {
                if (!Jdl.findAd(attrName)) {
                    throw new InvalidAttributeValueException(attrName + ": mismatch value, cannot be an Expression");
                }
                if (Jdl.compare(attrName, "OutputData")) {
                    try {
                        if (attrValue.getType("OutputFile") != 5) {
                            throw new InvalidAttributeValueException(attrName + "." + "OutputFile" + ": mismatch value, String expected");
                        }
                        if (attrValue.hasAttribute("LogicalFileName") && attrValue.getType("LogicalFileName") != 5) {
                            throw new InvalidAttributeValueException(attrName + "." + "LogicalFileName" + ": mismatch value, String expected");
                        }
                        if (attrValue.hasAttribute("StorageElement") && attrValue.getType("StorageElement") != 5) {
                            throw new InvalidAttributeValueException(attrName + "." + "StorageElement" + ": mismatch value, String expected");
                        }
                        break block14;
                    }
                    catch (NoSuchFieldException exc) {
                        throw new InvalidAttributeValueException(attrName + "." + exc.getMessage());
                    }
                }
                if (Jdl.compare(attrName, "UserTags")) {
                    Iterator attrs = attrValue.attributes();
                    try {
                        while (attrs.hasNext()) {
                            String attr = attrs.next().toString();
                            if (attrValue.getType(attr) == 5) continue;
                            throw new InvalidAttributeValueException("UserTags." + attr + ": mismatch value, String expected");
                        }
                    }
                    catch (NoSuchFieldException exc) {
                        exc.printStackTrace();
                        throw new RuntimeException(attrName + ": Fatal attribute value filled.");
                    }
                } else if (Jdl.compare(attrName, "JobState")) {
                    // empty if block
                }
            }
        }
    }

    static void checkAttributeExpr(String attrName, String attrValue) throws InvalidAttributeValueException {
        if (Jdl.find(attrName) && !Jdl.findExpr(attrName)) {
            throw new InvalidAttributeValueException(attrName + ": mismatch value, cannot be an Expression");
        }
    }

    static void checkAttribute(String attrName, String attrValue) throws InvalidAttributeValueException {
        if (Jdl.find(attrName)) {
            if (!Jdl.findString(attrName)) {
                throw new InvalidAttributeValueException(attrName + ": mismatch value, cannot be a String");
            }
            String errMsgStr = attrName + ": wrong value for " + attrValue + ".\nThe right format is: ";
            if (Jdl.compare(attrName, "SubmitTo")) {
                String[] format = new String[]{sepStr, ":", sepInt, "/", sepStr, "-", sepStr, "-", sepStr};
                if (!JobAd.checkFormat(format, attrValue)) {
                    throw new InvalidAttributeValueException(errMsgStr + "<full-hostname>:<port-number>/jobmanager-<service>-<queuename>");
                }
            } else if (Jdl.compare(attrName, "Environment")) {
                String[] format = new String[]{sepStr, "=", sepStr};
                if (!JobAd.checkFormat(format, attrValue)) {
                    throw new InvalidAttributeValueException(errMsgStr + "<variable>=<value>");
                }
            } else if (Jdl.compare(attrName, "InputSandbox")) {
                if (attrValue.indexOf("/") != -1 && attrValue.indexOf("\\") != -1) {
                    throw new InvalidAttributeValueException(attrName + ": wrong value for " + attrValue + ". Two different system operator's separators checked");
                }
            } else if (Jdl.compare(attrName, "StdInput") || Jdl.compare(attrName, "Executable")) {
                if (!ExtractFiles.isAbsolute(attrValue) && attrValue.indexOf(OpSysSeparator) != -1) {
                    throw new InvalidAttributeValueException(errMsgStr + "<absolute path>|<simple file name>");
                }
            } else if (Jdl.compare(attrName, "InputData")) {
                String[] format_lfn = new String[]{"lfn:", sepStr};
                String[] format_guid = new String[]{"guid:", sepStr};
                String[] format_si_lfn = new String[]{"si-lfn:", sepStr};
                String[] format_si_guid = new String[]{"si-guid:", sepStr};
                if (!(JobAd.checkFormat(format_lfn, attrValue) || JobAd.checkFormat(format_guid, attrValue) || JobAd.checkFormat(format_si_lfn, attrValue) || JobAd.checkFormat(format_si_guid, attrValue))) {
                    throw new InvalidAttributeValueException(errMsgStr + "lfn | guid | si-lfn | si-guid :<value>");
                }
            } else if (Jdl.compare(attrName, "UserContact")) {
                int at = 0;
                int ind = attrValue.indexOf("@");
                while (ind != -1) {
                    ++at;
                    ind = attrValue.indexOf("@", ind + 1);
                }
                if (at != 1) {
                    throw new InvalidAttributeValueException(errMsgStr + "<user>@<host domain>");
                }
            } else if (Jdl.compare(attrName, "JobType")) {
                if (!(Jdl.compare(attrValue, "mpich") || Jdl.compare(attrValue, "normal") || Jdl.compare(attrValue, "partitionable") || Jdl.compare(attrValue, "multiple") || Jdl.compare(attrValue, "checkpointable") || Jdl.compare(attrValue, "interactive") || Jdl.compare(attrValue, "parametric"))) {
                    throw new InvalidAttributeValueException(errMsgStr + "mpich | normal | partitionable | multiple | checkpointable | parametric");
                }
            } else if (Jdl.compare(attrName, "StdOutput") || Jdl.compare(attrName, "StdError") || Jdl.compare(attrName, "OutputSandbox")) {
                if (attrValue.startsWith("..")) {
                    throw new InvalidAttributeValueException(attrName + ": relative path are allowed only when directory name are specified");
                }
            } else if (Jdl.compare(attrName, "StdOutput") || Jdl.compare(attrName, "StdError") || Jdl.compare(attrName, "StdInput") || Jdl.compare(attrName, "Executable")) {
                String[] format = new String[]{"*", "[", "]", "?", "{", "}"};
                ExtractFiles.checkString(attrName, attrValue, format);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean checkFormat(String[] format, String value) {
        int index = 0;
        int last = 0;
        String previous = "";
        for (int i = 0; i < format.length; ++i) {
            if (format[i].equals(sepStr) || format[i].equals(sepInt)) {
                if (!previous.equals("")) return false;
                previous = format[i];
            } else {
                block11: {
                    if ((index = value.indexOf(format[i], index) + format[i].length()) < format[i].length()) {
                        return false;
                    }
                    if (index == format[i].length()) {
                        if (!previous.equals("")) {
                            return false;
                        }
                    } else {
                        if (previous.equals("")) {
                            return false;
                        }
                        try {
                            Integer.parseInt(value.substring(last, index - format[i].length()));
                            if (previous.equals(sepStr)) {
                                return false;
                            }
                        }
                        catch (NumberFormatException exc) {
                            if (!previous.equals(sepInt)) break block11;
                            return false;
                        }
                    }
                }
                previous = "";
            }
            last = index;
        }
        return true;
    }

    static void checkSyntax(String attrName, Expr value) throws InvalidAttributeValueException, IllegalArgumentException {
        if (value.type == 1) {
            throw new IllegalArgumentException(attrName + ": syntax error, unable to parse the value");
        }
        if (value.type == 5) {
            JobAd.checkAttribute(attrName, ((Constant)value).stringValue());
        } else if (value.type == 4) {
            JobAd.checkAttribute(attrName, ((Constant)value).realValue());
        } else if (value.type == 3) {
            JobAd.checkAttribute(attrName, ((Constant)value).intValue());
        } else if (value.type == 2) {
            JobAd.checkAttribute(attrName, ((Constant)value).isTrue());
        } else if (value.type == -1) {
            try {
                JobAd.checkAttribute(attrName, new Ad((RecordExpr)value));
            }
            catch (JobAdException exc) {
                exc.printStackTrace();
                throw new InvalidAttributeValueException(attrName + ": Fatal Error caught");
            }
        } else if (!Jdl.findExpr(attrName)) {
            throw new InvalidAttributeValueException(attrName + ": expression type not allowed");
        }
    }

    private void throwCheck(Exception exc) {
        if (exc.getMessage() != null) {
            this.finalExceptionMessage = this.finalExceptionMessage + "- " + exc.getMessage() + "\n";
        } else {
            exc.printStackTrace();
        }
    }

    public void setSchema(JobAdSchema schema) {
        this.schema = schema;
    }

    public void setDefaultRank(String attrValue) {
        attrValue = JobAd.parseStringValue(attrValue);
        ClassAdParser cp = new ClassAdParser(attrValue);
        this.defaultRank = cp.parse();
    }

    public void setDefaultRequirements(String attrValue) {
        attrValue = JobAd.parseStringValue(attrValue);
        ClassAdParser cp = new ClassAdParser(attrValue);
        this.defaultReq = cp.parse();
    }

    private void checkSemantic(String[] attributes) throws Exception {
        Vector extracted;
        boolean execFound = false;
        boolean stdInputFound = false;
        String exec = "";
        String stdInput = "";
        if (Jdl.findAttribute("Type", attributes) || attributes.length == 0) {
            if (this.hasAttribute("Type")) {
                String type = this.getString("Type").toLowerCase();
                if (!type.equals("job")) {
                    this.throwCheck(new JobAdException("Type: '" + type + "' is not allowed for JobAd"));
                }
                this.delAttribute("Type");
                this.setAttribute("Type", type);
            } else {
                this.setAttribute("Type", "job");
            }
        }
        if (Jdl.findAttribute("Executable", attributes) || attributes.length == 0) {
            if (this.hasAttribute("Executable")) {
                exec = this.getString("Executable");
                execFound = false;
                if (ExtractFiles.isAbsolute(exec)) {
                    execFound = true;
                } else if (exec.equals(ExtractFiles.getName(exec))) {
                    execFound = true;
                }
            } else {
                this.throwCheck(new NoSuchFieldException("Executable: mandatory attribute not set"));
            }
        }
        if ((Jdl.findAttribute("VirtualOrganisation", attributes) || attributes.length == 0) && !this.hasAttribute("VirtualOrganisation")) {
            this.throwCheck(new NoSuchFieldException("VirtualOrganisation: mandatory attribute not set"));
        }
        if ((Jdl.findAttribute("StdInput", attributes) || attributes.length == 0) && this.hasAttribute("StdInput") && ExtractFiles.isAbsolute(stdInput = this.getString("StdInput"))) {
            stdInputFound = true;
        }
        if ((Jdl.findAttribute("InputSandbox", attributes) || attributes.length == 0) && this.hasAttribute("InputSandbox") && this.localAccess) {
            try {
                this.extractFiles("InputSandbox");
            }
            catch (Exception exc) {
                this.throwCheck(exc);
            }
            if (!stdInputFound || !execFound) {
                extracted = this.getStringValue("InputSandbox");
                for (int i = 0; i < extracted.size(); ++i) {
                    String extr = extracted.get(i).toString();
                    if (extr.endsWith(exec)) {
                        execFound = true;
                    }
                    if (!extr.endsWith(stdInput)) continue;
                    stdInputFound = true;
                }
            }
        }
        if (this.localAccess) {
            if ((Jdl.findAttribute("Executable", attributes) && Jdl.findAttribute("InputSandbox", attributes) || attributes.length == 0) && !execFound && this.hasAttribute("Executable")) {
                this.throwCheck(new NoSuchFieldException("Executable: file is not listed in InputSandbox"));
            }
            if ((Jdl.findAttribute("StdInput", attributes) && Jdl.findAttribute("InputSandbox", attributes) || attributes.length == 0) && !stdInputFound && this.hasAttribute("StdInput")) {
                this.throwCheck(new NoSuchFieldException("StdInput: file is not listed in InputSandbox"));
            }
        }
        if ((Jdl.findAttribute("StdOutput", attributes) && Jdl.findAttribute("StdError", attributes) || attributes.length == 0) && this.hasAttribute("StdOutput") && this.hasAttribute("StdError")) {
            String stdOutput = this.getString("StdOutput");
            String stdError = this.getString("StdError");
            if (ExtractFiles.getName(stdOutput).equals(ExtractFiles.getName(stdError)) && !stdOutput.equals(stdError)) {
                this.throwCheck(new IllegalArgumentException("StdOutput,StdError: if same file then paths must be equal"));
            }
        }
        if ((Jdl.findAttribute("OutputSandbox", attributes) || attributes.length == 0) && this.hasAttribute("OutputSandbox")) {
            extracted = this.getStringValue("OutputSandbox");
            HashSet<String> outSboxMap = new HashSet<String>();
            HashSet<String> outSboxDupli = new HashSet<String>();
            for (int i = 0; i < extracted.size(); ++i) {
                String outputSimple = new File(extracted.get(i).toString()).getName();
                if (outSboxMap.add(outputSimple)) continue;
                outSboxDupli.add(outputSimple);
            }
            if (!outSboxDupli.isEmpty()) {
                Iterator it = outSboxDupli.iterator();
                String exceptionMessage = new String();
                while (it.hasNext()) {
                    exceptionMessage = exceptionMessage + "\n- OutputSandbox: filename conflict found. The following file is repeated more than once: " + it.next();
                }
                this.throwCheck(new JobAdException(exceptionMessage.trim().substring(2)));
            }
        }
        if (Jdl.findAttribute("InputData", attributes) && Jdl.findAttribute("DataAccessProtocol", attributes) || attributes.length == 0) {
            boolean id = this.hasAttribute("InputData");
            boolean dp = this.hasAttribute("DataAccessProtocol");
            if (!(!id && !dp || id && dp)) {
                String errStr = "InputData, DataAccessProtocol";
                this.throwCheck(new IllegalArgumentException(errStr + ": attributes must be specified all togheter"));
            }
        }
        if ((Jdl.findAttribute("UserContact", attributes) || attributes.length == 0) && this.hasAttribute("UserContact")) {
            Vector ctVect = this.getStringValue("UserContact");
            String contact = ctVect.get(0).toString();
            for (int i = 1; i < ctVect.size(); ++i) {
                contact = contact + "," + ctVect.get(i);
            }
            this.jobAd.removeAttribute(AttrName.fromText((String)"UserContact"));
            this.jobAd.insertAttribute("UserContact", (Expr)Constant.getInstance((String)contact));
        }
        if (Jdl.findAttribute("JobType", attributes) || attributes.length == 0) {
            if (this.hasAttribute("JobType")) {
                try {
                    Vector jtvect = this.getStringValue("JobType");
                    this.jobAd.removeAttribute(AttrName.fromText((String)"JobType"));
                    for (int i = 0; i < jtvect.size(); ++i) {
                        jtvect.add(i, jtvect.remove(i).toString().toLowerCase());
                        this.addAttribute("JobType", jtvect.get(i).toString());
                    }
                    this.checkJobType(jtvect);
                }
                catch (Exception exc) {
                    this.throwCheck(exc);
                }
            } else {
                this.setAttribute("JobType", "normal");
            }
        }
        if ((Jdl.findAttribute("requirements", attributes) || attributes.length == 0) && !this.hasAttribute("requirements")) {
            if (this.defaultReq != null) {
                this.insertAttribute("requirements", this.defaultReq);
            } else {
                this.throwCheck(new NoSuchFieldException("requirements: mandatory attribute not set"));
            }
        }
        if (Jdl.findAttribute("rank", attributes) || attributes.length == 0) {
            if (!this.hasAttribute("rank")) {
                if (this.defaultRank != null) {
                    this.insertAttribute("rank", this.defaultRank);
                    this.checkRank();
                } else {
                    this.throwCheck(new NoSuchFieldException("rank: mandatory attribute not set"));
                }
            } else {
                this.checkRank();
            }
        }
        if ((Jdl.findAttribute("DefaultRank", attributes) || attributes.length == 0) && !this.hasAttribute("DefaultRank")) {
            this.setAttributeExpr("DefaultRank", "-other.GlueCEStateEstimatedResponseTime");
        }
    }

    private void extractFiles(String attrName) throws JobAdException, NoSuchFieldException {
        ExtractFiles eFiles = new ExtractFiles(this.getStringValue(attrName));
        Vector extractedFiles = eFiles.getMatchingFiles();
        Vector<Constant> exprFiles = new Vector<Constant>();
        for (int i = 0; i < extractedFiles.size(); ++i) {
            exprFiles.add(Constant.getInstance((String)extractedFiles.get(i).toString()));
        }
        if (extractedFiles.size() != 0) {
            this.delAttribute(attrName);
            this.jobAd.insertAttribute(attrName, (Expr)new ListExpr(exprFiles));
        }
        eFiles.check(attrName);
    }
}

