/*
 * Decompiled with CFR 0.152.
 */
package org.glite.jdl;

import java.io.File;
import java.io.FilenameFilter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.directory.InvalidAttributeValueException;
import org.glite.jdl.JobAdException;

public class ExtractFiles
implements FilenameFilter {
    private Vector inputFiles;
    private Vector extractedFiles;
    private HashSet duplicates;
    private HashSet matches;
    private Pattern pattern;
    private String sep = System.getProperty("file.separator");
    private String expr;
    HashSet hSet;

    public ExtractFiles() {
        this.extractedFiles = new Vector();
        this.hSet = new HashSet();
        this.duplicates = new HashSet();
        this.matches = new HashSet();
        this.inputFiles = new Vector();
    }

    public ExtractFiles(String file) {
        this();
        this.inputFiles = new Vector();
        this.inputFiles.add(file);
    }

    public ExtractFiles(Vector files) {
        this();
        this.inputFiles = files;
    }

    public Vector getMatchingFiles() {
        String operatingSystem = System.getProperty("os.name");
        String absDir = operatingSystem.equals("Linux") || operatingSystem.equals("Solaris") || operatingSystem.equals("SunOS") || operatingSystem.equals("Digital Unix") || operatingSystem.equals("Unix") ? new String(new File("").getAbsolutePath()) : new String(new File("").getAbsolutePath());
        for (int it = 0; it < this.inputFiles.size(); ++it) {
            String filter;
            String dir;
            String expr = (String)this.inputFiles.get(it);
            int separator = expr.lastIndexOf(this.sep);
            if (separator >= expr.length() - 1) {
                dir = new String(expr.substring(0, separator));
                filter = new String("");
            } else if (separator >= 0) {
                dir = expr.substring(0, separator + 1);
                filter = new String(expr.substring(separator + 1));
                if (!new File(dir).isAbsolute()) {
                    dir = absDir + this.sep + dir + this.sep;
                }
            } else {
                filter = new String(expr);
                dir = absDir;
            }
            this.generatePattern(filter);
            this.extractFiles(new File(dir));
        }
        return this.extractedFiles;
    }

    public void check(String name) throws JobAdException {
        String exceptionMessage = new String();
        Iterator it = this.matches.iterator();
        while (it.hasNext()) {
            exceptionMessage = exceptionMessage + "\n- " + name + ": unable to find any match for the following path:\n" + it.next();
        }
        it = this.duplicates.iterator();
        while (it.hasNext()) {
            exceptionMessage = exceptionMessage + "\n- " + name + ": filename conflict found while extracting files. The following file is repeated more than once: " + it.next();
        }
        if (this.matches.size() + this.duplicates.size() != 0) {
            throw new JobAdException(exceptionMessage.trim().substring(2));
        }
    }

    public HashSet getNoMatchingFiles() {
        return this.matches;
    }

    public HashSet getDuplicateFiles() {
        return this.duplicates;
    }

    private Vector extractFiles(File dir) {
        File[] tmp = dir.listFiles(this);
        if (tmp == null || tmp.length == 0) {
            String tail = "";
            if (!dir.getAbsolutePath().endsWith(this.sep)) {
                tail = this.sep;
            }
            this.matches.add(dir.getAbsolutePath() + tail + this.expr);
            this.extractedFiles.add(dir.getAbsolutePath() + tail + this.expr);
            return this.extractedFiles;
        }
        for (int i = 0; i < tmp.length; ++i) {
            File file = tmp[i];
            if (file.isFile()) {
                if (!this.hSet.add(file.getName())) {
                    this.duplicates.add(file.getName());
                }
                this.extractedFiles.add(file.getAbsolutePath());
                continue;
            }
            if (!file.isDirectory() || file.listFiles().length == 0) continue;
            this.extractFiles(file);
        }
        return this.extractedFiles;
    }

    public boolean accept(File dir, String name) {
        Matcher match = this.pattern.matcher(name);
        return match.matches();
    }

    private void generatePattern(String filter) {
        this.expr = new String(filter);
        int index = filter.indexOf("\\");
        String toReplace = "\\\\";
        while (index != -1) {
            filter = filter.substring(0, index) + toReplace + filter.substring(index + 1);
            index = filter.indexOf("\\", index + 2);
        }
        index = filter.indexOf(".");
        toReplace = "\\x2E";
        while (index != -1) {
            filter = filter.substring(0, index) + toReplace + filter.substring(index + 1);
            index = filter.indexOf(".", index + 1);
        }
        index = filter.indexOf("*");
        toReplace = ".*";
        while (index != -1) {
            filter = filter.substring(0, index) + toReplace + filter.substring(index + 1);
            index = filter.indexOf("*", index + 2);
        }
        int fpar = filter.indexOf("{");
        int lpar = filter.indexOf("}");
        while (fpar + lpar != -2) {
            index = filter.indexOf(",");
            toReplace = "|";
            while (index != -1) {
                if (index > fpar && index < lpar) {
                    filter = filter.substring(0, index) + toReplace + filter.substring(index + 1);
                }
                index = filter.indexOf(",", index + 1);
            }
            filter = filter.substring(0, fpar) + "(" + filter.substring(fpar + 1, lpar) + ")" + filter.substring(lpar + 1);
            fpar = filter.indexOf("{");
            lpar = filter.indexOf("}");
        }
        index = filter.indexOf("?");
        toReplace = ".";
        while (index != -1) {
            filter = filter.substring(0, index) + toReplace + filter.substring(index + 1);
            index = filter.indexOf("?", index + 1);
        }
        this.pattern = Pattern.compile(filter);
    }

    static void checkString(String attrName, String attrValue, String[] forbidden) throws InvalidAttributeValueException {
        for (int i = 0; i < forbidden.length; ++i) {
            if (attrValue.indexOf(forbidden[i]) == -1) continue;
            throw new InvalidAttributeValueException(attrName + ": wrong value for" + attrValue + ".Character '" + forbidden[i] + "' is not allowed");
        }
    }

    public static String getName(String path) {
        int indexBackSlash = path.lastIndexOf("\\");
        int indexSlash = path.lastIndexOf("/");
        if (path.lastIndexOf("\\") != -1 && path.lastIndexOf("/") != -1) {
            return null;
        }
        String name1 = "";
        String name2 = "";
        int prefixLength = ExtractFiles.getPrefixLength(path);
        name1 = indexBackSlash < prefixLength ? path.substring(prefixLength) : path.substring(indexBackSlash + 1);
        prefixLength = ExtractFiles.getPrefixLength(path);
        name2 = indexSlash < prefixLength ? path.substring(prefixLength) : path.substring(indexSlash + 1);
        return name1.length() < name2.length() ? name1 : name2;
    }

    private static int getPrefixLength(String path) {
        if (path.length() == 0) {
            return 0;
        }
        return path.charAt(0) == '/' ? 1 : 0;
    }

    public static boolean isAbsolute(String path) {
        int length = path.length();
        if (length == 0) {
            return false;
        }
        if (path.charAt(0) == '$') {
            return true;
        }
        if (path.charAt(0) == '\\') {
            return path.indexOf("/") == -1;
        }
        if (path.charAt(0) == '/') {
            return path.indexOf("\\") == -1;
        }
        return length >= 3 && Character.isLetter(path.charAt(0)) && path.charAt(1) == ':' && path.charAt(2) == '\\' && path.indexOf("/") == -1;
    }
}

