/*
 * Decompiled with CFR 0.152.
 */
package org.glite.jdl;

import condor.classad.Constant;
import condor.classad.Expr;
import condor.classad.ListExpr;
import condor.classad.RecordExpr;
import java.text.ParseException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import org.glite.jdl.Ad;
import org.glite.jdl.JobAdException;
import org.glite.jdl.Node;

public class DagAd
extends Ad {
    public static int STRING_CURRENT = 0;
    public static int STRING_SUBMISSION = 1;
    public static int STRING_NO_NODES = 2;
    public static int STRING_MULTI_LINES = 3;
    private Ad nodes;
    private HashMap cycleJobs;
    private HashMap dependencies = new HashMap();

    public String toString(int level) {
        switch (level) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            default: {
                return "";
            }
        }
        return "DagAd ToString:\n\n" + this.jobAd.toString();
    }

    public void addNode(Node node) throws Exception {
        if (this.nodes.lookup(node.name) != null) {
            throw new JobAdException("The node \"" + node.name + "\" already exists");
        }
    }

    public void removeNode(String node) throws NoSuchFieldException {
        if (this.nodes.lookup(node) == null) {
            throw new NoSuchFieldException("Unknown node: \"" + node + "\"");
        }
        this.nodes.delAttribute(node);
    }

    private void addArc(String jobFather, String jobSon) throws Exception {
        Vector<Object> depList = new Vector<Object>();
        ListExpr depExpr = (ListExpr)this.nodes.lookup("Dependencies");
        if (depExpr != null) {
            for (int i = 0; i < depExpr.size(); ++i) {
                depList.add(depExpr.sub(i));
            }
        }
        Vector<Constant> vect = new Vector<Constant>();
        vect.add(Constant.getInstance((String)jobFather));
        vect.add(Constant.getInstance((String)jobSon));
        ListExpr exprToAdd = new ListExpr(vect);
        depList.add(exprToAdd);
        this.nodes.setAttribute("Dependencies", (Expr)new ListExpr(depList));
    }

    public void addDependency(String jobFather, String jobSon) throws NoSuchFieldException, JobAdException, Exception {
        if (jobFather.equals(jobSon)) {
            throw new NoSuchFieldException("Unable to add a dependency with two equal nodes (" + jobFather + ")");
        }
        if (this.nodes.lookup(jobFather) == null) {
            throw new NoSuchFieldException("Unknown node: \"" + jobFather + "\"");
        }
        if (this.nodes.lookup(jobSon) == null) {
            throw new NoSuchFieldException("Unknown node: \"" + jobSon + "\"");
        }
        HashSet<String> hSet = (HashSet<String>)this.dependencies.get(jobFather);
        if (hSet == null) {
            hSet = new HashSet<String>();
            hSet.add(jobSon);
            this.dependencies.put(jobFather, hSet);
            this.addArc(jobFather, jobSon);
        } else {
            if (hSet.contains(jobSon)) {
                throw new JobAdException("The dependency \"" + jobFather + "-\"" + jobSon + "\" already exists");
            }
            hSet.add(jobSon);
            this.addArc(jobFather, jobSon);
        }
    }

    public void removeDependency(String jobFather, String jobSon) throws NoSuchFieldException {
        HashSet hSet = (HashSet)this.dependencies.get(jobFather);
        if (hSet == null) {
            throw new NoSuchFieldException("Unknown node: \"" + jobFather + "\"");
        }
        if (!hSet.remove(jobSon)) {
            throw new NoSuchFieldException("Unknown node: \"" + jobSon + "\"");
        }
    }

    private void setNodes(RecordExpr attrValue) {
        Iterator it = attrValue.attributes();
        while (it.hasNext()) {
            String nodeName = (String)it.next();
            if (attrValue.lookup((String)nodeName).type == -1) continue;
            throw new IllegalArgumentException(nodeName + ": Must be a of classad type");
        }
    }

    public void setAttribute(String attrName, Expr attrValue) throws IllegalArgumentException {
        if (this.lookup(attrName) != null) {
            throw new IllegalArgumentException(attrName + ": already set attribute");
        }
        if (attrName.toLowerCase().equals("Nodes".toLowerCase())) {
            if (attrValue.type != -1) {
                throw new IllegalArgumentException(attrName + ": Must be a of classad type");
            }
            this.setNodes((RecordExpr)attrValue);
        } else if (attrName.toLowerCase().equals("Dependencies".toLowerCase())) {
            // empty if block
        }
        this.jobAd.insertAttribute(attrName, attrValue);
    }

    private HashSet extractSons(String father) throws ParseException {
        HashSet<String> sons = (HashSet<String>)this.cycleJobs.get(father);
        if (sons == null) {
            this.cycleJobs.put(father, new HashSet());
            sons = (HashSet)this.dependencies.get(father);
            if (sons == null) {
                sons = new HashSet<String>();
                sons.add(father);
                this.cycleJobs.put(father, sons);
                return sons;
            }
            HashSet<String> newSons = new HashSet<String>();
            for (String node : sons) {
                Iterator iter = this.extractSons(node).iterator();
                while (iter.hasNext()) {
                    newSons.add((String)iter.next());
                }
            }
            newSons.add(father);
            this.cycleJobs.put(father, newSons);
            return newSons;
        }
        if (sons.isEmpty()) {
            throw new ParseException(father + ": dependency error closed cycle catched", 0);
        }
        return sons;
    }

    private void checkLoops() throws Exception {
        HashMap thMap = new HashMap();
        this.cycleJobs = new HashMap();
        for (String father : this.dependencies.keySet()) {
            if (this.cycleJobs.containsKey(father)) continue;
            this.extractSons(father);
        }
    }

    public void check() throws Exception {
        this.checkLoops();
        this.jobAd.insertAttribute("Type", (Expr)Constant.getInstance((String)"dag"));
    }
}

