/*
 * Decompiled with CFR 0.152.
 */
package org.glite.jdl;

import condor.classad.AttrName;
import condor.classad.ClassAdParser;
import condor.classad.Constant;
import condor.classad.Env;
import condor.classad.Expr;
import condor.classad.ListExpr;
import condor.classad.RecordExpr;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import org.glite.jdl.Ad;
import org.glite.jdl.EnumerableAd;
import org.glite.jdl.JobAd;
import org.glite.jdl.JobAdException;

public class CollectionAd
extends Ad
implements EnumerableAd {
    public CollectionAd() {
    }

    public CollectionAd(String ad) throws JobAdException, ParseException {
        super(ad);
        if (super.lookup("OutputSandbox") != null) {
            throw new JobAdException("OutputSandbox top level attribute not allowed for a collection");
        }
    }

    public CollectionAd(RecordExpr ad) throws JobAdException {
        super(ad);
        if (super.lookup("OutputSandbox") != null) {
            throw new JobAdException("OutputSandbox top level attribute not allowed for a collection");
        }
    }

    public Enumeration getJobEnumeration() throws JobAdException {
        Expr voExpr = super.lookup("VirtualOrganisation");
        Expr hlrExpr = super.lookup("HLRLocation");
        Expr lbExpr = super.lookup("LBAddress");
        Expr myproxyExpr = super.lookup("MyProxyServer");
        Expr jpExpr = super.lookup("JobProvenance");
        Expr allowZipExpr = super.lookup("AllowedZippedISB");
        Expr zipISBExpr = super.lookup("ZippedISB");
        Expr eTimeExpr = super.lookup("ExpiryTime");
        Expr perusalExpr = super.lookup("PerusalFileEnable");
        Expr rankExpr = super.lookup("rank");
        Expr reqExpr = super.lookup("requirements");
        Expr isbExpr = super.lookup("InputSandbox");
        Expr isbBaseExpr = super.lookup("InputSandboxBaseURI");
        Env baseEnv = new Env();
        baseEnv.push(this.jobAd);
        try {
            ListExpr nodes = (ListExpr)super.lookup("Nodes");
            Vector<JobAd> subJobs = new Vector<JobAd>(nodes.size());
            for (RecordExpr expr : nodes) {
                Expr tmpexpr;
                String jobType;
                Expr fileExpr = expr.lookup("File");
                if (fileExpr != null) {
                    ClassAdParser cp;
                    String fileName = ((Constant)fileExpr).stringValue();
                    if (expr.size() != 1) {
                        throw new JobAdException("Attribute \"File\" must be the only attribute into a node");
                    }
                    StringBuffer buff = new StringBuffer();
                    BufferedReader in = null;
                    String tmps = null;
                    try {
                        in = new BufferedReader(new FileReader(fileName));
                        tmps = in.readLine();
                        while (tmps != null) {
                            buff.append(tmps.trim()).append("\n");
                            tmps = in.readLine();
                        }
                    }
                    catch (IOException ioEx) {
                        throw new JobAdException(ioEx.getMessage());
                    }
                    finally {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Exception ex) {}
                        }
                    }
                    tmps = Ad.parseStringValue(buff.toString());
                    if (!tmps.startsWith("[")) {
                        tmps = "[" + tmps + "]";
                    }
                    if ((expr = (RecordExpr)(cp = new ClassAdParser(tmps)).parse()) == null) {
                        throw new JobAdException("Cannot parse file: " + fileName);
                    }
                }
                String string = jobType = (tmpexpr = expr.lookup("JobType")) != null ? ((Constant)tmpexpr).stringValue() : null;
                if (jobType != null && (jobType.equalsIgnoreCase("parametric") || jobType.equalsIgnoreCase("partitionable"))) {
                    throw new JobAdException("Wrong job type for collection: " + jobType);
                }
                if (voExpr == null) {
                    throw new JobAdException("Missing attribute VirtualOrganisation");
                }
                expr.insertAttribute("VirtualOrganisation", voExpr);
                if (hlrExpr != null) {
                    expr.insertAttribute("HLRLocation", hlrExpr);
                }
                if (lbExpr != null) {
                    expr.insertAttribute("LBAddress", lbExpr);
                }
                if (myproxyExpr != null) {
                    expr.insertAttribute("MyProxyServer", myproxyExpr);
                }
                if (jpExpr != null) {
                    expr.insertAttribute("JobProvenance", jpExpr);
                }
                if (allowZipExpr != null) {
                    expr.insertAttribute("AllowedZippedISB", allowZipExpr);
                } else {
                    expr.insertAttribute("AllowedZippedISB", (Expr)Constant.FALSE);
                }
                if (zipISBExpr != null) {
                    expr.insertAttribute("ZippedISB", zipISBExpr);
                } else if (expr.lookup("ZippedISB") != null) {
                    expr.removeAttribute(AttrName.fromString((String)"ZippedISB"));
                }
                if (eTimeExpr != null && expr.lookup("ExpiryTime") == null) {
                    expr.insertAttribute("ExpiryTime", eTimeExpr);
                }
                if (perusalExpr != null && expr.lookup("PerusalFileEnable") == null) {
                    expr.insertAttribute("PerusalFileEnable", perusalExpr);
                }
                if (rankExpr != null && expr.lookup("rank") == null) {
                    expr.insertAttribute("rank", rankExpr);
                }
                if (reqExpr != null && expr.lookup("requirements") == null) {
                    expr.insertAttribute("requirements", reqExpr);
                }
                if (isbBaseExpr != null && expr.lookup("InputSandboxBaseURI") == null) {
                    expr.insertAttribute("InputSandboxBaseURI", isbBaseExpr);
                }
                if ((tmpexpr = expr.lookup("InputSandbox")) == null) {
                    if (isbExpr != null) {
                        expr.insertAttribute("InputSandbox", isbExpr);
                    }
                } else {
                    expr.insertAttribute("InputSandbox", this.checkISB(tmpexpr, baseEnv));
                }
                subJobs.add(new JobAd(expr));
            }
            return subJobs.elements();
        }
        catch (Exception ex) {
            throw new JobAdException(ex.getMessage());
        }
    }

    private Expr checkISB(Expr isbExpr, Env env) throws JobAdException {
        if (isbExpr == null) {
            return null;
        }
        if (isbExpr.type == -2) {
            Iterator allExpr = ((ListExpr)isbExpr).iterator();
            boolean foundRef = false;
            while (allExpr.hasNext() && !foundRef) {
                Expr tmpExpr = (Expr)allExpr.next();
                foundRef = tmpExpr.type == -5 || tmpExpr.type == -4;
            }
            if (foundRef) {
                ListExpr result = new ListExpr();
                allExpr = ((ListExpr)isbExpr).iterator();
                while (allExpr.hasNext()) {
                    int res;
                    Expr tmpExpr = ((Expr)allExpr.next()).eval(env);
                    if (tmpExpr.type == 3 && ((res = ((Constant)tmpExpr).intValue()) == 1 || res == 0)) {
                        throw new JobAdException("Error resolving references in " + isbExpr.toString());
                    }
                    result.add(tmpExpr);
                }
                return result;
            }
            return isbExpr;
        }
        if (isbExpr.type == -3) {
            return isbExpr;
        }
        throw new JobAdException("Bad attribute type for ISB");
    }
}

