/*
 * Decompiled with CFR 0.152.
 */
package org.glite.jdl;

import condor.classad.ClassAdParser;
import condor.classad.Expr;
import condor.classad.RecordExpr;
import org.glite.jdl.Ad;
import org.glite.jdl.CollectionAd;
import org.glite.jdl.JobAd;
import org.glite.jdl.JobAdException;
import org.glite.jdl.ParametricAd;

public class AdParser {
    public static Ad parseJdl(String jdl) throws JobAdException {
        ClassAdParser cp;
        Expr expr;
        if (!(jdl = Ad.parseStringValue(jdl.trim())).startsWith("[")) {
            jdl = "[ " + jdl + "]";
        }
        if ((expr = (cp = new ClassAdParser(jdl)).parse()) == null) {
            throw new JobAdException("Unable to parse: doesn't seem to be a valid Expression");
        }
        if (expr.type != -1) {
            throw new JobAdException("Unable to parse: the parsed expression is not a ClassAd");
        }
        RecordExpr jdlExpr = (RecordExpr)expr;
        String type = null;
        expr = jdlExpr.lookup("Type");
        if (expr == null) {
            type = "job";
        } else {
            if (!expr.isConstant()) {
                throw new JobAdException("Wrong type parameter");
            }
            type = expr.stringValue();
        }
        if (type.equalsIgnoreCase("job")) {
            expr = jdlExpr.lookup("JobType");
            if (expr == null) {
                return new JobAd(jdlExpr);
            }
            if (!expr.isConstant()) {
                throw new JobAdException("Missing or wrong JobType");
            }
            String jobType = expr.stringValue();
            if (jobType.equalsIgnoreCase("parametric")) {
                return new ParametricAd(jdlExpr);
            }
            return new JobAd(jdlExpr);
        }
        if (type.equalsIgnoreCase("collection")) {
            return new CollectionAd(jdlExpr);
        }
        throw new JobAdException("Unsupported type " + expr.toString());
    }
}

