/*
 * Decompiled with CFR 0.152.
 */
package org.glite.jdl;

import condor.classad.AttrName;
import condor.classad.ClassAdParser;
import condor.classad.ClassAdWriter;
import condor.classad.Constant;
import condor.classad.Expr;
import condor.classad.ListExpr;
import condor.classad.RecordExpr;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.ParseException;
import java.util.Iterator;
import java.util.Vector;
import javax.naming.directory.InvalidAttributeValueException;
import org.glite.jdl.JobAdException;

public class Ad {
    public static final int TYPE_UNKNOWN = 1;
    public static final int TYPE_INTEGER = 3;
    public static final int TYPE_BOOL = 2;
    public static final int TYPE_STRING = 5;
    public static final int TYPE_REAL = 4;
    public static final int TYPE_AD = -1;
    public static final int TYPE_EXPRESSION = 0;
    protected RecordExpr jobAd;
    private String finalExceptionMessage;

    public Ad() {
        this.jobAd = new RecordExpr();
    }

    public Ad(String ad) throws ParseException, JobAdException {
        this.fromString(ad);
    }

    public Ad(RecordExpr ad) throws JobAdException {
        this.fromRecord(ad);
    }

    protected static void copy(RecordExpr re, Ad target) throws JobAdException {
        Iterator attrs = re.attributes();
        String excMessage = "";
        while (attrs.hasNext()) {
            String attrName = attrs.next().toString();
            try {
                target.setAttribute(attrName, re.lookup(attrName));
            }
            catch (Exception exc) {
                excMessage = excMessage + "\n- " + exc.getMessage();
            }
        }
        if (!excMessage.equals("")) {
            throw new JobAdException("JobAd:The following error(s) have been found while creating an instance:" + excMessage);
        }
    }

    public Object clone() {
        Ad target = new Ad();
        try {
            Ad.copy(this.jobAd, target);
        }
        catch (JobAdException jobAdException) {
            // empty catch block
        }
        return target;
    }

    public void setAttribute(String attrName, int attrValue) throws InvalidAttributeValueException {
        this.setAttribute(attrName, (Expr)Constant.getInstance((int)attrValue));
    }

    public void setAttribute(String attrName, boolean attrValue) throws InvalidAttributeValueException {
        this.setAttribute(attrName, (Expr)(attrValue ? Constant.TRUE : Constant.FALSE));
    }

    public void setAttribute(String attrName, double attrValue) throws InvalidAttributeValueException {
        this.setAttribute(attrName, (Expr)Constant.getInstance((double)attrValue));
    }

    public void setAttribute(String attrName, String attrValue) throws InvalidAttributeValueException {
        this.setAttribute(attrName, (Expr)Constant.getInstance((String)attrValue));
    }

    public void setAttribute(String attrName, Ad attrValue) throws InvalidAttributeValueException {
        this.setAttribute(attrName, (Expr)attrValue.jobAd);
    }

    public void setAttribute(String attrName, Expr attrValue) throws InvalidAttributeValueException, IllegalArgumentException {
        char[] notAllowed = new char[]{' ', ':', '#', '@', '[', ']', '+', '*', '$', '%', '!', '?', '~'};
        for (int i = 0; i < notAllowed.length; ++i) {
            if (attrName.indexOf(notAllowed[i]) == -1) continue;
            throw new InvalidAttributeValueException(attrName + ": Not allowed char '" + notAllowed[i] + "' found");
        }
        this.jobAd.insertAttribute(attrName, attrValue);
    }

    public void addAttribute(String attrName, Ad attrValue) throws IllegalArgumentException, InvalidAttributeValueException {
        this.addAttribute(attrName, (Expr)attrValue.jobAd);
    }

    public void addAttribute(String attrName, int attrValue) throws IllegalArgumentException, InvalidAttributeValueException {
        this.addAttribute(attrName, (Expr)Constant.getInstance((int)attrValue));
    }

    public void addAttribute(String attrName, double attrValue) throws IllegalArgumentException, InvalidAttributeValueException {
        this.addAttribute(attrName, (Expr)Constant.getInstance((double)attrValue));
    }

    public void addAttribute(String attrName, boolean attrValue) throws IllegalArgumentException, InvalidAttributeValueException {
        if (attrValue) {
            this.addAttribute(attrName, (Expr)Constant.TRUE);
        } else {
            this.addAttribute(attrName, (Expr)Constant.FALSE);
        }
    }

    public void addAttribute(String attrName, String attrValue) throws IllegalArgumentException, InvalidAttributeValueException {
        this.addAttribute(attrName, (Expr)Constant.getInstance((String)attrValue));
    }

    private void addAttribute(String attrName, Expr attrValue) throws InvalidAttributeValueException, IllegalArgumentException {
        Expr previous = this.lookup(attrName);
        if (previous == null) {
            this.setAttribute(attrName, attrValue);
        } else if (previous.type == -2) {
            ListExpr valueToAppend = this.appendValue(attrValue, (ListExpr)previous);
            this.setAttribute(attrName, (Expr)valueToAppend);
        } else if (previous.type == 2 || previous.type == 4 || previous.type == 3 || previous.type == -1 || previous.type == 5) {
            Vector<Expr> vect = new Vector<Expr>();
            vect.add(previous);
            vect.add(attrValue);
            this.setAttribute(attrName, (Expr)new ListExpr(vect));
        } else {
            throw new IllegalArgumentException(attrName + ": unexpected type");
        }
    }

    public int getType(String attrName) throws NoSuchFieldException {
        Expr expr = this.jobAd.lookup(attrName);
        if (expr == null) {
            throw new NoSuchFieldException(attrName + ": attribute has not been set");
        }
        if (expr.type == -2) {
            expr = ((ListExpr)expr).sub(0);
        }
        switch (expr.type) {
            case -1: 
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return expr.type;
            }
        }
        return 1;
    }

    public Vector getIntValue(String attrName) throws NoSuchFieldException, IllegalArgumentException {
        Expr value = this.lookup(attrName);
        return this.getValue(attrName, value, 3);
    }

    public Vector getDoubleValue(String attrName) throws NoSuchFieldException, IllegalArgumentException {
        Expr value = this.lookup(attrName);
        return this.getValue(attrName, value, 4);
    }

    public Vector getBooleanValue(String attrName) throws NoSuchFieldException, IllegalArgumentException {
        Expr value = this.lookup(attrName);
        return this.getValue(attrName, value, 2);
    }

    public Vector getStringValue(String attrName) throws NoSuchFieldException, IllegalArgumentException {
        Expr value = this.lookup(attrName);
        return this.getValue(attrName, value, 5);
    }

    public Vector getAdValue(String attrName) throws NoSuchFieldException, IllegalArgumentException {
        Expr value = this.lookup(attrName);
        return this.getValue(attrName, value, -1);
    }

    public Ad getAd(String attrName) throws NoSuchFieldException, IllegalArgumentException {
        Ad result = new Ad();
        Expr value = this.lookup(attrName);
        if (value == null) {
            throw new NoSuchFieldException(attrName + ": attribute has not beenset");
        }
        if (value.type != -1) {
            throw new IllegalArgumentException(attrName + ": attribute type is not an Ad instance");
        }
        result.jobAd = (RecordExpr)value;
        return result;
    }

    protected Object getConstant(String attrName, Expr value, int exprType) throws IllegalArgumentException, NoSuchFieldException {
        if (value.type == -2) {
            return this.getValue(attrName, value, exprType);
        }
        if (value.type != exprType) {
            throw new IllegalArgumentException(attrName + ": Requested type doesn't match with value type found.");
        }
        if (exprType == -1) {
            Ad ad = new Ad();
            ad.jobAd = (RecordExpr)value;
            return ad;
        }
        Constant co = (Constant)value;
        if (exprType == 3) {
            return new Integer(co.intValue());
        }
        if (exprType == 2) {
            return new Boolean(co.isTrue());
        }
        if (exprType == 4) {
            return new Double(co.realValue());
        }
        if (exprType == 5) {
            return co.stringValue();
        }
        throw new IllegalArgumentException(attrName + ": unexpected type found.");
    }

    protected Vector getValue(String attrName, Expr value, int exprType) throws NoSuchFieldException, IllegalArgumentException {
        Vector<Object> vect = new Vector<Object>();
        if (value == null) {
            throw new NoSuchFieldException(attrName + ": attribute has not been set");
        }
        if (value.type == -2) {
            ListExpr le = (ListExpr)value;
            for (int i = 0; i < le.size(); ++i) {
                vect.add(this.getConstant(attrName, le.sub(i), exprType));
            }
        } else {
            vect.add(this.getConstant(attrName, value, exprType));
        }
        return vect;
    }

    public Expr lookup(String attrName) {
        return this.jobAd.lookup(attrName);
    }

    public Iterator attributes() {
        return this.jobAd.attributes();
    }

    public boolean hasAttribute(String attrName) {
        return this.lookup(attrName) != null;
    }

    public boolean isSet() {
        return this.jobAd.size() != 0;
    }

    public int size() {
        return this.jobAd.size();
    }

    public void clear() {
        this.jobAd = new RecordExpr();
    }

    public void delAttribute(String attrName) throws NoSuchFieldException {
        if (this.jobAd.lookup(attrName) == null) {
            throw new NoSuchFieldException(attrName + ": attribute not set, unable to remove");
        }
        this.jobAd.removeAttribute(AttrName.fromText((String)attrName));
    }

    protected ListExpr appendValue(Expr attrValue, ListExpr list) {
        Vector<Expr> vect = new Vector<Expr>();
        for (int i = 0; i < list.size(); ++i) {
            vect.add(list.sub(i));
        }
        vect.add(attrValue);
        return new ListExpr(vect);
    }

    public void fromFile(String path) throws Exception {
        BufferedReader in = new BufferedReader(new FileReader(path));
        String result = new String();
        String tmp = new String();
        while ((tmp = in.readLine()) != null) {
            if ((tmp = tmp.trim()).startsWith("#") || tmp.startsWith("//")) continue;
            result = result + tmp + " ";
        }
        in.close();
        this.fromString(result);
    }

    public String toString() {
        return this.toString(false, false);
    }

    public String toString(boolean multiLines, boolean multiLists) {
        StringWriter result = new StringWriter();
        ClassAdWriter caWriter = new ClassAdWriter((Writer)result);
        caWriter.setFormatFlags(0);
        if (multiLines) {
            caWriter.enableFormatFlags(8);
        }
        if (multiLists) {
            caWriter.enableFormatFlags(16);
        }
        caWriter.print((Expr)this.jobAd);
        caWriter.setFormatFlags(0);
        return result.toString();
    }

    public void fromRecord(RecordExpr re) throws JobAdException {
        Iterator it = re.attributes();
        String finalExceptionMessage = "";
        this.jobAd = new RecordExpr();
        while (it.hasNext()) {
            String attrName = it.next().toString();
            try {
                this.setAttribute(attrName, re.lookup(attrName));
            }
            catch (Exception exc) {
                finalExceptionMessage = finalExceptionMessage + exc.getMessage();
            }
        }
        if (finalExceptionMessage.length() != 0) {
            throw new JobAdException(finalExceptionMessage);
        }
    }

    public void fromString(String jdl) throws ParseException, JobAdException {
        ClassAdParser cp;
        Expr ex;
        jdl = jdl.trim();
        if (!(jdl = Ad.parseStringValue(jdl)).startsWith("[")) {
            jdl = "[ " + jdl + "]";
        }
        if ((ex = (cp = new ClassAdParser(jdl)).parse()) == null) {
            throw new ParseException("Unable to parse: doesn't seem to be a valid Expression", 1);
        }
        if (ex.type != -1) {
            throw new ParseException("Unable to parse: the parsed expression is not a ClassAd", 1);
        }
        RecordExpr re = (RecordExpr)ex;
        ex = null;
        this.fromRecord(re);
    }

    static String parseStringValue(String value) {
        int ind = 0;
        ind = value.indexOf("\\");
        while (ind != -1) {
            value = value.substring(0, ind) + "\\\\" + value.substring(ind + 1);
            ind = value.indexOf("\\", ind + 2);
        }
        ind = value.indexOf("\\\"");
        while (ind != -1) {
            value = value.substring(0, ind) + value.substring(ind + 1);
            ind = value.indexOf("\\\"", ind + 1);
        }
        return value;
    }

    static String unparseStringValue(String jdl) {
        int index = jdl.indexOf("\\\\");
        while (index != -1) {
            jdl = jdl.substring(0, index) + jdl.substring(index + 1);
            index = jdl.indexOf("\\\\", index + 1);
        }
        return jdl;
    }
}

