/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.osgceplugin.format.util;

import java.util.ArrayList;

public class CEGlueSchema {
    public static int GlueCE = 0;
    public static int GlueCluster = 1;
    public static int GlueSubCluster = 2;
    public static int GlueCESEBindSE = 3;
    public static int GlueCESEBindGroupCE = 4;
    public static int GlueSite = 5;
    public static int GlueSE = 6;
    public static int GlueSA = 7;
    public static int GlueSEControlProtocol = 8;
    public static int GlueSEAccessProtocol = 9;
    public static int GlueVOInfo = 10;
    public static int GlueVOView = 11;
    public static int GlueSoftware = 12;
    public static int GlueSoftwareData = 13;
    public static String[] keys = new String[]{"GlueCE", "GlueCluster", "GlueSubCluster", "GlueCESEBindSE", "GlueCESEBindGroupCE", "GlueSite", "GlueSE", "GlueSA", "GlueSEControlProtocol", "GlueSEAccessProtocol", "GlueVOInfo", "GlueVOView", "GlueSoftware", "GlueSoftwareData"};
    public static String[] softwareKeys = new String[]{"GlueSoftwareLocalID", "GlueSoftwareName", "GlueSoftwareVersion", "GlueSoftwareInstalledRoot", "GlueSoftwareEnvironmentSetup", "GlueSoftwareModuleName"};

    public static String[] makeCEGlueSchemaInfo(String glueSchema) {
        int x;
        int i;
        String[] msg = null;
        ArrayList[] elements = new ArrayList[keys.length];
        ArrayList<String> ce_list = new ArrayList<String>();
        String siteInfo = "";
        if (glueSchema == null) {
            return null;
        }
        String[] dn = glueSchema.split("\n\n");
        for (i = 0; i < keys.length; ++i) {
            elements[i] = new ArrayList();
        }
        for (i = 0; i < dn.length; ++i) {
            int type = CEGlueSchema.checkElementType(dn[i], "UniqueID");
            if (type != -1) {
                elements[type].add(dn[i]);
                continue;
            }
            type = CEGlueSchema.checkElementType(dn[i], "LocalID");
            if (type != -1) {
                elements[type].add(dn[i]);
                continue;
            }
            type = CEGlueSchema.checkElementType(dn[i], "Key");
            if (type == -1) continue;
            elements[type].add(dn[i]);
        }
        for (x = 0; x < elements[GlueSite].size(); ++x) {
            try {
                String site = (String)elements[GlueSite].get(x);
                siteInfo = siteInfo + "\n\n" + site;
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (x = 0; x < elements[GlueCE].size(); ++x) {
            String ceInfo = (String)elements[GlueCE].get(x);
            try {
                String voView = "";
                String ceUniqueID = CEGlueSchema.getID(ceInfo, "dn: GlueCEUniqueID", ",").trim();
                ArrayList ceAccessControlBaseRule = CEGlueSchema.getList(ceInfo, "GlueCEAccessControlBaseRule");
                ArrayList voViews = CEGlueSchema.getElements(elements[GlueVOView], ceUniqueID, "", "GlueCEUniqueID", ",");
                for (int v = 0; v < voViews.size(); ++v) {
                    voView = (String)voViews.get(v);
                    String[] voViewAttributes = voView.split("\n");
                    ArrayList voViewAccessControlBaseRule = CEGlueSchema.getList(voView, "GlueCEAccessControlBaseRule");
                    ArrayList supportedVO = new ArrayList();
                    boolean isAlike = CEGlueSchema.isAlike(ceAccessControlBaseRule, voViewAccessControlBaseRule, supportedVO);
                    if (supportedVO.size() > 0) {
                        for (int j = 0; j < voViewAttributes.length; ++j) {
                            String attr;
                            int index;
                            String voAttr = voViewAttributes[j];
                            if (!voAttr.startsWith("GlueCE") || voAttr.startsWith("GlueCEAccessControlBaseRule:") || (index = ceInfo.indexOf((attr = voAttr.split(": ")[0].trim()) + ": ")) < 0) continue;
                            int index1 = ceInfo.indexOf(voAttr);
                            ceInfo = index1 >= 0 ? ceInfo.replace(voAttr + "\n", "") : ceInfo.replace(attr + ":", attr + "Original" + ":");
                        }
                        if (!isAlike) {
                            ceInfo = ceInfo.replaceAll("GlueCEAccessControlBaseRule:", "GlueCEAccessControlBaseRuleOriginal:");
                        } else {
                            for (int l = 0; l < supportedVO.size(); ++l) {
                                voView = voView.replace("\nGlueCEAccessControlBaseRule: " + (String)supportedVO.get(l), "");
                            }
                        }
                    }
                    String clusterUniqueID = CEGlueSchema.getID(ceInfo, "GlueForeignKey", "\n").trim();
                    ArrayList bindInfo = CEGlueSchema.getElements(elements[GlueCESEBindSE], ceUniqueID, "", "GlueCESEBindGroupCEUniqueID", ",");
                    ArrayList clusterInfo = CEGlueSchema.getElements(elements[GlueCluster], clusterUniqueID, "GlueClusterUniqueID=", "dn: GlueClusterUniqueID", ",");
                    for (int i2 = 0; i2 < clusterInfo.size(); ++i2) {
                        ceInfo = ceInfo + "\n\n" + clusterInfo.get(i2);
                        ArrayList subclusterInfo = CEGlueSchema.getElements(elements[GlueSubCluster], clusterUniqueID, "", "GlueChunkKey", "\n");
                        for (int j = 0; j < subclusterInfo.size(); ++j) {
                            String subClusterUniqueID = CEGlueSchema.getID((String)subclusterInfo.get(j), "dn: GlueSubClusterUniqueID", ",").trim();
                            String subInfo = (String)subclusterInfo.get(j) + "\n";
                            ArrayList tmp = CEGlueSchema.getElements(elements[GlueSoftware], subClusterUniqueID, "", "GlueSubClusterUniqueID", ",");
                            ArrayList softwareInfo = CEGlueSchema.getElements(tmp, clusterUniqueID, "GlueClusterUniqueID=", "GlueClusterUniqueID", ",");
                            for (int m = 0; m < softwareInfo.size(); ++m) {
                                String softwareID = CEGlueSchema.getID((String)softwareInfo.get(m), "dn: GlueSoftwareLocalID", ",").trim();
                                tmp = CEGlueSchema.getElements(elements[GlueSoftwareData], softwareID, "", "GlueSoftwareLocalID", ",");
                                ArrayList tmp1 = CEGlueSchema.getElements(tmp, subClusterUniqueID, "", "GlueSubClusterUniqueID", ",");
                                ArrayList softwareData = CEGlueSchema.getElements(tmp1, clusterUniqueID, "GlueClusterUniqueID=", "GlueClusterUniqueID", ",");
                                subInfo = subInfo + "\n" + (String)softwareInfo.get(m) + "\n" + CEGlueSchema.addSoftwareDataKey(softwareData);
                            }
                            boolean classAdGenerated = false;
                            if (bindInfo.size() > 0) {
                                for (int k = 0; k < bindInfo.size(); ++k) {
                                    String seUniqueID = CEGlueSchema.getID((String)bindInfo.get(k), "dn: GlueCESEBindSEUniqueID", ",").trim();
                                    String seInfo = "\n\n" + CEGlueSchema.elementsToString(CEGlueSchema.getElements(elements[GlueSE], seUniqueID, "", "dn: GlueSEUniqueID", ","));
                                    seInfo = seInfo + "\n\n" + CEGlueSchema.elementsToString(CEGlueSchema.getElements(elements[GlueSEControlProtocol], seUniqueID, "", "GlueSEUniqueID", ","));
                                    seInfo = seInfo + "\n\n" + CEGlueSchema.elementsToString(CEGlueSchema.getElements(elements[GlueSEAccessProtocol], seUniqueID, "", "GlueSEUniqueID", ","));
                                    ArrayList saInfo = CEGlueSchema.getElements(elements[GlueSA], seUniqueID, "", "GlueSEUniqueID", ",");
                                    if (saInfo.size() == 0) {
                                        ce_list.add(ceInfo + "\n\n" + siteInfo + "\n\n" + "\n\n" + voView + "\n\n" + subInfo);
                                        classAdGenerated = true;
                                        continue;
                                    }
                                    for (int l = 0; l < saInfo.size(); ++l) {
                                        ArrayList supportedSAVO = new ArrayList();
                                        ArrayList saAccessControlBaseRule = CEGlueSchema.getList((String)saInfo.get(l), "GlueSAAccessControlBaseRule");
                                        isAlike = CEGlueSchema.isAlike(supportedVO, saAccessControlBaseRule, supportedSAVO);
                                        if (supportedSAVO.size() == 0) continue;
                                        String saLocalID = CEGlueSchema.getID((String)saInfo.get(l), "dn: GlueSALocalID", ",").trim();
                                        ArrayList voInfo = CEGlueSchema.getElements(elements[GlueVOInfo], saLocalID, "", "GlueSALocalID", ",");
                                        String voinfo = "";
                                        for (int n = 0; n < voInfo.size(); ++n) {
                                            ArrayList supportedVOInfoVO = new ArrayList();
                                            ArrayList voInfoAccessControlBaseRule = CEGlueSchema.getList((String)voInfo.get(n), "GlueVOInfoAccessControlBaseRule");
                                            isAlike = CEGlueSchema.isAlike(supportedSAVO, voInfoAccessControlBaseRule, supportedVOInfoVO);
                                            if (supportedVOInfoVO.size() == 0) continue;
                                            voinfo = (String)voInfo.get(n);
                                            break;
                                        }
                                        ce_list.add(ceInfo + "\n\n" + (String)bindInfo.get(k) + "\n\n" + siteInfo + "\n\n" + voView + "\n\n" + subInfo + "\n\n" + seInfo + "\n\n" + saInfo.get(l) + "\n\n" + voinfo);
                                        classAdGenerated = true;
                                    }
                                }
                            } else {
                                ce_list.add(ceInfo + "\n\n" + siteInfo + "\n\n" + "\n\n" + voView + "\n\n" + subInfo);
                                classAdGenerated = true;
                            }
                            if (classAdGenerated) continue;
                            ce_list.add(ceInfo + "\n\n" + siteInfo + "\n\n" + "\n\n" + voView + "\n\n" + subInfo);
                        }
                    }
                }
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        msg = new String[ce_list.size()];
        return ce_list.toArray(msg);
    }

    private static String getID(String dn, String key, String delim) throws Exception {
        if (dn == null || key == null) {
            throw new Exception("dn or key is null!");
        }
        int index = dn.indexOf(key);
        if (index > -1) {
            String id = dn.substring(index += key.length() + 1, dn.indexOf(delim, index + 1));
            return id;
        }
        throw new Exception("key " + key + " not found!");
    }

    private static int checkElementType(String dn, String id) {
        for (int i = 0; i < keys.length; ++i) {
            if (!dn.startsWith("dn: " + keys[i] + id)) continue;
            return i;
        }
        return -1;
    }

    private static ArrayList getElements(ArrayList elements, String uniqueID, String prefix, String key, String delim) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        for (int y = 0; y < elements.size(); ++y) {
            String info = (String)elements.get(y);
            String id = CEGlueSchema.getID(info, key, delim).trim();
            if (!uniqueID.equals(prefix + id)) continue;
            list.add(info);
        }
        return list;
    }

    private static String addSoftwareDataKey(ArrayList softwareData) throws Exception {
        String params = "";
        if (softwareData.size() == 0) {
            return "GlueSoftwareDataParams: ";
        }
        for (int i = 0; i < softwareData.size(); ++i) {
            String key = CEGlueSchema.getID((String)softwareData.get(i), "GlueSoftwareDataKey:", "\n");
            String value = CEGlueSchema.getID((String)softwareData.get(i) + "\n", "GlueSoftwareDataValue:", "\n");
            params = params.length() == 0 ? "GlueSoftwareDataParams: " : params + "; ";
            params = params + key + "=" + value;
        }
        return params;
    }

    private static ArrayList getList(String dn, String prefix) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        String[] elements = dn.split("\n");
        for (int y = 0; y < elements.length; ++y) {
            String info = elements[y].trim();
            if (!info.startsWith(prefix.trim())) continue;
            list.add(info.split(": ")[1].trim());
        }
        return list;
    }

    private static boolean isAlike(ArrayList arr1, ArrayList arr2, ArrayList supportedVO) throws Exception {
        boolean isAlike = true;
        for (int i = 0; i < arr1.size(); ++i) {
            boolean found = false;
            String v1 = (String)arr1.get(i);
            if (v1.indexOf(":") > 0) {
                v1 = v1.split(":")[1].trim();
            }
            for (int j = 0; j < arr2.size(); ++j) {
                String v2 = (String)arr2.get(j);
                if (v2.indexOf(":") > 0) {
                    v2 = v2.split(":")[1].trim();
                }
                if (!v1.equals(v2)) continue;
                supportedVO.add(v1);
                found = true;
            }
            if (!isAlike || found) continue;
            isAlike = false;
        }
        return isAlike;
    }

    private static String elementsToString(ArrayList elements) {
        String result = "";
        if (elements != null) {
            for (int i = 0; i < elements.size(); ++i) {
                String info = (String)elements.get(i);
                if (info == null) continue;
                result = result + "\n\n" + info;
            }
        }
        return result;
    }
}

