/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.osgceplugin.format;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glite.ce.osgceplugin.format.AbstractClassAdOutputFormat;

public class OldClassAd
extends AbstractClassAdOutputFormat {
    Pattern pattern = Pattern.compile(".*\\-.*|.*\\+.*|.*\\=.*|.*\\!.*|.*\\!=.*|.*\\*.*|.*/.*|.*\\..*|.*:.*|.*<.*|.*>.*|.*\\^.*|.*\\%.*");
    Pattern special = Pattern.compile("[0-9]+|[0-9]+\\.[0-9]+|undefined|true|t|false|f|error|\".*\"");
    Matcher matcher;

    public OldClassAd(ArrayList multipleAttributesList, ArrayList notSupportedAttributesList) {
        super("OLD_CLASSAD", multipleAttributesList, notSupportedAttributesList);
    }

    protected String ldifToClassad(String ldif, ArrayList multipleAttributes, ArrayList notSupportedAttributes) {
        ArrayList values;
        if (ldif == null) {
            return null;
        }
        String[] attributes = ldif.split("\n");
        Hashtable<String, Object> attributeTable = new Hashtable<String, Object>();
        if (attributes == null) {
            return null;
        }
        for (int i = 0; i < attributes.length; ++i) {
            String name;
            String[] attribute = attributes[i].split(": ", 2);
            if (attribute == null || attribute.length != 2 || this.checkAttribute(name = attribute[0].trim(), notSupportedAttributes)) continue;
            String value = this.parseAttributeValue(attribute[1], false);
            if (this.checkAttribute(name, multipleAttributes)) {
                values = null;
                if (attributeTable.containsKey(name)) {
                    values = (ArrayList)attributeTable.get(name);
                } else {
                    values = new ArrayList();
                    attributeTable.put(name, values);
                }
                values.add(value);
                continue;
            }
            attributeTable.put(name, value);
        }
        String classad = "[\n";
        Enumeration e = attributeTable.keys();
        while (e.hasMoreElements()) {
            String attrName = (String)e.nextElement();
            Object attrValue = attributeTable.get(attrName);
            classad = classad + "\t" + attrName + " = ";
            if (attrValue instanceof String) {
                if (attributeTable.containsKey(attrValue)) {
                    classad = classad + attrValue + ";\n";
                    continue;
                }
                this.matcher = this.pattern.matcher((String)attrValue);
                if (this.matcher.matches()) {
                    classad = classad + "\"" + attrValue + "\";\n";
                    continue;
                }
                if (this.special.matcher((String)attrValue).matches()) {
                    classad = classad + attrValue + ";\n";
                    continue;
                }
                classad = classad + "\"" + attrValue + "\";\n";
                continue;
            }
            classad = classad + "\"";
            values = (ArrayList)attrValue;
            for (int i = 0; i < values.size(); ++i) {
                classad = classad + values.get(i);
                classad = classad + (i < values.size() - 1 ? "," : "\";\n");
            }
        }
        classad = classad + "\n]";
        return classad;
    }
}

