/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.osgceplugin.format;

import java.util.ArrayList;
import java.util.Hashtable;
import org.glite.ce.monitorapij.sensor.SensorOutputDataFormat;
import org.glite.ce.osgceplugin.format.util.CEGlueSchema;

public abstract class AbstractClassAdOutputFormat
extends SensorOutputDataFormat {
    private ArrayList notSupportedattributes;
    private ArrayList multipleValuesAttributes;

    public AbstractClassAdOutputFormat(String formatName, ArrayList multipleValuesAttributeList, ArrayList notSupportedattributeList) {
        super(formatName);
        this.initMultipleAttributeList(multipleValuesAttributeList);
        this.initNotSupportedAttributeList(notSupportedattributeList);
        this.initSupportedQueryLang();
    }

    private void initMultipleAttributeList(ArrayList multipleAttributesList) {
        this.multipleValuesAttributes = multipleAttributesList == null ? new ArrayList() : multipleAttributesList;
    }

    private void initNotSupportedAttributeList(ArrayList notSupportedattributesList) {
        this.notSupportedattributes = notSupportedattributesList == null ? new ArrayList() : notSupportedattributesList;
    }

    private void initSupportedQueryLang() {
        String[] supportedQueryLang = new String[]{"RegEx", "ClassAd"};
        this.setSupportedQueryLang(supportedQueryLang);
    }

    protected ArrayList getMultipleAttributes() {
        return this.multipleValuesAttributes;
    }

    protected void setMultipleAttributes(ArrayList multiAttributes) {
        this.multipleValuesAttributes = multiAttributes;
    }

    protected ArrayList getNotSupportedattributes() {
        return this.notSupportedattributes;
    }

    protected void setNotSupportedattributes(ArrayList notSupportedattributes) {
        this.notSupportedattributes = notSupportedattributes;
    }

    public String[] apply(Hashtable parameters) throws Exception {
        if (parameters == null) {
            throw new Exception(this.getName() + " apply format error: parameter is null");
        }
        String glueSchema = (String)parameters.get("glueSchema");
        if (glueSchema != null) {
            String[] ceinfo = CEGlueSchema.makeCEGlueSchemaInfo(glueSchema);
            for (int i = 0; i < ceinfo.length; ++i) {
                String classad = this.ldifToClassad(ceinfo[i], this.multipleValuesAttributes, this.notSupportedattributes);
                if (classad == null) continue;
                ceinfo[i] = classad;
            }
            return ceinfo;
        }
        throw new Exception(this.getName() + " apply format error: glueSchema is null");
    }

    abstract String ldifToClassad(String var1, ArrayList var2, ArrayList var3);

    protected boolean checkAttribute(String attributeName, ArrayList attributes) {
        if (attributes == null) {
            return false;
        }
        return attributes.contains(attributeName.toLowerCase());
    }

    protected String parseAttributeValue(String value, boolean attrQuoted) {
        if (value == null) {
            return "undefined";
        }
        String value_lc = value;
        while (value_lc.startsWith(" ")) {
            value_lc = value_lc.substring(1, value_lc.length());
        }
        try {
            Double.parseDouble(value_lc);
            return value_lc;
        }
        catch (NumberFormatException ex) {
            if (value_lc.equalsIgnoreCase("true") || value_lc.equalsIgnoreCase("false") || value_lc.equalsIgnoreCase("undefined")) {
                return value_lc.toLowerCase();
            }
            value_lc = attrQuoted ? "\"" + value_lc + "\"" : value_lc;
            return value_lc;
        }
    }
}

