/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.osgceplugin;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.glite.ce.monitorapij.resource.types.Property;
import org.glite.ce.monitorapij.sensor.AbstractSensor;
import org.glite.ce.monitorapij.sensor.Sensor;
import org.glite.ce.monitorapij.sensor.SensorException;
import org.glite.ce.osgceplugin.OSGCESensorEvent;
import org.glite.ce.osgceplugin.format.LDIF;
import org.glite.ce.osgceplugin.format.NewClassAd;
import org.glite.ce.osgceplugin.format.OldClassAd;
import org.glite.ce.osgceplugin.format.Raw;

public class OSGCESensor
extends AbstractSensor {
    private static final long serialVersionUID = 1L;
    private Runtime runtime;
    private String scriptURI;
    private String path = ".";
    private static final Logger logger = Logger.getLogger((String)OSGCESensor.class.getName());

    public OSGCESensor() {
        super("OSG CE Sensor", "OSG_CE");
        Property[] properties = new Property[]{new Property("executionDelay", "60000"), new Property("scriptURI", "/opt/glite/etc/glite-ce-ce-plugin/glite-ce-info"), new Property("not_supported_attributes", "GlueSiteDescription,GlueSiteLocation,GlueSiteWeb,GlueSiteSponsor,GlueSiteOtherInfo,GlueSiteLatitude,GlueSiteLongitude,GlueForeignKey,GlueChunkKey,createTimestamp,GlueCESEBindCEUniqueID,GlueCESEBindCEAccesspoint,GlueCESEBindGroupCEUniqueID,GlueCESEBindSEUniqueID,GlueCESEBindGroupSEUniqueID,entryTtl,modifyTimestamp,dn,ObjectClass"), new Property("multiple_values_attributes", "GlueSiteSponsor,GlueSiteOtherInfo,GlueServiceAccessPointURL,GlueServiceAccessControlRule,GlueInformationServiceURL,GlueChunkKey,GlueForeignKey,GlueCEAccessControlBaseRule,GlueClusterService,GlueHostService,GlueHostApplicationSoftwareRunTimeEnvironment,GlueHostLocalFileSystemClient,GlueHostRemoteFileSystemServer,GlueCESEBindGroupSEUniqueID,GlueSEHostingSL,GlueSEAccessProtocolSupportedSecurity,GlueSLService,GlueSLLocalFileSystemClient,GlueSAAccessControlBaseRule")};
        this.setProperty(properties);
        this.setEventOverwriteModeActive(true);
        this.setScope("HIGH");
    }

    public void init() throws SensorException {
        String prop_value;
        String prop_value2;
        int index;
        super.init();
        Property scriptURIproperty = this.getProperty("scriptURI");
        if (scriptURIproperty == null) {
            throw new SensorException(0, "scriptURI not defined");
        }
        this.scriptURI = scriptURIproperty.getValue();
        if (this.scriptURI != null && (index = this.scriptURI.lastIndexOf("/")) != -1) {
            this.path = this.scriptURI.substring(0, index);
        }
        ArrayList<String> multipleValuesAttributeList = new ArrayList<String>();
        Property property = this.getProperty("multiple_values_attributes");
        if (property != null && (prop_value2 = property.getValue()) != null) {
            String[] attributes = prop_value2.split(",");
            for (int i = 0; i < attributes.length; ++i) {
                multipleValuesAttributeList.add(attributes[i].toLowerCase());
            }
        }
        ArrayList<String> notSupportedAttributeList = new ArrayList<String>();
        property = this.getProperty("not_supported_attributes");
        if (property != null && (prop_value = property.getValue()) != null) {
            String[] attributes = prop_value.split(",");
            for (int i = 0; i < attributes.length; ++i) {
                notSupportedAttributeList.add(attributes[i].toLowerCase());
            }
        }
        OldClassAd defaultFormat = new OldClassAd(multipleValuesAttributeList, notSupportedAttributeList);
        this.addFormat(defaultFormat);
        this.addFormat(new NewClassAd(multipleValuesAttributeList, notSupportedAttributeList));
        this.addFormat(new LDIF());
        this.addFormat(new Raw());
        this.setDefaultFormat(defaultFormat);
        this.runtime = Runtime.getRuntime();
    }

    public void execute() throws SensorException {
        try {
            String GLUESchema = "";
            logger.info((Object)"Executing the sensor OSG_CE...");
            if (this.scriptURI == null) {
                throw new SensorException(0, "scriptURI not found!");
            }
            Process p = this.runtime.exec(this.scriptURI, null, new File(this.path));
            InputStreamReader isr = new InputStreamReader(p.getInputStream());
            BufferedReader in = new BufferedReader(isr);
            char[] buffer = new char[10000];
            int n = 1;
            while (n > 0) {
                n = in.read(buffer, 0, buffer.length);
                if (n <= 0) continue;
                GLUESchema = GLUESchema + new String(buffer, 0, n);
            }
            in.close();
            if (GLUESchema.equals("")) {
                String inputLine;
                String error = "";
                isr = new InputStreamReader(p.getErrorStream());
                in = new BufferedReader(isr);
                while ((inputLine = in.readLine()) != null) {
                    error = error + inputLine + "\n";
                }
                in.close();
                if (!error.equals("")) {
                    throw new Exception(error);
                }
            } else {
                this.fireSensorEvent(new OSGCESensorEvent((Sensor)this, System.currentTimeMillis(), GLUESchema));
            }
        }
        catch (IOException ioe) {
            logger.info((Object)("OSGCESensor ERROR: " + ioe.toString()));
            throw new SensorException(0, ioe.getMessage());
        }
        catch (Exception e) {
            logger.info((Object)("OSGCESensor ERROR: " + e.toString()));
            throw new SensorException(0, e.getMessage());
        }
        logger.info((Object)"Executing the sensor OSG_CE... done!");
    }
}

