/*
  Copyright (c) Members of the EGEE Collaboration. 2004. 
  See http://www.eu-egee.org/partners/ for details on the copyright
  holders.  
  
  Licensed under the Apache License, Version 2.0 (the "License"); 
  you may not use this file except in compliance with the License. 
  You may obtain a copy of the License at 
  
      http://www.apache.org/licenses/LICENSE-2.0 
  
  Unless required by applicable law or agreed to in writing, software 
  distributed under the License is distributed on an "AS IS" BASIS, 
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
  See the License for the specific language governing permissions and 
  limitations under the License.
*/

/*
        Property: a class to handle properties for actions

        Authors: Alvise Dorigo <alvise.dorigo@pd.infn.it>
        Version info: $Id: Property.h,v 1.11.10.1 2010/03/22 12:11:11 pandreet Exp $
*/

#ifndef __GLITE_CE_MONITOR_CLIENT_PROPERTY_H__
#define __GLITE_CE_MONITOR_CLIENT_PROPERTY_H__

#include "glite/ce/monitor-client-api-c/monitor_client_CEMON_CLIENTStub.h"
#include <string>
#include <iostream>

#define PROPERTY monitortypes__Property

namespace glite {
  namespace ce {
    namespace monitor_client_api {
      namespace soap_proxy {

class ActionW;

class PropertyW : public PROPERTY {

  //friend class ActionW;

 protected:
  PropertyW(const PROPERTY&);
  PropertyW& operator=(const PropertyW&);

 public:
  PropertyW(const std::string& name, const std::string& value);
  virtual ~PropertyW() {/*std::cerr<<"~PropertyW..."<<std::endl;*/}
  std::string getPropertyName(void) const;
  std::string getPropertyValue(void) const;
  void setPropertyName(const std::string&);
  void setPropertyValue(const std::string&);
};
      }
    }
  }
}
#endif
