/*
  Copyright (c) Members of the EGEE Collaboration. 2004. 
  See http://www.eu-egee.org/partners/ for details on the copyright
  holders.  
  
  Licensed under the Apache License, Version 2.0 (the "License"); 
  you may not use this file except in compliance with the License. 
  You may obtain a copy of the License at 
  
      http://www.apache.org/licenses/LICENSE-2.0 
  
  Unless required by applicable law or agreed to in writing, software 
  distributed under the License is distributed on an "AS IS" BASIS, 
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
  See the License for the specific language governing permissions and 
  limitations under the License.
*/

/*
        AbsException: a C++ parent class for all request exceptions
        Authors: Alvise Dorigo <alvise.dorigo@pd.infn.it>
        Version info: $Id: AbsException.h,v 1.11.14.1 2010/03/22 12:11:11 pandreet Exp $
*/

#ifndef __GLITE_CE_MONITOR_CLIENT_ABSEXCEPTION_H__
#define __GLITE_CE_MONITOR_CLIENT_ABSEXCEPTION_H__

#include <string>
#include <exception>

/// Base class for all faults not generated by CEMonitor.
/**
        This class is the base for all SOAP faults not generated by the CEMonitor services.\n
	This class is not instantiable.
	\sa ServiceNotFoundException
	\sa GeneralException
	\sa AuthenticationException
*/
class AbsException : public std::exception {
 private:
  std::string cause;
  
 public:
  AbsException(const std::string& _cause) throw() : cause(_cause) {}
  virtual ~AbsException() throw() {}
  
  const char* what() const throw() { return cause.c_str(); }
};

#endif
