/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.monitorapij.sensor;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.log4j.Logger;
import org.glite.ce.commonj.CEResource;
import org.glite.ce.monitorapij.sensor.Sensor;
import org.glite.ce.monitorapij.sensor.SensorException;
import org.glite.ce.monitorapij.sensor.SensorOutputDataFormat;
import org.glite.ce.monitorapij.types.TopicEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SensorEvent
implements TopicEvent,
Externalizable,
CEResource {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger((String)SensorEvent.class.getName());
    private int ID;
    private Calendar timestamp;
    private String[] message;
    private String producer;
    private Sensor source;
    private String name;
    private Hashtable<String, Object> parameters;
    private String outputDataFormatApplied;
    private Calendar expirationTime;
    private String receiverId;
    private String receiverGroup;

    public SensorEvent() {
        this(null, -1, Calendar.getInstance(), null);
    }

    public SensorEvent(Sensor source, int eventID) {
        this(source, eventID, Calendar.getInstance(), null);
    }

    public SensorEvent(Sensor source, int eventID, Calendar when) {
        this(source, eventID, when, null);
    }

    public SensorEvent(Sensor source, int eventID, Calendar when, Calendar expirationTime) {
        if (source != null) {
            this.source = source;
            this.producer = source.getName();
        }
        this.setID(eventID);
        this.setTimestamp(when);
        this.setExpirationTime(expirationTime);
        this.parameters = new Hashtable(0);
    }

    @Override
    public int getID() {
        return this.ID;
    }

    @Override
    public void setID(int ID) {
        this.ID = ID;
    }

    @Override
    public Calendar getTimestamp() {
        return this.timestamp;
    }

    @Override
    public void setTimestamp(Calendar timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public String[] getMessage() {
        return this.message;
    }

    @Override
    public void setMessage(String[] message) {
        this.message = message;
    }

    @Override
    public String getMessage(int i) {
        return this.message[i];
    }

    @Override
    public void setMessage(int i, String _value) {
        this.message[i] = _value;
    }

    protected String getOutputDataFormatApplied() {
        return this.outputDataFormatApplied;
    }

    protected void setOutputDataFormatApplied(String outputDataFormatApplied) {
        this.outputDataFormatApplied = outputDataFormatApplied;
    }

    @Override
    public String getProducer() {
        return this.producer;
    }

    @Override
    public void setProducer(String producer) {
        this.producer = producer;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Calendar getExpirationTime() {
        return this.expirationTime;
    }

    public void setExpirationTime(Calendar expirationTime) {
        this.expirationTime = expirationTime;
    }

    @Override
    public boolean isExpired() {
        return Calendar.getInstance().after(this.expirationTime);
    }

    public String getReceiverId() {
        return this.receiverId;
    }

    public void setReceiverId(String receiverId) {
        this.receiverId = receiverId;
    }

    public String getReceiverGroup() {
        return this.receiverGroup;
    }

    public void setReceiverGroup(String group) {
        this.receiverGroup = group;
    }

    public SensorOutputDataFormat getSensorOutputDataFormatApplied() {
        if (this.source == null) {
            return null;
        }
        return this.getSource().getFormat(this.outputDataFormatApplied);
    }

    @Override
    public Object getParameter(String name) {
        return this.parameters.get(name);
    }

    @Override
    public void addParameter(String name, Object value) {
        this.parameters.put(name, value);
    }

    @Override
    public void setParameters(Hashtable<String, Object> parameters) {
        this.parameters = parameters;
    }

    @Override
    public Hashtable<String, Object> getParameters() {
        return this.parameters;
    }

    @Override
    public void applyFormat(String format) throws SensorException {
        Sensor sensor = this.getSource();
        if (sensor == null) {
            throw new SensorException("sensor not found!");
        }
        SensorOutputDataFormat dataformat = null;
        logger.debug((Object)("ApplyFormat name = " + this.getName() + "  format = " + format + " getSource() != null? " + (this.getSource() != null)));
        dataformat = format == null || format.equalsIgnoreCase("default") ? sensor.getDefaultFormat() : sensor.getFormat(format);
        this.applyFormat(dataformat);
    }

    @Override
    public void applyFormat(SensorOutputDataFormat dataformat) throws SensorException {
        if (dataformat == null) {
            throw new SensorException("SensorEvent applyFormat: the sensor output dataformat is null!");
        }
        if (!this.getSource().isFormatSupported(dataformat)) {
            throw new SensorException("SensorEvent applyFormat: \"" + dataformat.getName() + "\" format not supported!");
        }
        try {
            String[] msg = dataformat.apply(this.parameters);
            this.setMessage((String[])msg.clone());
            this.outputDataFormatApplied = dataformat.getName();
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            throw new SensorException(ex.getMessage());
        }
    }

    @Override
    public Sensor getSource() {
        return this.source;
    }

    @Override
    public void setSource(Sensor source) {
        this.source = source;
        this.producer = source != null ? source.getName() : "N/A";
    }

    public Object clone() {
        logger.debug((Object)("Clone name = " + this.getName() + "  producer = " + this.producer + "    getSource() != null? " + (this.getSource() != null)));
        SensorEvent event = new SensorEvent(this.getSource(), this.getID(), this.getTimestamp());
        event.setName(this.getName());
        event.setReceiverId(this.getReceiverId());
        event.setReceiverGroup(this.getReceiverGroup());
        event.setProducer(this.getProducer());
        if (this.getMessage() != null) {
            event.setMessage((String[])this.getMessage().clone());
        }
        if (this.parameters != null) {
            event.setParameters((Hashtable)this.parameters.clone());
        }
        if (this.expirationTime != null) {
            event.setExpirationTime((Calendar)this.expirationTime.clone());
        }
        return event;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.getID());
        this.writeString(out, this.name);
        this.writeString(out, this.producer);
        this.writeString(out, this.receiverId);
        this.writeString(out, this.receiverGroup);
        this.writeString(out, this.outputDataFormatApplied);
        this.writeCalendar(out, this.expirationTime);
        this.writeCalendar(out, this.getTimestamp());
        this.writeStringArray(out, this.getMessage());
        if (this.parameters != null) {
            out.writeInt(this.parameters.size());
            Enumeration<String> allKeys = this.parameters.keys();
            while (allKeys.hasMoreElements()) {
                String key = allKeys.nextElement();
                this.writeString(out, key);
                out.writeObject(this.parameters.get(key));
            }
        } else {
            out.writeInt(-1);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.setID(in.readInt());
        this.setName(this.readString(in));
        this.setProducer(this.readString(in));
        this.setReceiverId(this.readString(in));
        this.setReceiverGroup(this.readString(in));
        this.outputDataFormatApplied = this.readString(in);
        this.setExpirationTime(this.readCalendar(in));
        this.setTimestamp(this.readCalendar(in));
        this.setMessage(this.readStringArray(in));
        int htSize = in.readInt();
        if (htSize >= 0) {
            Hashtable<String, Object> parameters = new Hashtable<String, Object>(htSize);
            for (int k = 0; k < htSize; ++k) {
                parameters.put(in.readUTF(), in.readObject());
            }
            this.setParameters(parameters);
        } else {
            this.setParameters(null);
        }
    }

    private void writeStringArray(ObjectOutput out, String[] array) throws IOException {
        if (array != null) {
            out.writeInt(array.length);
            for (int k = 0; k < array.length; ++k) {
                if (array[k] != null) {
                    out.writeUTF(array[k]);
                    continue;
                }
                out.writeUTF("_NULL_");
            }
        } else {
            out.writeInt(-1);
        }
    }

    private String[] readStringArray(ObjectInput in) throws IOException {
        int size = in.readInt();
        if (size >= 0) {
            String[] result = new String[size];
            for (int k = 0; k < size; ++k) {
                String s = in.readUTF();
                if (s == null) continue;
                result[k] = s;
            }
            return result;
        }
        return null;
    }

    private String readString(ObjectInput in) throws IOException {
        String s = in.readUTF();
        if (s != null && !s.endsWith("_NULL_")) {
            return s;
        }
        return null;
    }

    private void writeString(ObjectOutput out, String s) throws IOException {
        if (s != null) {
            out.writeUTF(s);
        } else {
            out.writeUTF("_NULL_");
        }
    }

    private void writeCalendar(ObjectOutput out, Calendar cal) throws IOException {
        if (cal != null) {
            out.writeLong(cal.getTimeInMillis());
        } else {
            out.writeLong(0L);
        }
    }

    private Calendar readCalendar(ObjectInput in) throws IOException {
        long ts = in.readLong();
        if (ts == 0L) {
            return null;
        }
        Calendar result = Calendar.getInstance();
        result.setTimeInMillis(ts);
        return result;
    }
}

