/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.monitorapij.sensor;

import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.glite.ce.commonj.utils.BooleanLock;
import org.glite.ce.monitorapij.resource.Resource;
import org.glite.ce.monitorapij.resource.types.CEMonResource;
import org.glite.ce.monitorapij.resource.types.Property;
import org.glite.ce.monitorapij.sensor.MonitorEvent;
import org.glite.ce.monitorapij.sensor.MonitorListener;
import org.glite.ce.monitorapij.sensor.Sensor;
import org.glite.ce.monitorapij.sensor.SensorEvent;
import org.glite.ce.monitorapij.sensor.SensorException;
import org.glite.ce.monitorapij.sensor.SensorListener;
import org.glite.ce.monitorapij.sensor.SensorOutputDataFormat;

public abstract class AbstractSensor
extends CEMonResource
implements Runnable,
Resource,
Sensor,
MonitorListener {
    private static final Logger logger = Logger.getLogger((String)AbstractSensor.class.getName());
    private static final Object objMutex = new Object();
    private ArrayList<SensorListener> listeners;
    private ArrayList<SensorOutputDataFormat> sensorOutputDataFormat;
    private SensorOutputDataFormat defaultFormat;
    private BooleanLock lock = new BooleanLock();
    private long executionDelay = 0L;
    private Thread thisThread;
    private String scope = "HIGH";
    private boolean isEventOverwriteModeActive = false;
    private boolean purgeAllEventsOnStartup = false;
    private boolean isInitialized = false;
    private boolean isDestroySensor = false;

    public AbstractSensor() {
        this("CE Sensor", "Sensor");
    }

    public AbstractSensor(String name, String type) {
        super(name, type);
        this.sensorOutputDataFormat = new ArrayList(0);
        this.listeners = new ArrayList(0);
        this.thisThread = new Thread(this);
        this.thisThread.setName(this.getName());
    }

    public void addFormat(SensorOutputDataFormat format) {
        if (format != null && !this.isFormatSupported(format.getName())) {
            this.sensorOutputDataFormat.add(format);
        }
    }

    public void addSensorListener(SensorListener l) {
        if (l != null) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroySensor() {
        logger.debug((Object)("destroying sensor " + this.getName() + "..."));
        this.isDestroySensor = true;
        this.lock.setValue(false);
        Object object = objMutex;
        synchronized (object) {
            objMutex.notify();
        }
        this.listeners.clear();
        logger.debug((Object)("destroying sensor " + this.getName() + "... done!"));
    }

    public void doOnMonitorEvent(MonitorEvent mEvt) {
    }

    protected void fireSensorEvent(SensorEvent event) {
        if (event == null) {
            return;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            SensorListener listener = this.listeners.get(i);
            if (!(listener instanceof SensorListener)) continue;
            listener.doOnSensorEvent(event);
        }
    }

    public SensorOutputDataFormat getDefaultFormat() {
        if (this.defaultFormat == null && this.sensorOutputDataFormat.size() > 0) {
            this.defaultFormat = this.sensorOutputDataFormat.get(0);
        }
        return this.defaultFormat;
    }

    public SensorOutputDataFormat getFormat(String format) {
        if (format == null) {
            return null;
        }
        for (int i = 0; i < this.sensorOutputDataFormat.size(); ++i) {
            SensorOutputDataFormat supportedFormat = this.sensorOutputDataFormat.get(i);
            if (!supportedFormat.getName().equalsIgnoreCase(format)) continue;
            return supportedFormat;
        }
        return null;
    }

    public SensorOutputDataFormat[] getFormats() {
        SensorOutputDataFormat[] formats = new SensorOutputDataFormat[this.sensorOutputDataFormat.size()];
        formats = this.sensorOutputDataFormat.toArray(formats);
        return formats;
    }

    public String getScope() {
        return this.scope;
    }

    public SensorListener[] getSensorListeners() {
        SensorListener[] sensorListener = new SensorListener[this.listeners.size()];
        return this.listeners.toArray(sensorListener);
    }

    public void init() throws SensorException {
        if (!this.isInitialized) {
            Property property;
            logger.debug((Object)("init() - Initializing sensor [" + this.getName() + "]"));
            Property[] propertyList = this.getProperty();
            if (propertyList != null) {
                for (int i = 0; i < propertyList.length; ++i) {
                    logger.debug((Object)("init() - property name = " + propertyList[i].getName()));
                }
            }
            if ((property = this.getProperty("purgeAllEventsOnStartup")) != null) {
                this.purgeAllEventsOnStartup = property.getValue() != null ? Boolean.parseBoolean(property.getValue()) : false;
                logger.debug((Object)("init() - purgeAllEventsOnStartup is [" + this.purgeAllEventsOnStartup + "]"));
            }
            this.isInitialized = true;
            this.isDestroySensor = false;
        }
    }

    public boolean isEventOverwriteModeActive() {
        return this.isEventOverwriteModeActive;
    }

    public boolean isFormatSupported(SensorOutputDataFormat sensorOutputDataFormat) {
        if (sensorOutputDataFormat == null) {
            return false;
        }
        return this.isFormatSupported(sensorOutputDataFormat.getName());
    }

    public boolean isFormatSupported(String format) {
        if (format == null) {
            return false;
        }
        for (int i = 0; i < this.sensorOutputDataFormat.size(); ++i) {
            SensorOutputDataFormat supportedFormat = this.sensorOutputDataFormat.get(i);
            if (!supportedFormat.getName().equals(format)) continue;
            return true;
        }
        return false;
    }

    public boolean isPurgeAllEventsOnStartup() {
        return this.purgeAllEventsOnStartup;
    }

    public void removeFormat(SensorOutputDataFormat format) {
        if (format != null) {
            this.sensorOutputDataFormat.remove(format);
            if (this.getDefaultFormat().getName().equals(format.getName())) {
                this.getDefaultFormat();
            }
        }
    }

    public void removeSensorListener(SensorListener l) {
        if (l != null) {
            this.listeners.remove(l);
        }
    }

    public synchronized void resumeSensor() {
        this.lock.setValue(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.isDestroySensor) {
            try {
                this.lock.waitUntilFalse(0L);
            }
            catch (InterruptedException ex) {
                logger.error((Object)ex.toString());
            }
            if (this.isDestroySensor) {
                logger.debug((Object)("destroying sensor " + this.getName() + " inside run method"));
                return;
            }
            try {
                logger.debug((Object)("sensor " + this.getName() + ": invoking execute()"));
                this.execute();
                logger.debug((Object)("sensor " + this.getName() + ": execute() invoked!"));
            }
            catch (SensorException se) {
                logger.error((Object)se.toString(), (Throwable)se);
                if (se.getExceptionID() != 0) continue;
                this.destroySensor();
                logger.error((Object)("sensor " + this.getName() + " destroyed \"" + this.getName() + "\" sensor because of previous errors"));
            }
            finally {
                Object object = objMutex;
                synchronized (object) {
                    if (this.executionDelay > 0L && !this.isDestroySensor) {
                        try {
                            objMutex.wait(this.executionDelay);
                        }
                        catch (InterruptedException e) {
                            logger.error((Object)("InterruptedException: " + e.getMessage()));
                        }
                    }
                }
            }
        }
    }

    public void setDefaultFormat(SensorOutputDataFormat format) {
        if (format != null) {
            this.defaultFormat = format;
            this.addFormat(format);
        }
    }

    public void setEventOverwriteModeActive(boolean i) {
        this.isEventOverwriteModeActive = i;
    }

    public void setPurgeAllEventsOnStartup(boolean purgeAllEventsOnStartup) {
        this.purgeAllEventsOnStartup = purgeAllEventsOnStartup;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public void startSensor() {
        Property property = this.getProperty("executionDelay");
        if (property != null) {
            String delay = this.getProperty("executionDelay").getValue();
            if (delay != null) {
                this.executionDelay = Long.parseLong(delay);
                this.executionDelay *= 1000L;
            }
        } else {
            logger.warn((Object)"ExecutionDelay property not found, using default 60");
            this.executionDelay = 60000L;
        }
        this.thisThread.start();
    }

    public synchronized void suspendSensor() {
        this.lock.setValue(true);
    }
}

