/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.monitorapij.resource.types;

import java.io.Serializable;
import org.glite.ce.monitorapij.resource.types.Dialect;

public class Topic
implements Serializable {
    public static final String ALL = "ALL";
    public static final String GROUP = "GROUP";
    public static final String USER = "USER";
    private static final long serialVersionUID = 1319031832L;
    private boolean isEventOverwriteModeActive = false;
    private boolean purgeAllEventsOnStartup = false;
    private String name;
    private String visibility;
    private Dialect[] dialect;

    public Topic() {
        this("");
    }

    public Topic(String topicName) {
        this.name = topicName;
    }

    public Topic(String topicName, Dialect[] dialect) {
        this.name = topicName;
        this.dialect = dialect;
    }

    public Topic(org.glite.ce.monitorapij.types.Topic topic) {
        this.name = topic.getName();
        this.visibility = topic.getVisibility();
        org.glite.ce.monitorapij.types.Dialect[] allDials = topic.getDialect();
        this.dialect = new Dialect[allDials.length];
        for (int k = 0; k < allDials.length; ++k) {
            this.dialect[k] = new Dialect(allDials[k]);
        }
    }

    public boolean checkSupportedDialect(Dialect dlct) {
        if (dlct == null) {
            return false;
        }
        return this.checkSupportedDialect(dlct.getName());
    }

    public boolean checkSupportedDialect(String dialectName) {
        if (dialectName == null) {
            return false;
        }
        Dialect[] dialect = this.getDialect();
        for (int i = 0; i < dialect.length; ++i) {
            if (!dialect[i].getName().equalsIgnoreCase(dialectName)) continue;
            return true;
        }
        return false;
    }

    public Dialect[] getDialect() {
        return this.dialect;
    }

    public Dialect getDialect(String dialectName) {
        if (dialectName == null) {
            return null;
        }
        Dialect[] dialect = this.getDialect();
        for (int i = 0; i < dialect.length; ++i) {
            if (!dialect[i].getName().equalsIgnoreCase(dialectName)) continue;
            return dialect[i];
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getVisibility() {
        return this.visibility;
    }

    public boolean isEventOverwriteModeActive() {
        return this.isEventOverwriteModeActive;
    }

    public boolean isPurgeAllEventsOnStartup() {
        return this.purgeAllEventsOnStartup;
    }

    public void setDialect(Dialect[] dialect) {
        this.dialect = dialect;
    }

    public void setEventOverwriteModeActive(boolean i) {
        this.isEventOverwriteModeActive = i;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPurgeAllEventsOnStartup(boolean purgeAllEventsOnStartup) {
        this.purgeAllEventsOnStartup = purgeAllEventsOnStartup;
    }

    public void setVisibility(String visibility) {
        this.visibility = visibility;
    }
}

