/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.monitorapij.resource.types;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.util.Calendar;
import org.apache.axis2.databinding.types.URI;
import org.glite.ce.commonj.CEResource;
import org.glite.ce.monitorapij.resource.Resource;
import org.glite.ce.monitorapij.resource.types.Action;
import org.glite.ce.monitorapij.resource.types.CEMonResource;
import org.glite.ce.monitorapij.resource.types.Dialect;
import org.glite.ce.monitorapij.resource.types.Parameter;
import org.glite.ce.monitorapij.resource.types.Policy;
import org.glite.ce.monitorapij.resource.types.Property;
import org.glite.ce.monitorapij.resource.types.Query;
import org.glite.ce.monitorapij.resource.types.Topic;
import org.glite.ce.monitorapij.types.Subscription;

public class SubscriptionPersistent
extends CEMonResource
implements Externalizable,
CEResource,
Resource,
Serializable {
    public static final long serialVersionUID = 1319032441L;
    private Calendar pauseTime;
    private Boolean pauseNotify;
    private int maxRetryCount;
    private int retryCount;
    private String subscriberId;
    private String subscriberGroup;
    private String credentialFilename;
    private String passphrase;
    private Boolean removeOnStartup;
    private String sslProtocol;
    private java.net.URI monitorConsumerURL;
    private Calendar expirationTime;
    private Topic topic;
    private Policy policy;

    public SubscriptionPersistent() {
        this.retryCount = this.maxRetryCount = 20;
        this.passphrase = "";
        this.removeOnStartup = new Boolean(false);
        this.sslProtocol = "SSLv3";
        this.setCreationTime(Calendar.getInstance());
        this.pauseNotify = new Boolean(false);
        this.setId(this.generateSubscriptionID());
        this.setName(this.getId());
    }

    public SubscriptionPersistent(Subscription subscription) throws IllegalArgumentException, Exception {
        this();
        org.glite.ce.monitorapij.types.Property[] property;
        if (subscription == null) {
            throw new IllegalArgumentException("the subscription is null");
        }
        this.setExpirationTime(subscription.getExpirationTime());
        this.setType(subscription.getType());
        this.setMonitorConsumerURL(new java.net.URI(subscription.getMonitorConsumerURL().toString()));
        if (subscription.getJarPath() != null) {
            this.setJarPath(new java.net.URI(subscription.getJarPath().toString()));
        }
        if ((property = subscription.getProperty()) != null) {
            Property[] newProperty = new Property[property.length];
            for (int i = 0; i < property.length; ++i) {
                newProperty[i] = new Property(property[i].getName(), property[i].getValue());
            }
            this.setProperty(newProperty);
        }
        org.glite.ce.monitorapij.types.Topic topic = subscription.getTopic();
        org.glite.ce.monitorapij.types.Dialect[] dialect = topic.getDialect();
        Topic newtopic = new Topic(topic.getName());
        if (dialect != null) {
            Dialect[] newDialect = new Dialect[dialect.length];
            for (int i = 0; i < dialect.length; ++i) {
                newDialect[i] = new Dialect(dialect[i].getName(), dialect[i].getQueryLanguage());
            }
            newtopic.setDialect(newDialect);
        }
        this.setTopic(newtopic);
        org.glite.ce.monitorapij.types.Policy policy = subscription.getPolicy();
        if (policy != null) {
            org.glite.ce.monitorapij.types.Action[] action;
            Policy newPolicy = new Policy();
            newPolicy.setRate(policy.getRate());
            org.glite.ce.monitorapij.types.Query query = policy.getQuery();
            if (query != null) {
                newPolicy.setQuery(new Query(query.getExpression(), query.getQueryLanguage()));
            }
            if ((action = policy.getAction()) != null) {
                Action[] newAction = new Action[action.length];
                for (int i = 0; i < action.length; ++i) {
                    newAction[i] = new Action(action[i].getName());
                    newAction[i].setDoActionWhenQueryIs(action[i].getDoActionWhenQueryIs());
                    org.glite.ce.monitorapij.types.Parameter[] parameter = action[i].getParameter();
                    if (parameter == null) continue;
                    Parameter[] newParameter = new Parameter[parameter.length];
                    for (int j = 0; j < parameter.length; ++j) {
                        newParameter[j] = new Parameter(parameter[j].getName(), parameter[j].getValue());
                    }
                    newAction[i].setParameter(newParameter);
                }
                newPolicy.setAction(newAction);
            }
            this.setPolicy(newPolicy);
        }
    }

    public Object clone() {
        SubscriptionPersistent subscription = new SubscriptionPersistent();
        subscription.setRemoveOnStartup(this.removeOnStartup());
        subscription.setId(this.getId());
        subscription.setSubscriberId(this.getSubscriberId());
        subscription.setSubscriberGroup(this.getSubscriberGroup());
        subscription.setMonitorConsumerURL(this.getMonitorConsumerURL());
        subscription.setTopic(this.getTopic());
        subscription.setPolicy(this.getPolicy());
        subscription.setExpirationTime(this.getExpirationTime());
        subscription.setCreationTime(this.getCreationTime());
        subscription.setName(this.getName());
        subscription.setMaxRetryCount(this.getMaxRetryCount());
        subscription.setRetryCount(this.getRetryCount());
        subscription.setProperty(this.getProperty());
        subscription.setJarPath(this.getJarPath());
        subscription.setType(this.getType());
        subscription.setCredentialFile(this.getCredentialFile());
        subscription.setPassphrase(this.getPassphrase());
        subscription.setSSLProtocol(this.getSSLProtocol());
        if (!this.pauseNotify.booleanValue()) {
            subscription.resume();
        } else {
            subscription.pause(this.getPauseTime());
        }
        return subscription;
    }

    public int decrRetryCount() {
        if (this.maxRetryCount != -1 && this.retryCount > 0) {
            --this.retryCount;
        }
        return this.retryCount;
    }

    public String getCompleteInfo() {
        StringBuffer info = new StringBuffer(super.getCompleteInfo());
        info.append(" - SubscriberID=[");
        info.append(this.getSubscriberId());
        info.append("] - TopicName=[");
        info.append(this.getTopic().getName());
        info.append("] - ConsumerURL=[");
        info.append(this.getMonitorConsumerURL().toString());
        info.append("] - IsExpired=[");
        info.append(this.isExpired());
        info.append("] - IsPaused=[");
        info.append(this.isPaused());
        info.append("]");
        return info.toString();
    }

    private String generateSubscriptionID() {
        return "uuid-" + this.getCreationTime().getTimeInMillis();
    }

    public String getCredentialFile() {
        return this.credentialFilename;
    }

    public String getCredentialFilename() {
        return this.credentialFilename;
    }

    public Calendar getExpirationTime() {
        return this.expirationTime;
    }

    public int getMaxRetryCount() {
        return this.maxRetryCount;
    }

    public java.net.URI getMonitorConsumerURL() {
        return this.monitorConsumerURL;
    }

    public String getPassphrase() {
        return this.passphrase;
    }

    public Boolean getPauseNotify() {
        return this.pauseNotify;
    }

    public Calendar getPauseTime() {
        return this.pauseTime;
    }

    public Policy getPolicy() {
        return this.policy;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public String getSslProtocol() {
        return this.sslProtocol;
    }

    public String getSSLProtocol() {
        return this.sslProtocol;
    }

    public String getSubscriberGroup() {
        return this.subscriberGroup;
    }

    public String getSubscriberId() {
        return this.subscriberId;
    }

    public Topic getTopic() {
        return this.topic;
    }

    public boolean isExpired() {
        Calendar currentTime = Calendar.getInstance();
        Calendar terminationTime = this.getExpirationTime();
        if (terminationTime == null) {
            return false;
        }
        return !currentTime.before(terminationTime);
    }

    public boolean isPaused() {
        if (!this.pauseNotify.booleanValue()) {
            return false;
        }
        if (this.pauseTime == null) {
            return true;
        }
        Calendar currentTime = Calendar.getInstance();
        if (currentTime.before(this.pauseTime)) {
            return true;
        }
        this.resume();
        return false;
    }

    public void pause() {
        this.pauseNotify = new Boolean(true);
    }

    public void pause(Calendar pauseTime) {
        this.pauseTime = pauseTime;
        this.pauseNotify = new Boolean(true);
    }

    private Calendar readCalendar(ObjectInput in) throws IOException {
        long ts = in.readLong();
        if (ts == 0L) {
            return null;
        }
        Calendar result = Calendar.getInstance();
        result.setTimeInMillis(ts);
        return result;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int rate;
        super.readExternal(in);
        this.pauseTime = this.readCalendar(in);
        this.setExpirationTime(this.readCalendar(in));
        this.setSubscriberId(this.readString(in));
        this.setSubscriberGroup(this.readString(in));
        this.setCredentialFilename(this.readString(in));
        this.setPassphrase(this.readString(in));
        this.setSslProtocol(this.readString(in));
        this.setMaxRetryCount(in.readInt());
        this.setRetryCount(in.readInt());
        this.pauseNotify = new Boolean(in.readBoolean());
        this.setRemoveOnStartup(in.readBoolean());
        try {
            String uri = this.readString(in);
            if (uri != null) {
                this.setMonitorConsumerURL(new java.net.URI(uri));
            }
        }
        catch (URISyntaxException ex) {
            // empty catch block
        }
        String name = this.readString(in);
        if (!name.equals("topic_null")) {
            Topic topic = new Topic(name);
            topic.setVisibility(this.readString(in));
            int size = in.readInt();
            if (size >= 0) {
                Dialect[] dialect = new Dialect[size];
                for (int k = 0; k < size; ++k) {
                    dialect[k] = new Dialect(this.readString(in), this.readStringArray(in));
                }
                topic.setDialect(dialect);
            }
            this.setTopic(topic);
        }
        if ((rate = in.readInt()) > -1) {
            int size;
            Policy policy = new Policy();
            policy.setRate(rate);
            name = in.readUTF();
            if (!name.equals("query_null")) {
                policy.setQuery(new Query(name, this.readString(in)));
            }
            if ((size = in.readInt()) >= 0) {
                Action[] action = new Action[size];
                for (int k = 0; k < size; ++k) {
                    action[k] = new Action(this.readString(in));
                    action[k].setDoActionWhenQueryIs(in.readBoolean());
                    int paramSize = in.readInt();
                    if (paramSize < 0) continue;
                    Parameter[] param = new Parameter[paramSize];
                    for (int y = 0; y < paramSize; ++y) {
                        param[y] = new Parameter(this.readString(in), in.readObject());
                    }
                    action[k].setParameter(param);
                }
                policy.setAction(action);
            }
            this.setPolicy(policy);
        }
    }

    private String readString(ObjectInput in) throws IOException {
        String s = in.readUTF();
        return s.equals("_null_") ? null : s;
    }

    private String[] readStringArray(ObjectInput in) throws IOException {
        int size = in.readInt();
        if (size >= 0) {
            String[] result = new String[size];
            for (int k = 0; k < size; ++k) {
                result[k] = in.readUTF();
            }
            return result;
        }
        return null;
    }

    public boolean removeOnStartup() {
        return this.removeOnStartup;
    }

    public void resetRetryCount() {
        this.retryCount = this.maxRetryCount;
    }

    public void resume() {
        this.pauseNotify = new Boolean(false);
        this.pauseTime = null;
    }

    public void setCredentialFile(String filename) {
        this.credentialFilename = filename;
    }

    public void setCredentialFilename(String credentialFilename) {
        this.credentialFilename = credentialFilename;
    }

    public void setExpirationTime(Calendar expirationTime) {
        this.expirationTime = expirationTime;
    }

    public void setMaxRetryCount(int max) {
        this.maxRetryCount = max;
        this.retryCount = max;
    }

    public void setMonitorConsumerURL(java.net.URI consumerURL) {
        this.monitorConsumerURL = consumerURL;
    }

    public void setPassphrase(String pass) {
        this.passphrase = pass;
    }

    public void setPauseNotify(Boolean pauseNotify) {
        this.pauseNotify = pauseNotify;
    }

    public void setPauseTime(Calendar pauseTime) {
        this.pauseTime = pauseTime;
    }

    public void setPolicy(Policy policy) {
        this.policy = policy;
    }

    public void setRemoveOnStartup(boolean b) {
        this.removeOnStartup = new Boolean(b);
    }

    public void setRetryCount(int retryCount) throws IllegalArgumentException {
        if (retryCount > this.maxRetryCount) {
            this.resetRetryCount();
            throw new IllegalArgumentException("the specified retryCount value (" + retryCount + ") exceeds the maxRetryCount (" + this.maxRetryCount + "): going to use the default");
        }
        this.retryCount = retryCount;
    }

    public void setSslProtocol(String sslProtocol) {
        this.sslProtocol = sslProtocol;
    }

    public void setSSLProtocol(String protocol) {
        this.sslProtocol = protocol;
    }

    public void setSubscriberGroup(String subscriberGroup) {
        this.subscriberGroup = subscriberGroup;
    }

    public void setSubscriberId(String subscriberId) {
        this.subscriberId = subscriberId;
    }

    public void setTopic(Topic topic) {
        this.topic = topic;
    }

    private void writeCalendar(ObjectOutput out, Calendar cal) throws IOException {
        if (cal != null) {
            out.writeLong(cal.getTimeInMillis());
        } else {
            out.writeLong(0L);
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        this.writeCalendar(out, this.pauseTime);
        this.writeCalendar(out, this.expirationTime);
        this.writeString(out, this.subscriberId);
        this.writeString(out, this.subscriberGroup);
        this.writeString(out, this.credentialFilename);
        this.writeString(out, this.passphrase);
        this.writeString(out, this.sslProtocol);
        out.writeInt(this.maxRetryCount);
        out.writeInt(this.retryCount);
        out.writeBoolean(this.pauseNotify);
        out.writeBoolean(this.removeOnStartup());
        this.writeString(out, this.monitorConsumerURL != null ? this.monitorConsumerURL.toString() : null);
        if (this.topic != null) {
            this.writeString(out, this.topic.getName());
            this.writeString(out, this.topic.getVisibility());
            Dialect[] dialect = this.topic.getDialect();
            if (dialect != null) {
                out.writeInt(dialect.length);
                for (int i = 0; i < dialect.length; ++i) {
                    this.writeString(out, dialect[i].getName());
                    this.writeStringArray(out, dialect[i].getQueryLanguage());
                }
            } else {
                out.writeInt(-1);
            }
        } else {
            out.writeUTF("topic_null");
        }
        if (this.policy != null) {
            out.writeInt(this.policy.getRate());
            Query query = this.policy.getQuery();
            if (query != null) {
                this.writeString(out, query.getExpression());
                this.writeString(out, query.getQueryLanguage());
            } else {
                out.writeUTF("query_null");
            }
            Action[] action = this.policy.getAction();
            if (action != null) {
                out.writeInt(action.length);
                for (int i = 0; i < action.length; ++i) {
                    this.writeString(out, action[i].getName());
                    out.writeBoolean(action[i].isDoActionWhenQueryIs());
                    Parameter[] param = action[i].getParameter();
                    if (param != null) {
                        out.writeInt(param.length);
                        for (int j = 0; j < param.length; ++j) {
                            this.writeString(out, param[j].getName());
                            out.writeObject(param[j].getValue());
                        }
                        continue;
                    }
                    out.writeInt(-1);
                }
            } else {
                out.writeInt(-1);
            }
        } else {
            out.writeInt(-1);
        }
    }

    public Subscription cloneSubscription() throws IllegalArgumentException, Exception {
        Property[] property;
        Subscription subscription = new Subscription();
        subscription.setId(this.getId());
        subscription.setName(this.getName());
        subscription.setExpirationTime(this.getExpirationTime());
        subscription.setType(this.getType());
        subscription.setMonitorConsumerURL(new URI(this.getMonitorConsumerURL().toString()));
        if (this.getJarPath() != null) {
            subscription.setJarPath(new URI(this.getJarPath().toString()));
        }
        if ((property = this.getProperty()) != null) {
            org.glite.ce.monitorapij.types.Property[] newProperty = new org.glite.ce.monitorapij.types.Property[property.length];
            for (int i = 0; i < property.length; ++i) {
                newProperty[i] = new org.glite.ce.monitorapij.types.Property();
                newProperty[i].setName(property[i].getName());
                newProperty[i].setValue(property[i].getValue());
            }
            subscription.setProperty(newProperty);
        }
        Topic topic = this.getTopic();
        org.glite.ce.monitorapij.types.Topic newtopic = new org.glite.ce.monitorapij.types.Topic();
        newtopic.setName(topic.getName());
        Dialect[] dialect = topic.getDialect();
        if (dialect != null) {
            org.glite.ce.monitorapij.types.Dialect[] newDialect = new org.glite.ce.monitorapij.types.Dialect[dialect.length];
            for (int i = 0; i < dialect.length; ++i) {
                newDialect[i] = new org.glite.ce.monitorapij.types.Dialect();
                newDialect[i].setName(dialect[i].getName());
                newDialect[i].setQueryLanguage(dialect[i].getQueryLanguage());
            }
            newtopic.setDialect(newDialect);
        }
        subscription.setTopic(newtopic);
        Policy policy = this.getPolicy();
        if (policy != null) {
            Action[] action;
            org.glite.ce.monitorapij.types.Policy newPolicy = new org.glite.ce.monitorapij.types.Policy();
            newPolicy.setRate(policy.getRate());
            Query query = policy.getQuery();
            if (query != null) {
                org.glite.ce.monitorapij.types.Query tmpQuery = new org.glite.ce.monitorapij.types.Query();
                tmpQuery.setExpression(query.getExpression());
                tmpQuery.setQueryLanguage(query.getQueryLanguage());
                newPolicy.setQuery(tmpQuery);
            }
            if ((action = policy.getAction()) != null) {
                org.glite.ce.monitorapij.types.Action[] newAction = new org.glite.ce.monitorapij.types.Action[action.length];
                for (int i = 0; i < action.length; ++i) {
                    newAction[i] = new org.glite.ce.monitorapij.types.Action();
                    newAction[i].setName(action[i].getName());
                    newAction[i].setDoActionWhenQueryIs(action[i].isDoActionWhenQueryIs());
                    Parameter[] parameter = action[i].getParameter();
                    if (parameter == null) continue;
                    org.glite.ce.monitorapij.types.Parameter[] newParameter = new org.glite.ce.monitorapij.types.Parameter[parameter.length];
                    for (int j = 0; j < parameter.length; ++j) {
                        newParameter[j] = new org.glite.ce.monitorapij.types.Parameter();
                        newParameter[j].setName(parameter[j].getName());
                        newParameter[j].setValue((String)parameter[j].getValue());
                    }
                    newAction[i].setParameter(newParameter);
                }
                newPolicy.setAction(newAction);
            }
            subscription.setPolicy(newPolicy);
        }
        return subscription;
    }

    private void writeString(ObjectOutput out, String s) throws IOException {
        if (s != null) {
            out.writeUTF(s);
        } else {
            out.writeUTF("_null_");
        }
    }

    private void writeStringArray(ObjectOutput out, String[] array) throws IOException {
        if (array != null) {
            out.writeInt(array.length);
            for (int k = 0; k < array.length; ++k) {
                if (array[k] != null) {
                    out.writeUTF(array[k]);
                    continue;
                }
                out.writeUTF("");
            }
        } else {
            out.writeInt(-1);
        }
    }
}

