/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.monitorapij.resource.types;

import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.URISyntaxException;
import java.util.Calendar;
import org.apache.axis2.databinding.types.URI;
import org.glite.ce.commonj.configuration.CEConfigResource;
import org.glite.ce.monitorapij.resource.Resource;
import org.glite.ce.monitorapij.resource.types.Property;

public class CEMonResource
implements Externalizable,
Resource,
CEConfigResource {
    protected transient boolean newResource;
    protected transient Calendar creationTime;
    protected String id;
    protected String name;
    protected String type;
    protected java.net.URI jarPath;
    protected Property[] property;

    public CEMonResource() {
    }

    public CEMonResource(String name, String type) {
        this.name = name;
        this.type = type;
    }

    public CEMonResource(org.glite.ce.monitorapij.types.CEMonResource resource) {
        this.name = resource.getName();
        this.id = resource.getId();
        this.type = resource.getType();
        try {
            this.jarPath = new java.net.URI(resource.getJarPath().toString());
        }
        catch (Throwable th) {
            this.jarPath = null;
        }
        org.glite.ce.monitorapij.types.Property[] oldProps = resource.getProperty();
        this.property = new Property[oldProps.length];
        for (int k = 0; k < oldProps.length; ++k) {
            this.property[k] = new Property(oldProps[k]);
        }
    }

    public String getCompleteInfo() {
        StringBuffer info = new StringBuffer("id=");
        info.append(this.id);
        info.append("] - name=[");
        info.append(this.name);
        info.append("] - type=[");
        info.append(this.type);
        info.append("] - CreationTime=[");
        info.append(this.getCreationTime().getTime().toString());
        info.append("]");
        return info.toString();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public java.net.URI getJarPath() {
        return this.jarPath;
    }

    public URI cloneURI() {
        URI result = new URI();
        try {
            result.setScheme(this.jarPath.getScheme());
            result.setHost(this.jarPath.getHost());
            result.setPort(this.jarPath.getPort());
            result.setPath(this.jarPath.getPath());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }

    public void setJarPath(java.net.URI jarPath) {
        this.jarPath = jarPath;
    }

    public Property[] getProperty() {
        return this.property;
    }

    public org.glite.ce.monitorapij.types.Property[] cloneProperties() {
        org.glite.ce.monitorapij.types.Property[] result = new org.glite.ce.monitorapij.types.Property[this.property.length];
        for (int k = 0; k < this.property.length; ++k) {
            result[k] = new org.glite.ce.monitorapij.types.Property();
            result[k].setName(this.property[k].getName());
            result[k].setValue(this.property[k].getValue());
        }
        return result;
    }

    public Property getProperty(int i) {
        if (i >= 0 && i < this.property.length) {
            return this.property[i];
        }
        return null;
    }

    public void setProperty(Property[] property) {
        this.property = property;
    }

    public void setProperty(int i, Property p) {
        if (i >= 0 && i < this.property.length) {
            this.property[i] = p;
        }
    }

    public boolean isNew() {
        return this.newResource;
    }

    public void setNew(boolean b) {
        this.newResource = b;
    }

    public Calendar getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Calendar time) {
        this.creationTime = time;
    }

    public Property getProperty(String name) {
        Property[] localProps = this.getProperty();
        if (localProps == null) {
            return null;
        }
        for (int i = 0; i < localProps.length; ++i) {
            if (!localProps[i].getName().equalsIgnoreCase(name)) continue;
            return localProps[i];
        }
        return null;
    }

    public boolean exists() {
        try {
            File file = new File(this.getJarPath().getPath());
            return file.exists();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public Calendar lastModified() {
        Calendar time = null;
        try {
            File file = new File(this.getJarPath().getPath());
            time = Calendar.getInstance();
            time.setTimeInMillis(file.lastModified());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return time;
    }

    public Object clone() {
        CEMonResource result = new CEMonResource();
        result.setId(this.getId());
        result.setName(this.getName());
        result.setType(this.getType());
        result.setJarPath(this.getJarPath());
        Property[] oldProps = this.getProperty();
        if (oldProps == null) {
            result.setProperty(null);
        } else {
            Property[] newProps = new Property[oldProps.length];
            for (int k = 0; k < oldProps.length; ++k) {
                newProps[k] = new Property(oldProps[k].getName(), oldProps[k].getValue());
            }
            result.setProperty(newProps);
        }
        result.setNew(false);
        result.setCreationTime(Calendar.getInstance());
        return result;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeBoolean(this.newResource);
        this.writeCalendar(out, this.creationTime);
        this.writeString(out, this.id);
        this.writeString(out, this.name);
        this.writeString(out, this.type);
        this.writeString(out, this.jarPath != null ? this.jarPath.toString() : null);
        if (this.property != null) {
            out.writeInt(this.property.length);
            for (int i = 0; i < this.property.length; ++i) {
                this.writeString(out, this.property[i].getName());
                this.writeString(out, this.property[i].getValue());
            }
        } else {
            out.writeInt(-1);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.newResource = in.readBoolean();
        this.setCreationTime(this.readCalendar(in));
        this.setId(this.readString(in));
        this.setName(this.readString(in));
        this.setType(this.readString(in));
        try {
            String uri = this.readString(in);
            if (uri != null) {
                this.setJarPath(new java.net.URI(uri));
            }
        }
        catch (URISyntaxException ex) {
            // empty catch block
        }
        int size = in.readInt();
        if (size >= 0) {
            Property[] property = new Property[size];
            for (int k = 0; k < size; ++k) {
                property[k] = new Property(this.readString(in), this.readString(in));
            }
            this.setProperty(property);
        }
    }

    private void writeString(ObjectOutput out, String s) throws IOException {
        if (s != null) {
            out.writeUTF(s);
        } else {
            out.writeUTF("_null_");
        }
    }

    private String readString(ObjectInput in) throws IOException {
        String s = in.readUTF();
        return s.equals("_null_") ? null : s;
    }

    private void writeCalendar(ObjectOutput out, Calendar cal) throws IOException {
        if (cal != null) {
            out.writeLong(cal.getTimeInMillis());
        } else {
            out.writeLong(0L);
        }
    }

    private Calendar readCalendar(ObjectInput in) throws IOException {
        long ts = in.readLong();
        if (ts == 0L) {
            return null;
        }
        Calendar result = Calendar.getInstance();
        result.setTimeInMillis(ts);
        return result;
    }
}

