/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.monitor.action;

import org.glite.ce.monitorapij.queryprocessor.QueryResult;
import org.glite.ce.monitorapij.resource.types.Action;
import org.glite.ce.monitorapij.resource.types.Parameter;
import org.glite.ce.monitorapij.resource.types.Property;
import org.glite.ce.monitorapij.ws.CEMonitorConsumerStub;

public class SendExpiredNotificationAction
extends Action {
    private static final long serialVersionUID = 1318511605L;

    public SendExpiredNotificationAction() {
        super("SendExpiredNotification");
        Property property = new Property("supportedDialectsList", "LFID,ISM_LDIF,OLD_CLASSAD,NEW_CLASSAD,ISM_CLASSAD");
        this.setProperty(new Property[]{property});
    }

    public synchronized void execute() throws Exception {
        Parameter parameter = this.getParameter("notification");
        if (parameter == null) {
            return;
        }
        CEMonitorConsumerStub.Notification notification = (CEMonitorConsumerStub.Notification)parameter.getValue();
        parameter = this.getParameter("queryResult");
        if (parameter == null) {
            return;
        }
        QueryResult[] result = (QueryResult[])parameter.getValue();
        String dialect = notification.getTopic().getDialect()[0].getName();
        boolean isISM_LDIF = dialect.toLowerCase().indexOf("ldif") != -1;
        CEMonitorConsumerStub.Event[] eventArray = notification.getEvent();
        for (int i = 0; i < eventArray.length; ++i) {
            CEMonitorConsumerStub.Event event = eventArray[i];
            QueryResult eventResult = result[i];
            for (int j = 0; j < eventResult.size(); ++j) {
                if (eventResult.isSuccessfully(j) != this.isDoActionWhenQueryIs()) continue;
                String[] msgList = event.getMessage();
                String msg = msgList[j];
                int index = msg.indexOf("TTLCEinfo");
                if (index > -1) {
                    msg = msg.substring(0, index);
                }
                if (isISM_LDIF) {
                    if (j > 0) {
                        msg = msg + "\nTTLCEinfo: 0";
                    }
                } else {
                    msg = msg.substring(0, msg.length() - 2);
                    msg = msg + "\n\tTTLCEinfo = 0;\n]";
                }
                msgList[j] = msg;
                event.setMessage(msgList);
            }
        }
    }
}

