/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.monitor.queryprocessor;

import condor.classad.ClassAd;
import condor.classad.ClassAdParser;
import condor.classad.Expr;
import condor.classad.RecordExpr;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import org.glite.ce.monitorapij.queryprocessor.QueryProcessor;
import org.glite.ce.monitorapij.queryprocessor.QueryResult;
import org.glite.ce.monitorapij.resource.Resource;
import org.glite.ce.monitorapij.resource.types.CEMonResource;
import org.glite.ce.monitorapij.resource.types.Query;
import org.glite.ce.monitorapij.sensor.SensorEvent;
import org.glite.ce.monitorapij.types.TopicEvent;

public class ClassAdProcessor
extends CEMonResource
implements Resource,
QueryProcessor {
    private static final long serialVersionUID = 1L;

    public ClassAdProcessor() {
        super("ClassAd", "QueryProcessor");
    }

    private void checkQuery(Query query) throws Exception {
        if (query == null) {
            throw new Exception("Invalid argument: the query is null!");
        }
        if (query.getQueryLanguage() == null) {
            throw new Exception("the query language is null");
        }
        if (!query.getQueryLanguage().equalsIgnoreCase(this.getName())) {
            throw new Exception("Query Language mismatch: expected \"" + this.getName() + "\", found \"" + query.getQueryLanguage() + "\"");
        }
        if (query.getExpression() == null) {
            throw new Exception("the query expression is null");
        }
    }

    private void checkEvent(TopicEvent event) throws Exception {
        if (event == null) {
            throw new Exception("Invalid argument: the event is null!");
        }
        if (event.getMessage() == null || event.getMessage().length == 0) {
            throw new Exception("the event is empty");
        }
    }

    private Expr makeClassAdExpression(StringReader input) {
        int format = 0;
        boolean tracing = false;
        ClassAdParser parser = new ClassAdParser((Reader)input, format);
        parser.enableTracing(tracing);
        return parser.parse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryResult evaluate(Query query, SensorEvent event) throws Exception {
        this.checkQuery(query);
        if (event == null) {
            throw new Exception("Invalid argument: the event is null!");
        }
        ArrayList goodMessages = new ArrayList(0);
        String[] messages = null;
        QueryResult queryResult = null;
        int index = 0;
        SensorEvent se = event;
        messages = event.getMessage();
        if (messages == null || messages.length == 0) {
            return new QueryResult(0);
        }
        queryResult = new QueryResult(messages.length);
        StringReader input = new StringReader("[test = " + query.getExpression() + " ];");
        ClassAdParser parser = new ClassAdParser((Reader)input, 0);
        parser.enableTracing(false);
        Expr p = parser.parse();
        for (int i = 0; i < messages.length; ++i) {
            try {
                StringReader input2 = new StringReader(messages[i]);
                parser.reset((Reader)input2);
                RecordExpr prova = (RecordExpr)parser.parse();
                prova.insertAttribute("test", (Expr)p.selectExpr("test"));
                Expr val = ClassAd.eval((RecordExpr)prova, (String[])new String[]{"test"});
                queryResult.setResult(index, val.isTrue());
                continue;
            }
            catch (Exception ex) {
                queryResult.setResult(index, false);
                continue;
            }
            finally {
                ++index;
            }
        }
        return queryResult;
    }
}

