/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.monitor.registry;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import org.apache.log4j.Logger;
import org.glite.ce.monitorapij.resource.types.SubscriptionPersistent;
import org.glite.ce.monitorapij.resource.types.Topic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubscriptionRegistry {
    private static final Logger logger = Logger.getLogger((String)SubscriptionRegistry.class.getName());
    private DirContext rootCtx;

    public SubscriptionRegistry(String cacheDir, int cacheSize, String factory) throws FileNotFoundException, NamingException {
        Hashtable<String, Object> env = new Hashtable<String, Object>();
        env.put("java.naming.factory.initial", factory);
        env.put("java.naming.provider.url", cacheDir);
        env.put("cache.size", new Integer(cacheSize));
        logger.debug((Object)("factory=[" + factory + "] - cacheDir=[" + cacheDir + "] - cacheSize=[" + cacheSize + "]"));
        InitialDirContext topCtx = new InitialDirContext(env);
        try {
            this.rootCtx = (DirContext)topCtx.lookup("subscription");
        }
        catch (NameNotFoundException nnfEx) {
            logger.warn((Object)"Context subscription not found, trying to create it");
            this.rootCtx = topCtx.createSubcontext("subscription", null);
        }
        try {
            NamingEnumeration<NameClassPair> allNames = this.rootCtx.list("");
            while (allNames.hasMoreElements()) {
                SubscriptionPersistent subscription;
                NameClassPair item = (NameClassPair)allNames.nextElement();
                Object obj = this.rootCtx.lookup(item.getName());
                if (obj == null || !(obj instanceof SubscriptionPersistent) || !(subscription = (SubscriptionPersistent)obj).removeOnStartup() && !subscription.isExpired()) continue;
                logger.debug((Object)("unregistering subscription: id = " + subscription.getId()));
                try {
                    this.unregister(subscription);
                }
                catch (Throwable th) {
                    logger.error((Object)th.getMessage(), th);
                }
            }
        }
        catch (Throwable th) {
            logger.error((Object)th.getMessage(), th);
        }
    }

    public void register(SubscriptionPersistent subscription) throws IllegalArgumentException, NamingException {
        if (subscription == null) {
            throw new IllegalArgumentException("the subscription is null");
        }
        if (subscription.getId() == null) {
            throw new IllegalArgumentException("The key argument is null");
        }
        this.rootCtx.bind(subscription.getId(), (Object)subscription);
    }

    public void unregister(SubscriptionPersistent subscription) throws IllegalArgumentException, NamingException {
        if (subscription == null) {
            throw new IllegalArgumentException("the subscription is null");
        }
        this.unregister(subscription.getId());
    }

    public void unregister(String key) throws NamingException {
        if (key == null) {
            throw new IllegalArgumentException("The key argument is null");
        }
        this.rootCtx.unbind(key);
    }

    public void update(SubscriptionPersistent subscription) throws IllegalArgumentException, NamingException {
        if (subscription == null) {
            throw new IllegalArgumentException("the subscription is null");
        }
        if (subscription.getId() == null) {
            throw new IllegalArgumentException("The key argument is null");
        }
        this.rootCtx.rebind(subscription.getId(), (Object)subscription);
    }

    public SubscriptionPersistent getSubscription(String id) throws NamingException {
        SubscriptionPersistent subscription = null;
        if (id != null) {
            try {
                logger.debug((Object)("Looking for " + id));
                subscription = (SubscriptionPersistent)this.rootCtx.lookup(id);
            }
            catch (ClassCastException ccEx) {
                logger.error((Object)ccEx);
            }
        }
        return subscription;
    }

    public ArrayList<SubscriptionPersistent> getAllSubscriptions() {
        return this.getSubscriptionByObject(null);
    }

    public ArrayList<SubscriptionPersistent> getSubscriptionByTopic(Topic topic) {
        if (topic == null) {
            return null;
        }
        return this.getSubscriptionByObject(topic);
    }

    public ArrayList<SubscriptionPersistent> getSubscriptionBySubscriberId(String subscriberId) {
        if (subscriberId == null) {
            return null;
        }
        return this.getSubscriptionByObject(subscriberId);
    }

    private ArrayList<SubscriptionPersistent> getSubscriptionByObject(Object criterion) {
        ArrayList<SubscriptionPersistent> goodSubscriptions = new ArrayList<SubscriptionPersistent>();
        try {
            NamingEnumeration<NameClassPair> allNames = this.rootCtx.list("");
            while (allNames.hasMoreElements()) {
                NameClassPair item = (NameClassPair)allNames.nextElement();
                Object obj = this.rootCtx.lookup(item.getName());
                if (obj == null || !(obj instanceof SubscriptionPersistent)) continue;
                SubscriptionPersistent subscription = (SubscriptionPersistent)obj;
                if (subscription.isExpired()) {
                    try {
                        this.unregister(subscription.getId());
                    }
                    catch (Exception ex) {
                        logger.error((Object)ex.getMessage(), (Throwable)ex);
                    }
                    continue;
                }
                if (criterion == null) {
                    goodSubscriptions.add(subscription);
                    continue;
                }
                if (criterion instanceof Topic) {
                    Topic topic = (Topic)criterion;
                    if (subscription.getTopic() == null || !subscription.getTopic().getName().equals(topic.getName())) continue;
                    goodSubscriptions.add(subscription);
                    continue;
                }
                String subscriberId = criterion.toString();
                String sub_Id = subscription.getSubscriberId();
                if (sub_Id == null || !sub_Id.equals(subscriberId)) continue;
                goodSubscriptions.add(subscription);
            }
        }
        catch (NamingException nEx) {
            logger.error((Object)nEx);
        }
        return goodSubscriptions;
    }
}

