/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.monitor.holder;

import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Iterator;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.glite.ce.commonj.utils.Timer;
import org.glite.ce.commonj.utils.TimerTask;
import org.glite.ce.monitor.configuration.CEMonServiceConfig;
import org.glite.ce.monitor.holder.EventNotFoundException;
import org.glite.ce.monitor.holder.SensorEventArrayList;
import org.glite.ce.monitor.holder.SensorEventEnumeration;
import org.glite.ce.monitor.holder.SensorHolder;
import org.glite.ce.monitor.holder.TopicEventInfoPersistent;
import org.glite.ce.monitor.holder.TopicNotFoundException;
import org.glite.ce.monitorapij.resource.types.Topic;
import org.glite.ce.monitorapij.sensor.Sensor;
import org.glite.ce.monitorapij.sensor.SensorEvent;

public final class TopicHolder {
    private static final Logger logger = Logger.getLogger((String)TopicHolder.class.getName());
    private int eventId = 0;
    private Timer timer = new Timer("TopicHolder_TIMER", true);
    private TopicEventInfoPersistent backend = null;
    private Hashtable<String, EventRemover> eventRemoverTable = new Hashtable(0);
    private SensorHolder sensorHolder;

    public TopicHolder(SensorHolder sensorHolder) {
        File dir;
        this.sensorHolder = sensorHolder;
        String cachePath = null;
        int cacheSize = 100;
        CEMonServiceConfig sConfiguration = CEMonServiceConfig.getConfiguration();
        if (sConfiguration != null) {
            cachePath = sConfiguration.getGlobalAttributeAsString("backendLocation");
            cacheSize = sConfiguration.getGlobalAttributeAsInt("backendCacheSize", 100);
        }
        if (cachePath == null) {
            cachePath = "/var/cache/cemonitor";
        }
        if (!(dir = new File(cachePath)).exists()) {
            dir.mkdirs();
        }
        try {
            this.backend = new TopicEventInfoPersistent(sensorHolder, "org.glite.ce.commonj.jndi.provider.fscachedprovider.CEGeneralDirContextFactory", cachePath, cacheSize);
        }
        catch (NamingException e) {
            logger.error((Object)("CTOR() - NamingException catched: [" + e.getMessage() + "]. Follow the Stack trace:"), (Throwable)e);
        }
    }

    public void destroy() {
        Iterator<EventRemover> iterator = this.eventRemoverTable.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().cancel();
        }
        this.timer.cancel();
        this.timer.purge();
        this.eventRemoverTable.clear();
    }

    public final void addTopic(Topic topic) throws IllegalArgumentException, NameAlreadyBoundException, NamingException {
        if (topic == null) {
            throw new IllegalArgumentException("topic not specified!");
        }
        if (topic.isPurgeAllEventsOnStartup()) {
            logger.info((Object)("addTopic() - purging all events belonging to " + topic.getName() + " topic"));
            try {
                this.backend.removeTopic(topic);
            }
            catch (TopicNotFoundException e) {
                logger.error((Object)("addTopic() - TopicNotFoundException catched: [" + e.getMessage() + "]. Follow the Stack trace:"), (Throwable)e);
            }
        }
        this.backend.bindTopic(topic, true);
        if (!this.eventRemoverTable.containsKey(topic.getName())) {
            EventRemover eventRemover = new EventRemover(topic.getName());
            this.eventRemoverTable.put(topic.getName(), eventRemover);
            this.timer.schedule((TimerTask)eventRemover, 0L, 600000L, TimerTask.EXECUTION_TYPE.FIXED_DELAY_POST_EXECUTION);
        }
    }

    public final boolean checkSupportedTopic(String topicName) {
        return this.backend.checkSupportedTopic(topicName);
    }

    public final boolean checkSupportedTopic(Topic topic) {
        return this.backend.checkSupportedTopic(topic);
    }

    public final synchronized int getEventId() {
        return this.eventId++;
    }

    public final SensorEventArrayList getEvents(String topicName, String receiverId, String receiverGroup) throws IllegalArgumentException, TopicNotFoundException {
        Topic topic = this.backend.getTopic(topicName);
        return this.getEvents(topic, receiverId, receiverGroup);
    }

    public final SensorEventArrayList getEvents(Topic topic, String receiverId, String receiverGroup) throws IllegalArgumentException, TopicNotFoundException {
        if (topic == null) {
            throw new IllegalArgumentException("The topic argument is null");
        }
        if (!this.backend.checkSupportedTopic(topic)) {
            throw new TopicNotFoundException("Topic \"" + topic.getName() + "\" not found");
        }
        String group = null;
        if (topic.getVisibility().equalsIgnoreCase("ALL")) {
            group = "ALL";
        } else if (topic.getVisibility().equalsIgnoreCase("GROUP")) {
            if (receiverGroup == null) {
                throw new IllegalArgumentException("the receiverGroup cannot be null when the topic visibility is \"GROUP\"");
            }
            group = receiverGroup;
        } else if (topic.getVisibility().equalsIgnoreCase("USER")) {
            if (receiverId == null) {
                throw new IllegalArgumentException("the receiverId cannot be null when the topic visibility is \"USER\"");
            }
            group = receiverId;
        }
        logger.debug((Object)("TopicHolder getEvents: retrieving events from topic " + topic.getName() + "..."));
        SensorEventArrayList eventList = this.backend.getTopicEvents(topic.getName(), group);
        logger.debug((Object)("TopicHolder getEvents: retrieving " + eventList.size() + " events from topic " + topic.getName() + " DONE!!!"));
        eventList.setSensorHolder(this.sensorHolder);
        return eventList;
    }

    public final Topic getTopic(String name) throws IllegalArgumentException, TopicNotFoundException {
        return this.backend.getTopic(name);
    }

    public final Topic[] getTopics() {
        Sensor[] sensorArray = this.sensorHolder.getSensors();
        ArrayList<Topic> topicList = new ArrayList<Topic>(0);
        for (int i = 0; i < sensorArray.length; ++i) {
            try {
                topicList.add(this.backend.getTopic(sensorArray[i].getType()));
                continue;
            }
            catch (IllegalArgumentException e) {
                logger.error((Object)e.getMessage());
                continue;
            }
            catch (TopicNotFoundException e) {
                logger.error((Object)e.getMessage());
            }
        }
        Topic[] topicArray = new Topic[topicList.size()];
        topicArray = topicList.toArray(topicArray);
        return topicArray;
    }

    public final void removeTopic(String topicName) throws IllegalArgumentException, TopicNotFoundException {
        this.backend.removeTopic(topicName);
        EventRemover eventRemover = this.eventRemoverTable.remove(topicName);
        if (eventRemover != null) {
            eventRemover.cancel();
            this.timer.purge();
        }
    }

    public final void removeTopic(Topic topic) throws IllegalArgumentException, TopicNotFoundException {
        this.backend.removeTopic(topic);
        EventRemover eventRemover = this.eventRemoverTable.remove(topic.getName());
        if (eventRemover != null) {
            eventRemover.cancel();
            this.timer.purge();
        }
    }

    public final void removeEvent(SensorEvent event) throws IllegalArgumentException, EventNotFoundException {
        if (event == null) {
            throw new IllegalArgumentException("Event argument not specified!");
        }
        this.backend.removeTopicEvent(event);
        logger.debug((Object)("removed event [id=" + event.getID() + "] [name=" + event.getName() + "]"));
    }

    public final void setCurrentEvent(String topicName, SensorEvent event) throws IllegalArgumentException, TopicNotFoundException {
        if (topicName != null) {
            this.setCurrentEvent(this.getTopic(topicName), event);
        }
    }

    public final void setCurrentEvent(Topic topic, SensorEvent event) throws IllegalArgumentException, TopicNotFoundException {
        if (topic == null) {
            throw new IllegalArgumentException("The topic argument is null");
        }
        if (event == null) {
            throw new IllegalArgumentException("The event argument is null");
        }
        if (!this.backend.checkSupportedTopic(topic)) {
            throw new TopicNotFoundException("Topic \"" + topic.getName() + "\" not found");
        }
        SensorEvent eventClone = (SensorEvent)event.clone();
        if (topic.isEventOverwriteModeActive() && event.getName() != null) {
            String eventId = eventClone.getName();
        } else {
            eventClone.setID(this.getEventId());
            String eventId = "" + eventClone.getID();
            eventClone.setName(eventId);
        }
        if (event.getExpirationTime() == null) {
            Calendar time = (Calendar)eventClone.getTimestamp().clone();
            time.add(6, 1);
            eventClone.setExpirationTime(time);
        }
        try {
            this.backend.bindTopicEvent(topic, eventClone);
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NameAlreadyBoundException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NamingException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private final class EventRemover
    extends TimerTask {
        public EventRemover(String topicName) {
            super(topicName);
        }

        public void run() {
            if (TopicHolder.this.backend == null) {
                logger.warn((Object)"EventRemover: backend is null!");
                return;
            }
            String[] eventGroupArray = TopicHolder.this.backend.getTopicEventGroups(this.getName());
            SensorEventEnumeration eventEnum = null;
            for (int i = 0; i < eventGroupArray.length; ++i) {
                logger.info((Object)("EventRemover: removing expired events for the topic: " + this.getName() + " [event group: " + eventGroupArray[i] + "] ... "));
                eventEnum = TopicHolder.this.backend.getTopicEventsEnumeration(this.getName(), eventGroupArray[i]);
                SensorEvent event = null;
                while (eventEnum.hasMoreElements()) {
                    event = eventEnum.nextSensorEvent();
                    if (event != null && event.isExpired()) {
                        try {
                            logger.debug((Object)("EventRemover: removing event from topic: " + this.getName() + " [event group: " + eventGroupArray[i] + "] event id = " + event.getName()));
                            TopicHolder.this.backend.removeTopicEvent(event);
                        }
                        catch (EventNotFoundException e) {
                            logger.error((Object)e.getMessage(), (Throwable)e);
                        }
                        catch (IllegalArgumentException e) {
                            logger.error((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                    event = null;
                }
                logger.info((Object)("EventRemover: removing expired events for the topic: " + this.getName() + " [event group: " + eventGroupArray[i] + "] ... DONE!!!!!"));
            }
        }
    }
}

