/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.monitor.holder;

import java.util.ArrayList;
import java.util.Hashtable;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import org.apache.log4j.Logger;
import org.glite.ce.commonj.jndi.provider.fscachedprovider.CEGeneralAttributes;
import org.glite.ce.monitor.holder.EventNotFoundException;
import org.glite.ce.monitor.holder.SensorEventArrayList;
import org.glite.ce.monitor.holder.SensorEventEnumeration;
import org.glite.ce.monitor.holder.SensorHolder;
import org.glite.ce.monitor.holder.TopicNotFoundException;
import org.glite.ce.monitorapij.resource.types.Dialect;
import org.glite.ce.monitorapij.resource.types.Topic;
import org.glite.ce.monitorapij.sensor.Sensor;
import org.glite.ce.monitorapij.sensor.SensorEvent;

public final class TopicEventInfoPersistent {
    private static Logger logger = Logger.getLogger((String)TopicEventInfoPersistent.class.getName());
    private DirContext rootCtx;
    private SensorHolder sensorHolder;
    private static final String TOPIC_ATTR_VISIBILITY = "visibility";
    private static final String TOPIC_ATTR_DIALECT = "dialect";
    private static final String TOPIC_ATTR_IsEventOverwriteModeActive = "isEventOverwriteModeActive";

    public TopicEventInfoPersistent(SensorHolder sensorHolder, String factory, String cemonCacheDir, int cacheSize) throws NamingException {
        this.sensorHolder = sensorHolder;
        Hashtable<String, Object> env = new Hashtable<String, Object>(0);
        env.put("java.naming.factory.initial", factory);
        env.put("java.naming.provider.url", cemonCacheDir);
        env.put("cache.size", new Integer(cacheSize));
        this.rootCtx = (DirContext)new InitialDirContext(env).lookup("");
    }

    public void bindTopic(Topic topic, boolean useRebind) throws IllegalArgumentException, NamingException, NameAlreadyBoundException {
        if (topic == null) {
            throw new IllegalArgumentException("The topic argument is null");
        }
        String objName = topic.getName();
        DirContext topicContext = null;
        boolean nameAlreadyBound = false;
        try {
            topicContext = (DirContext)this.rootCtx.lookup(objName);
            nameAlreadyBound = true;
        }
        catch (NameNotFoundException nfEx) {
            nameAlreadyBound = false;
        }
        if (nameAlreadyBound && !useRebind) {
            throw new NameAlreadyBoundException("Topic \"" + objName + "\" already bound");
        }
        CEGeneralAttributes attributes = new CEGeneralAttributes();
        attributes.put(TOPIC_ATTR_VISIBILITY, (Object)topic.getVisibility());
        attributes.put(TOPIC_ATTR_IsEventOverwriteModeActive, (Object)new Boolean(topic.isEventOverwriteModeActive()));
        Dialect[] dialect = topic.getDialect();
        if (dialect != null) {
            BasicAttribute ba = new BasicAttribute(TOPIC_ATTR_DIALECT, true);
            for (int i = 0; i < dialect.length; ++i) {
                if (dialect[i] == null) continue;
                ba.add(dialect[i].getName());
                ba.add(dialect[i].getQueryLanguage());
            }
            attributes.put((Attribute)ba);
        }
        if (nameAlreadyBound) {
            topicContext.modifyAttributes("", 2, (Attributes)attributes);
        } else {
            topicContext = this.rootCtx.createSubcontext(objName, (Attributes)attributes);
        }
    }

    public void removeTopic(Topic topic) throws IllegalArgumentException, TopicNotFoundException {
        if (topic == null) {
            throw new IllegalArgumentException("The topic argument is null");
        }
        this.removeTopic(topic.getName());
    }

    public void removeTopic(String topicName) throws IllegalArgumentException, TopicNotFoundException {
        if (topicName == null) {
            throw new IllegalArgumentException("The topicName argument is null");
        }
        try {
            this.rootCtx.destroySubcontext(topicName);
        }
        catch (NamingException e) {
            throw new TopicNotFoundException("Topic \"" + topicName + "\" not found");
        }
    }

    public boolean checkSupportedTopic(Topic topic) {
        if (topic == null) {
            return false;
        }
        return this.checkSupportedTopic(topic.getName());
    }

    public boolean checkSupportedTopic(String topicName) {
        if (topicName == null) {
            return false;
        }
        try {
            NamingEnumeration<NameClassPair> allNames = this.rootCtx.list("");
            while (allNames.hasMoreElements()) {
                NameClassPair item = (NameClassPair)allNames.nextElement();
                if (!topicName.equals(item.getName())) continue;
                return true;
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return false;
    }

    public Topic[] getTopics() throws IllegalArgumentException {
        Topic[] topicArray = null;
        try {
            NamingEnumeration<NameClassPair> allNames = this.rootCtx.list("");
            ArrayList<Topic> list = new ArrayList<Topic>(0);
            while (allNames.hasMoreElements()) {
                NameClassPair item = (NameClassPair)allNames.nextElement();
                try {
                    list.add(this.getTopic(item.getName()));
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (TopicNotFoundException e) {
                    e.printStackTrace();
                }
            }
            topicArray = new Topic[list.size()];
            topicArray = list.toArray(topicArray);
        }
        catch (NamingException nEx) {
            topicArray = new Topic[]{};
        }
        return topicArray;
    }

    public Topic getTopic(String topicName) throws IllegalArgumentException, TopicNotFoundException {
        if (topicName == null) {
            throw new IllegalArgumentException("The topicName argument is null");
        }
        try {
            DirContext topicContext = (DirContext)this.rootCtx.lookup(topicName);
            Attributes attr = topicContext.getAttributes("", new String[]{TOPIC_ATTR_VISIBILITY, TOPIC_ATTR_DIALECT, TOPIC_ATTR_IsEventOverwriteModeActive});
            Topic topic = new Topic();
            topic.setName(topicName);
            Attribute attribute = attr.get(TOPIC_ATTR_VISIBILITY);
            if (attribute != null) {
                topic.setVisibility((String)attribute.get());
            }
            if ((attribute = attr.get(TOPIC_ATTR_IsEventOverwriteModeActive)) != null) {
                topic.setEventOverwriteModeActive(((Boolean)attribute.get()).booleanValue());
            }
            if ((attribute = attr.get(TOPIC_ATTR_DIALECT)) != null) {
                ArrayList<Dialect> list = new ArrayList<Dialect>(0);
                for (int index = 0; index < attribute.size(); index += 2) {
                    Dialect dialect = new Dialect((String)attribute.get(index));
                    dialect.setQueryLanguage((String[])attribute.get(index + 1));
                    list.add(dialect);
                }
                Dialect[] dialectArray = new Dialect[list.size()];
                dialectArray = list.toArray(dialectArray);
                topic.setDialect(dialectArray);
            }
            return topic;
        }
        catch (NamingException nEx) {
            throw new TopicNotFoundException("Topic \"" + topicName + "\" not supported");
        }
    }

    public SensorEventArrayList getTopicEvents(Topic topic, String eventGroup) throws IllegalArgumentException {
        if (topic == null) {
            throw new IllegalArgumentException("The topic argument is null");
        }
        return this.getTopicEvents(topic.getName(), eventGroup);
    }

    public SensorEventArrayList getTopicEvents(Topic topic) throws IllegalArgumentException {
        if (topic == null) {
            throw new IllegalArgumentException("The topic argument is null");
        }
        return this.getTopicEvents(topic.getName());
    }

    public String[] getTopicEventGroups(String topicName) throws IllegalArgumentException {
        if (topicName == null) {
            throw new IllegalArgumentException("The topicName argument is null");
        }
        String[] groupArray = null;
        ArrayList<String> list = new ArrayList<String>(0);
        try {
            NamingEnumeration<NameClassPair> allNames = this.rootCtx.list(topicName);
            while (allNames.hasMoreElements()) {
                NameClassPair item = (NameClassPair)allNames.nextElement();
                list.add(item.getName());
            }
            groupArray = new String[list.size()];
            groupArray = list.toArray(groupArray);
        }
        catch (NamingException nEx) {
            groupArray = new String[]{};
        }
        return groupArray;
    }

    public SensorEventArrayList getTopicEvents(String topicName) throws IllegalArgumentException {
        if (topicName == null) {
            throw new IllegalArgumentException("The topicName argument is null");
        }
        SensorEventArrayList list = new SensorEventArrayList(this.rootCtx);
        try {
            NamingEnumeration<NameClassPair> allNames = this.rootCtx.list(topicName);
            while (allNames.hasMoreElements()) {
                NameClassPair item = (NameClassPair)allNames.nextElement();
                list.addAll(this.getTopicEvents(topicName, item.getName()));
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return list;
    }

    public SensorEventArrayList getTopicEvents(String topicName, String eventGroup) throws IllegalArgumentException {
        if (topicName == null) {
            throw new IllegalArgumentException("The topicName argument is null");
        }
        if (eventGroup == null) {
            throw new IllegalArgumentException("The eventGroup argument is null");
        }
        SensorEventArrayList list = new SensorEventArrayList(this.rootCtx);
        try {
            NamingEnumeration<NameClassPair> allNames = this.rootCtx.list(topicName + "/" + eventGroup);
            while (allNames.hasMoreElements()) {
                NameClassPair item = (NameClassPair)allNames.nextElement();
                list.add(topicName + "/" + eventGroup + "/" + item.getName());
            }
        }
        catch (NamingException nEx) {
            logger.error((Object)nEx);
        }
        return list;
    }

    public SensorEventEnumeration getTopicEventsEnumeration(String topicName, String eventGroup) throws IllegalArgumentException {
        if (topicName == null) {
            throw new IllegalArgumentException("The topicName argument is null");
        }
        if (eventGroup == null) {
            throw new IllegalArgumentException("The eventGroup argument is null");
        }
        return new SensorEventEnumeration(topicName, eventGroup, this.rootCtx);
    }

    public SensorEvent getTopicEvent(Topic topic, String eventGroup, String eventName) throws IllegalArgumentException {
        if (topic == null) {
            throw new IllegalArgumentException("The topic argument is null");
        }
        return this.getTopicEvent(topic.getName(), eventGroup, eventName);
    }

    public SensorEvent getTopicEvent(String topicName, String eventGroup, String eventName) throws IllegalArgumentException {
        if (topicName == null) {
            throw new IllegalArgumentException("The topicName argument is null");
        }
        if (eventGroup == null) {
            throw new IllegalArgumentException("The eventGroup argument is null");
        }
        if (eventName == null) {
            throw new IllegalArgumentException("The eventName argument is null");
        }
        try {
            SensorEvent event = (SensorEvent)this.rootCtx.lookup(topicName + "/" + eventGroup + "/" + eventName);
            if (event != null) {
                event.setSource(this.sensorHolder.getSensorByName(event.getProducer()));
            }
            return event;
        }
        catch (NamingException nEx) {
            return null;
        }
    }

    public void removeTopicEvent(SensorEvent event) throws IllegalArgumentException, EventNotFoundException {
        String eventCtxName;
        block15: {
            if (event == null) {
                throw new IllegalArgumentException("The event argument is null");
            }
            Topic topic = null;
            try {
                Sensor sensor = this.sensorHolder.getSensorByType(event.getProducer());
                if (sensor != null) {
                    topic = this.getTopic(sensor.getType());
                }
            }
            catch (Exception e) {
                throw new EventNotFoundException(e);
            }
            if (topic == null) {
                throw new IllegalArgumentException("Topic \"" + event.getProducer() + "\" not found");
            }
            eventCtxName = null;
            try {
                if (topic.getVisibility().equalsIgnoreCase("ALL")) {
                    eventCtxName = this.rootCtx.composeName("ALL", topic.getName());
                    break block15;
                }
                if (topic.getVisibility().equalsIgnoreCase("GROUP")) {
                    if (event.getReceiverGroup() != null) {
                        eventCtxName = this.rootCtx.composeName(event.getReceiverGroup(), topic.getName());
                        break block15;
                    }
                    throw new EventNotFoundException("SensorEvent receiverGroup not defined!");
                }
                if (!topic.getVisibility().equalsIgnoreCase("USER")) break block15;
                if (event.getReceiverId() != null) {
                    eventCtxName = this.rootCtx.composeName(event.getReceiverId(), topic.getName());
                    break block15;
                }
                throw new EventNotFoundException("SensorEvent receiverId not defined!");
            }
            catch (NamingException e) {
                throw new EventNotFoundException(e);
            }
        }
        try {
            DirContext eventContext = (DirContext)this.rootCtx.lookup(eventCtxName);
            if (eventContext != null && event.getName() != null) {
                eventContext.unbind(event.getName());
            }
        }
        catch (NameNotFoundException e) {
            logger.error((Object)e.getMessage());
            throw new EventNotFoundException(e);
        }
        catch (NamingException e) {
            logger.error((Object)e.getMessage());
            throw new EventNotFoundException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void bindTopicEvent(Topic topic, SensorEvent event) throws IllegalArgumentException, NamingException, NameAlreadyBoundException {
        if (topic == null || topic.getName() == null) {
            throw new IllegalArgumentException("The topic argument is null");
        }
        if (event == null) {
            throw new IllegalArgumentException("The event argument is null");
        }
        event.setProducer(topic.getName());
        String eventCtxName = null;
        if (topic.getVisibility().equalsIgnoreCase("ALL")) {
            eventCtxName = this.rootCtx.composeName("ALL", topic.getName());
        } else if (topic.getVisibility().equalsIgnoreCase("GROUP")) {
            if (event.getReceiverGroup() == null) throw new NamingException("SensorEvent receiverGroup not defined!");
            eventCtxName = this.rootCtx.composeName(event.getReceiverGroup(), topic.getName());
        } else if (topic.getVisibility().equalsIgnoreCase("USER")) {
            if (event.getReceiverId() == null) throw new NamingException("SensorEvent receiverId not defined!");
            eventCtxName = this.rootCtx.composeName(event.getReceiverId(), topic.getName());
        }
        DirContext topicContext = (DirContext)this.rootCtx.createSubcontext(eventCtxName);
        if (topic.isEventOverwriteModeActive()) {
            try {
                topicContext.rebind(event.getName(), (Object)event);
                return;
            }
            catch (Exception e) {
                topicContext.bind(event.getName(), (Object)event);
            }
            return;
        } else {
            topicContext.bind(event.getName(), (Object)event);
        }
    }
}

