/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.monitor.holder;

import java.util.ArrayList;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import org.glite.ce.monitor.holder.SensorHolder;
import org.glite.ce.monitorapij.sensor.SensorEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SensorEventArrayList
implements Cloneable {
    private ArrayList<String> eventList = null;
    private DirContext rootCtx;
    private SensorHolder sensorHolder;

    public SensorEventArrayList() {
        this.eventList = new ArrayList(0);
    }

    public SensorEventArrayList(DirContext rootCtx) {
        this.eventList = new ArrayList(0);
        this.rootCtx = rootCtx;
    }

    public SensorEventArrayList(ArrayList<String> eventList, DirContext rootCtx) {
        this.eventList = eventList == null ? new ArrayList(0) : eventList;
        this.rootCtx = rootCtx;
    }

    public void setSensorHolder(SensorHolder sensorHolder) {
        this.sensorHolder = sensorHolder;
    }

    public ArrayList<String> getEventList() {
        return this.eventList;
    }

    public DirContext getDirContext() {
        return this.rootCtx;
    }

    public void setDirContext(DirContext rootCtx) {
        this.rootCtx = rootCtx;
    }

    public void addAll(SensorEventArrayList list) {
        if (list != null) {
            this.eventList.addAll(list.getEventList());
        }
    }

    public void add(String name) {
        if (name != null) {
            this.eventList.add(name);
        }
    }

    public void add(String[] name) {
        if (name == null) {
            return;
        }
        for (int i = 0; i < name.length; ++i) {
            this.eventList.add(name[i]);
        }
    }

    public synchronized SensorEventArrayList drain(int index) throws IndexOutOfBoundsException {
        if (index < 0) {
            throw new IndexOutOfBoundsException("the index is out of range (index < 0)");
        }
        if (index >= this.eventList.size()) {
            index = this.eventList.size();
        }
        SensorEventArrayList newList = new SensorEventArrayList(new ArrayList<String>(this.eventList.subList(0, index)), this.rootCtx);
        newList.setSensorHolder(this.sensorHolder);
        for (int i = 0; i < index; ++i) {
            this.eventList.remove(0);
        }
        return newList;
    }

    public SensorEvent get(int index) {
        if (index < 0 || index > this.eventList.size() - 1 || this.rootCtx == null) {
            return null;
        }
        try {
            SensorEvent event = (SensorEvent)this.rootCtx.lookup(this.eventList.get(index));
            if (event != null && this.sensorHolder != null) {
                event.setSource(this.sensorHolder.getSensorByType(event.getProducer()));
            }
            return event;
        }
        catch (NamingException ex) {
            return null;
        }
    }

    public SensorEvent remove(int index) {
        if (index >= 0 || index < this.eventList.size()) {
            String name = this.eventList.remove(index);
            try {
                SensorEvent event = (SensorEvent)this.rootCtx.lookup(name);
                if (event != null && this.sensorHolder != null) {
                    event.setSource(this.sensorHolder.getSensorByName(event.getProducer()));
                }
                return event;
            }
            catch (NamingException ex) {
                return null;
            }
        }
        return null;
    }

    public int size() {
        return this.eventList.size();
    }

    public boolean isEmpty() {
        return this.eventList.isEmpty();
    }

    public void clear() {
        this.eventList.clear();
    }

    public Object clone() {
        SensorEventArrayList result = new SensorEventArrayList();
        result.eventList = (ArrayList)this.eventList.clone();
        result.rootCtx = this.rootCtx;
        return result;
    }
}

