/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.monitor.holder;

import java.util.HashMap;
import org.apache.log4j.Logger;
import org.glite.ce.monitor.holder.ActionHolder;
import org.glite.ce.monitor.holder.NotificationHolder;
import org.glite.ce.monitor.holder.QueryProcessorHolder;
import org.glite.ce.monitor.holder.TopicHolder;
import org.glite.ce.monitor.registry.SubscriptionRegistry;
import org.glite.ce.monitorapij.resource.types.SubscriptionPersistent;

public class NotificationPool {
    private static final Logger logger = Logger.getLogger((String)NotificationPool.class.getName());
    private HashMap<String, NotificationHolder> pool = new HashMap();
    private boolean notificationSharedThread;

    public NotificationPool(boolean sharedThread) {
        this.notificationSharedThread = sharedThread;
    }

    public NotificationHolder activateHolder(String name, int rate, TopicHolder topicHolder, QueryProcessorHolder queryProcessorHolder, SubscriptionRegistry subscriptionRegistry) {
        if (this.pool.containsKey(name)) {
            return this.pool.get(name);
        }
        NotificationHolder holder = new NotificationHolder(name, rate, topicHolder, queryProcessorHolder, subscriptionRegistry, this);
        this.pool.put(name, holder);
        return holder;
    }

    public NotificationHolder activateHolder(SubscriptionPersistent subscription, TopicHolder topicHolder, ActionHolder actionHolder, QueryProcessorHolder queryProcessorHolder, SubscriptionRegistry subscriptionRegistry) {
        String name = this.getNameFromSubscription(subscription);
        int rate = subscription.getPolicy().getRate() * 1000;
        return this.activateHolder(name, rate, topicHolder, queryProcessorHolder, subscriptionRegistry);
    }

    public NotificationHolder getHolder(String name) {
        return this.pool.get(name);
    }

    public NotificationHolder getHolder(SubscriptionPersistent subscription) {
        if (subscription == null) {
            return null;
        }
        return this.pool.get(this.getNameFromSubscription(subscription));
    }

    public void check() {
        for (NotificationHolder holder : this.pool.values()) {
            if (holder.getSubscriptionListSize() != 0) continue;
            holder.destroy();
            this.pool.remove(holder.getName());
            logger.info((Object)("removed notificationHolder [name = " + holder.getName() + "]"));
        }
    }

    public void destroy() {
        for (NotificationHolder holder : this.pool.values()) {
            holder.destroy();
        }
        this.pool.clear();
    }

    private String getNameFromSubscription(SubscriptionPersistent subscription) {
        return this.notificationSharedThread ? String.valueOf(subscription.getPolicy().getRate()) : subscription.getId();
    }
}

