/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.monitor.holder;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.naming.NamingException;
import org.apache.axis2.databinding.types.URI;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.apache.log4j.Logger;
import org.glite.ce.monitor.configuration.CEMonServiceConfig;
import org.glite.ce.monitor.holder.NotificationPool;
import org.glite.ce.monitor.holder.QueryProcessorHolder;
import org.glite.ce.monitor.holder.SensorEventArrayList;
import org.glite.ce.monitor.holder.TopicHolder;
import org.glite.ce.monitor.registry.SubscriptionRegistry;
import org.glite.ce.monitorapij.queryprocessor.QueryProcessor;
import org.glite.ce.monitorapij.queryprocessor.QueryResult;
import org.glite.ce.monitorapij.resource.types.Action;
import org.glite.ce.monitorapij.resource.types.Dialect;
import org.glite.ce.monitorapij.resource.types.Parameter;
import org.glite.ce.monitorapij.resource.types.Policy;
import org.glite.ce.monitorapij.resource.types.Query;
import org.glite.ce.monitorapij.resource.types.SubscriptionPersistent;
import org.glite.ce.monitorapij.resource.types.Topic;
import org.glite.ce.monitorapij.sensor.SensorEvent;
import org.glite.ce.monitorapij.sensor.SensorOutputDataFormat;
import org.glite.ce.monitorapij.types.Event;
import org.glite.ce.monitorapij.ws.CEMonitorConsumerStub;
import org.glite.security.trustmanager.axis2.AXIS2SocketFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NotificationHolder
implements Runnable {
    private static final Logger logger = Logger.getLogger((String)NotificationHolder.class.getName());
    private static final int EVN_PAGE_SIZE = 100;
    private String name;
    private TopicHolder topicHolder;
    private int rate = 0;
    private QueryProcessorHolder queryProcessorHolder;
    private SubscriptionRegistry subscriptionRegistry;
    private boolean exit = false;
    private Thread notificationThread;
    private HashMap<String, SubscriptionPersistent> subscrMap;
    private NotificationPool notificationPool;

    public NotificationHolder(String name, int rate, TopicHolder topicHolder, QueryProcessorHolder queryProcessorHolder, SubscriptionRegistry subscriptionRegistry, NotificationPool pool) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name not specified!");
        }
        this.name = name;
        if (rate <= 0) {
            throw new IllegalArgumentException("rate must be > 0!");
        }
        if (topicHolder == null) {
            throw new IllegalArgumentException("topicHolder not specified!");
        }
        if (queryProcessorHolder == null) {
            throw new IllegalArgumentException("queryProcessorHolder not specified!");
        }
        if (subscriptionRegistry == null) {
            throw new IllegalArgumentException("subscriptionRegistry not specified!");
        }
        this.rate = rate;
        this.topicHolder = topicHolder;
        this.queryProcessorHolder = queryProcessorHolder;
        this.subscriptionRegistry = subscriptionRegistry;
        this.notificationPool = pool;
        this.subscrMap = new HashMap();
        Protocol.registerProtocol((String)"https", (Protocol)new Protocol("https", (SecureProtocolSocketFactory)new AXIS2SocketFactory(), 8443));
        this.notificationThread = new Thread(this);
        this.notificationThread.setName(name);
        this.notificationThread.start();
    }

    public String getName() {
        return this.name;
    }

    public synchronized int getSubscriptionListSize() {
        return this.subscrMap.size();
    }

    public synchronized void addSubscription(SubscriptionPersistent subscription) {
        if (subscription != null) {
            this.subscrMap.put(subscription.getId(), subscription);
        }
    }

    public synchronized void removeSubscription(SubscriptionPersistent subscription) {
        if (subscription != null) {
            this.subscrMap.remove(subscription.getId());
        }
    }

    public synchronized List<SubscriptionPersistent> getSubscriptions() {
        return new ArrayList<SubscriptionPersistent>(this.subscrMap.values());
    }

    private void processPolicy(SensorEventArrayList eventList, Policy policy, CEMonitorConsumerStub.Notification notification, SubscriptionPersistent subscription) throws Exception {
        Query query = policy.getQuery();
        QueryProcessor qp = null;
        Action[] actions = policy.getAction();
        if (actions == null) {
            throw new Exception("policy.actions not found!");
        }
        if (query != null && (qp = this.queryProcessorHolder.getQueryProcessor(query.getQueryLanguage())) == null) {
            logger.error((Object)("QueryProcessor \"" + query.getQueryLanguage() + "\" not found!"));
            throw new Exception("QueryProcessor \"" + query.getQueryLanguage() + "\" not found!");
        }
        Dialect[] dialectArray = subscription.getTopic().getDialect();
        String dataFormat = "default";
        if (dialectArray != null && dialectArray.length > 0 && dialectArray[0].getName() != null) {
            dataFormat = dialectArray[0].getName();
        }
        ArrayList<Event> notificationEventList = new ArrayList<Event>(0);
        ArrayList<QueryResult> queryResultList = new ArrayList<QueryResult>(0);
        for (int i = 0; i < eventList.size(); ++i) {
            SensorEvent event = eventList.get(i);
            if (event == null) continue;
            if (event.isExpired()) {
                try {
                    logger.debug((Object)("removing expired event [id=" + event.getID() + "] [name=" + event.getName() + "] [expirationTime=" + event.getExpirationTime() + "]"));
                    this.topicHolder.removeEvent(event);
                }
                catch (Throwable t) {
                    logger.error((Object)("cannot remove the event [id=" + event.getID() + "] [name=" + event.getName() + "]!"), t);
                }
                eventList.remove(i);
                continue;
            }
            SensorOutputDataFormat format = event.getSensorOutputDataFormatApplied();
            if (format == null || !format.getName().equals(dataFormat)) {
                event.applyFormat(dataFormat);
            }
            if (qp != null) {
                queryResultList.add(qp.evaluate(query, event));
            } else {
                QueryResult queryRes = new QueryResult(event.getMessage().length);
                for (int x = 0; x < queryRes.size(); ++x) {
                    queryRes.setResult(x, true);
                }
                queryResultList.add(queryRes);
            }
            if (event.getMessage() == null || event.getMessage().length <= 0) continue;
            Event tmpEvent = new Event();
            tmpEvent.setID(event.getID());
            tmpEvent.setTimestamp(event.getTimestamp());
            tmpEvent.setMessage(event.getMessage());
            tmpEvent.setProducer(event.getProducer());
            notificationEventList.add(tmpEvent);
        }
        notificationEventList.trimToSize();
        CEMonitorConsumerStub.Event[] eventArray = new CEMonitorConsumerStub.Event[notificationEventList.size()];
        for (int k = 0; k < eventArray.length; ++k) {
            Event srcEvn = (Event)notificationEventList.get(k);
            CEMonitorConsumerStub.Event dstEvn = new CEMonitorConsumerStub.Event();
            dstEvn.setID(srcEvn.getID());
            dstEvn.setMessage(srcEvn.getMessage());
            dstEvn.setProducer(srcEvn.getProducer());
            dstEvn.setTimestamp(srcEvn.getTimestamp());
            eventArray[k] = dstEvn;
        }
        notificationEventList.clear();
        notification.setEvent(eventArray);
        QueryResult[] queryResult = new QueryResult[notificationEventList.size()];
        queryResult = queryResultList.toArray(queryResult);
        for (int i = 0; i < actions.length; ++i) {
            try {
                Action action = new Action();
                action.setCreationTime(actions[i].getCreationTime());
                action.setDoActionWhenQueryIs(actions[i].isDoActionWhenQueryIs());
                action.setId(actions[i].getId());
                action.setJarPath(actions[i].getJarPath());
                action.setName(actions[i].getName());
                action.setType(actions[i].getType());
                action.setParameter(actions[i].getParameter());
                action.setProperty(actions[i].getProperty());
                action.addParameter(new Parameter("notification", (Object)notification));
                action.addParameter(new Parameter("queryResult", (Object)queryResult));
                action.addParameter(new Parameter("subscriptionId", (Object)subscription.getId()));
                action.execute();
                continue;
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Override
    public void run() {
        while (!this.exit) {
            List<SubscriptionPersistent> subscriptionList = this.getSubscriptions();
            long tmpTS = System.currentTimeMillis();
            for (SubscriptionPersistent subscription : subscriptionList) {
                URI consumerURI = null;
                try {
                    java.net.URI tmpURI = subscription.getMonitorConsumerURL();
                    consumerURI = new URI(tmpURI.toString());
                }
                catch (URI.MalformedURIException mEx) {
                    logger.error((Object)mEx.getMessage(), (Throwable)mEx);
                }
                if (consumerURI == null) {
                    this.eraseSubscription(subscription, "consumer URL not found!");
                    continue;
                }
                if (subscription.isExpired()) {
                    this.eraseSubscription(subscription, "the subscription is expired!");
                    continue;
                }
                if (subscription.isPaused()) continue;
                try {
                    logger.debug((Object)("[name=" + this.name + "] - processing subscription id " + subscription.getId()));
                    Topic topic = subscription.getTopic();
                    Policy policy = subscription.getPolicy();
                    if (policy == null) continue;
                    SensorEventArrayList event = this.topicHolder.getEvents(topic.getName(), subscription.getSubscriberId(), subscription.getSubscriberGroup());
                    logger.debug((Object)("[name=" + this.name + "] - found " + event.size() + " events"));
                    CEMonitorConsumerStub.Notification notification = new CEMonitorConsumerStub.Notification();
                    notification.setExpirationTime(subscription.getExpirationTime());
                    CEMonitorConsumerStub.Topic newTopic = new CEMonitorConsumerStub.Topic();
                    newTopic.setName(topic.getName());
                    if (topic.getDialect() != null && topic.getDialect().length > 0) {
                        Dialect[] dialect = topic.getDialect();
                        CEMonitorConsumerStub.Dialect[] newDialect = new CEMonitorConsumerStub.Dialect[dialect.length];
                        for (int x = 0; x < dialect.length; ++x) {
                            newDialect[x] = new CEMonitorConsumerStub.Dialect();
                            newDialect[x].setName(dialect[x].getName());
                            newDialect[x].setQueryLanguage(dialect[x].getQueryLanguage());
                        }
                        newTopic.setDialect(newDialect);
                    }
                    notification.setTopic(newTopic);
                    notification.setEvent(null);
                    notification.setConsumerURL(consumerURI);
                    while (event.size() > 0) {
                        SensorEventArrayList subEventList = event.drain(100);
                        this.processPolicy(subEventList, policy, notification, subscription);
                        if (notification.getEvent().length > 0) {
                            logger.info((Object)("[name=" + this.name + "] - sending notification (containing " + notification.getEvent().length + " events) to " + consumerURI.toString()));
                            if (logger.isDebugEnabled()) {
                                this.printNotification(subscription, subEventList);
                            }
                            Properties sslConfig = this.getSSLParameters(subscription.getCredentialFile(), subscription.getPassphrase(), subscription.getSSLProtocol());
                            AXIS2SocketFactory.setCurrentProperties((Properties)sslConfig);
                            CEMonitorConsumerStub consumer = new CEMonitorConsumerStub(consumerURI.toString());
                            CEMonitorConsumerStub.Notify msg = new CEMonitorConsumerStub.Notify();
                            msg.setNotification(notification);
                            consumer.notify(msg);
                            logger.info((Object)("[name=" + this.name + "] - [done]"));
                        } else {
                            logger.info((Object)("[name=" + this.name + "] - the notification doesn't contains messages to be notified! [aborted]"));
                        }
                        if (subscription.getMaxRetryCount() == -1) continue;
                        subscription.resetRetryCount();
                        try {
                            this.removeSubscription(subscription);
                            this.subscriptionRegistry.update(subscription);
                            this.addSubscription(subscription);
                        }
                        catch (Throwable th) {
                            logger.error((Object)th.getMessage(), th);
                        }
                    }
                }
                catch (NamingException e) {
                    logger.error((Object)("[name=" + this.name + "] - NamingException occurred: subscription id = " + subscription.getId() + " consumer URL = " + subscription.getMonitorConsumerURL() + " message error = " + e.getMessage()));
                }
                catch (IOException e) {
                    logger.error((Object)("[name=" + this.name + "] - IOException occurred: subscription id = " + subscription.getId() + " consumer URL = " + subscription.getMonitorConsumerURL() + " message error = " + e.getMessage()));
                    if (subscription.getMaxRetryCount() == -1) continue;
                    int retries = subscription.decrRetryCount();
                    logger.info((Object)("[name=" + this.name + "] - decrementing the retry count to " + retries + " for the subscription id = " + subscription.getId() + "; consumer URL = " + subscription.getMonitorConsumerURL() + "; message error = " + e.getMessage()));
                    if (retries == 0) {
                        this.eraseSubscription(subscription, "retry count = 0");
                        continue;
                    }
                    try {
                        this.removeSubscription(subscription);
                        this.subscriptionRegistry.update(subscription);
                        this.addSubscription(subscription);
                    }
                    catch (Throwable th) {
                        logger.error((Object)th.getMessage(), th);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)("[name=" + this.name + "] - Exception catched: subscriptionId = " + subscription.getId() + " consumer URL = " + subscription.getMonitorConsumerURL() + " message error = " + e.getMessage() + ". Follow the Stack trace:"), (Throwable)e);
                }
            }
            try {
                long waitTime = (long)this.rate - System.currentTimeMillis() + tmpTS;
                if (waitTime > 0L) {
                    logger.debug((Object)("[name=" + this.name + "] - sleeping " + waitTime));
                    Thread.sleep(waitTime);
                    continue;
                }
                logger.warn((Object)"Notifications overlapping");
            }
            catch (InterruptedException intEx) {
                logger.info((Object)("[name=" + this.name + "] - destroyed"));
            }
        }
    }

    private void eraseSubscription(SubscriptionPersistent subscription, String msg) {
        logger.info((Object)("[name=" + this.name + "] - unregistering subscription " + subscription.getId() + " [reason: " + msg + "]"));
        this.removeSubscription(subscription);
        try {
            this.subscriptionRegistry.unregister(subscription);
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        this.notificationPool.check();
    }

    private void printNotification(SubscriptionPersistent subscription, SensorEventArrayList eventList) {
        StringBuffer sb = new StringBuffer();
        sb.append("\n******* NOTIFICATION *******");
        sb.append("\nsubscriptionId: " + subscription.getId());
        sb.append("\nuser: " + subscription.getSubscriberId());
        sb.append("\nconsumer url: " + subscription.getMonitorConsumerURL());
        if (subscription.getTopic() != null && subscription.getTopic().getName() != null) {
            sb.append("\topic name: " + subscription.getTopic().getName());
        }
        if (eventList == null) {
            sb.append("\nNONE EVENT FOUND!");
        } else {
            SensorEvent event = null;
            for (int i = 0; i < eventList.size(); ++i) {
                event = eventList.get(i);
                sb.append("\n").append(i).append(") event_name: ").append(event.getName());
                if (event.getTimestamp() != null) {
                    sb.append(" - timestamp: ").append(event.getTimestamp().getTime());
                }
                if (event.getExpirationTime() != null) {
                    sb.append(" - expirationTime: ").append(event.getExpirationTime().getTime());
                }
                sb.append(" - messages: ");
                String[] msg = event.getMessage();
                if (msg == null) {
                    sb.append("0");
                    continue;
                }
                sb.append(msg.length);
            }
        }
        sb.append("\n******* END NOTIFICATION *******\n");
        logger.debug((Object)sb.toString());
    }

    private Properties getSSLParameters(String credFile, String passphrase, String protocol) {
        String CRLfiles;
        String CAfiles;
        Properties sslConfig = new Properties();
        CEMonServiceConfig sConfiguration = CEMonServiceConfig.getConfiguration();
        if (sConfiguration == null) {
            throw new RuntimeException("Service is not configured");
        }
        if (credFile != null) {
            sslConfig.put("gridProxyFile", credFile);
        } else {
            String tmps = sConfiguration.getGlobalAttributeAsString("gridproxyfile");
            if (tmps != "") {
                sslConfig.put("gridProxyFile", tmps);
            } else {
                String certFilename = sConfiguration.getGlobalAttributeAsString("sslcertfile");
                String keyFilename = sConfiguration.getGlobalAttributeAsString("sslkeyfile");
                String passwd = sConfiguration.getGlobalAttributeAsString("sslkeypasswd");
                if (passwd == null) {
                    passwd = "";
                }
                if (certFilename == "" || keyFilename == "") {
                    throw new RuntimeException("Missing user credentials");
                }
                sslConfig.put("sslCertFile", certFilename);
                sslConfig.put("sslKey", keyFilename);
                sslConfig.put("sslKeyPasswd", passwd);
            }
        }
        if (passphrase != "") {
            sslConfig.put("sslKeyPasswd", passphrase);
        }
        if (protocol != "") {
            sslConfig.put("sslProtocol", protocol);
        }
        if ((CAfiles = sConfiguration.getGlobalAttributeAsString("sslCAfiles")) != "") {
            sslConfig.put("sslCAFiles", CAfiles);
        }
        if ((CRLfiles = sConfiguration.getGlobalAttributeAsString("sslCRLfiles")) != "") {
            sslConfig.put("crlEnabled", "true");
            sslConfig.put("crlFiles", CRLfiles);
            sslConfig.put("crlUpdateInterval", "0s");
        } else {
            sslConfig.put("crlEnabled", "false");
        }
        return sslConfig;
    }

    public void destroy() {
        this.exit = true;
        this.notificationThread.interrupt();
    }
}

