/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.monitor.holder;

import java.io.IOException;
import java.util.Properties;
import org.apache.axis2.databinding.types.URI;
import org.apache.log4j.Logger;
import org.glite.ce.monitor.holder.NotificationClient;
import org.glite.ce.monitor.holder.SensorEventArrayList;
import org.glite.ce.monitorapij.resource.types.Dialect;
import org.glite.ce.monitorapij.resource.types.SubscriptionPersistent;
import org.glite.ce.monitorapij.resource.types.Topic;
import org.glite.ce.monitorapij.ws.CEMonitorConsumerStub;
import org.glite.security.trustmanager.axis2.AXIS2SocketFactory;

public class CEMonNotificationClient
implements NotificationClient {
    private static final Logger logger = Logger.getLogger((String)CEMonNotificationClient.class.getName());
    private CEMonitorConsumerStub.Notification notification;

    public CEMonNotificationClient(SubscriptionPersistent subscription) {
        URI consumerURI = null;
        try {
            consumerURI = new URI(subscription.getMonitorConsumerURL().toString());
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        Topic topic = subscription.getTopic();
        this.notification = new CEMonitorConsumerStub.Notification();
        this.notification.setExpirationTime(subscription.getExpirationTime());
        CEMonitorConsumerStub.Topic newTopic = new CEMonitorConsumerStub.Topic();
        newTopic.setName(topic.getName());
        if (topic.getDialect() != null && topic.getDialect().length > 0) {
            Dialect[] dialect = topic.getDialect();
            CEMonitorConsumerStub.Dialect[] newDialect = new CEMonitorConsumerStub.Dialect[dialect.length];
            for (int x = 0; x < dialect.length; ++x) {
                newDialect[x] = new CEMonitorConsumerStub.Dialect();
                newDialect[x].setName(dialect[x].getName());
                newDialect[x].setQueryLanguage(dialect[x].getQueryLanguage());
            }
            newTopic.setDialect(newDialect);
        }
        this.notification.setTopic(newTopic);
        this.notification.setEvent(null);
        this.notification.setConsumerURL(consumerURI);
    }

    public void processEvents(SensorEventArrayList evnList) {
    }

    public SensorEventArrayList getProcessedEvents() {
        return null;
    }

    public int size() {
        return 0;
    }

    public void sendEvents(Properties sslConfig) throws IOException {
        URI consumerURI = this.notification.getConsumerURL();
        AXIS2SocketFactory.setCurrentProperties((Properties)sslConfig);
        try {
            CEMonitorConsumerStub consumer = new CEMonitorConsumerStub(consumerURI.toString());
            CEMonitorConsumerStub.Notify msg = new CEMonitorConsumerStub.Notify();
            msg.setNotification(this.notification);
            consumer.notify(msg);
        }
        catch (Throwable th) {
            logger.error((Object)th.getMessage());
            throw new IOException("Cannot send notification to " + consumerURI.toString());
        }
    }
}

