/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.monitor.holder;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.glite.ce.monitorapij.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasicResourceHolder {
    private static Logger logger = Logger.getLogger((String)BasicResourceHolder.class.getName());
    protected HashMap<String, Resource> resourceList = new HashMap(0);

    public void addResource(Resource resource) {
        if (resource != null) {
            logger.debug((Object)("Inserted new resource " + resource.getId()));
            this.resourceList.put(resource.getId(), resource);
        }
    }

    public void removeResource(Resource resource) {
        if (resource != null) {
            logger.debug((Object)("Removed resource " + resource.getId()));
            this.resourceList.remove(resource.getId());
        }
    }

    public Resource getResource(String id) {
        return id != null ? this.resourceList.get(id) : null;
    }

    public int getResourceListSize() {
        return this.resourceList.size();
    }

    public Resource[] getResources() {
        Resource[] resources = new Resource[this.resourceList.values().size()];
        this.resourceList.values().toArray(resources);
        return resources;
    }

    public List<Resource> getResourceList() {
        return new ArrayList<Resource>(this.resourceList.values());
    }

    public Resource[] getResourceByType(String type) {
        ArrayList<Resource> tmpList = new ArrayList<Resource>(0);
        for (Resource res : this.resourceList.values()) {
            if (!res.getType().equals(type)) continue;
            tmpList.add(res);
        }
        Resource[] result = new Resource[tmpList.size()];
        tmpList.toArray(result);
        return result;
    }

    public Resource[] getResourceByJARPath(URI path) {
        ArrayList<Resource> tmpList = new ArrayList<Resource>(0);
        for (Resource res : this.resourceList.values()) {
            if (!res.getJarPath().equals(path)) continue;
            tmpList.add(res);
        }
        Resource[] result = new Resource[tmpList.size()];
        tmpList.toArray(result);
        return result;
    }

    public Resource[] getResourceByName(String name) {
        ArrayList<Resource> tmpList = new ArrayList<Resource>(0);
        for (Resource res : this.resourceList.values()) {
            if (!res.getName().equals(name)) continue;
            tmpList.add(res);
        }
        Resource[] result = new Resource[tmpList.size()];
        tmpList.toArray(result);
        return result;
    }

    public void setResources(Resource[] resources) {
        this.clear();
        if (resources == null) {
            return;
        }
        for (int i = 0; i < resources.length; ++i) {
            this.addResource(resources[i]);
        }
    }

    public void clear() {
        this.resourceList.clear();
    }
}

