/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.monitor.configuration.xppm;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.xml.xpath.XPathExpression;
import org.apache.log4j.Logger;
import org.glite.ce.commonj.configuration.CommonConfigException;
import org.glite.ce.commonj.configuration.xppm.ConfigurationHandler;
import org.glite.ce.commonj.utils.JarClassLoader;
import org.glite.ce.monitorapij.resource.Resource;
import org.glite.ce.monitorapij.resource.types.Property;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class ResourceConfigHandler
extends ConfigurationHandler {
    private static Logger logger = Logger.getLogger((String)ResourceConfigHandler.class.getName());
    protected static final String RES_ID_ATTR = "id";
    protected static final String RES_NAME_ATTR = "name";
    protected static final String RES_JAR_ATTR = "jarpath";
    protected static final String RES_TYPE_ATTR = "type";
    private static final String PARAMETER_TAG = "property";
    private static final String PARA_NAME_ATTR = "name";
    private static final String PARA_VALUE_ATTR = "value";
    protected XPathExpression expr;
    protected ArrayList<Resource> currentResList;
    protected ArrayList<Resource> tmpResList;

    public XPathExpression getXPath() {
        return this.expr;
    }

    public Object[] getConfigurationElement() {
        if (this.currentResList != null) {
            Object[] result = new Object[this.currentResList.size()];
            this.currentResList.toArray(result);
            return result;
        }
        return null;
    }

    public boolean process(NodeList parsedElements) throws CommonConfigException {
        this.tmpResList = new ArrayList(parsedElements.getLength());
        for (int k = 0; k < parsedElements.getLength(); ++k) {
            String type;
            Element resElement = (Element)parsedElements.item(k);
            String id = resElement.getAttribute(RES_ID_ATTR);
            String jar = resElement.getAttribute(RES_JAR_ATTR);
            String name = resElement.getAttribute("name");
            Resource resource = this.createResource(id, name, type = resElement.getAttribute(RES_TYPE_ATTR), jar);
            if (resource == null) {
                throw new CommonConfigException("Cannot instantiate resource " + id);
            }
            NodeList paraElemList = resElement.getElementsByTagName(PARAMETER_TAG);
            Property[] allParams = new Property[paraElemList.getLength()];
            for (int j = 0; j < paraElemList.getLength(); ++j) {
                Element paraElement = (Element)paraElemList.item(j);
                String paraName = paraElement.getAttribute("name");
                String paraValue = paraElement.getAttribute(PARA_VALUE_ATTR);
                if (paraName == "") {
                    throw new CommonConfigException("Missing parameter name in " + id);
                }
                allParams[j] = new Property(paraName, paraValue);
                logger.debug((Object)("Parameter " + id + "[" + paraName + "] = " + paraValue));
            }
            resource.setProperty(allParams);
            this.tmpResList.add(resource);
        }
        return !this.tmpResList.equals(this.currentResList);
    }

    public boolean processTriggers() throws CommonConfigException {
        return false;
    }

    public void commit() {
        this.currentResList = this.tmpResList;
        this.tmpResList = null;
    }

    public void rollback() {
        this.tmpResList = null;
    }

    public File[] getTriggers() {
        return null;
    }

    public void clean() {
    }

    protected Resource createResource(String id, String name, String type, String jarFilename) {
        try {
            File jarFile = new File(jarFilename);
            logger.debug((Object)("JAR filename: " + jarFilename));
            URL resourceURL = jarFile.toURI().toURL();
            JarClassLoader loader = new JarClassLoader("file://" + jarFile.getPath(), ((Object)((Object)this)).getClass().getClassLoader());
            loader.addJarURL(resourceURL);
            String className = loader.getMainClassName(resourceURL);
            if (className == null) {
                throw new IOException("\"Main-Class\" attribute not found into the MANIFEST.MF of " + jarFile.getAbsolutePath());
            }
            Class resourceClass = loader.loadClass(className);
            logger.debug((Object)("Loaded class: " + resourceClass.getName()));
            Resource result = (Resource)resourceClass.newInstance();
            result.setId(id);
            result.setName(name);
            result.setType(type);
            result.setJarPath(new URI("file://" + jarFile.getAbsolutePath()));
            result.setCreationTime((Calendar)new GregorianCalendar());
            return result;
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            return null;
        }
    }
}

