/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.monitor.configuration;

import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.glite.ce.commonj.configuration.CommonConfigException;
import org.glite.ce.commonj.configuration.CommonServiceConfig;
import org.glite.ce.commonj.configuration.xppm.ConfigurationListener;
import org.glite.ce.monitorapij.queryprocessor.QueryProcessor;
import org.glite.ce.monitorapij.resource.Resource;
import org.glite.ce.monitorapij.resource.types.Action;
import org.glite.ce.monitorapij.resource.types.SubscriptionPersistent;
import org.glite.ce.monitorapij.sensor.Sensor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CEMonServiceConfig
extends CommonServiceConfig {
    private static Logger logger = Logger.getLogger((String)CEMonServiceConfig.class.getName());
    protected static CEMonServiceConfig serviceConfiguration = null;

    protected CEMonServiceConfig() throws CommonConfigException {
    }

    protected String getSysPropertyName() {
        return "cemonitor.configuration.path";
    }

    public ArrayList<Resource> getResources(String category) {
        ArrayList<Resource> result = new ArrayList<Resource>();
        Class<?> resClass = CEMonServiceConfig.getClassForCategory(category);
        if (this.confManager != null && resClass != null) {
            Object[] tmpArray;
            for (Object obj : tmpArray = this.confManager.getConfigurationElements(resClass)) {
                logger.debug((Object)("Found resource " + ((Resource)obj).getId()));
                result.add((Resource)obj);
            }
        }
        return result;
    }

    public void registerListener(ConfigurationListener lsnr) {
        this.confManager.addListener(lsnr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CEMonServiceConfig getConfiguration() {
        if (serviceConfiguration != null) return serviceConfiguration;
        Class<CEMonServiceConfig> clazz = CEMonServiceConfig.class;
        synchronized (CEMonServiceConfig.class) {
            if (serviceConfiguration != null) return serviceConfiguration;
            try {
                serviceConfiguration = new CEMonServiceConfig();
            }
            catch (CommonConfigException cEx) {
                logger.error((Object)cEx.getMessage(), (Throwable)cEx);
            }
            return serviceConfiguration;
        }
    }

    public static Class<?> getClassForCategory(String category) {
        if (category == "action") {
            return Action.class;
        }
        if (category == "queryprocessor") {
            return QueryProcessor.class;
        }
        if (category == "subscription") {
            return SubscriptionPersistent.class;
        }
        if (category == "sensor") {
            return Sensor.class;
        }
        return null;
    }
}

