/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.monitor.queryprocessor;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.glite.ce.monitorapij.queryprocessor.QueryProcessor;
import org.glite.ce.monitorapij.queryprocessor.QueryResult;
import org.glite.ce.monitorapij.resource.Resource;
import org.glite.ce.monitorapij.resource.types.CEMonResource;
import org.glite.ce.monitorapij.resource.types.Query;
import org.glite.ce.monitorapij.sensor.SensorEvent;
import org.glite.ce.monitorapij.sensor.SensorOutputDataFormat;
import org.glite.ce.monitorapij.types.TopicEvent;

public class RegExProcessor
extends CEMonResource
implements Resource,
QueryProcessor {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)RegExProcessor.class.getName());

    public RegExProcessor() {
        super("RegEx", "QueryProcessor");
    }

    private void checkQuery(Query query) throws Exception {
        if (query == null) {
            throw new Exception("Invalid argument: the query is null!");
        }
        if (query.getQueryLanguage() == null) {
            throw new Exception("the query language is null");
        }
        if (!query.getQueryLanguage().equalsIgnoreCase(this.getName())) {
            throw new Exception("Query Language mismatch: expected \"" + this.getName() + "\", found \"" + query.getQueryLanguage() + "\"");
        }
        if (query.getExpression() == null) {
            throw new Exception("the query expression is null");
        }
    }

    private void checkEvent(TopicEvent event) throws Exception {
        if (event == null) {
            throw new Exception("Invalid argument: the event is null!");
        }
        if (event.getMessage() == null || event.getMessage().length == 0) {
            throw new Exception("the event is empty");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryResult evaluate(Query query, SensorEvent event) throws Exception {
        this.checkQuery(query);
        this.checkEvent((TopicEvent)event);
        ArrayList goodMessages = new ArrayList();
        String[] messages = event.getMessage();
        QueryResult queryResult = new QueryResult(messages.length);
        String regex = query.getExpression();
        SensorEvent se = event;
        SensorOutputDataFormat sodf = se.getSensorOutputDataFormatApplied();
        int index = 0;
        if (sodf.getName().equalsIgnoreCase("ISM_LDIF")) {
            queryResult.setResult(0, true);
            index = 1;
        }
        Pattern pattern = regex != null ? Pattern.compile(regex) : null;
        for (int i = index; i < messages.length; ++i) {
            try {
                Matcher m = pattern.matcher(messages[i]);
                boolean good = m.find();
                queryResult.setResult(index, good);
                continue;
            }
            catch (Exception e) {
                queryResult.setResult(index, false);
                continue;
            }
            finally {
                ++index;
            }
        }
        return queryResult;
    }
}

