/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.jobplugin;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.glite.ce.creamapi.jobmanagement.Job;
import org.glite.ce.creamapi.jobmanagement.JobStatus;
import org.glite.ce.jobplugin.CREAMJobSensorEvent;
import org.glite.ce.jobplugin.format.ClassAd;
import org.glite.ce.monitorapij.resource.types.Property;
import org.glite.ce.monitorapij.sensor.AbstractSensor;
import org.glite.ce.monitorapij.sensor.Sensor;
import org.glite.ce.monitorapij.sensor.SensorException;

public final class CREAMJobSensor
extends AbstractSensor {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger((String)CREAMJobSensor.class.getName());
    private int expiration;
    private ServerSocket serverSocket = null;
    private static final int SERVER_SOCKET_TIMEOUT = 60000;
    private boolean working = true;
    private static final int THREAD_COUNT = 20;
    private ThreadPoolExecutor pool = null;

    public CREAMJobSensor() {
        super("CREAM Job Sensor", "CREAM_JOBS");
        Property[] properties = new Property[]{new Property("executionDelay", "60000"), new Property("pushMode", "false"), new Property("expiration", "60")};
        this.setProperty(properties);
        this.setEventOverwriteModeActive(true);
        this.setScope("LOW");
        this.working = false;
        ClassAd defaultFormat = new ClassAd();
        this.addFormat(defaultFormat);
        this.setDefaultFormat(defaultFormat);
    }

    public void init() throws SensorException {
        super.init();
        Property listenerPort = this.getProperty("LISTENER_PORT");
        int port = -1;
        if (listenerPort != null) {
            try {
                port = Integer.parseInt(listenerPort.getValue());
            }
            catch (Throwable e) {
                logger.error((Object)("Found wrong value for the LISTENER_PORT parameter " + listenerPort));
                throw new SensorException("Found wrong value for the LISTENER_PORT parameter " + listenerPort);
            }
        } else {
            logger.error((Object)"LISTENER_PORT parameter not found.");
            throw new SensorException("LISTENER_PORT parameter not found.");
        }
        try {
            this.serverSocket = new ServerSocket(port, 10);
            this.serverSocket.setSoTimeout(60000);
            logger.debug((Object)"Server socket timeout is set to: 60000 ms.");
            this.pool = new ThreadPoolExecutor(20, 20, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
            this.working = true;
            logger.debug((Object)("Server listening on port " + port));
        }
        catch (IOException e) {
            logger.error((Object)("Problem to create the ServerSocket: " + e.getMessage()), (Throwable)e);
        }
        Property expirationProperty = this.getProperty("expiration");
        try {
            if (expirationProperty != null && expirationProperty.getValue() != null) {
                this.expiration = Integer.parseInt(expirationProperty.getValue());
            }
        }
        catch (NumberFormatException numEx) {
            logger.error((Object)("Found wrong value (" + this.expiration + ") for the expiration parameter: " + numEx.getMessage()));
        }
    }

    public void startSensor() {
        super.startSensor();
        logger.debug((Object)"startSensor executed!");
    }

    public void suspendSensor() {
        super.suspendSensor();
        this.working = false;
        logger.debug((Object)"suspendSensor executed!");
    }

    public void resumeSensor() {
        super.resumeSensor();
        this.working = true;
        this.startSensor();
        logger.debug((Object)"resumeSensor executed!");
    }

    public void destroySensor() {
        super.destroySensor();
        logger.debug((Object)"Destroying listeners");
        this.working = false;
    }

    public void execute() throws SensorException {
        logger.debug((Object)"execute BEGIN");
        if (this.serverSocket == null) {
            try {
                this.init();
                logger.debug((Object)"init completed");
            }
            catch (SensorException e) {
                logger.error((Object)("init error: " + e.getMessage()), (Throwable)e);
                return;
            }
        }
        Socket socket = null;
        while (this.working) {
            try {
                socket = this.serverSocket.accept();
                this.pool.execute(new Worker(socket));
            }
            catch (SocketTimeoutException ste) {
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        try {
            this.pool.shutdownNow();
            this.serverSocket.close();
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage());
        }
        logger.debug((Object)"execute END");
    }

    private void fireJobChanged(Job job) {
        if (job == null) {
            return;
        }
        String userId = job.getUserId();
        logger.debug((Object)("fireJobChanged with userId " + userId));
        if (userId == null || userId.length() == 0) {
            logger.error((Object)("userId is invalid: job " + job.getId()));
            return;
        }
        List<JobStatus> status = job.getStatusHistory();
        if (status == null || status.size() == 0) {
            return;
        }
        ArrayList<String> classadList = new ArrayList<String>(0);
        for (int i = 0; i < status.size(); ++i) {
            JobStatus tmpStat = status.get(i);
            if (tmpStat == null || tmpStat.getExitCode() != null && tmpStat.getExitCode().equals("W")) continue;
            StringBuffer buff = new StringBuffer("[\n\tCREAM_JOB_ID = \"");
            buff.append(job.getId()).append("\";\n");
            buff.append("\tCREAM_URL = \"").append(job.getCreamURL()).append("\";\n");
            buff.append("\tJOB_STATUS = \"").append(tmpStat.getName()).append("\";\n");
            buff.append("\tTIMESTAMP = \"").append(tmpStat.getTimestamp().getTimeInMillis()).append("\"");
            if (tmpStat.getExitCode() != null) {
                buff.append(";\n\tEXIT_CODE = ").append(tmpStat.getExitCode());
            }
            if (job.getICEId() != null) {
                buff.append(";\n\tICE_ID = \"").append(job.getICEId()).append("\"");
            }
            if (job.getWorkerNode() != null) {
                buff.append(";\n\tWORKER_NODE = \"").append(job.getWorkerNode()).append("\"");
            }
            if (tmpStat.getFailureReason() != null) {
                buff.append(";\n\tFAILURE_REASON = \"").append(tmpStat.getFailureReason()).append("\"");
            }
            if (tmpStat.getDescription() != null) {
                buff.append(";\n\tDESCRIPTION = \"").append(tmpStat.getDescription()).append("\"");
            }
            buff.append("\n]");
            classadList.add(buff.toString());
        }
        String[] classads = new String[classadList.size()];
        classads = classadList.toArray(classads);
        Calendar startTime = Calendar.getInstance();
        Calendar endTime = (Calendar)startTime.clone();
        if (job.getLastStatus().getType() == 9) {
            endTime.add(12, 5);
        } else {
            endTime.add(12, this.expiration);
        }
        logger.debug((Object)("JOB_SENSOR received event: job = " + job.getId() + "  status = " + job.getLastStatus().getName()));
        this.fireSensorEvent(new CREAMJobSensorEvent((Sensor)this, startTime, endTime, job.getId(), userId, job.getVirtualOrganization(), classads));
    }

    class Worker
    implements Runnable {
        private Socket clientSocket;

        public Worker(Socket s) {
            this.clientSocket = s;
            try {
                this.clientSocket.setKeepAlive(false);
            }
            catch (SocketException e) {
                e.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ObjectInputStream ois = null;
            try {
                if (this.clientSocket != null) {
                    ois = new ObjectInputStream(this.clientSocket.getInputStream());
                    Job job = null;
                    while (true) {
                        job = new Job();
                        job.readExternal(ois);
                        logger.debug((Object)"executed a job.readExternal()");
                        CREAMJobSensor.this.fireJobChanged(job);
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
            }
            finally {
                try {
                    if (ois != null) {
                        ois.close();
                        ois = null;
                    }
                    if (this.clientSocket != null) {
                        this.clientSocket.close();
                        this.clientSocket = null;
                    }
                }
                catch (IOException ioe) {
                    logger.error((Object)ioe.getMessage());
                }
            }
        }
    }
}

