/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.creamapi.jobmanagement.command;

import java.util.Calendar;
import java.util.List;
import org.glite.ce.creamapi.jobmanagement.cmdexecutor.JobCommandConstant;

public class JobCommand {
    public static final int CREATED = 0;
    public static final int QUEUED = 1;
    public static final int SCHEDULED = 2;
    public static final int RESCHEDULED = 3;
    public static final int PROCESSING = 4;
    public static final int REMOVED = 5;
    public static final int SUCCESSFULL = 6;
    public static final int ERROR = 7;
    public static final int ABORTED = 8;
    public static final String[] statusName = new String[]{"CREATED", "QUEUED", "SCHEDULED", "RESCHEDULED", "PROCESSING", "REMOVED", "SUCCESSFULL", "ERROR", "ABORTED"};
    private int type = 0;
    private int status;
    private Calendar creationTime;
    private Calendar startSchedulingTime;
    private Calendar startProcessingTime;
    private Calendar executionCompletedTime;
    private String jobId;
    private String userId;
    private String failureReason;
    private String description;
    private String cmdExecutorName = null;
    private long id = -1L;

    public static String getCommandName(int type) {
        if (type < 0 || type >= JobCommandConstant.commandNameList.size()) {
            return null;
        }
        return JobCommandConstant.commandNameList.get(type);
    }

    public static String getStatusName(int type) {
        if (type < 0 || type >= statusName.length) {
            return null;
        }
        return statusName[type];
    }

    public JobCommand() {
    }

    public JobCommand(String name) {
        this(name, null);
    }

    public JobCommand(String name, String jobId) {
        List<String> commandNames = JobCommandConstant.commandNameList;
        for (int i = 0; i < commandNames.size(); ++i) {
            if (!name.equals(commandNames.get(i))) continue;
            this.jobId = jobId;
            this.type = i;
            this.status = 0;
            this.setCreationTime(Calendar.getInstance());
            break;
        }
    }

    public JobCommand(int type) throws IllegalArgumentException {
        this(type, null);
    }

    public JobCommand(int type, String jobId) throws IllegalArgumentException {
        if (type < 0 || type >= JobCommandConstant.commandNameList.size()) {
            throw new IllegalArgumentException("Job Command error: command type out of range (type=" + type + ")");
        }
        this.type = type;
        this.jobId = jobId;
        this.status = 0;
        this.setCreationTime(Calendar.getInstance());
    }

    public Calendar getCreationTime() {
        return this.creationTime;
    }

    public String getDescription() {
        return this.description;
    }

    public Calendar getExecutionCompletedTime() {
        return this.executionCompletedTime;
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getName() {
        return JobCommandConstant.commandNameList.get(this.type);
    }

    public Calendar getStartProcessingTime() {
        return this.startProcessingTime;
    }

    public Calendar getStartSchedulingTime() {
        return this.startSchedulingTime;
    }

    public int getStatus() {
        return this.status;
    }

    public String getStatusName() {
        return statusName[this.status];
    }

    public int getType() {
        return this.type;
    }

    public String getUserId() {
        return this.userId;
    }

    public boolean isSuccessfull() {
        return this.status == 6;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setCreationTime(Calendar creationTime) {
        this.creationTime = creationTime;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setExecutionCompletedTime(Calendar executionCompletedTime) {
        this.executionCompletedTime = executionCompletedTime;
    }

    public void setFailureReason(String failureReason) {
        this.failureReason = failureReason;
        if (failureReason != null) {
            this.status = 7;
        }
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public void setStartProcessingTime(Calendar startProcessingTime) {
        this.startProcessingTime = startProcessingTime;
    }

    public void setStartSchedulingTime(Calendar startSchedulingTime) {
        this.startSchedulingTime = startSchedulingTime;
    }

    public void setStatus(int status) {
        if (status < 0 || status >= statusName.length) {
            return;
        }
        this.status = status;
        switch (status) {
            case 2: {
                this.startSchedulingTime = Calendar.getInstance();
                this.startProcessingTime = null;
                this.executionCompletedTime = null;
                break;
            }
            case 4: {
                this.startProcessingTime = Calendar.getInstance();
                this.executionCompletedTime = null;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.executionCompletedTime = Calendar.getInstance();
            }
        }
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setType(int type) throws IllegalArgumentException {
        if (type < 0 || type >= JobCommandConstant.commandNameList.size()) {
            throw new IllegalArgumentException("Job Command error: command type out of range (type=" + type + ")");
        }
        this.type = type;
    }

    public String getCommandExecutorName() {
        return this.cmdExecutorName;
    }

    public void setCommandExecutorName(String cmdExecutorName) {
        this.cmdExecutorName = cmdExecutorName;
    }

    public String toString() {
        StringBuffer info = new StringBuffer("commandName=");
        info.append(JobCommand.getCommandName(this.type));
        if (this.cmdExecutorName != null) {
            info.append("; cmdExecutorName=").append(this.cmdExecutorName);
        }
        if (this.userId != null) {
            info.append("; userId=").append(this.userId);
        }
        if (this.jobId != null) {
            info.append("; jobId=").append(this.jobId);
        }
        info.append("; status=").append(statusName[this.status]);
        if (this.failureReason != null) {
            info.append("; failureReason=").append(this.failureReason);
        }
        if (this.description != null) {
            info.append("; description=").append(this.description);
        }
        info.append(";");
        return info.toString();
    }
}

