/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.creamapi.jobmanagement;

import java.util.Calendar;

public final class JobStatus {
    public static final int REGISTERED = 0;
    public static final int PENDING = 1;
    public static final int IDLE = 2;
    public static final int RUNNING = 3;
    public static final int REALLY_RUNNING = 4;
    public static final int CANCELLED = 5;
    public static final int HELD = 6;
    public static final int DONE_OK = 7;
    public static final int DONE_FAILED = 8;
    public static final int PURGED = 9;
    public static final int ABORTED = 10;
    public static final String[] statusName = new String[]{"REGISTERED", "PENDING", "IDLE", "RUNNING", "REALLY-RUNNING", "CANCELLED", "HELD", "DONE-OK", "DONE-FAILED", "PURGED", "ABORTED"};
    private String exitCode;
    private String failureReason;
    private String description;
    private String jobId;
    private int type = 0;
    private Calendar timestamp;
    private long id = -1L;

    public static String getNameByType(int type) {
        if (type < 0 || type >= statusName.length) {
            return null;
        }
        return statusName[type];
    }

    public JobStatus(int type) {
        this(type, null);
    }

    public JobStatus(int type, String jobId) {
        this(type, jobId, null);
    }

    public JobStatus(int type, String jobId, Calendar time) {
        this.type = type;
        this.jobId = jobId;
        if (time == null) {
            this.timestamp = Calendar.getInstance();
            this.timestamp.set(14, 0);
        } else {
            this.timestamp = time;
        }
    }

    public String getDescription() {
        return this.description;
    }

    public String getExitCode() {
        return this.exitCode;
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    public long getId() {
        return this.id;
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getName() {
        if (this.type < 0 || this.type >= statusName.length) {
            return null;
        }
        return statusName[this.type];
    }

    public Calendar getTimestamp() {
        return this.timestamp;
    }

    public int getType() {
        return this.type;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setExitCode(String exitCode) {
        this.exitCode = exitCode;
    }

    public void setFailureReason(String failureReason) {
        this.failureReason = failureReason;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public void setTimestamp(Calendar timestamp) {
        this.timestamp = timestamp;
    }

    public void setType(int type) {
        this.type = type;
    }
}

