/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.cream.delegationmanagement;

import java.io.Serializable;
import java.util.List;
import org.apache.log4j.Logger;
import org.glite.ce.cream.cmdmanagement.CommandManager;
import org.glite.ce.cream.delegationmanagement.DelegationManager;
import org.glite.ce.creamapi.cmdmanagement.Command;
import org.glite.ce.creamapi.cmdmanagement.CommandException;
import org.glite.ce.creamapi.cmdmanagement.CommandManagerException;
import org.glite.ce.creamapi.delegationmanagement.Delegation;
import org.glite.ce.creamapi.delegationmanagement.DelegationCommand;

public class DelegationPurger
extends Thread {
    private static final Logger logger = Logger.getLogger((String)DelegationPurger.class.getName());
    private static final Object objMutex = new Object();
    private static DelegationPurger delegationPurger = null;
    private boolean terminate = false;
    int rateInMinutes = 720;

    public static DelegationPurger getInstance() {
        if (delegationPurger == null) {
            delegationPurger = new DelegationPurger();
        }
        return delegationPurger;
    }

    private DelegationPurger() {
        super("DelegationPurger");
        this.setDaemon(true);
        this.start();
    }

    public void terminate() {
        logger.info((Object)"terminate invoked!");
        this.terminate = true;
        delegationPurger = null;
        logger.info((Object)"terminated!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRate(int rate) {
        if (rate > 0) {
            Object object = objMutex;
            synchronized (object) {
                this.rateInMinutes = rate;
                objMutex.notify();
                logger.info((Object)("purger rate changed to " + this.rateInMinutes + " min"));
            }
        }
    }

    public int getRate() {
        return this.rateInMinutes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.info((Object)"BEGIN DelegationPurger");
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            logger.error((Object)e.getMessage());
        }
        while (!this.terminate) {
            try {
                List<Delegation> expiredDelegationList = DelegationManager.getInstance().getExpiredDelegations();
                for (Delegation delegation : expiredDelegationList) {
                    logger.debug((Object)("deleting the expired delegation " + delegation.toString()));
                    try {
                        DelegationCommand command = new DelegationCommand("DESTROY_DELEGATION");
                        command.setUserId(delegation.getUserId());
                        command.addParameter("DELEGATION_ID", (Serializable)((Object)delegation.getId()));
                        command.addParameter("USER_DN_RFC2253", (Serializable)((Object)delegation.getDN()));
                        command.addParameter("LOCAL_USER", (Serializable)((Object)delegation.getLocalUser()));
                        command.addParameter("LOCAL_USER_GROUP", (Serializable)((Object)delegation.getLocalUserGroup()));
                        CommandManager.getInstance().execute((Command)command);
                        logger.info((Object)("deleted the expired delegation " + delegation.toString()));
                    }
                    catch (CommandException e) {
                        logger.error((Object)("DelegationPurger CommandException: " + e.getMessage()));
                    }
                    catch (CommandManagerException e) {
                        logger.error((Object)("DelegationPurger CommandManagementException: " + e.getMessage()));
                    }
                }
            }
            catch (Throwable t) {
                logger.error((Object)t.getMessage());
            }
            Object object = objMutex;
            synchronized (object) {
                try {
                    objMutex.wait(this.rateInMinutes * 60000);
                }
                catch (InterruptedException e) {
                    logger.warn((Object)"purger execution interrupted!");
                    this.terminate = true;
                }
            }
        }
        logger.info((Object)"END DelegationPurger");
    }
}

