/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.cream.configuration;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.glite.ce.commonj.configuration.CommonConfigException;
import org.glite.ce.commonj.configuration.CommonServiceConfig;
import org.glite.ce.cream.configuration.CREAMConfigConstants;
import org.glite.ce.cream.configuration.CommandExecutorConfig;

public class ServiceConfig
extends CommonServiceConfig {
    private static Logger logger = Logger.getLogger((String)ServiceConfig.class.getName());
    protected static ServiceConfig serviceConfiguration = null;

    protected ServiceConfig() throws CommonConfigException {
    }

    protected String getSysPropertyName() {
        return "cream.configuration.path";
    }

    public String getStringParameter(CREAMConfigConstants.ServiceAttribute name) {
        return this.getGlobalAttributeAsString(name.toString());
    }

    public int getIntParameter(CREAMConfigConstants.ServiceAttribute name, int defValue) {
        return this.getGlobalAttributeAsInt(name.toString(), defValue);
    }

    public List<CommandExecutorConfig> getCommandExecutorList() {
        Object[] tmpArray;
        ArrayList<CommandExecutorConfig> result = new ArrayList<CommandExecutorConfig>(0);
        for (Object obj : tmpArray = this.confManager.getConfigurationElements(CommandExecutorConfig.class)) {
            result.add((CommandExecutorConfig)obj);
        }
        return result;
    }

    public String getServiceDescription() {
        String result = this.getStringParameter(CREAMConfigConstants.ServiceAttribute.CREAM_DESCRIPTION_LABEL);
        if (result == "") {
            return "CREAM2";
        }
        return result;
    }

    public String getInterfaceVersion() {
        String result = this.getStringParameter(CREAMConfigConstants.ServiceAttribute.CREAM_INTERFACE_VERSION_LABEL);
        if (result == "") {
            return "N/A";
        }
        return result;
    }

    public String getServiceVersion() {
        String distrInfo = this.getDistributionInfo();
        String srvInfo = this.getStringParameter(CREAMConfigConstants.ServiceAttribute.CREAM_SERVICE_VERSION_LABEL);
        if (srvInfo == "") {
            srvInfo = "N/A";
        }
        if (distrInfo != "") {
            return srvInfo + " - " + distrInfo;
        }
        return srvInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ServiceConfig getConfiguration() {
        if (serviceConfiguration != null) return serviceConfiguration;
        Class<ServiceConfig> clazz = ServiceConfig.class;
        synchronized (ServiceConfig.class) {
            if (serviceConfiguration != null) return serviceConfiguration;
            try {
                serviceConfiguration = new ServiceConfig();
            }
            catch (CommonConfigException cEx) {
                logger.error((Object)cEx.getMessage(), (Throwable)cEx);
            }
            return serviceConfiguration;
        }
    }
}

