/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.cream.client.es;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.impl.OMNamespaceImpl;
import org.apache.axiom.om.impl.llom.OMElementImpl;
import org.apache.axis2.AxisFault;
import org.apache.axis2.databinding.types.URI;
import org.glite.ce.cream.client.es.ActivityCommand;
import org.glite.ce.creamapi.ws.es.creation.types.ActivityStatusAttribute;
import org.glite.ce.creamapi.ws.es.creation.types.ActivityStatus_type0;
import org.glite.ce.creamapi.ws.es.creation.types.DirectoryReference;
import org.glite.ce.creamapi.ws.es.resourceinfo.AccessControlFault;
import org.glite.ce.creamapi.ws.es.resourceinfo.InternalBaseFault;
import org.glite.ce.creamapi.ws.es.resourceinfo.NotSupportedQueryDialectFault;
import org.glite.ce.creamapi.ws.es.resourceinfo.NotValidQueryStatementFault;
import org.glite.ce.creamapi.ws.es.resourceinfo.types.DefaultQueryDialectsEnumType;
import org.glite.ce.creamapi.ws.es.resourceinfo.types.ExtendedQueryDialectEnumType;
import org.glite.ce.creamapi.ws.es.resourceinfo.types.GetResourceInfo;
import org.glite.ce.creamapi.ws.es.resourceinfo.types.GetResourceInfoResponse;
import org.glite.ce.creamapi.ws.es.resourceinfo.types.QueryExpressionType;
import org.glite.ce.creamapi.ws.es.resourceinfo.types.QueryResourceInfo;
import org.glite.ce.creamapi.ws.es.resourceinfo.types.QueryResourceInfoItem_type0;
import org.glite.ce.creamapi.ws.es.resourceinfo.types.QueryResourceInfoResponse;

public class ResourceInfoClient
extends ActivityCommand {
    public static void main(String[] args) {
        ArrayList<String> options = new ArrayList<String>(8);
        options.add("EPR");
        options.add("PROXY");
        options.add("GET_RESOURCE_INFO");
        options.add("QUERY_RESOURCE_INFO");
        new ResourceInfoClient(args, options);
    }

    public ResourceInfoClient(String[] args, List<String> options) throws RuntimeException {
        super(args, options);
    }

    private String checkValue(ActivityStatus_type0 activityStatus) {
        if (activityStatus == null || activityStatus.getStatus() == null) {
            return "N/A";
        }
        return activityStatus.getStatus().getValue();
    }

    private String checkValue(ActivityStatusAttribute[] attribute) {
        StringBuffer buffer = new StringBuffer("[ ");
        if (attribute == null) {
            buffer.append("]");
        } else {
            for (int i = 0; i < attribute.length; ++i) {
                buffer.append(attribute[i].getValue()).append(", ");
            }
            buffer.replace(buffer.length() - 2, buffer.length(), " ]");
        }
        return buffer.toString();
    }

    private String checkValue(DirectoryReference dir) {
        StringBuffer buffer = new StringBuffer("[ ");
        if (dir == null || dir.getURL() == null) {
            buffer.append("]");
        } else {
            URI[] urlArray = dir.getURL();
            for (int i = 0; i < urlArray.length; ++i) {
                buffer.append(urlArray[i].toString()).append(", ");
            }
            buffer.replace(buffer.length() - 2, buffer.length(), " ]");
        }
        return buffer.toString();
    }

    private String checkValue(String value) {
        if (value == null) {
            value = "N/A";
        }
        return value;
    }

    private String checkValue(URI uri) {
        if (uri == null) {
            return "N/A";
        }
        return uri.toString();
    }

    @Override
    public void execute() {
        if (this.isGetResourceInfo()) {
            GetResourceInfoResponse response = null;
            try {
                response = this.getResourceInfoServiceStub().getResourceInfo(new GetResourceInfo());
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            if (response == null) {
                System.out.println("ResourceInfo not available!");
                return;
            }
            try {
                XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(System.out);
                response.serialize(GetResourceInfoResponse.MY_QNAME, writer);
                writer.flush();
                writer.close();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        } else if (this.isQueryResourceInfo()) {
            ExtendedQueryDialectEnumType dialects = new ExtendedQueryDialectEnumType();
            dialects.setObject((Object)DefaultQueryDialectsEnumType._value1);
            System.out.println("query = " + this.getQuery());
            QueryExpressionType query = new QueryExpressionType();
            OMElementImpl elem = new OMElementImpl("query", (OMNamespace)new OMNamespaceImpl("http://www.eu-emi.eu", "s"), OMAbstractFactory.getOMFactory());
            elem.setText(this.getQuery());
            query.setExtraElement((OMElement)elem);
            QueryResourceInfo req = new QueryResourceInfo();
            req.setQueryExpression(query);
            req.setQueryDialect(dialects);
            QueryResourceInfoResponse result = null;
            try {
                result = this.getResourceInfoServiceStub().queryResourceInfo(req);
            }
            catch (AxisFault e) {
                System.out.println(e.getMessage());
            }
            catch (RemoteException e) {
                System.out.println(e.getMessage());
            }
            catch (InternalBaseFault e) {
                System.out.println(e.getFaultMessage().getInternalBaseFault().getMessage());
            }
            catch (AccessControlFault e) {
                System.out.println(e.getFaultMessage().getMessage());
            }
            catch (NotValidQueryStatementFault e) {
                System.out.println(e.getFaultMessage().getMessage());
            }
            catch (NotSupportedQueryDialectFault e) {
                System.out.println(e.getFaultMessage().getMessage());
            }
            if (result == null) {
                System.out.println("query result not available!");
                return;
            }
            try {
                XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(System.out);
                result.serialize(QueryResourceInfoResponse.MY_QNAME, writer);
                writer.flush();
                writer.close();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            if (result.isQueryResourceInfoItemSpecified()) {
                for (QueryResourceInfoItem_type0 item : result.getQueryResourceInfoItem()) {
                    if (item.getExtraElement() != null) {
                        try {
                            XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(System.out);
                            item.getExtraElement().serialize(writer, true);
                            writer.flush();
                            writer.close();
                            System.out.println();
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    if (item.getExtraAttributes() == null) continue;
                    OMAttribute[] attributes = item.getExtraAttributes();
                    for (int i = 0; i < attributes.length; ++i) {
                        System.out.println(attributes[i].getLocalName() + "=" + attributes[i].getAttributeValue());
                    }
                }
            } else {
                System.out.println("none result found!");
            }
        }
    }
}

