/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.cream.client.es;

import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.axis2.AxisFault;
import org.apache.axis2.databinding.types.NonNegativeInteger;
import org.apache.axis2.databinding.types.URI;
import org.apache.axis2.databinding.types.UnsignedLong;
import org.glite.ce.cream.client.es.ActivityCommand;
import org.glite.ce.creamapi.ws.es.activityinfo.AccessControlFault;
import org.glite.ce.creamapi.ws.es.activityinfo.InternalBaseFault;
import org.glite.ce.creamapi.ws.es.activityinfo.InvalidParameterFault;
import org.glite.ce.creamapi.ws.es.activityinfo.UnknownAttributeFault;
import org.glite.ce.creamapi.ws.es.activityinfo.VectorLimitExceededFault;
import org.glite.ce.creamapi.ws.es.activityinfo.types.ActivityInfoDocument_t;
import org.glite.ce.creamapi.ws.es.activityinfo.types.ActivityInfoItemChoice_type1;
import org.glite.ce.creamapi.ws.es.activityinfo.types.ActivityInfoItem_type0;
import org.glite.ce.creamapi.ws.es.activityinfo.types.ActivityStatusAttribute;
import org.glite.ce.creamapi.ws.es.activityinfo.types.ActivityStatusItemChoice_type1;
import org.glite.ce.creamapi.ws.es.activityinfo.types.ActivityStatusItem_type0;
import org.glite.ce.creamapi.ws.es.activityinfo.types.ActivityStatusState;
import org.glite.ce.creamapi.ws.es.activityinfo.types.ActivityStatus_type0;
import org.glite.ce.creamapi.ws.es.activityinfo.types.ActivityStatus_type1;
import org.glite.ce.creamapi.ws.es.activityinfo.types.ComputingActivityHistory_type0;
import org.glite.ce.creamapi.ws.es.activityinfo.types.GetActivityInfo;
import org.glite.ce.creamapi.ws.es.activityinfo.types.GetActivityInfoResponse;
import org.glite.ce.creamapi.ws.es.activityinfo.types.GetActivityStatus;
import org.glite.ce.creamapi.ws.es.activityinfo.types.GetActivityStatusResponse;
import org.glite.ce.creamapi.ws.es.activityinfo.types.InternalBaseFault_Type;
import org.glite.ce.creamapi.ws.es.activityinfo.types.ListActivities;
import org.glite.ce.creamapi.ws.es.activityinfo.types.ListActivitiesResponse;
import org.glite.ce.creamapi.ws.es.activityinfo.types.Operation_type0;
import org.glite.ce.creamapi.ws.es.glue.ComputingActivityState_t;
import org.glite.ce.creamapi.ws.es.glue.ComputingActivityType_t;
import org.glite.ce.creamapi.ws.es.glue.JobDescription_t;

public class ActivityInfoClient
extends ActivityCommand {
    public static void main(String[] args) {
        ArrayList<String> options = new ArrayList<String>(8);
        options.add("EPR");
        options.add("PROXY");
        options.add("GET_ACTIVITY_INFO");
        options.add("GET_ACTIVITY_STATUS");
        options.add("LIST_ACTIVITIES");
        new ActivityInfoClient(args, options);
    }

    public ActivityInfoClient(String[] args, List<String> options) throws RuntimeException {
        super(args, options);
    }

    private String checkAttribute(String name, BigInteger value) {
        if (value == null) {
            return "";
        }
        return "\n" + name + " = " + value.toString();
    }

    private String checkAttribute(String name, ComputingActivityState_t[] state) {
        if (state == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer("[ ");
        for (int i = 0; i < state.length; ++i) {
            buffer.append(state[i].getComputingActivityState_t()).append(", ");
        }
        buffer.replace(buffer.length() - 2, buffer.length(), " ]");
        return "\n" + name + " = " + buffer.toString();
    }

    private String checkAttribute(String name, ComputingActivityType_t type) {
        if (type == null) {
            return "";
        }
        return "\n" + name + " = " + type.getValue();
    }

    private String checkAttribute(String name, Integer value) {
        if (value == null) {
            return "";
        }
        return "\n" + name + " = " + value.toString();
    }

    private String checkAttribute(String name, JobDescription_t jobDescription) {
        if (jobDescription == null) {
            return "";
        }
        return "\n" + name + " = " + jobDescription.getJobDescription_t();
    }

    private String checkAttribute(String name, List<String> value) {
        if (value == null) {
            return "";
        }
        return "\n" + name + " = " + value.toString();
    }

    private String checkAttribute(String name, String value) {
        if (value == null) {
            return "";
        }
        return "\n" + name + " = " + value;
    }

    private String checkAttribute(String name, String[] values) {
        if (values == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer("[ ");
        for (int i = 0; i < values.length; ++i) {
            buffer.append(values[i]).append(", ");
        }
        buffer.replace(buffer.length() - 2, buffer.length(), " ]");
        return "\n" + name + " = " + buffer.toString();
    }

    private String checkAttribute(String name, URI[] values) {
        if (values == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer("[ ");
        for (int i = 0; i < values.length; ++i) {
            buffer.append(values[i]).append(", ");
        }
        buffer.replace(buffer.length() - 2, buffer.length(), " ]");
        return "\n" + name + " = " + buffer.toString();
    }

    private String checkAttribute(String name, UnsignedLong value) {
        if (value == null) {
            return "";
        }
        return "\n" + name + " = " + value.toString();
    }

    private String checkAttribute(String name, URI uri) {
        if (uri == null) {
            return "";
        }
        return "\n" + name + " = " + uri.toString();
    }

    private String checkAttribute(String name, Calendar time) {
        if (time == null) {
            return "";
        }
        return "\n" + name + " = " + time.getTime();
    }

    @Override
    public void execute() {
        if (this.isListActivities()) {
            ListActivities req = new ListActivities();
            req.setFromDate(this.getFromDate());
            req.setToDate(this.getToDate());
            if (this.getLimit() > 0) {
                req.setLimit(new NonNegativeInteger("" + this.getLimit()));
            }
            String status = null;
            String attribute = null;
            StringTokenizer st = null;
            ListActivitiesResponse response = null;
            try {
                ActivityStatus_type1 activityStatus = null;
                List<String> idList = this.getIdList();
                for (int i = 0; i < idList.size(); ++i) {
                    st = new StringTokenizer(idList.get(i), ":");
                    status = st.nextToken();
                    attribute = null;
                    activityStatus = new ActivityStatus_type1();
                    activityStatus.setStatus(ActivityStatusState.Factory.fromValue((String)status));
                    while (st.hasMoreTokens()) {
                        attribute = st.nextToken();
                        activityStatus.addAttribute(ActivityStatusAttribute.Factory.fromValue((String)attribute));
                    }
                    req.addActivityStatus(activityStatus);
                }
                response = this.getActivityInfoServiceStub().listActivities(req);
            }
            catch (AxisFault e) {
                System.out.println(e.getMessage());
                return;
            }
            catch (RemoteException e) {
                System.out.println("RemoteException: " + e.getMessage());
                return;
            }
            catch (AccessControlFault e) {
                System.out.println("AccessControlFault: " + e.getFaultMessage().getMessage());
                return;
            }
            catch (InternalBaseFault e) {
                System.out.println("InternalBaseFault:" + e.getFaultMessage().getInternalBaseFault().getMessage());
                return;
            }
            catch (InvalidParameterFault e) {
                System.out.println("InvalidParameterFault:" + e.getFaultMessage().getMessage());
                return;
            }
            catch (IllegalArgumentException e) {
                if (attribute == null) {
                    System.out.println("IllegalArgumentException: wrong status name found (" + status + "); please use: " + ActivityStatusState._value1 + ", " + ActivityStatusState._value2 + ", " + ActivityStatusState._value3 + ", " + ActivityStatusState._value4 + ", " + ActivityStatusState._value5 + ", " + ActivityStatusState._value6 + ", " + ActivityStatusState._value7 + ", " + ActivityStatusState._value8);
                } else {
                    System.out.println("IllegalArgumentException: wrong status attribute name found (" + attribute + "); please use: " + ActivityStatusAttribute._value1 + ", " + ActivityStatusAttribute._value2 + ", " + ActivityStatusAttribute._value3 + ", " + ActivityStatusAttribute._value4 + ", " + ActivityStatusAttribute._value5 + ", " + ActivityStatusAttribute._value6 + ", " + ActivityStatusAttribute._value7 + ", " + ActivityStatusAttribute._value8 + ", " + ActivityStatusAttribute._value9 + ", " + ActivityStatusAttribute._value10 + ", " + ActivityStatusAttribute._value11 + ", " + ActivityStatusAttribute._value12 + ", " + ActivityStatusAttribute._value13 + ", " + ActivityStatusAttribute._value14 + ", " + ActivityStatusAttribute._value15 + ", " + ActivityStatusAttribute._value16 + ", " + ActivityStatusAttribute._value17 + ", " + ActivityStatusAttribute._value18 + ", " + ActivityStatusAttribute._value19);
                }
                return;
            }
            if (response == null) {
                System.out.println("none response received!");
                return;
            }
            if (response.isActivityIDSpecified()) {
                String[] responseItems = response.getActivityID();
                for (int i = 0; i < responseItems.length; ++i) {
                    System.out.println(i + 1 + ") activityId = " + responseItems[i]);
                }
                System.out.println("\nthe result was " + (response.getTruncated() ? "" : "not ") + "truncated");
            } else {
                System.out.println("none activity found");
            }
        } else if (this.isGetActivityStatus()) {
            if (this.getIdList().size() == 0) {
                this.printUsage();
                return;
            }
            GetActivityStatus req = new GetActivityStatus();
            req.setActivityID(this.getIdArray());
            GetActivityStatusResponse response = null;
            try {
                response = this.getActivityInfoServiceStub().getActivityStatus(req);
            }
            catch (AxisFault e) {
                System.out.println(e.getMessage());
                return;
            }
            catch (RemoteException e) {
                System.out.println(e.getMessage());
                return;
            }
            catch (VectorLimitExceededFault e) {
                System.out.println(e.getFaultMessage().getMessage());
                return;
            }
            catch (InternalBaseFault e) {
                System.out.println(e.getFaultMessage().getInternalBaseFault().getMessage());
                return;
            }
            catch (AccessControlFault e) {
                System.out.println(e.getFaultMessage().getMessage());
                return;
            }
            if (response == null) {
                System.out.println("none response received!");
                return;
            }
            ActivityStatus_type0 status = null;
            ActivityStatusItemChoice_type1 choice = null;
            ActivityStatusAttribute[] statusAttributes = null;
            ActivityStatusItem_type0[] activityStatusItems = response.getActivityStatusItem();
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < activityStatusItems.length; ++i) {
                buffer.append("\n").append(i).append(") activityId = ");
                buffer.append(activityStatusItems[i].getActivityID());
                choice = activityStatusItems[i].getActivityStatusItemChoice_type1();
                if (choice.isActivityStatusSpecified()) {
                    status = choice.getActivityStatus();
                    buffer.append("\nstatus = ").append(status.getStatus().getValue());
                    if (status.isAttributeSpecified()) {
                        buffer.append("\nattributes = { ");
                        statusAttributes = status.getAttribute();
                        for (int j = 0; j < statusAttributes.length; ++j) {
                            buffer.append(statusAttributes[j].getValue()).append(", ");
                        }
                        buffer.replace(buffer.length() - 2, buffer.length() - 1, " }");
                    }
                    if (status.getDescription() != null) {
                        buffer.append("\ndescription = \"" + status.getDescription()).append("\"");
                    }
                    buffer.append("\ntimestamp = " + status.getTimestamp().getTime());
                } else if (choice.isAccessControlFaultSpecified()) {
                    buffer.append("\nfault = AccessControlFault");
                    buffer.append(this.printFault((InternalBaseFault_Type)choice.getAccessControlFault()));
                } else if (choice.isActivityNotFoundFaultSpecified()) {
                    buffer.append("\nfault = ActivityNotFoundFault");
                    buffer.append(this.printFault((InternalBaseFault_Type)choice.getActivityNotFoundFault()));
                } else if (choice.isInternalBaseFaultSpecified()) {
                    buffer.append("\nfault = InternalBaseFault");
                    buffer.append(this.printFault(choice.getInternalBaseFault()));
                } else if (choice.isOperationNotAllowedFaultSpecified()) {
                    buffer.append("\nfault = OperationNotAllowedFault");
                    buffer.append(this.printFault((InternalBaseFault_Type)choice.getOperationNotAllowedFault()));
                } else if (choice.isOperationNotPossibleFaultSpecified()) {
                    buffer.append("\nfault = OperationNotPossibleFault");
                    buffer.append(this.printFault((InternalBaseFault_Type)choice.getOperationNotPossibleFault()));
                } else if (choice.isUnableToRetrieveStatusFaultSpecified()) {
                    buffer.append("\nfault = UnableToRetrieveStatusFault");
                    buffer.append(this.printFault((InternalBaseFault_Type)choice.getUnableToRetrieveStatusFault()));
                }
                buffer.append("\n");
            }
            System.out.println(buffer.toString());
        } else if (this.isGetActivityInfo()) {
            if (this.getIdList().size() == 0) {
                this.printUsage();
                return;
            }
            GetActivityInfo req = new GetActivityInfo();
            req.setActivityID(this.getIdArray());
            GetActivityInfoResponse response = null;
            try {
                response = this.getActivityInfoServiceStub().getActivityInfo(req);
            }
            catch (AxisFault e) {
                System.out.println("AxisFault: " + e.getMessage());
                return;
            }
            catch (RemoteException e) {
                System.out.println("RemoteException: " + e.getMessage());
                return;
            }
            catch (AccessControlFault e) {
                System.out.println("AccessControlFault: " + e.getFaultMessage().getMessage());
                return;
            }
            catch (InternalBaseFault e) {
                System.out.println("InternalBaseFault:" + e.getFaultMessage().getInternalBaseFault().getMessage());
                return;
            }
            catch (UnknownAttributeFault e) {
                System.out.println("UnknownAttributeFault: " + e.getFaultMessage().getUnknownAttributeFault().getMessage());
                return;
            }
            catch (VectorLimitExceededFault e) {
                System.out.println("VectorLimitExceededFault " + e.getFaultMessage().getMessage());
                return;
            }
            if (response == null) {
                System.out.println("none response received!");
                return;
            }
            ActivityInfoDocument_t activityInfoDocument = null;
            ActivityInfoItemChoice_type1 choice = null;
            ActivityInfoItem_type0[] activityInfoItems = response.getActivityInfoItem();
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < activityInfoItems.length; ++i) {
                buffer.append("\n").append(i).append(") activityId = ");
                buffer.append(activityInfoItems[i].getActivityID());
                choice = activityInfoItems[i].getActivityInfoItemChoice_type1();
                if (choice.isActivityInfoDocumentSpecified()) {
                    ComputingActivityHistory_type0 history;
                    activityInfoDocument = choice.getActivityInfoDocument();
                    buffer.append(this.checkAttribute("id", activityInfoDocument.getID()));
                    buffer.append(this.checkAttribute("idFromEndpoint", activityInfoDocument.getIDFromEndpoint()));
                    buffer.append(this.checkAttribute("localIDFromManager", activityInfoDocument.getLocalIDFromManager()));
                    if (activityInfoDocument.isTypeSpecified()) {
                        buffer.append(this.checkAttribute("type", activityInfoDocument.getType().toString()));
                    }
                    buffer.append(this.checkAttribute("name", activityInfoDocument.getName()));
                    buffer.append(this.checkAttribute("description", activityInfoDocument.getJobDescription()));
                    buffer.append(this.checkAttribute("computingManagerExitCode", activityInfoDocument.getComputingManagerExitCode()));
                    buffer.append(this.checkAttribute("localOwner", activityInfoDocument.getLocalOwner()));
                    buffer.append(this.checkAttribute("owner", activityInfoDocument.getOwner()));
                    buffer.append(this.checkAttribute("userDomain", activityInfoDocument.getUserDomain()));
                    buffer.append(this.checkAttribute("logDir", activityInfoDocument.getLogDir()));
                    buffer.append(this.checkAttribute("queue", activityInfoDocument.getQueue()));
                    buffer.append(this.checkAttribute("stdIn", activityInfoDocument.getStdIn()));
                    buffer.append(this.checkAttribute("stdOut", activityInfoDocument.getStdOut()));
                    buffer.append(this.checkAttribute("stdErr", activityInfoDocument.getStdErr()));
                    buffer.append(this.checkAttribute("sessionDirectory", activityInfoDocument.getSessionDirectory()));
                    buffer.append(this.checkAttribute("stageInDirectory", activityInfoDocument.getStageInDirectory()));
                    buffer.append(this.checkAttribute("stageOutDirectory", activityInfoDocument.getStageOutDirectory()));
                    buffer.append(this.checkAttribute("submissionClientName", activityInfoDocument.getSubmissionClientName()));
                    buffer.append(this.checkAttribute("submissionHost", activityInfoDocument.getSubmissionHost()));
                    if (activityInfoDocument.isExitCodeSpecified()) {
                        buffer.append(this.checkAttribute("exitCode", activityInfoDocument.getExitCode()));
                    }
                    buffer.append(this.checkAttribute("creationTime", activityInfoDocument.getCreationTime()));
                    buffer.append(this.checkAttribute("startTime", activityInfoDocument.getStartTime()));
                    buffer.append(this.checkAttribute("submissionTime ", activityInfoDocument.getSubmissionTime()));
                    buffer.append(this.checkAttribute("computingManagerSubmissionTime", activityInfoDocument.getComputingManagerSubmissionTime()));
                    buffer.append(this.checkAttribute("computingManagerEndTime", activityInfoDocument.getComputingManagerEndTime()));
                    buffer.append(this.checkAttribute("endTime", activityInfoDocument.getEndTime()));
                    buffer.append(this.checkAttribute("workingAreaEraseTime", activityInfoDocument.getWorkingAreaEraseTime()));
                    buffer.append(this.checkAttribute("proxyExpirationTime", activityInfoDocument.getProxyExpirationTime()));
                    buffer.append(this.checkAttribute("state", activityInfoDocument.getState()));
                    buffer.append(this.checkAttribute("restartState", activityInfoDocument.getRestartState()));
                    buffer.append(this.checkAttribute("error", activityInfoDocument.getError()));
                    buffer.append(this.checkAttribute("otherInfo", activityInfoDocument.getOtherInfo()));
                    buffer.append(this.checkAttribute("otherMessages", activityInfoDocument.getOtherMessages()));
                    buffer.append(this.checkAttribute("executionNode", activityInfoDocument.getExecutionNode()));
                    buffer.append(this.checkAttribute("requestedApplicationEnvironment", activityInfoDocument.getRequestedApplicationEnvironment()));
                    if (activityInfoDocument.isRequestedSlotsSpecified()) {
                        buffer.append("\nrequestedSlots = ").append(activityInfoDocument.getRequestedSlots());
                    }
                    buffer.append(this.checkAttribute("requestedTotalCPUTime", activityInfoDocument.getRequestedTotalCPUTime()));
                    buffer.append(this.checkAttribute("requestedTotalWallTime", activityInfoDocument.getRequestedTotalWallTime()));
                    buffer.append(this.checkAttribute("usedMainMemory", activityInfoDocument.getUsedMainMemory()));
                    buffer.append(this.checkAttribute("usedTotalCPUTime", activityInfoDocument.getUsedTotalCPUTime()));
                    buffer.append(this.checkAttribute("usedTotalWallTime", activityInfoDocument.getUsedTotalWallTime()));
                    buffer.append(this.checkAttribute("validity", activityInfoDocument.getValidity()));
                    if (activityInfoDocument.isWaitingPositionSpecified()) {
                        buffer.append("\nwaitingPosition = ").append(activityInfoDocument.getWaitingPosition());
                    }
                    if ((history = activityInfoDocument.getComputingActivityHistory()) != null) {
                        int x;
                        if (history.getActivityStatus() != null) {
                            ActivityStatus_type0[] activityStatusArray = history.getActivityStatus();
                            for (x = 0; x < activityStatusArray.length; ++x) {
                                ActivityStatusAttribute[] attributes;
                                buffer.append("\n[ status = ").append(activityStatusArray[x].getStatus().getValue());
                                buffer.append("; timestamp = ").append(activityStatusArray[x].getTimestamp().getTime());
                                if (activityStatusArray[x].isDescriptionSpecified()) {
                                    buffer.append("; description = \"").append(activityStatusArray[x].getDescription()).append("\"");
                                }
                                if ((attributes = activityStatusArray[x].getAttribute()) != null && attributes.length > 0) {
                                    buffer.append("; attributes = { ");
                                    for (int y = 0; y < attributes.length; ++y) {
                                        buffer.append(attributes[y].getValue()).append(", ");
                                    }
                                    buffer.replace(buffer.length() - 2, buffer.length(), " }");
                                }
                                buffer.append(" ]");
                            }
                        }
                        if (history.isOperationSpecified()) {
                            Operation_type0[] operationArray = history.getOperation();
                            for (x = 0; x < operationArray.length; ++x) {
                                buffer.append("\n[ operation = ").append(operationArray[x].getRequestedOperation().toString());
                                buffer.append("; timestamp = ").append(operationArray[x].getTimestamp().getTime());
                                buffer.append("; success = ").append(operationArray[x].getSuccess());
                                buffer.append(" ]");
                            }
                        }
                    }
                } else if (choice.isAccessControlFaultSpecified()) {
                    buffer.append("\nfault = AccessControlFault");
                    buffer.append(this.printFault((InternalBaseFault_Type)choice.getAccessControlFault()));
                } else if (choice.isActivityNotFoundFaultSpecified()) {
                    buffer.append("\nfault = ActivityNotFoundFault");
                    buffer.append(this.printFault((InternalBaseFault_Type)choice.getActivityNotFoundFault()));
                } else if (choice.isInternalBaseFaultSpecified()) {
                    buffer.append("\nfault = InternalBaseFault");
                    buffer.append(this.printFault(choice.getInternalBaseFault()));
                } else if (choice.isOperationNotAllowedFaultSpecified()) {
                    buffer.append("\nfault = OperationNotAllowedFault");
                    buffer.append(this.printFault((InternalBaseFault_Type)choice.getOperationNotAllowedFault()));
                } else if (choice.isOperationNotPossibleFaultSpecified()) {
                    buffer.append("\nfault = OperationNotPossibleFault");
                    buffer.append(this.printFault((InternalBaseFault_Type)choice.getOperationNotPossibleFault()));
                } else if (choice.isUnableToRetrieveStatusFaultSpecified()) {
                    buffer.append("\nfault = UnableToRetrieveStatusFault");
                    buffer.append(this.printFault((InternalBaseFault_Type)choice.getUnableToRetrieveStatusFault()));
                } else if (choice.isUnknownAttributeFaultSpecified()) {
                    buffer.append("\nfault = UnknownAttributeFault");
                    buffer.append(this.printFault((InternalBaseFault_Type)choice.getUnknownAttributeFault()));
                }
                buffer.append("\n");
            }
            System.out.println(buffer.toString());
        } else {
            this.printUsage();
        }
    }

    private String printFault(InternalBaseFault_Type fault) {
        StringBuffer buffer = new StringBuffer();
        if (fault != null) {
            buffer.append("\nmessage = \"").append(fault.getMessage()).append("\"");
            buffer.append("\ntimestamp = " + fault.getTimestamp().getTime());
            if (fault.getDescription() != null) {
                buffer.append("\ndescription = \"" + fault.getDescription()).append("\"");
            }
        }
        return buffer.toString();
    }
}

