/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.cream.client;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.apache.axis2.AxisFault;
import org.glite.ce.cream.client.JobCommand;
import org.glite.ce.creamapi.ws.cream2.Authorization_Fault;
import org.glite.ce.creamapi.ws.cream2.Generic_Fault;
import org.glite.ce.creamapi.ws.cream2.types.BaseFaultType;
import org.glite.ce.creamapi.ws.cream2.types.Property;
import org.glite.ce.creamapi.ws.cream2.types.ServiceInfo;
import org.glite.ce.creamapi.ws.cream2.types.ServiceMessage;

public class GetServiceInfo
extends JobCommand {
    public GetServiceInfo(String[] args, List<String> options) throws RuntimeException {
        super(args, options);
    }

    @Override
    public void execute() {
        ServiceInfo info = null;
        try {
            info = this.getCREAMStub().getServiceInfo(2);
        }
        catch (Authorization_Fault e) {
            this.printFault((BaseFaultType)e.getFaultMessage());
        }
        catch (Generic_Fault gf) {
            if (gf.getFaultMessage() != null) {
                this.printFault((BaseFaultType)gf.getFaultMessage().getGenericFault());
            }
        }
        catch (AxisFault e) {
            this.printFault(e);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        System.out.println("service descrition: " + (info.getDescription() != null ? info.getDescription() : "N/A"));
        System.out.println("interface version: " + info.getInterfaceVersion());
        System.out.println("service version: " + info.getServiceVersion());
        System.out.println("service startup time: " + info.getStartupTime().getTime());
        System.out.println("service status: " + info.getStatus());
        System.out.println("service does accept new jobs: " + info.getDoesAcceptNewJobSubmissions());
        ServiceMessage[] message = info.getMessage();
        System.out.print("messages: ");
        if (message == null) {
            System.out.println("0");
        } else {
            System.out.println(message.length);
            for (int i = 0; i < message.length; ++i) {
                System.out.println("" + i + ") " + message[i].getMessage() + " type: " + message[i].getType() + " timestamp: " + message[i].getTimastamp().getTime());
            }
        }
        Property[] property = info.getProperty();
        System.out.print("properties: ");
        if (property == null) {
            System.out.println("0");
        } else {
            System.out.println(property.length);
            for (int i = 0; i < property.length; ++i) {
                System.out.println("" + i + ") " + property[i].getName() + " = " + property[i].getValue());
            }
        }
    }

    public static void main(String[] args) {
        ArrayList<String> options = new ArrayList<String>(2);
        options.add("epr");
        options.add("proxy");
        new GetServiceInfo(args, options);
    }
}

