/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.cream.blahmanagement;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.ConnectionPendingException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import org.apache.log4j.Logger;
import org.glite.ce.commonj.utils.BooleanLock;
import org.glite.ce.cream.blahmanagement.BLAHJobStatus;
import org.glite.ce.cream.blahmanagement.BLAHJobStatusChangeListener;
import org.glite.ce.cream.blahmanagement.BLAHNotifierInfo;

public class BLAHNotifierClient
extends Thread {
    private static final Logger logger = Logger.getLogger((String)BLAHNotifierClient.class.getName());
    private String lrms = null;
    private String host = null;
    private String prefix = null;
    private int port = -1;
    private int version = -1;
    private int retryCount = 100;
    private int retryDelay = 60000;
    private Socket socket = null;
    private BooleanLock isNTFDATEfinished = null;
    private PrintWriter out;
    private BufferedReader breader;
    private BLAHJobStatusChangeListener jobStatusChangeListener = null;
    private boolean working = true;

    public BLAHNotifierClient() {
        this((BLAHNotifierInfo)null);
    }

    public BLAHNotifierClient(BLAHNotifierInfo blahNotifierInfo) {
        super("BLAHNotifierClient");
        this.setDaemon(true);
        this.isNTFDATEfinished = new BooleanLock(false);
        if (blahNotifierInfo != null) {
            this.lrms = blahNotifierInfo.getLRMS();
            this.host = blahNotifierInfo.getHost();
            this.port = blahNotifierInfo.getPort();
        }
    }

    private boolean getConnection(int maxRetryCount) {
        int i = maxRetryCount;
        boolean isConnected = false;
        boolean forever = i < 0;
        this.isNTFDATEfinished.setValue(false);
        while (!isConnected && (forever || i-- > 0)) {
            logger.info((Object)("getting connection with the remote Notifier \"" + this.lrms + "\" [host:port=" + this.host + ":" + this.port + "; retryCount=" + i + "/" + maxRetryCount + "]"));
            try {
                this.socket = new Socket(this.host, this.port);
                this.out = new PrintWriter(this.socket.getOutputStream(), true);
                this.breader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
                logger.info((Object)("Connection with the remote Notifier [host:port=" + this.host + ":" + this.port + "] correctly established."));
                isConnected = true;
            }
            catch (IOException e) {
                logger.error((Object)("Connection with the remote Notifier [host:port=" + this.host + ":" + this.port + "] cannot be established"));
            }
            catch (AlreadyConnectedException e) {
                logger.error((Object)("Connection with the remote Notifier [host:port=" + this.host + ":" + this.port + "] already established"));
            }
            catch (ConnectionPendingException e) {
                logger.error((Object)("Connection with the remote Notifier [host:port=" + this.host + ":" + this.port + "] is pending"));
            }
            catch (SecurityException e) {
                logger.error((Object)("Connection with the remote Notifier [host:port=" + this.host + ":" + this.port + "] failed: " + e.getMessage()));
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error((Object)("Connection with the remote Notifier [host:port=" + this.host + ":" + this.port + "] failed: " + e.getMessage()));
            }
            if (isConnected) continue;
            try {
                BLAHNotifierClient.sleep(this.retryDelay);
            }
            catch (InterruptedException ie) {
                logger.error((Object)ie.getMessage());
            }
        }
        if (!isConnected && maxRetryCount > 0) {
            logger.error((Object)("Connection with the remote Notifier [host:port=" + this.host + ":" + this.port + "] failed: max retry count reached"));
        }
        return isConnected;
    }

    public String getHost() {
        return this.host;
    }

    public BLAHJobStatusChangeListener getJobStatusChangeListener() {
        return this.jobStatusChangeListener;
    }

    public String getLRMS() {
        return this.lrms;
    }

    public int getPort() {
        return this.port;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public int getRetryDelay() {
        return this.retryDelay;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean isConnected() {
        return this.socket != null && !this.socket.isClosed() && this.socket.isConnected() && this.breader != null;
    }

    public boolean isInitialized() {
        return this.isNTFDATEfinished.isTrue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.info((Object)"BLAHNotifierClient started!");
        while (this.working) {
            if (!this.getConnection(this.retryCount)) {
                this.interrupt();
                this.working = false;
            }
            if (!this.working) continue;
            try {
                this.sendCREAMFilterCommand();
                this.version = this.sendParserVersionCommand();
                logger.info((Object)("version = " + this.version));
                this.sendStartNotifyJobListCommand(null);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
                this.interrupt();
                this.working = false;
            }
            logger.info((Object)("working = " + this.working));
            String line = null;
            String notification = "";
            try {
                while (this.working) {
                    BufferedReader bufferedReader = this.breader;
                    synchronized (bufferedReader) {
                        line = this.breader.readLine();
                    }
                    if (line == null) {
                        throw new Exception("Lost the connection with remote Notifier [host:port=" + this.host + ":" + this.port + "]!");
                    }
                    logger.debug((Object)("line = " + line));
                    if (line.startsWith("NTFDATE/END")) {
                        this.isNTFDATEfinished.setValue(true);
                    } else {
                        notification = notification + line;
                        if (line.endsWith("]")) {
                            if (this.jobStatusChangeListener != null) {
                                this.jobStatusChangeListener.doOnJobStatusChange(new BLAHJobStatus(notification, 0));
                            }
                            notification = "";
                        }
                    }
                    line = null;
                }
            }
            catch (Throwable t) {
                if (!this.working) continue;
                logger.error((Object)t.getMessage());
            }
        }
        logger.info((Object)"BLAHNotifierClient terminated");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendCREAMFilterCommand() throws Exception {
        if (this.prefix == null) {
            return;
        }
        PrintWriter printWriter = this.out;
        synchronized (printWriter) {
            logger.debug((Object)("sendCREAMFilterCommand() sending CREAMFILTER/" + this.prefix + " ..."));
            this.out.println("CREAMFILTER/" + this.prefix);
            logger.debug((Object)("sendCREAMFilterCommand() sending CREAMFILTER/" + this.prefix + " ... done"));
        }
        String filterResult = null;
        BufferedReader bufferedReader = this.breader;
        synchronized (bufferedReader) {
            filterResult = this.breader.readLine();
        }
        logger.debug((Object)("received: " + filterResult));
        if (filterResult.indexOf("ERROR") > 0) {
            throw new Exception("CREAMFILTER error: " + filterResult);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendParserVersionCommand() throws Exception {
        PrintWriter printWriter = this.out;
        synchronized (printWriter) {
            logger.debug((Object)"sendParserVersionCommand(): sending PARSERVERSION/ ...");
            this.out.println("PARSERVERSION/");
            logger.debug((Object)"sendParserVersionCommand(): sending PARSERVERSION/ ... done");
        }
        String parserVersion = null;
        BufferedReader bufferedReader = this.breader;
        synchronized (bufferedReader) {
            parserVersion = this.breader.readLine();
        }
        logger.debug((Object)("sendParserVersionCommand() received: " + parserVersion));
        if (parserVersion == null) {
            throw new Exception("PARSERVERSION did not return the version value");
        }
        if (parserVersion.endsWith("__0")) {
            return 0;
        }
        if (parserVersion.endsWith("__1")) {
            return 1;
        }
        throw new Exception("PARSERVERSION returned an unsupported version value! (value=" + parserVersion + ")");
    }

    public void sendStartNotifyJobListCommand(List<String> jobList) throws Exception {
        this.sendStartNotifyJobListCommand(jobList, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendStartNotifyJobListCommand(List<String> jobList, Calendar olderJobTime) throws Exception {
        StringBuffer cmd = new StringBuffer("STARTNOTIFYJOBLIST/");
        if (this.version == 0) {
            if (olderJobTime == null) {
                olderJobTime = Calendar.getInstance();
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            cmd.append(dateFormat.format(olderJobTime.getTime())).append(";");
        }
        if (jobList != null && jobList.size() > 0) {
            for (String jobId : jobList) {
                cmd.append(this.prefix).append(jobId.substring(5, jobId.length())).append(",");
            }
            cmd.deleteCharAt(cmd.length() - 1);
            jobList.clear();
            jobList = null;
        }
        PrintWriter printWriter = this.out;
        synchronized (printWriter) {
            logger.debug((Object)("sendStartNotifyJobListCommand(): sending " + cmd + " ..."));
            this.out.println(cmd);
            logger.debug((Object)"sendStartNotifyJobListCommand(): sending STARTNOTIFYJOBLIST/ ... done");
            logger.debug((Object)"sendStartNotifyJobListCommand(): sending STARTNOTIFYJOBEND/ ...");
            this.out.println("STARTNOTIFYJOBEND/");
            logger.debug((Object)"sendStartNotifyJobListCommand(): sending STARTNOTIFYJOBEND/ ... done");
        }
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setJobStatusChangeListener(BLAHJobStatusChangeListener jobStatusChangeListener) {
        this.jobStatusChangeListener = jobStatusChangeListener;
    }

    public void setLRMS(String lrms) {
        this.lrms = lrms;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public void setRetryDelay(int retryDelay) {
        this.retryDelay = retryDelay;
    }

    public void terminate() {
        logger.info((Object)("terminate invoked! [host:port=" + this.host + ":" + this.port + "]"));
        this.working = false;
        try {
            if (this.socket != null) {
                this.socket.shutdownInput();
                this.socket.shutdownOutput();
                this.socket.close();
            }
            if (this.breader != null) {
                this.breader.close();
            }
            if (this.out != null) {
                this.out.close();
            }
            logger.info((Object)("terminated! [host:port=" + this.host + ":" + this.port + "]"));
        }
        catch (Throwable t) {
            logger.error((Object)("failure on terminating the BLAHNotifierClient [host:port=" + this.host + ":" + this.port + "]: " + t.getMessage()));
        }
        this.host = null;
        this.port = -1;
    }
}

