/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.cream.blahmanagement;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.glite.ce.cream.blahmanagement.BLAHException;

public class BLAHCommand
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String QUIT = "QUIT";
    public static final String RESULTS = "RESULTS";
    public static final String VERSION = "VERSION";
    public static final String ASYNC_MODE_ON = "ASYNC_MODE_ON";
    public static final String ASYNC_MODE_OFF = "ASYNC_MODE_OFF";
    public static final String BLAH_JOB_CANCEL = "BLAH_JOB_CANCEL";
    public static final String BLAH_JOB_STATUS = "BLAH_JOB_STATUS";
    public static final String BLAH_JOB_STATUS_ALL = "BLAH_JOB_STATUS_ALL";
    public static final String BLAH_JOB_STATUS_SELECT = "BLAH_JOB_STATUS_SELECT";
    public static final String BLAH_JOB_SUBMIT = "BLAH_JOB_SUBMIT";
    public static final String BLAH_JOB_HOLD = "BLAH_JOB_HOLD";
    public static final String BLAH_JOB_RESUME = "BLAH_JOB_RESUME";
    public static final String BLAH_JOB_REFRESH_PROXY = "BLAH_JOB_REFRESH_PROXY";
    public static final String BLAH_JOB_SEND_PROXY_TO_WORKER_NODE = "BLAH_JOB_SEND_PROXY_TO_WORKER_NODE";
    public static final String BLAH_GET_HOSTPORT = "BLAH_GET_HOSTPORT";
    public static final String BLAH_SET_GLEXEC_DN = "BLAH_SET_GLEXEC_DN";
    public static final String BLAH_SET_GLEXEC_OFF = "BLAH_SET_GLEXEC_OFF";
    public static final String BLAH_SET_SUDO_ID = "BLAH_SET_SUDO_ID";
    private String name = null;
    private String reqId = null;
    private String blahJobId = null;
    private BLAHException exception;
    private Calendar timeout;
    private List<String> parameterList = null;
    private List<String> resultList = null;

    public BLAHCommand(String name) {
        this.name = name;
    }

    public BLAHCommand(String name, String blahJobId) {
        this(name, blahJobId, null);
    }

    public BLAHCommand(String name, String blahJobId, String reqId) {
        this.name = name;
        this.blahJobId = blahJobId;
        this.reqId = reqId;
    }

    public void addParameter(String parameter) {
        if (parameter == null) {
            return;
        }
        if (this.parameterList == null) {
            this.parameterList = new ArrayList<String>(1);
        }
        this.parameterList.add(parameter);
    }

    public void addResult(String result) {
        if (result == null) {
            return;
        }
        if (this.resultList == null) {
            this.resultList = new ArrayList<String>(1);
        }
        this.resultList.add(result);
    }

    public String getBlahJobId() {
        return this.blahJobId;
    }

    public BLAHException getException() {
        return this.exception;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getParameterList() {
        return this.parameterList;
    }

    public String getReqId() {
        return this.reqId;
    }

    public List<String> getResultList() {
        return this.resultList;
    }

    public Calendar getTimeout() {
        return this.timeout;
    }

    public boolean isSuccessfull() {
        return this.exception == null;
    }

    public boolean isTimedOut() {
        return this.timeout != null && Calendar.getInstance().after(this.timeout);
    }

    public void setException(BLAHException exception) {
        this.exception = exception;
    }

    public void setReqId(String reqId) {
        this.reqId = reqId;
    }

    public void setTimeout(Calendar timeout) {
        this.timeout = timeout;
    }

    public String toString() {
        String cmd = this.name;
        if (this.reqId != null) {
            cmd = cmd + " " + this.reqId;
        }
        if (this.blahJobId != null) {
            cmd = cmd + " " + this.blahJobId;
        }
        if (this.parameterList != null) {
            for (String parameter : this.parameterList) {
                cmd = cmd + " " + parameter;
            }
        }
        return cmd + "\n";
    }
}

