/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.cream.blahmanagement;

import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.glite.ce.cream.blahmanagement.BLAHCommand;
import org.glite.ce.cream.blahmanagement.BLAHException;
import org.glite.ce.cream.blahmanagement.BLAHJob;
import org.glite.ce.cream.blahmanagement.BLAHJobStatus;
import org.glite.ce.cream.blahmanagement.BLAHJobStatusChangeListener;
import org.glite.ce.cream.blahmanagement.BLAHNotificationListener;
import org.glite.ce.cream.blahmanagement.BLAHNotifierClient;
import org.glite.ce.cream.blahmanagement.BLAHNotifierInfo;
import org.glite.ce.cream.blahmanagement.BLAHProcess;

public class BLAHClient {
    private static final Logger logger = Logger.getLogger((String)BLAHClient.class.getName());
    public static final String SANDBOX_TRANSFER_METHOD_LRMS = "LRMS";
    public static final String SANDBOX_TRANSFER_METHOD_GSIFTP = "GSIFTP";
    private BLAHProcess blahProcess = null;
    private String prefix = null;
    private String executablePath = "/usr/bin/blahpd";
    private String scratchDirPath = "/tmp/";
    private String sandboxTransfertMethod = "LRMS";
    private int hostSMPSize = 1;
    private int commandTimeout = 300;
    private int notifierRetryCount = 100;
    private int notifierRetryDelay = 60000;
    private int notificationListenerPort = 9091;
    private boolean asynchronousMode = false;
    private Hashtable<String, BLAHNotifierClient> blahNotifierClientTable;
    private BLAHNotificationListener blahNotificationListener = null;
    private BLAHJobStatusChangeListener jobStatusChangeListener = null;
    private static int nextId = 1;

    public void cancel(String blahJobId, String localUser) throws BLAHException {
        this.execute(new BLAHCommand("BLAH_JOB_CANCEL", blahJobId, this.getReqId()), localUser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(BLAHCommand command, String localUser) throws BLAHException {
        if (command == null) {
            throw new BLAHException("command not specified!");
        }
        ArrayList<BLAHCommand> commandList = new ArrayList<BLAHCommand>(1);
        if (localUser != null) {
            BLAHCommand setSudoCommand = new BLAHCommand("BLAH_SET_SUDO_ID");
            setSudoCommand.addParameter(localUser);
            commandList.add(setSudoCommand);
        }
        commandList.add(command);
        BLAHProcess bLAHProcess = this.blahProcess;
        synchronized (bLAHProcess) {
            this.blahProcess.execute(commandList);
        }
        if (this.asynchronousMode) {
            this.blahProcess.waitForResult(command);
        }
        if (!command.isSuccessfull()) {
            throw command.getException();
        }
    }

    protected BLAHNotifierInfo getBlahHostPort(String batchSystem) {
        if (batchSystem == null) {
            return null;
        }
        try {
            List<BLAHNotifierInfo> list = this.getBLAHNotifierInfo();
            for (BLAHNotifierInfo blahNotifierInfo : list) {
                if (!batchSystem.equalsIgnoreCase(blahNotifierInfo.getLRMS())) continue;
                return blahNotifierInfo;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public List<BLAHNotifierInfo> getBLAHNotifierInfo() throws BLAHException {
        BLAHCommand getHostPortCommand = new BLAHCommand("BLAH_GET_HOSTPORT");
        getHostPortCommand.setReqId(this.getReqId());
        this.execute(getHostPortCommand, null);
        List<String> resultList = getHostPortCommand.getResultList();
        if (resultList == null) {
            throw new BLAHException("result not available!");
        }
        ArrayList<BLAHNotifierInfo> list = new ArrayList<BLAHNotifierInfo>(0);
        int port = -1;
        String lrms = null;
        String host = null;
        StringTokenizer st = null;
        for (String result : resultList) {
            port = -1;
            lrms = null;
            host = null;
            st = new StringTokenizer(result);
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                int i = token.indexOf("/");
                try {
                    if (i <= 0) continue;
                    lrms = token.substring(0, i).toLowerCase();
                    int j = token.indexOf(":");
                    if (j > 0) {
                        host = token.substring(i + 1, j);
                        port = Integer.parseInt(token.substring(j + 1, token.length()));
                    }
                    list.add(new BLAHNotifierInfo(lrms, host, port));
                }
                catch (IndexOutOfBoundsException e) {
                    e.printStackTrace();
                }
            }
        }
        return list;
    }

    public int getCommandTimeout() {
        return this.commandTimeout;
    }

    public String getExecutablePath() {
        return this.executablePath;
    }

    public int getHostSMPSize() {
        return this.hostSMPSize;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public int getNotificationListenerPort() {
        return this.notificationListenerPort;
    }

    public int getNotifierRetryCount() {
        return this.notifierRetryCount;
    }

    public int getNotifierRetryDelay() {
        return this.notifierRetryDelay;
    }

    public synchronized String getReqId() {
        return "" + nextId++;
    }

    public String getSandboxTransferMethod() {
        return this.sandboxTransfertMethod;
    }

    public String getScratchDirPath() {
        return this.scratchDirPath;
    }

    public BLAHJobStatus getStatus(String blahJobId, String localUser) throws BLAHException {
        BLAHCommand jobStatusCommand = new BLAHCommand("BLAH_JOB_STATUS", blahJobId, this.getReqId());
        this.execute(jobStatusCommand, localUser);
        List<String> result = jobStatusCommand.getResultList();
        if (result == null || result.size() == 0) {
            throw new BLAHException("result not available!");
        }
        return new BLAHJobStatus(result.get(0));
    }

    public BLAHJobStatus getStatusAll(String localUser) throws BLAHException {
        BLAHCommand jobStatusCommand = new BLAHCommand("BLAH_JOB_STATUS_ALL", null, this.getReqId());
        this.execute(jobStatusCommand, localUser);
        List<String> result = jobStatusCommand.getResultList();
        if (result == null || result.size() == 0) {
            throw new BLAHException("result not available!");
        }
        return new BLAHJobStatus(result.get(0));
    }

    public BLAHJobStatus getStatusSelect(String classadExpr, String localUser) throws BLAHException {
        BLAHCommand jobStatusCommand = new BLAHCommand("BLAH_JOB_STATUS_SELECT", classadExpr, this.getReqId());
        this.execute(jobStatusCommand, localUser);
        List<String> result = jobStatusCommand.getResultList();
        if (result == null || result.size() == 0) {
            throw new BLAHException("result not available!");
        }
        return new BLAHJobStatus(result.get(0));
    }

    public void init() throws BLAHException {
        try {
            this.blahProcess = new BLAHProcess(this.executablePath, this.scratchDirPath, this.commandTimeout);
            List<BLAHNotifierInfo> list = this.getBLAHNotifierInfo();
            this.blahNotifierClientTable = new Hashtable(list.size());
            if (list.size() == 0) {
                logger.error((Object)"Unable to retrieve info about Notifier from BLAH => CREAM will not be able to submit jobs anymore! Please check if the blParser process is up and running and restart CREAM");
                return;
            }
            BLAHNotifierClient blahNotifierClient = null;
            for (BLAHNotifierInfo blahNotifierInfo : list) {
                blahNotifierClient = new BLAHNotifierClient();
                blahNotifierClient.setPrefix(this.prefix);
                blahNotifierClient.setRetryCount(this.notifierRetryCount);
                blahNotifierClient.setRetryDelay(this.notifierRetryDelay);
                blahNotifierClient.setLRMS(blahNotifierInfo.getLRMS());
                blahNotifierClient.setHost(blahNotifierInfo.getHost());
                blahNotifierClient.setPort(blahNotifierInfo.getPort());
                blahNotifierClient.setJobStatusChangeListener(this.jobStatusChangeListener);
                this.blahNotifierClientTable.put(blahNotifierClient.getLRMS(), blahNotifierClient);
            }
        }
        catch (BLAHException e) {
            logger.error((Object)e.getMessage());
            throw new BLAHException(e.getMessage());
        }
        for (BLAHNotifierClient client : this.blahNotifierClientTable.values()) {
            client.start();
        }
        this.blahNotificationListener = new BLAHNotificationListener(this.notificationListenerPort);
        this.blahNotificationListener.setJobStatusChangeListener(this.jobStatusChangeListener);
        this.blahNotificationListener.startListener();
    }

    public boolean isBatchSystemSupported(String batchSystem) {
        if (batchSystem == null) {
            return false;
        }
        return this.blahNotifierClientTable.containsKey(batchSystem.toLowerCase());
    }

    public void quit() throws BLAHException {
        this.execute(new BLAHCommand("QUIT"), null);
    }

    public void renewProxy(String blahJobId, String delegationCertPath, String localUser) throws BLAHException {
        this.renewProxy(blahJobId, localUser, delegationCertPath, null, false);
    }

    public void renewProxy(String blahJobId, String localUser, String delegationCertPath, String workerNode, boolean sendToWN) throws BLAHException {
        if (delegationCertPath == null) {
            throw new BLAHException("delegationCertPath not specified!");
        }
        BLAHCommand command = null;
        if (sendToWN) {
            if (workerNode == null) {
                throw new BLAHException("workerNode not specified!");
            }
            command = new BLAHCommand("BLAH_JOB_SEND_PROXY_TO_WORKER_NODE", blahJobId, this.getReqId());
            command.addParameter(delegationCertPath);
            command.addParameter(workerNode);
        } else {
            command = new BLAHCommand("BLAH_JOB_REFRESH_PROXY", blahJobId, this.getReqId());
            command.addParameter(delegationCertPath);
        }
        this.execute(command, localUser);
    }

    public void resume(String blahJobId, String localUser) throws BLAHException {
        this.execute(new BLAHCommand("BLAH_JOB_RESUME", blahJobId, this.getReqId()), localUser);
    }

    public void setAsynchronousMode(boolean on) throws BLAHException {
        this.execute(new BLAHCommand(on ? "ASYNC_MODE_ON" : "ASYNC_MODE_OFF"), null);
        this.asynchronousMode = on;
    }

    public boolean setCommandTimeout(int timeout) {
        if (this.commandTimeout < 0) {
            logger.warn((Object)("wrong command timeout value found, using the default value: " + this.commandTimeout + " sec"));
            return false;
        }
        this.commandTimeout = timeout;
        return true;
    }

    public boolean setExecutablePath(String path) {
        if (path == null) {
            logger.warn((Object)("blahpd path not specified, usign default value: " + this.executablePath));
            return false;
        }
        this.executablePath = path;
        return true;
    }

    public void setHostSMPSize(int hostSMPSize) {
        if (hostSMPSize <= 0) {
            logger.warn((Object)("wrong value for the \"HOST_SMP_SIZE\" parameter, using the default value: " + hostSMPSize));
        }
        this.hostSMPSize = hostSMPSize;
    }

    public void setPrefix(String prefix) {
        String defaultPrefix = "crxxx_";
        if (prefix != null) {
            if (prefix.length() != 6) {
                logger.warn((Object)("the prefix must be 6 chars long, usign the default value: " + defaultPrefix));
                prefix = defaultPrefix;
            } else if (!prefix.startsWith("cr")) {
                logger.warn((Object)("the prefix must start with \"cr\", using the default value: " + defaultPrefix + ")"));
                prefix = defaultPrefix;
            } else if (!prefix.endsWith("_")) {
                logger.warn((Object)("the prefix must end with '_', using the default value: " + defaultPrefix + ")"));
                prefix = defaultPrefix;
            } else {
                this.prefix = prefix;
            }
        } else {
            logger.warn((Object)("prefix not specified, using the default value: " + defaultPrefix + ")"));
            prefix = defaultPrefix;
        }
    }

    public BLAHNotifierClient getBLAHNotifierClient(String batchSystem) {
        BLAHNotifierClient client = null;
        if (batchSystem != null) {
            client = this.blahNotifierClientTable.get(batchSystem.toLowerCase());
        }
        return client;
    }

    public void setNotificationListenerPort(int port) {
        this.notificationListenerPort = port;
    }

    public boolean setNotifierRetryCount(int retryCount) {
        if (retryCount < 0) {
            logger.warn((Object)("wrong retry count value found, using the default value: " + this.notifierRetryCount + " sec"));
            return false;
        }
        this.notifierRetryCount = retryCount;
        return true;
    }

    public boolean setNotifierRetryDelay(int retryDelay) {
        if (retryDelay < 0) {
            logger.warn((Object)("wrong retry delay value found, using the default value: " + this.notifierRetryDelay + " sec"));
            return false;
        }
        this.notifierRetryDelay = retryDelay;
        return true;
    }

    public boolean setSandboxTransferMethod(String transferMethod) {
        if (transferMethod == null || !SANDBOX_TRANSFER_METHOD_LRMS.equalsIgnoreCase(transferMethod) && !SANDBOX_TRANSFER_METHOD_GSIFTP.equalsIgnoreCase(transferMethod)) {
            logger.warn((Object)"wrong sandbox transfer method foud, usign default value: LRMS");
            this.sandboxTransfertMethod = SANDBOX_TRANSFER_METHOD_LRMS;
            return false;
        }
        this.sandboxTransfertMethod = transferMethod;
        return true;
    }

    public boolean setScratchDirPath(String path) {
        if (path == null) {
            logger.warn((Object)("blahpd scratch dir path not specified, usign the default value: " + this.scratchDirPath));
            return false;
        }
        File dir = new File(this.scratchDirPath);
        if (!dir.exists()) {
            return dir.mkdirs();
        }
        this.scratchDirPath = path;
        return true;
    }

    public String submit(BLAHJob blahJob) throws BLAHException {
        List<String> arguments;
        if (blahJob == null) {
            throw new BLAHException("command not specified!");
        }
        if (blahJob.getLocalUser() == null) {
            throw new BLAHException("localUser not specified!");
        }
        if (blahJob.getJobId() == null) {
            throw new BLAHException("jobId not specified!");
        }
        if (blahJob.getQueue() == null) {
            throw new BLAHException("queue not specified!");
        }
        if (blahJob.getLRMS() == null) {
            throw new BLAHException("lrms not specified!");
        }
        if (blahJob.getExecutableFile() == null) {
            throw new BLAHException("executableFile not specified!");
        }
        if (blahJob.getLocalUser() == null) {
            throw new BLAHException("localUser not specified");
        }
        if (blahJob.getDelegationCertPath() != null) {
            if (blahJob.getUserDN() == null) {
                throw new BLAHException("userDN not specified");
            }
            if (blahJob.getUserFQAN() == null) {
                throw new BLAHException("userFQAN not specified");
            }
        }
        String jobId = blahJob.getJobId();
        String clientJobId = jobId.substring(jobId.length() - 9);
        String queue = blahJob.getQueue();
        int smpGranularity = blahJob.getSmpGranularity();
        int hostNumber = blahJob.getHostNumber();
        StringBuffer blahpAD = new StringBuffer("[Cmd=\"");
        blahpAD.append(blahJob.getExecutableFile());
        blahpAD.append("\";gridType=\"").append(blahJob.getLRMS());
        blahpAD.append("\";uniquejobid=\"").append(jobId);
        blahpAD.append("\";Out=\"").append(blahJob.getStandardOutputFile());
        blahpAD.append("\";Err=\"").append(blahJob.getStandardErrorFile());
        if (blahJob.getVirtualOrganisation() != null) {
            blahpAD.append("\";VirtualOrganisation=\"").append(blahJob.getVirtualOrganisation());
        }
        if (blahJob.getDelegationCertPath() != null) {
            blahpAD.append("\";x509userproxy=\"").append(blahJob.getDelegationCertPath());
            blahpAD.append("\";x509UserProxySubject=\"").append(blahJob.getUserDN());
            blahpAD.append("\";x509UserProxyFQAN=\"").append(blahJob.getUserFQAN());
        }
        if (blahJob.getMwVersion() != null) {
            blahpAD.append("\";Env=\"EDG_MW_VERSION=").append(blahJob.getMwVersion());
        }
        if (blahJob.getCeId() != null) {
            blahpAD.append("\";ceid=\"").append(blahJob.getCeId());
        }
        if (this.prefix == null) {
            blahpAD.append("\";ClientJobId=\"").append(clientJobId).append("\"");
        } else {
            blahpAD.append("\";ClientJobId=\"").append(this.prefix).append(clientJobId).append("\"");
        }
        if (blahJob.isWholeNodes()) {
            blahpAD.append(";WholeNodes=true;HostSMPSize=").append(this.hostSMPSize);
        } else {
            blahpAD.append(";WholeNodes=false");
            if (blahJob.getNodeNumber() > 0) {
                blahpAD.append(";NodeNumber=").append(blahJob.getNodeNumber());
            } else {
                blahpAD.append(";NodeNumber=1");
            }
            if (smpGranularity > 0 && hostNumber > 0) {
                throw new BLAHException("the SMPGranularity and HostNumber attributes cannot be specified together when WholeNodes=false");
            }
        }
        if (smpGranularity > 0) {
            blahpAD.append(";SMPGranularity=").append(smpGranularity);
        }
        if (hostNumber > 0) {
            blahpAD.append(";HostNumber=").append(hostNumber);
        }
        if (!(arguments = blahJob.getArguments()).isEmpty()) {
            blahpAD.append(";Args=\"'");
            for (String arg : arguments) {
                blahpAD.append(arg).append(":");
            }
            blahpAD.replace(blahpAD.length() - 1, blahpAD.length(), "'\"");
        }
        if (blahJob.getCeRequirements() != null) {
            String req = blahJob.getCeRequirements();
            req = req.replaceAll(" ", "\\\\ ");
            req = req.replaceAll("\"", "\\\\\"");
            blahpAD.append(";CERequirements=\"").append(req).append("\"");
        }
        if (blahJob.getGridJobId() != null) {
            blahpAD.append(";edg_jobid=\"").append(blahJob.getGridJobId()).append("\"");
        }
        if (SANDBOX_TRANSFER_METHOD_LRMS.equalsIgnoreCase(this.sandboxTransfertMethod)) {
            if (blahJob.getIwd() != null) {
                blahpAD.append(";iwd=\"").append(blahJob.getIwd()).append("\"");
            }
            if (blahJob.getTransferInput() != null) {
                blahpAD.append(";TransferInput=\"").append(blahJob.getTransferInput()).append("\"");
            }
            if (blahJob.getTransferOutput() != null) {
                blahpAD.append(";TransferOutput=\"").append(blahJob.getTransferOutput()).append("\"");
            }
            if (blahJob.getTransferOutputRemaps() != null) {
                blahpAD.append(";TransferOutputRemaps=\"").append(blahJob.getTransferOutputRemaps()).append("\"");
            }
        }
        blahpAD.append(queue != null && !queue.equals("") ? ";queue=\"" + queue + "\"]" : "]");
        BLAHCommand jobSubmitCommand = new BLAHCommand("BLAH_JOB_SUBMIT", null, this.getReqId());
        jobSubmitCommand.addParameter(blahpAD.toString());
        this.execute(jobSubmitCommand, blahJob.getLocalUser());
        List<String> result = jobSubmitCommand.getResultList();
        if (result == null || result.size() == 0) {
            throw new BLAHException("blahJobId not available!");
        }
        return result.get(0).trim();
    }

    public void suspend(String blahJobId, String localUser) throws BLAHException {
        this.execute(new BLAHCommand("BLAH_JOB_HOLD", blahJobId, this.getReqId()), localUser);
    }

    public void terminate() {
        logger.info((Object)"teminate invoked!");
        try {
            logger.info((Object)"sending the QUIT command...");
            this.quit();
            logger.info((Object)"sending the QUIT command... done!");
        }
        catch (BLAHException e) {
            logger.error((Object)("error on sending the QUIT command: " + e.getMessage()));
        }
        if (this.blahNotificationListener != null) {
            this.blahNotificationListener.stopListener();
            logger.info((Object)"LRMSEventsListener stopped!");
        }
        if (this.blahNotifierClientTable != null) {
            for (BLAHNotifierClient client : this.blahNotifierClientTable.values()) {
                client.terminate();
            }
        }
        logger.info((Object)"teminated!");
    }

    public static void main(String[] args) {
        BLAHClient blahClient = new BLAHClient();
        try {
            blahClient.setAsynchronousMode(false);
            List<BLAHNotifierInfo> list = blahClient.getBLAHNotifierInfo();
            System.out.println("list size = " + list.size());
            for (BLAHNotifierInfo blahNotifierInfo : list) {
                System.out.println("blahNotifier [lrms=" + blahNotifierInfo.getLRMS() + "; host=" + blahNotifierInfo.getHost() + "; port=" + blahNotifierInfo.getPort() + "]");
            }
            blahClient.quit();
        }
        catch (BLAHException e1) {
            e1.printStackTrace();
            blahClient.terminate();
        }
    }

    public void setJobStatusChangeListener(BLAHJobStatusChangeListener jobStatusChangeListener) {
        this.jobStatusChangeListener = jobStatusChangeListener;
    }

    public BLAHJobStatusChangeListener getJobStatusChangeListener() {
        return this.jobStatusChangeListener;
    }
}

