/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.cream.activitymanagement.db.table;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.glite.ce.creamapi.activitymanagement.db.table.RecipientTableInterface;

public class RecipientTable
implements RecipientTableInterface {
    private static final Logger logger = Logger.getLogger((String)RecipientTable.class.getName());
    private static final String insertSP = "{call insertRecipientTable (?, ?)}";
    private static final String selectSP = "{call selectRecipientTable (?)}";

    public void executeInsert(long notificationId, String value, Connection connection) throws SQLException {
        CallableStatement insertCS = null;
        try {
            insertCS = connection.prepareCall(insertSP);
            insertCS.setLong(1, notificationId);
            insertCS.setString(2, value);
            insertCS.execute();
            logger.debug((Object)"insert into RecipientTable done");
        }
        catch (SQLException se) {
            throw se;
        }
        finally {
            try {
                if (insertCS != null) {
                    insertCS.close();
                }
            }
            catch (SQLException se2) {}
        }
    }

    public List<String> executeSelect(long notificationId, Connection connection) throws SQLException {
        CallableStatement selectCS = null;
        ArrayList<String> recipientList = null;
        try {
            selectCS = connection.prepareCall(selectSP);
            selectCS.setLong(1, notificationId);
            if (selectCS.execute()) {
                recipientList = new ArrayList<String>(0);
                ResultSet resultSet = selectCS.getResultSet();
                while (resultSet.next()) {
                    recipientList.add(resultSet.getString("value"));
                }
            }
            logger.debug((Object)"select RecipientTable done");
        }
        catch (SQLException se) {
            throw se;
        }
        finally {
            try {
                if (selectCS != null) {
                    selectCS.close();
                }
            }
            catch (SQLException se2) {}
        }
        return recipientList;
    }
}

