/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.cream.activitymanagement.db.table;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.glite.ce.creamapi.activitymanagement.db.table.OutputFileTableInterface;
import org.glite.ce.creamapi.activitymanagement.wrapper.adl.CreationFlagEnumeration;
import org.glite.ce.creamapi.activitymanagement.wrapper.adl.OptionType;
import org.glite.ce.creamapi.activitymanagement.wrapper.adl.OutputFile;
import org.glite.ce.creamapi.activitymanagement.wrapper.adl.Target;

public class OutputFileTable
implements OutputFileTableInterface {
    private static final Logger logger = Logger.getLogger((String)OutputFileTable.class.getName());
    private static final String insertOutputFileSP = "{call insertOutputFileTable (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)}";
    private static final String insertOptionTypeOutputFileSP = "{call insertOptionTypeOutputFileTable (?, ?, ?)}";
    private static final String selectOutputFileSP = "{call selectOutputFileTable (?)}";
    private static final String selectOptionTypeOutputFileSP = "{call selectOptionTypeOutputFileTable (?)}";

    public void executeInsert(String activityId, OutputFile outputFile, Connection connection) throws SQLException {
        CallableStatement insertOutputFileCS = null;
        CallableStatement insertOptionTypeOutputFileCS = null;
        try {
            insertOutputFileCS = connection.prepareCall(insertOutputFileSP);
            insertOptionTypeOutputFileCS = connection.prepareCall(insertOptionTypeOutputFileSP);
            insertOutputFileCS.setString(1, activityId);
            insertOutputFileCS.setString(2, outputFile.getName());
            long outputFileId = 0L;
            for (Target target : outputFile.getTarget()) {
                insertOutputFileCS.setString(3, target.getURI());
                insertOutputFileCS.setString(4, target.getDelegationID());
                insertOutputFileCS.setBoolean(5, (boolean)target.isMandatory());
                if (target.getCreationFlag() != null) {
                    insertOutputFileCS.setString(6, target.getCreationFlag().value());
                } else {
                    insertOutputFileCS.setString(6, null);
                }
                insertOutputFileCS.setBoolean(7, (boolean)target.isUseIfFailure());
                insertOutputFileCS.setBoolean(8, (boolean)target.isUseIfCancel());
                insertOutputFileCS.setBoolean(9, (boolean)target.isUseIfSuccess());
                insertOutputFileCS.registerOutParameter(10, -5);
                insertOutputFileCS.execute();
                outputFileId = insertOutputFileCS.getLong(10);
                if (target.getOption().size() == 0) continue;
                for (OptionType optionType : target.getOption()) {
                    insertOptionTypeOutputFileCS.setLong(1, outputFileId);
                    insertOptionTypeOutputFileCS.setString(2, optionType.getName());
                    insertOptionTypeOutputFileCS.setString(3, optionType.getValue());
                    insertOptionTypeOutputFileCS.execute();
                }
            }
            if (outputFileId == 0L) {
                insertOutputFileCS.setString(3, null);
                insertOutputFileCS.setString(4, null);
                insertOutputFileCS.setBoolean(5, false);
                insertOutputFileCS.setString(6, null);
                insertOutputFileCS.setBoolean(7, false);
                insertOutputFileCS.setBoolean(8, false);
                insertOutputFileCS.setBoolean(9, false);
                insertOutputFileCS.registerOutParameter(10, -5);
                insertOutputFileCS.execute();
            }
            logger.debug((Object)"insert into OutputFileTable done");
        }
        catch (SQLException se) {
            throw se;
        }
        finally {
            try {
                if (insertOutputFileCS != null) {
                    insertOutputFileCS.close();
                }
            }
            catch (SQLException se2) {}
            try {
                if (insertOptionTypeOutputFileCS != null) {
                    insertOptionTypeOutputFileCS.close();
                }
            }
            catch (SQLException se2) {}
        }
    }

    public List<OutputFile> executeSelect(String activityId, Connection connection) throws SQLException {
        CallableStatement selectOutputFileCS = null;
        CallableStatement selectOptionTypeOutputFileCS = null;
        ArrayList<OutputFile> outputFileList = null;
        try {
            selectOutputFileCS = connection.prepareCall(selectOutputFileSP);
            selectOptionTypeOutputFileCS = connection.prepareCall(selectOptionTypeOutputFileSP);
            selectOutputFileCS.setString(1, activityId);
            if (selectOutputFileCS.execute()) {
                outputFileList = new ArrayList<OutputFile>(0);
                OutputFile outputFile = null;
                Target target = null;
                OptionType optionType = null;
                String fileNamePrec = null;
                ResultSet optionTypeResultSet = null;
                ResultSet resultSet = selectOutputFileCS.getResultSet();
                while (resultSet.next()) {
                    if (resultSet.getString("name") != fileNamePrec) {
                        fileNamePrec = resultSet.getString("name");
                        outputFile = new OutputFile();
                        outputFileList.add(outputFile);
                        outputFile.setName(resultSet.getString("name"));
                    }
                    if (resultSet.getString("uri") == null) continue;
                    target = new Target();
                    outputFile.getTarget().add(target);
                    if (resultSet.getString("creation_flag") != null) {
                        target.setCreationFlag(CreationFlagEnumeration.fromValue((String)resultSet.getString("creation_flag")));
                    }
                    target.setDelegationID(resultSet.getString("delegation_id"));
                    target.setMandatory(Boolean.valueOf(resultSet.getBoolean("mandatory")));
                    target.setURI(resultSet.getString("uri"));
                    target.setUseIfCancel(Boolean.valueOf(resultSet.getBoolean("use_if_cancel")));
                    target.setUseIfFailure(Boolean.valueOf(resultSet.getBoolean("use_if_failure")));
                    target.setUseIfSuccess(Boolean.valueOf(resultSet.getBoolean("use_if_success")));
                    selectOptionTypeOutputFileCS.setLong(1, resultSet.getLong("id"));
                    if (!selectOptionTypeOutputFileCS.execute()) continue;
                    optionTypeResultSet = selectOptionTypeOutputFileCS.getResultSet();
                    while (optionTypeResultSet.next()) {
                        optionType = new OptionType();
                        optionType.setName(optionTypeResultSet.getString("name"));
                        optionType.setValue(optionTypeResultSet.getString("value"));
                        target.getOption().add(optionType);
                    }
                }
            }
            logger.debug((Object)"select OutputFile done");
        }
        catch (SQLException se) {
            throw se;
        }
        finally {
            try {
                if (selectOutputFileCS != null) {
                    selectOutputFileCS.close();
                }
            }
            catch (SQLException se2) {}
            try {
                if (selectOptionTypeOutputFileCS != null) {
                    selectOptionTypeOutputFileCS.close();
                }
            }
            catch (SQLException se2) {}
        }
        return outputFileList;
    }
}

