/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.cream.activitymanagement.db.table;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.glite.ce.creamapi.activitymanagement.db.table.NotificationOnStateTableInterface;
import org.glite.ce.creamapi.activitymanagement.wrapper.creation.types.PrimaryActivityStatus;

public class NotificationOnStateTable
implements NotificationOnStateTableInterface {
    private static final Logger logger = Logger.getLogger((String)NotificationOnStateTable.class.getName());
    private static final String insertSP = "{call insertNotificationOnStateTable (?, ?)}";
    private static final String selectSP = "{call selectNotificationOnStateTable (?)}";

    public void executeInsert(long notificationId, PrimaryActivityStatus primaryActivityStatus, Connection connection) throws SQLException {
        CallableStatement insertCS = null;
        try {
            insertCS = connection.prepareCall(insertSP);
            insertCS.setLong(1, notificationId);
            insertCS.setString(2, primaryActivityStatus.value());
            insertCS.execute();
            logger.debug((Object)"insert into NotificationOnStateTable done");
        }
        catch (SQLException se) {
            throw se;
        }
        finally {
            try {
                if (insertCS != null) {
                    insertCS.close();
                }
            }
            catch (SQLException se2) {}
        }
    }

    public List<PrimaryActivityStatus> executeSelect(long notificationId, Connection connection) throws SQLException {
        CallableStatement selectCS = null;
        ArrayList<PrimaryActivityStatus> primaryActivityStatusList = null;
        try {
            selectCS = connection.prepareCall(selectSP);
            selectCS.setLong(1, notificationId);
            if (selectCS.execute()) {
                primaryActivityStatusList = new ArrayList<PrimaryActivityStatus>(0);
                PrimaryActivityStatus primaryActivityStatus = null;
                ResultSet resultSet = selectCS.getResultSet();
                while (resultSet.next()) {
                    primaryActivityStatus = PrimaryActivityStatus.fromValue((String)resultSet.getString("onstate"));
                    primaryActivityStatusList.add(primaryActivityStatus);
                }
            }
            logger.debug((Object)"select NotificationOnStateTable done");
        }
        catch (SQLException se) {
            throw se;
        }
        finally {
            try {
                if (selectCS != null) {
                    selectCS.close();
                }
            }
            catch (SQLException se2) {}
        }
        return primaryActivityStatusList;
    }
}

