/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.cream.activitymanagement.db.table;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.glite.ce.creamapi.activitymanagement.db.table.ExecutableTypeArgumentTableInterface;

public class ExecutableTypeArgumentTable
implements ExecutableTypeArgumentTableInterface {
    private static final Logger logger = Logger.getLogger((String)ExecutableTypeArgumentTable.class.getName());
    private static final String insertSP = "{call insertExecutableTypeArgumentTable (?, ?)}";
    private static final String selectSP = "{call selectExecutableTypeArgumentTable (?)}";

    public void executeInsert(long executableTypeId, String argument, Connection connection) throws SQLException {
        CallableStatement insertCS = null;
        try {
            insertCS = connection.prepareCall(insertSP);
            insertCS.setLong(1, executableTypeId);
            insertCS.setString(2, argument);
            insertCS.execute();
            logger.debug((Object)"insert into ExecutableTypeArgumentTable done");
        }
        catch (SQLException se) {
            throw se;
        }
        finally {
            try {
                if (insertCS != null) {
                    insertCS.close();
                }
            }
            catch (SQLException se2) {}
        }
    }

    public List<String> executeSelect(long executableTypeId, Connection connection) throws SQLException {
        CallableStatement selectCS = null;
        ArrayList<String> executableTypeArgumentList = null;
        try {
            selectCS = connection.prepareCall(selectSP);
            selectCS.setLong(1, executableTypeId);
            if (selectCS.execute()) {
                executableTypeArgumentList = new ArrayList<String>(0);
                ResultSet resultSet = selectCS.getResultSet();
                while (resultSet.next()) {
                    executableTypeArgumentList.add(resultSet.getString("argument"));
                }
            }
            logger.debug((Object)"select ExecutableTypeArgumentTable done");
        }
        catch (SQLException se) {
            throw se;
        }
        finally {
            try {
                if (selectCS != null) {
                    selectCS.close();
                }
            }
            catch (SQLException se2) {}
        }
        return executableTypeArgumentList;
    }
}

