/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.cream.activitymanagement.db.table;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.glite.ce.creamapi.activitymanagement.db.table.EnvironmentTableInterface;
import org.glite.ce.creamapi.activitymanagement.wrapper.adl.OptionType;

public class EnvironmentTable
implements EnvironmentTableInterface {
    private static final Logger logger = Logger.getLogger((String)EnvironmentTable.class.getName());
    private static final String insertSP = "{call insertEnvironmentTable (?, ?, ?)}";
    private static final String selectSP = "{call selectEnvironmentTable (?)}";

    public void executeInsert(String activityId, OptionType optionType, Connection connection) throws SQLException {
        CallableStatement insertCS = null;
        try {
            insertCS = connection.prepareCall(insertSP);
            insertCS.setString(1, activityId);
            insertCS.setString(2, optionType.getName());
            insertCS.setString(3, optionType.getValue());
            insertCS.execute();
            logger.debug((Object)"insert into EnvironmentTable done");
        }
        catch (SQLException se) {
            throw se;
        }
        finally {
            try {
                if (insertCS != null) {
                    insertCS.close();
                }
            }
            catch (SQLException se2) {}
        }
    }

    public List<OptionType> executeSelect(String activityId, Connection connection) throws SQLException {
        CallableStatement selectCS = null;
        ArrayList<OptionType> enviroment = null;
        try {
            selectCS = connection.prepareCall(selectSP);
            selectCS.setString(1, activityId);
            if (selectCS.execute()) {
                enviroment = new ArrayList<OptionType>(0);
                OptionType optionType = null;
                ResultSet resultSet = selectCS.getResultSet();
                while (resultSet.next()) {
                    optionType = new OptionType();
                    optionType.setName(resultSet.getString("name"));
                    optionType.setValue(resultSet.getString("value"));
                    enviroment.add(optionType);
                }
            }
            logger.debug((Object)"select EnvironmentTable done");
        }
        catch (SQLException se) {
            throw se;
        }
        finally {
            try {
                if (selectCS != null) {
                    selectCS.close();
                }
            }
            catch (SQLException se2) {}
        }
        return enviroment;
    }
}

